<?php
/**
* FILE_NAME : global.php
*
* @copyright Copyright (c) www.shuangyulin.com
* @author shuangyulin Design
* @package 后台全局引用文件
* @subpackage
* @version QQ:287307421 或 254540457
*/

if(!defined('IN_WEB')) 
{
	exit('Access Denied');
}

/*--  启动session  --*/
session_start();

/*--  定义环境常量  --*/
define('IN_ADMINCP',TRUE);

/*--  设置错误提示  --*/
error_reporting(E_ALL);

/*--  取得当前网站所在的根目录  --*/ 
define('WEB_ROOT', str_replace('admin/include/global.php', '', str_replace('\\', '/', __FILE__)));


/*--  引入基本配置文件  --*/
require_once WEB_ROOT.'config.inc.php';
 

//PHP_SELF = '/admin/index.php'
if (isset($_SERVER['PHP_SELF']))
{
    define('PHP_SELF', $_SERVER['PHP_SELF']);
}
else
{
    define('PHP_SELF', $_SERVER['SCRIPT_NAME']);
}


/*--  引入全局函数文件  --*/
require_once WEB_ROOT.'include/global.fun.php';
 
/*--  引入后台函数文件  --*/
require_once WEB_ROOT.'admin/include/admin_global.fun.php';
 
/*--  对用户传入的变量进行转义操作  --*/
if (!get_magic_quotes_gpc()) {
    if (!empty($_GET)) {
        $_GET  = addslashes_deep($_GET);
    }
    if (!empty($_POST)) {
        $_POST = addslashes_deep($_POST);
    }

    $_COOKIE   = addslashes_deep($_COOKIE);
    $_REQUEST  = addslashes_deep($_REQUEST);
}

/*--  对路径进行安全处理  --*/ 
if (strpos(PHP_SELF, '.php/') !== false)
{
	/*--  只跳转到 php 结尾的页面  --*/
    web_header("Location:" . substr(PHP_SELF, 0, strpos(PHP_SELF, '.php/') + 4) . "\n");
    exit();
}

/*--  初始化数据库类  --*/
require_once WEB_ROOT.'include/db_mysql.class.php';

 

$DB = new DB_MySQL();
$DB->connect($dbhost, $dbuser, $dbpass, $dbname, $pconnect);
unset($dbhost, $dbuser, $dbpass, $pconnect);
 
/*--  读取系统缓存文件  --*/
if (!@include(WEB_ROOT.'cache/settings.php')) {
	require_once(WEB_ROOT.'include/cache.php');
	recache(); 
	web_header("Location: index.php\n");
}
 
/*--  获得当前时间  --*/
$timestamp = gmtime();

/*--  引入网站基础类  --*/
require_once WEB_ROOT.'admin/include/admin_web.class.php';
 
$phpweb = new PHPWEB();

/*--  获得网站url  --*/
$web_url = $phpweb->url();

//$web_url = "http://www.phpwebsystem.com/";

/*--  获得css 和 图片 所在文件夹  --*/
$css_root = $phpweb->css_root();

//$css_root = "http://www.phpwebsystem.com/admin/templates/admin/";
 

/*--  初始化 action  --*/
if (!isset($_REQUEST['act']))
{
    $_REQUEST['act'] = '';
}
elseif (($_REQUEST['act'] == 'login' || $_REQUEST['act'] == 'logout' || $_REQUEST['act'] == 'signin') &&
    strpos(PHP_SELF, '/privilege.php') === false)
{
    $_REQUEST['act'] = '';
}

/*------------------------------------------------------ */
//-- 以下这里到最后使用邮件服务器的时候再开启
/*------------------------------------------------------ */
/*elseif (($_REQUEST['act'] == 'forget_pwd' || $_REQUEST['act'] == 'reset_pwd' || $_REQUEST['act'] == 'get_pwd') &&
    strpos(PHP_SELF, '/get_password.php') === false)
{
    $_REQUEST['act'] = '';
}*/

/*--  创建 Smarty 对象  --*/
require_once WEB_ROOT.'admin/include/config.smarty.php';
require_once WEB_ROOT.'smarty/Smarty.class.php';
 
$smarty = new Smarty();

$smarty->caching = $tpl_caching;
$smarty->template_dir = WEB_ROOT.$tpl_template_dir;
$smarty->compile_dir = WEB_ROOT.$tpl_compile_dir;
$smarty->cache_dir = WEB_ROOT.$tpl_cache_dir;
$smarty->left_delimiter = $tpl_left_delimiter;
$smarty->right_delimiter = $tpl_right_delimiter;

/*--  验证管理员身份  --*/
if ((!isset($_SESSION['admin_id']) || intval($_SESSION['admin_id']) <= 0) &&
    $_REQUEST['act'] != 'login' && $_REQUEST['act'] != 'signin' )
{
    /* session 不存在，检查cookie */
    if (!empty($_COOKIE['WEB']['admin_id']) && !empty($_COOKIE['WEB']['admin_pass']))
    {
        /* 找到了cookie, 验证cookie信息 */
        $sql = "SELECT id, adminname, password, ip, lastlogin FROM {$dbprefix}admin WHERE id = '" . intval($_COOKIE['WEB']['admin_id']) . "'";
        $row = $DB->fetch_one_array($sql);

        if (!$row) {
             /* 没有找到这个记录 */
            setcookie($_COOKIE['WEB']['admin_id'],   '', 1);
            setcookie($_COOKIE['WEB']['admin_pass'], '', 1);

            web_header("location:privilege.php?act=login\n");
            exit();
        } else {
            /* 检查密码是否正确 */
            if (md5($row['password'].$_CFG['hash_code']) == $_COOKIE['WEB']['admin_pass']) {
                !isset($row['lastlogin']) && $row['lastlogin'] = '';
                set_admin_session($row['id'], $row['adminname'], $row['password'], $row['lastlogin']);

                /* 更新最后登录时间和IP */
                $DB->query("UPDATE {$dbprefix}admin SET lastlogin = '" .$timestamp. "', ip = '" .getonlineip(). "' WHERE id = '" . $_SESSION['admin_id'] . "'");
            } else {
                setcookie($_COOKIE['WEB']['admin_id'],   '', 1);
                setcookie($_COOKIE['WEB']['admin_pass'], '', 1);

                web_header("location:privilege.php?act=login\n");
            	exit();
            }
        }
    } else {
        web_header("location:privilege.php?act=login\n");
        exit();
    }
}

/*--  判断 URL 是否正确，不正确则跳到登录页面  --*/
if ($_REQUEST['act'] != 'login' )
{
    $admin_path = preg_replace('/:\d+/', '', $phpweb->url()) . 'admin';
    if (!empty($_SERVER['HTTP_REFERER']) &&
        strpos(preg_replace('/:\d+/', '', $_SERVER['HTTP_REFERER']), $admin_path) === false)
    {
        web_header("location:privilege.php?act=login\n");
        exit();
    }
}

?>