<?php
/**
* FILE_NAME : upload.php
*
* @copyright Copyright (c) 2009 - 2010 www.dali.edu.cn
* @author DaLi University 2009 Graduation Design
* @package 编辑器图片上传程序
* @subpackage
* @version Sun Nov 01 03:16:43 GMT 2009
*/

define('IN_WEB', TRUE);
require_once( str_replace('\\', '/', dirname(__FILE__)). './global.php');
//require_once( WEB_ROOT."admin/include/admin_miniature.class.php");
//
//$mini = new Miniature();

function uploadfile($inputname)
{
	global $web_url;
	$attachdir= '../../attachments/editor';//上传文件保存路径，结尾不要带/
	$dirtype=1;//1:按天存入目录 2:按月存入目录 3:按扩展名存目录
	$maxattachsize=2097152;//最大上传大小，默认是2M
	
	$err = "";
	$msg = "";
	$upfile=$_FILES[$inputname];
	if(!empty($upfile['error']))
	{
		switch($upfile['error'])
		{
			case '1':
				$err = '文件大小超过了php.ini定义的upload_max_filesize值';
				break;
			case '2':
				$err = '文件大小超过了HTML定义的MAX_FILE_SIZE值';
				break;
			case '3':
				$err = '文件上传不完全';
				break;
			case '4':
				$err = '无文件上传';
				break;
			case '6':
				$err = '缺少临时文件夹';
				break;
			case '7':
				$err = '写文件失败';
				break;
			case '8':
				$err = '上传被其它扩展中断';
				break;
			case '999':
			default:
				$err = '无有效错误代码';
		}
	}
	elseif(empty($upfile['tmp_name']) || $upfile['tmp_name'] == 'none')
	{
		$err = '无文件上传';
	}
	else
	{
			$temppath=$upfile['tmp_name'];
			/*--  取后缀  --*/
			$fileinfo=pathinfo($upfile['name']);
			$extension=$fileinfo['extension'];
			/*--  取宽度，高度  --*/
//			$imagesize = getimagesize($upfile['name']);
			/*--  取大小  --*/
			$filesize=filesize($temppath);
			if($filesize <= $maxattachsize)
			{
				switch($dirtype)
				{
					case 1: $attach_subdir = 'day_'.date('ymd'); break;
					case 2: $attach_subdir = 'month_'.date('ym'); break;
					case 3: $attach_subdir = 'ext_'.$extension; break;
				}
				$attach_dir = $attachdir.'/'.$attach_subdir;
				if(!is_dir($attach_dir))
				{
					@mkdir($attach_dir, 0777);
					@fclose(fopen($attach_dir.'/index.htm', 'w'));
				}
				
				PHP_VERSION < '4.2.0' && mt_srand((double)microtime() * 1000000);
				$filename=date("YmdHis").mt_rand(1000,9999).'.'.$extension;
				$target = $attach_dir.'/'.$filename;
				
				move_uploaded_file($upfile['tmp_name'],$target);
				
//				require_once( WEB_ROOT."admin/include/admin_miniature.class.php");
//
//				$mini = new Miniature();
				/*--  判断宽度  --*/
//				if ($imagesize[0]>500) {
//					$mini->ReadImage($target);
//					$mini->ResizeImage(500,500);//智能缩小
//					$mini->ImageType=4;//保存成jpg格式
//					$mini->SaveImage($attach_dir.'/',$filename);//保存图片,"To/":保存路径,"demo_1":图片名称
//					$mini->DestroyImage();//销毁图片
//				}
				
				$msg=$web_url.substr($target,6);
			}
			else $err='文件大小超过'.$maxattachsize.'字节';

			@unlink($temppath);
	}
	return array('err'=>$err,'msg'=>$msg);
}

$state=uploadfile('upload');
echo json_encode($state);


?>