<?php
/**
* FILE_NAME : picmanage.php
*
* @copyright Copyright (c) www.shuangyulin.com
* @author 双鱼林设计
* @package 图片管理
* @subpackage
* @version QQ:287307421或254540457
*/

define('IN_WEB', TRUE);
	
require_once( str_replace('\\', '/', dirname(__FILE__)). '/include/global.php');

/* act操作项的初始化 */
if (empty($_REQUEST['act'])) {
    $_REQUEST['act'] = 'show';
} else {
    $_REQUEST['act'] = trim($_REQUEST['act']);
}

/*------------------------------------------------------ */
//-- 显示图片列表
/*------------------------------------------------------ */
if ($_REQUEST['act'] == 'show')
{
	$sql = $query = $piclist = $pages = '';
	
	/*--  处理分页数据  --*/
	$sql = "SELECT * FROM {$dbprefix}pictures";
	$query = $DB->query($sql);
	
	$allnum = $DB->num_rows($query);
	$perpage = 5;
	$curpage = isset($_GET['page']) ? intval($_GET['page']) : 1;
	$php_self = "picmanage.php?ack=show";
	
  
	/*--  创建分页  --*/
	$pages = multi($allnum, $perpage, $curpage, $php_self, 10);
	
	if (($curpage-1) >= 0) {
		$step = $curpage-1;
	} else {
		$step = 0;
	}
	$startpage = $perpage * $step;
	$sql = "SELECT * FROM {$dbprefix}pictures order by uploadtime DESC LIMIT $startpage,$perpage";
	 
	
	$query = $DB->query($sql);
	while ($row = $DB->fetch_array($query))
	{ 
		$row['uploadtime'] = formatdate($_CFG['format_type'],$row['uploadtime']);
		$piclist[] = $row;
	}
	
 
	
	$smarty->assign("css_root", $css_root);
	$smarty->assign("web_url",$web_url);
	$smarty->assign("piclist", $piclist);
	$smarty->assign("pages", $pages);
	
	$smarty->display("picmanage.html");
}

/*------------------------------------------------------ */
//-- 上传图片
/*------------------------------------------------------ */
if ($_REQUEST['act'] == 'add')
{
	$smarty->assign("css_root", $css_root);
	$smarty->assign("web_url", $web_url);
	
	$smarty->display("picmanage_add.html");
}

/*------------------------------------------------------ */
//-- 上传图片成功
/*------------------------------------------------------ */
if ($_REQUEST['act'] == 'addok')
{
	require_once( WEB_ROOT."admin/include/admin_upload.class.php");
	require_once( WEB_ROOT."admin/include/admin_miniature.class.php");

	 
	/*--  初始化变量，实例化上传类  --*/
	$file = $_FILES['pic'];
	$upload_path='../attachments/picture';
	$allow_type=array('jpg','bmp','png','gif','jpeg');
	$max_size=2048000;
	
	$upload=new upFiles($file, $upload_path, $max_size, $allow_type);
	$picnum = $upload->upload();
	$pic = $upload->getSaveFileInfo();
	
	/*--  缩略图  --*/
	$m=new Miniature();
	for ($i=0;$i<$picnum;$i++) {
		$_CFG['siteurl'] = WEB_ROOT;
		
		$str_file = $_CFG['siteurl'].substr($pic[$i]['file'],3);
	  
		$m->ReadImage($str_file);
		 
		$m->ResizeImage(200,200);//智能缩小
		$m->ImageType=4;//保存成jpg格式
		$thumb_name=$pic[$i]['basename']."_thumb";
		$m->SaveImage($pic[$i]['path']."/",$thumb_name);
		$m->DestroyImage();//销毁图片
		
		$sql = "INSERT INTO {$dbprefix}pictures (id,temname,filename,filepath,thumbpath,uploadtime) VALUE ('','".$pic[$i]['savename']."','".$pic[$i]['name']."','".$pic[$i]['path']."','".$pic[$i]['path']."','".$timestamp."')";
		$query = $DB->query($sql);
	}
	
	if ($query) {
		showmsg("图片添加成功","picmanage.php?act=show");
	} else {
		showmsg("图片添加失败");
	}
}

/*------------------------------------------------------ */
//-- 删除图片
/*------------------------------------------------------ */
if ($_REQUEST['act'] == 'remove')
{
	$id = $_REQUEST['id'];
	
	$sql = $row = $query = '';
	$sql = "SELECT * FROM {$dbprefix}pictures WHERE id = $id";
	$query = $DB->query($sql);
	$row = $DB->fetch_array($query);
	
	$filepath = WEB_ROOT.substr($row['filepath'],3);                            
	//打开 images 目录
	$dir = opendir($filepath);
		
	$file = $filepath.'/'.$row['temname'];
	if (is_file($file)) {
		@unlink($file);
	}
	closedir($dir);
	  
	$sql = "DELETE FROM {$dbprefix}pictures WHERE id = $id";
	$query = $DB->query($sql);

	if ($query) {
		showmsg("图片删除成功","picmanage.php?act=show");
	} else {
		showmsg("图片删除失败");
	}
}

/*------------------------------------------------------ */
//-- 批量删除图片
/*------------------------------------------------------ */
if ($_REQUEST['act'] == 'delall')
{
	$delid = isset($_REQUEST['delid']) ? $_REQUEST['delid'] : '';

	$list = array();
	$list = explode('/',$delid);
	
	for ($i=0;$i<count($list);$i++) {
		$sql = $row = $query = '';
		$sql = "SELECT * FROM {$dbprefix}pictures WHERE id = '".$list[$i]."'";
		$query = $DB->query($sql);
		$row = $DB->fetch_array($query);
		
		$filepath = WEB_ROOT.substr($row['filepath'],3);                            
		//打开 images 目录
		$dir = opendir($filepath);
		
		$file = $filepath.'/'.$row['temname'];
		if (is_file($file)) {
			@unlink($file);
		}
		closedir($dir);
		  
		$sql = "DELETE FROM {$dbprefix}pictures WHERE id = '".$list[$i]."'";
		$query = $DB->query($sql);
	}
	
	showmsg("删除成功","picmanage.php?act=show");
}
?>

