<?php
/**
* FILE_NAME : picture.php
*
* @copyright Copyright (c) www.shuangyulin.com
* @author 双鱼林设计
* @package 图片展示栏目列表
* @subpackage
* @version QQ:287307421或254540457
*/
header("Content-Type:text/html; charset=utf-8");
define('IN_WEB', TRUE);
	
require_once( str_replace('\\', '/', dirname(__FILE__)). '/include/global.php');

/* act操作项的初始化 */
if (empty($_REQUEST['act'])) {
    $_REQUEST['act'] = 'show';
} else {
    $_REQUEST['act'] = trim($_REQUEST['act']);
}

/*------------------------------------------------------ */
//-- 显示图片展示列表
/*------------------------------------------------------ */
if ($_REQUEST['act'] == 'show')
{
	$sql = $query = $piclist = '';
	
	$sql = "SELECT p.prid,p.catid,p.title,p.username,p.dateline,p.viewnum,c.catid,c.name FROM {$dbprefix}picturecontent p LEFT JOIN {$dbprefix}picturecategories c ON p.catid = c.catid";
	$query = $DB->query($sql);
	while ($row = $DB->fetch_array($query)) {
		$row['dateline'] = formatdate($_CFG['format_type'],$row['dateline']);
		$piclist[] = $row;
	}
	
	$smarty->assign("css_root", $css_root);
	
	$smarty->assign("piclist", $piclist);
	
	$smarty->display("picture.html");
}

/*------------------------------------------------------ */
//-- 增加图片展示
/*------------------------------------------------------ */
if ($_REQUEST['act'] == 'add')
{
	$sql = $query = $piccatelist = $username = '';
	
	/*--  查询分类信息  --*/
	$sql = "SELECT catid,name FROM {$dbprefix}picturecategories";
	$query = $DB->query($sql);
	while ($row = $DB->fetch_array($query)) {
		$piccatelist[] = $row;
	}
	
	$username = $_SESSION['admin_name'];
	$smarty->assign("css_root", $css_root);
	$smarty->assign("web_url", $web_url);
	
	$smarty->assign("username",$username);
	$smarty->assign("piccatelist",$piccatelist);
	
	$smarty->display("picture_add.html");
}

/*------------------------------------------------------ */
//-- 添加图片展示成功
/*------------------------------------------------------ */
if ($_REQUEST['act'] == 'addok')
{
	require_once( WEB_ROOT."admin/include/admin_upload.class.php");
	require_once( WEB_ROOT."admin/include/admin_miniature.class.php");
	$showpic = $coverpic = array();
	
	$pict = $_REQUEST['pict'];
	$sql = $query = $sercontent = $sercoverpic = '';
	
	/*--  初始化变量，实例化上传类  --*/
	$file = $_FILES['pic'];
	$upload_path='../attachments/picture';
	$allow_type=array('jpg','bmp','png','gif','jpeg');
	$max_size=2048000;
	
	$upload=new upFiles($file, $upload_path, $max_size, $allow_type);
	$picnum = $upload->upload();
	$pic = $upload->getSaveFileInfo();
	
	/*--  缩略图  --*/
	$m=new Miniature();
	for ($i=0;$i<$picnum;$i++)
	{
		$str_file = WEB_ROOT.substr($pic[$i]['file'],3);
		$m->ReadImage($str_file);
		$m->ResizeImage(200,130);//智能缩小
		$m->ImageType=4;//保存成jpg格式
		$thumb_name=$pic[$i]['basename']."_thumb";
//		$thumb_path = createdir()
		$m->SaveImage($pic[$i]['thumb_dir'],$thumb_name);
		
		/*--  写入图片表  --*/
		$sql = "INSERT INTO {$dbprefix}pictures (id,temname,filename,filepath,thumbpath,uploadtime) VALUE ('','".$pic[$i]['savename']."','".$pic[$i]['name']."','".$pic[$i]['path']."','".$pic[$i]['thumb_dir']."','".$timestamp."')";
		$DB->query($sql);
		
		/*--  构造图片展示数组  --*/
		$showpic['pic_dir'] = $pic[$i]['path'];
		$showpic['thumb_dir'] = $pic[$i]['thumb_dir'];
		$showpic[] = $pic[$i]['savename'];
		
		/*--  判断封面图片是否为空  --*/
		if ($_FILES['coverpic']['name'] == ''){
			if ($i==0){
				$cover_name=$pic[$i]['basename']."_pic";
				$m->SaveImage($pic[$i]['cover_dir'],$cover_name);
				$coverpic['cover_dir'] = $pic[$i]['cover_dir'];
				$coverpic['cover_name'] = $cover_name.'.jpg';
			}
		}
		$m->DestroyImage();//销毁图片
	}

	$sercontent =serialize($showpic);

	if ($_FILES['coverpic']['name'] != ''){
		/*--  实例化上传类  --*/
		$file = $_FILES['coverpic'];
		$upload_path = '../attachments/picture';
		$allow_type=array('jpg','bmp','png','gif','jpeg');
		$max_size=2048000;

//		/*--  开始上传  --*/
		$upload = new upFiles($file, $upload_path, $max_size, $allow_type);
		$upload->upload();
		$pic = $upload->getSaveFileInfo();

		/*--  缩略图  --*/
		$m=new Miniature();
		$str_file = WEB_ROOT.substr($pic['file'],3);
		$m->ReadImage($str_file);
		$m->ResizeImage(200,130);//智能缩小
		$m->ImageType=4;//保存成jpg格式
		$cover_name=$pic['basename']."_pic";
		$m->SaveImage($pic['cover_dir'],$cover_name);
		
		$coverpic['cover_dir'] = $pic['cover_dir'];
		$coverpic['cover_name'] = $cover_name.'.jpg';
		
		$m->DestroyImage();//销毁图片
	}

	$sercoverpic = serialize($coverpic);

	/*--  写入图片展示表  --*/
	$sql = "INSERT INTO {$dbprefix}picturecontent (prid,catid,title,username,coverpic,content,dateline,viewnum) VALUE ('','".$pict['catid']."','".$pict['title']."','".$pict['username']."','".$sercoverpic."','".$sercontent."','".$timestamp."',0)";
	$query = $DB->query($sql);
	
	if ($query) {
		showmsg("图片展示添加成功","picture.php?act=show");
	} else {
		showmsg("图片展示添加失败","picture.php?act=add");
	}
	
}

/*------------------------------------------------------ */
//-- 编辑图片展示
/*------------------------------------------------------ */
if ($_REQUEST['act'] == 'edit')
{
	$prid = $_REQUEST['prid'];
	
	$sql = $query = $piccatelist = '';
	
	/*--  查询分类信息  --*/
	$sql = "SELECT catid,name FROM {$dbprefix}picturecategories";
	$query = $DB->query($sql);
	while ($row = $DB->fetch_array($query))
	{
		$piccatelist[] = $row;
	}
	
	$sql = "SELECT * FROM {$dbprefix}picturecontent WHERE prid = $prid";
	$query = $DB->query($sql);
	$list = $DB->fetch_array($query);
	
	$str = $str1 = '';
	$str = stripslashes($list['content']);
	$str1 = stripslashes($list['coverpic']);
	
	/*--  反序列化  --*/
	$uncontent = $uncoverpic = '';
	$list['content'] = unserialize($str);
	$list['coverpic'] = unserialize($str1);

	/*--  构造图片展示数组  --*/
	$piclist = array();
	for ($i=0;$i<count($list['content'])-2;$i++) {
		/*--  取扩展名  --*/
		$ext = strrchr($list['content'][$i],'.');
		$basename = basename($list['content'][$i],$ext);
		$list['thumb_name'] = $basename.'_thumb'.$ext;
		
		$piclist[$i]['thumb_name'] = substr($list['content']['thumb_dir'],3).$list['thumb_name'];
		/*--  取图片名和后缀，为删除图片准备  --*/
		$piclist[$i]['basename'] = $basename;
		$piclist[$i]['ext'] = $ext;
	}
	
	$smarty->assign("css_root", $css_root);
	$smarty->assign("web_url", $web_url);
	
	$smarty->assign("pict_prid",$list['prid']);
	$smarty->assign("pict_catid",$list['catid']);
	$smarty->assign("pict_title",$list['title']);
	$smarty->assign("coverpic",$list['coverpic']['cover_name']);
	$smarty->assign("piclist",$piclist);
	
	$smarty->assign("piccatelist",$piccatelist);
	
	$smarty->display("picture_edit.html");
}

/*------------------------------------------------------ */
//-- 确定编辑图片
/*------------------------------------------------------ */
if ($_REQUEST['act'] == 'editok')
{
	$prid = $_REQUEST['prid'];
	
	/*--  查询数据表原数据  --*/
	$sql = "SELECT * FROM {$dbprefix}picturecontent WHERE prid = '".$prid."'";
	$query = $DB->query($sql);
	while ($row = $DB->fetch_array($query)) {
		$oldrow = $row;
	}
	/*--  对封面图片进行反序列化  --*/
	$oldrow['coverpic'] = unserialize(stripslashes($oldrow['coverpic']));	
	
	/*--  接收表单传来数据  --*/
	$pict = $_REQUEST['pict'];
	
	/*--  判断封面图片是否改变  --*/
	if ($pict['coverpic'] != $oldrow['coverpic']['cover_name']) {
//		$pict['coverpic'] 的值为: ../attachments/picture/2009/10/48437700_thumb.jpg
		/*--  分割 $pict[coverpic] 的值 --*/
		$ext = strrchr($pict['coverpic'],'.'); //取后缀
		$filepath = substr($pict['coverpic'],strrpos($pict['coverpic'],'/')); //取路径
		$filename = strrchr($pict['coverpic'],'/'); //取文件名
		
		/*--  复制图片  --*/
		$fromdir = WEB_ROOT.substr($pict['coverpic'],3);
		$todir = WEB_ROOT.substr($oldrow['coverpic']['cover_dir'],3).$oldrow['coverpic']['cover_name'];
		copy($fromdir,$todir);
		 
	}
	
	if ($_FILES['pic']) {
		require_once( WEB_ROOT."admin/include/admin_upload.class.php");
		require_once( WEB_ROOT."admin/include/admin_miniature.class.php");
		
		/*--  初始化变量，实例化上传类  --*/
		$file = $_FILES['pic'];
		$upload_path='../attachments/picture';
		$allow_type=array('jpg','bmp','png','gif','jpeg');
		$max_size=2048000;
		
		$upload=new upFiles($file, $upload_path, $max_size, $allow_type);
		$picnum = $upload->upload();
		$pic = $upload->getSaveFileInfo();
		
		/*--  整理图片内容数组  --*/
		$content = unserialize(stripslashes($oldrow['content']));

		/*--  缩略图  --*/
		$m=new Miniature();
		for ($i=0;$i<$picnum;$i++) {
			$str_file = WEB_ROOT.substr($pic[$i]['file'],3);
			$m->ReadImage($str_file);
			$m->ResizeImage(200,130);//智能缩小
			$m->ImageType=4;//保存成jpg格式
			$thumb_name=$pic[$i]['basename']."_thumb";
			$m->SaveImage($pic[$i]['thumb_dir'],$thumb_name);
			$m->DestroyImage();
			
			$content[] = $pic[$i]['savename'];
		}

		/*--  序列化数组  --*/
		$content = serialize($content);
		
		/*--  更新图片展示表  --*/
		$sql = "UPDATE {$dbprefix}picturecontent SET catid = '".$pict['catid']."', title = '".$pict['title']."', content = '".$content."' WHERE prid = '".$prid."'";
		$query = $DB->query($sql);
		
		if ($query) {
			showmsg("图片展示信息更新成功","picture.php?act=show");
		} else {
			showmsg("图片展示信息更新失败");
		}
	}
	
}

/*------------------------------------------------------ */
//-- 删除图片
/*------------------------------------------------------ */
if ($_REQUEST['act'] == 'remove')
{
	$prid = $_REQUEST['prid'];
	
	$sql = $row = $query = '';
	$sql = "SELECT * FROM {$dbprefix}picturecontent WHERE prid = $prid";
	$query = $DB->query($sql);
	$row = $DB->fetch_array($query);
	
	/*--  判断封面图片是否为空  --*/
	if ($row['coverpic']) {
		$row['coverpic'] = unserialize(stripslashes($row['coverpic']));
		$row['filepath'] = $row['coverpic']['cover_dir'];
		$row['temname'] = $row['coverpic']['cover_name'];
		
		/*--  开始删除  --*/
		$dir = $row['filepath'];                         
		//打开 images 目录
		$dirhandle = opendir($dir);
		
		/*--  列出 images 目录中的文件  --*/
		while (($file = readdir($dirhandle)) !== false)
		  {
		  	$file = $row['filepath'].'/'.$row['temname'];
		  @unlink($file);
		  }
		  closedir($dirhandle);
		  
		  $sql = "DELETE FROM {$dbprefix}pictures WHERE temname = '".$row['temname']."'";
		  $query = $DB->query($sql);
		  if ($query){
		  	echo "删除成功";
		  }
	}
	
	/*--  判断图片内容是否为空  --*/
	if ($row['content']) {
		$row['content'] = unserialize($row['content']);
		$row['filepath'] = $row['content']['pic_dir'];
		
		for ($i=0;$i<count($row['content'])-2;$i++) {
		$row['temname'] = $row['content'][$i];
		
		/*--  开始删除  --*/
		$dir = $row['filepath'];                         
		//打开 images 目录
		$dirhandle = opendir($dir);
		
		/*--  列出 images 目录中的文件  --*/
		while (($file = readdir($dirhandle)) !== false)
		  {
		  $file = $row['filepath'].'/'.$row['temname'];
		  @unlink($file);
		  }
		  closedir($dirhandle);
		  
		  $sql = "DELETE FROM {$dbprefix}pictures WHERE temname = '".$row['temname']."'";
		  $query = $DB->query($sql);
		  if ($query){
		  	echo "删除成功";
		  }
		}
	}
	
	/*--  删除图片展示表中的数据  --*/
	$sql = "DELETE FROM {$dbprefix}picturecontent WHERE prid = $prid";
	  $query = $DB->query($sql);

	showmsg("图片展示删除成功","picture.php?act=show");
}

/*------------------------------------------------------ */
//-- ajax 删除单张图片
/*------------------------------------------------------ */
if ($_REQUEST['act'] == 'delonepic')
{
	$prid = $_REQUEST['prid'];
	$picname = $_REQUEST['picname'];
	$ext = $_REQUEST['ext'];
	
	$sql = $row = $query = '';
	$sql = "SELECT * FROM {$dbprefix}picturecontent WHERE prid = $prid";
	$row = $DB->fetch_one_array($sql);
	
	/*--  删除图片  --*/
	$row['content'] = unserialize($row['content']);
	
	$filepath = $row['content']['pic_dir'];
	$filename = $picname.$ext;	
		
	/*--  开始删除  --*/
	$dir = WEB_ROOT.substr($filepath,3);                         
	//打开 images 目录
	$dirhandle = opendir($dir);
		
	/*--  列出 images 目录中的文件  --*/
	while (($file = readdir($dirhandle)) !== false) {
		if ($file == $filename) {
			$file = $dir.'/'.$file;
			unlink($file);
		}
	}
	closedir($dirhandle);	  
	
	/*--  删除缩略图  --*/
	$thumbpath = $row['content']['thumb_dir'];	
	$thumbname = $picname.'_thumb'.$ext;
		
	/*--  开始删除  --*/
	$dir = WEB_ROOT.substr($thumbpath,3);                         
	//打开 images 目录
	$dirhandle = opendir($thumbpath);
	
	/*--  列出 images 目录中的文件  --*/
	while (($file = readdir($dirhandle)) !== false) {
		if ($file == $thumbname) {
			$file = $dir.$file;
			unlink($file);
		}
	}
	closedir($dirhandle);	  

	/*--  处理数据表里面的序列串  --*/
	$html = '';
	for ($i=0;$i<count($row['content'])-2;$i++) {
		/*--  if 循环去除数组中删除的图片信息  --*/
		if ($row['content'][$i] != $picname.$ext) {
			$newrow['content'][] = $row['content'][$i];
			
			$basename = basename($row['content'][$i],$ext);
			$thumbname = $basename.'_thumb'.$ext;
				
			/*--  开始重新生成 html 传回页面显示  --*/
			$html .= "<li><img src=".$web_url.substr($row['content']['thumb_dir'],3).$thumbname." /><span><a href=\"#\" onclick=\"delOnePic('".substr($row['content']['pic_dir'],3).$basename."','".$ext."');\">删除</a></span></li>";
		}

	}
	
	/*--  更新数据库  --*/
	$newrow['content']['pic_dir'] = $row['content']['pic_dir'];
	$newrow['content']['thumb_dir'] = $row['content']['thumb_dir'];
	$content = serialize($newrow['content']);
	
	$sql = "UPDATE {$dbprefix}picturecontent SET `content` = '".$content."' WHERE `prid` = '".$prid."'";
	$query = $DB->query($sql);
	
	echo $html;
}
?>