<?php
/**
* FILE_NAME : produce.php
*
* @copyright Copyright (c) 2009 - 2010 www.dali.edu.cn
* @author DaLi University 2009 Graduation Design
* @package 商品展示管理
* @subpackage
* @version Tue Oct 27 05:53:25 GMT 2009
*/

define('IN_WEB', TRUE);
	
require_once( str_replace('\\', '/', dirname(__FILE__)). '/include/global.php');

/* act操作项的初始化 */
if (empty($_REQUEST['act'])) {
    $_REQUEST['act'] = 'show';
} else {
    $_REQUEST['act'] = trim($_REQUEST['act']);
}

/*------------------------------------------------------ */
//-- 显示商品展示列表
/*------------------------------------------------------ */
if ($_REQUEST['act'] == 'show')
{
	$sql = $query = $prolist = '';
	
	$sql = "SELECT p.prid,p.catid,p.title,p.username,p.note,p.dateline,p.viewnum,c.catid,c.name FROM {$dbprefix}produces p LEFT JOIN {$dbprefix}producecategories c ON p.catid = c.catid";
	$query = $DB->query($sql);
	while ($row = $DB->fetch_array($query)) {
		$row['dateline'] = formatdate($_CFG['format_type'],$row['dateline']);
		$prolist[] = $row;
	}
	
	$smarty->assign("css_root", $css_root);
	$smarty->assign("web_url",$web_url);
	
	$smarty->assign("prolist", $prolist);
	
	$smarty->display("produce.html");
}

/*------------------------------------------------------ */
//-- 增加商品展示
/*------------------------------------------------------ */
if ($_REQUEST['act'] == 'add')
{
	$sql = $query = $procatelist = $username = '';
	
	/*--  查询分类信息  --*/
	$sql = "SELECT catid,name FROM {$dbprefix}producecategories";
	$query = $DB->query($sql);
	while ($row = $DB->fetch_array($query)) {
		$procatelist[] = $row;
	}
	
	$username = $_SESSION['admin_name'];
	$smarty->assign("css_root", $css_root);
	$smarty->assign("web_url", $web_url);
	
	$smarty->assign("username",$username);
	$smarty->assign("procatelist",$procatelist);
	
	$smarty->display("produce_add.html");
}

/*------------------------------------------------------ */
//-- 添加商品展示成功
/*------------------------------------------------------ */
if ($_REQUEST['act'] == 'addok')
{
	require_once( WEB_ROOT."admin/include/admin_upload.class.php");
	require_once( WEB_ROOT."admin/include/admin_miniature.class.php");
	$coverpic = array();
	
	$pro = $_REQUEST['pro'];
	$sql = $query = $sercontent = $sercoverpic = '';
	
	if ($_FILES['coverpic']['name'] != ''){
		/*--  实例化上传类  --*/
		$file = $_FILES['coverpic'];
		$upload_path = '../attachments/produce';
		$allow_type=array('jpg','bmp','png','gif','jpeg');
		$max_size=2048000;

		$upload = new upFiles($file, $upload_path, $max_size, $allow_type);
		$upload->upload();
		$pic = $upload->getSaveFileInfo();

		/*--  缩略图  --*/
		$m=new Miniature();
		$str_file = WEB_ROOT.substr($pic['file'],2);
		$m->ReadImage($str_file);
		$m->ResizeImage(200,130);//智能缩小
		$m->ImageType=4;//保存成jpg格式
		$cover_name=$pic['basename'];
		$m->SaveImage($pic['cover_dir'],$cover_name);
		
		$coverpic['cover_dir'] = $pic['cover_dir'];
		$coverpic['cover_name'] = $cover_name.'.jpg';
		
		$m->DestroyImage();//销毁图片
	}

	$sercoverpic = serialize($coverpic);

	/*--  写入商品展示表  --*/
	$sql = "INSERT INTO {$dbprefix}produces (prid,catid,title,username,note,coverpic,dateline,viewnum) VALUE ('','".$pro['catid']."','".$pro['title']."','".$pro['username']."','".$pro['note']."','".$sercoverpic."','".$timestamp."',0)";
	$query = $DB->query($sql);
	$prid = $DB->insert_id();
	
	/*--  写入内容表  --*/
	$sql = "INSERT INTO {$dbprefix}producecontent (id,prid,content) VALUE ('','".$prid."','".$pro['content']."')";
	$query = $DB->query($sql);
	
	if ($query) {
		showmsg("商品展示添加成功","produce.php?act=show");
	}
}

/*------------------------------------------------------ */
//-- 编辑商品
/*------------------------------------------------------ */
if ($_REQUEST['act'] == 'edit')
{
	$prid = $_REQUEST['prid'];
	
	$sql = $query = $procatelist = '';
	
	/*--  查询分类信息  --*/
	$sql = "SELECT catid,name FROM {$dbprefix}producecategories";
	$query = $DB->query($sql);
	while ($row = $DB->fetch_array($query)) {
		$procatelist[] = $row;
	}
	
	/*--  查询商品基本信息  --*/
	$sql = "SELECT * FROM {$dbprefix}produces WHERE prid = $prid";
	$query = $DB->query($sql);
	$row= $DB->fetch_array($query);
	
	/*--  查询商品详细信息  --*/
	$sql = "SELECT * FROM {$dbprefix}producecontent WHERE prid = $prid";
	$query = $DB->query($sql);
	$pro = $DB->fetch_array($query);
	
	/*--  反序列化  --*/
	if ($row['coverpic']) {
//		$row['coverpic'] = unserialize(stripslashes($row['coverpic']));	
		$row['coverpic'] = unserialize($row['coverpic']);
	}
	
	$smarty->assign("css_root", $css_root);
	$smarty->assign("web_url", $web_url);
	
	$smarty->assign("pro_prid",$row['prid']);
	$smarty->assign("pro_catid",$row['catid']);
	$smarty->assign("pro_title",$row['title']);
	$smarty->assign("pro_note",$row['note']);
	$smarty->assign("coverpic",$row['coverpic']['cover_name']);
	$smarty->assign("content",$pro['content']);
	
	$smarty->assign("procatelist",$procatelist);
	
	$smarty->display("produce_edit.html");
}

/*------------------------------------------------------ */
//-- 确定编辑图片
/*------------------------------------------------------ */
if ($_REQUEST['act'] == 'editok')
{
	$prid = $_REQUEST['prid'];
	
	/*--  查询数据表原数据  --*/
	$sql = "SELECT * FROM {$dbprefix}produces WHERE prid = '".$prid."'";
	$query = $DB->query($sql);
	while ($row = $DB->fetch_array($query)) {
		$oldrow = $row;
	}
	/*--  对封面图片进行反序列化  --*/
	$oldrow['coverpic'] = unserialize(stripslashes($oldrow['coverpic']));	
	
	/*--  接收表单传来数据  --*/
	$pro = $_REQUEST['pro'];
	
	/*--  判断封面图片是否改变  --*/
	if ($pro['coverpic'] != $oldrow['coverpic']['cover_name']) {
//		$pict['coverpic'] 的值为: ../attachments/picture/2009/10/48437700_thumb.jpg
		/*--  分割 $pict[coverpic] 的值 --*/
		$ext = strrchr($pro['coverpic'],'.'); //取后缀
	 
		$filepath = substr($pro['coverpic'],strrpos($pro['coverpic'],'/')); //取路径
		 
		$filename = strrchr($pro['coverpic'],'/'); //取文件名
	 
		
		/*--  复制图片  --*/
		$fromdir = WEB_ROOT.substr($pro['coverpic'],3);
		 
		$todir = WEB_ROOT.substr($oldrow['coverpic']['cover_dir'],3).$oldrow['coverpic']['cover_name'];
		  
		copy($fromdir,$todir);
		 
		 
	}
	
	/*--  更新商品基本信息表  --*/
	$sql = "UPDATE {$dbprefix}produces SET catid = '".$pro['catid']."', title = '".$pro['title']."', note = '".$pro['note']."' WHERE prid = '".$prid."'";
	$DB->query($sql);
		
	/*--  更新图片展示表  --*/
	$sql = "UPDATE {$dbprefix}producecontent SET content = '".$pro['content']."' WHERE prid = '".$prid."'";
	$query = $DB->query($sql);
		
	if ($query) {
		showmsg("商品信息更新成功","produce.php?act=show");
	} else {
		showmsg("商品信息更新失败");
	}
	
}


/*------------------------------------------------------ */
//-- 删除图片
/*------------------------------------------------------ */
if ($_REQUEST['act'] == 'remove')
{
	$prid = $_REQUEST['prid'];
	
	$sql = $row = $query = '';
	$sql = "SELECT * FROM {$dbprefix}produces WHERE prid = $prid";
	$query = $DB->query($sql);
	$row = $DB->fetch_array($query);
	
	/*--  判断封面图片是否为空  --*/
	if ($row['coverpic']) {
		$row['coverpic'] = unserialize($row['coverpic']);
		$filepath = $row['coverpic']['cover_dir'];
		$filename = $row['coverpic']['cover_name'];
		
		/*--  开始删除  --*/
		$dir = WEB_ROOT.substr($filepath,3);                         
		//打开 images 目录
		$dirhandle = opendir($dir);
		
		/*--  列出 images 目录中的文件  --*/
		while (($file = readdir($dirhandle)) !== false)
		  {
		  	if ($file == $filename) {
		  		$file = WEB_ROOT.$filename;
		  		@unlink($file);
		  	}
		  }
		  closedir($dirhandle);
		  
		  $sql = "DELETE FROM {$dbprefix}produces WHERE prid = '".$prid."'";
		  $query = $DB->query($sql);
	}
	
	/*--  删除商品展示主要数据  --*/
	$sql = "DELETE FROM {$dbprefix}producecontent WHERE prid = $prid";
	$query = $DB->query($sql);

	if ($query) {
		showmsg("删除成功","produce.php?act=show");
	} else {
		showmsg("删除失败","picture.php?act=show");
	}
}
?>