<?php
/**
* FILE_NAME : common.inc.php
*
* @copyright Copyright (c) www.shuangyulin.com
* @author 双鱼林设计
* @package 前台控制文件
* @subpackage
* @version QQ:287307421 或 254540457
*/



//@header("content-Type: text/html; charset=UTF-8");
//定义PHP一些环境
session_start();
//error_reporting(0);
set_magic_quotes_runtime(0);



/*--  定义一些常量  --*/
define('IN_WEB', TRUE);
define('WEB_ROOT', str_replace("\\", '/', substr(dirname(__FILE__), 0, -7)));
define('MAGIC_QUOTES_GPC', get_magic_quotes_gpc());




/*--  引入前台全局函数库  --*/
require_once WEB_ROOT.'include/global.fun.php';



/*--  初始化一些变量  --*/
$dbhost = $dbuser = $dbpass = $dbname = $pconnect = $dbprefix = $dbcharset = $charset = '';
$_SGLOBAL = $_DCACHE = array();

/*--  对 URL 传值进行过滤  --*/
foreach(array('_COOKIE', '_POST', '_GET') as $_request) {
	foreach($$_request as $_key => $_value) {
		$_key{0} != '_' && $$_key = daddslashes($_value);
	}
}

/*--  引入基本配置文件  --*/
require_once WEB_ROOT.'config.inc.php';
require_once WEB_ROOT.'include/db_mysql.class.php';

/*--  实例化MySQL数据库类  --*/
$DB = new DB_MySQL();
$DB->connect($dbhost, $dbuser, $dbpass, $dbname, $pconnect);
unset($dbhost, $dbuser, $dbpass, $dbname, $pconnect);

/*--  获得本地时间  --*/
$timestamp = gmtime();

/*--  返回自身文件名常量  --*/
$php_self = dhtmlspecialchars($_SERVER['PHP_SELF'] ? $_SERVER['PHP_SELF'] : $_SERVER['SCRIPT_NAME']);

/*--  获取在线IP  --*/
$onlineip = getonlineip();

/*--  读取缓存  --*/
if (!@include(WEB_ROOT.'cache/settings.php')) {
	require_once(WEB_ROOT.'include/cache.php');
	recache();
	exit('<p>caches created successfully , please refresh the page!</p>');
}


/*--  系统URL  --*/
if (!$_CFG['siteurl']) {
	$_CFG['siteurl'] = 'http://'.$_SERVER['HTTP_HOST'].dirname($PHP_SELF).'/';
} else {
	$_CFG['siteurl'] = str_replace(array('{host}','index.php'), array($_SERVER['HTTP_HOST'],''), $_CFG['siteurl']);
	if (substr($_CFG['siteurl'], -1) != '/') {
		$_CFG['siteurl'] = $_CFG['siteurl'].'/';
	}
}

/*--  定义前台模板 CSS 和 图片 地址  --*/
$css_root = $_CFG['siteurl'].'templates/default/';
$web_url = $_CFG['siteurl'];

/*--  引入 smarty 配置文件  --*/
require_once WEB_ROOT.'include/config.smarty.php';
include_once WEB_ROOT.'smarty/Smarty.class.php';

$template = new Smarty();
$template->caching = $tpl_caching;
$template->template_dir = WEB_ROOT.$tpl_template_dir;
$template->compile_dir = WEB_ROOT.$tpl_compile_dir;
$template->cache_dir = WEB_ROOT.$tpl_cache_dir;
$template->left_delimiter = $tpl_left_delimiter;
$template->right_delimiter = $tpl_right_delimiter;
?>