<?php
/**
* FILE_NAME : db_mysql.class.php
*
* @copyright Copyright (c) www.shuangyulin.com
* @author 双鱼林
* @package 数据库类文件
* @subpackage
* @version  QQ:287307421 或 254540457
*/

if(!defined('IN_WEB')) 
{
	exit('Access Denied');
}

class DB_MySQL  {

	var $querycount = 0;
	
//	返回MySQL错误
	function geterrdesc() {
		return mysql_error();
	}

//	返回MySQL错误行号
	function geterrno() {
		return intval(mysql_errno());
	}

//	返回插入新行的id
	function insert_id() {
		$id = mysql_insert_id();
		return $id;
	}

//	连接数据库
	function connect($dbhost, $dbuser, $dbpass, $dbname, $pconnect=0) {
		if($pconnect) {
			if(!@mysql_pconnect($dbhost, $dbuser, $dbpass)) {
				$this->halt('数据库链接失败');
			}
		} else {
			if(!@mysql_connect($dbhost, $dbuser, $dbpass)) {
				$this->halt('数据库链接失败');
			}
		}

		if($this->version() > '4.1') {
			global $charset, $dbcharset;
			if(!$dbcharset && in_array(strtolower($charset), array('gbk', 'big5', 'utf-8'))) {
				$dbcharset = str_replace('-', '', $charset);
			}
			if($dbcharset) {
				mysql_query("SET NAMES '$dbcharset'");
				mysql_query("SET character_set_connection=$dbcharset, character_set_results=$dbcharset, character_set_client=binary;");
			}
		}

		if($this->version() > '5.0.1') {
			mysql_query("SET sql_mode=''");
		}

		if($dbname) {
			$this->select_db($dbname);
		}
	}

	//定义 fetch_array 方法，此函数返回根据从结果集取得的行生成的数组，如果没有返回FALSE
	function fetch_array($query, $result_type = MYSQL_ASSOC) {
		return mysql_fetch_array($query, $result_type);
	}

	//定义 query 方法，用于执行一次 SQL 查询
	function query($sql, $type = '') {
		$func = $type == 'UNBUFFERED' && @function_exists('mysql_unbuffered_query') ?
			'mysql_unbuffered_query' : 'mysql_query';
		if(!($query = $func($sql)) && $type != 'SILENT') {
			$this->halt('MySQL Query Error', $sql);
		}
		$this->querycount++;
		return $query;
	}

	//此方法比 query 方法多了一个清除缓存的参数
	function unbuffered_query($sql) {
		$query = $this->query($sql, 'UNBUFFERED');
		return $query;
	}

	//使用库为当前库
	function select_db($dbname) {
		return mysql_select_db($dbname);
	}

	//将查询结果以数组的形式返回
	function fetch_row($query) {
		$query = mysql_fetch_row($query);
		return $query;
	}

	//直接执行一个 SQL 语句，并返回结果
	function fetch_one_array($query) {
		$result = $this->query($query);
		$record = $this->fetch_array($result);
		return $record;
	}

	//	返回结果集中行的数目
	function num_rows($query) {
		$query = mysql_num_rows($query);
		return $query;
	}

	//返回结果集中字段的数目
	function num_fields($query) {
		return mysql_num_fields($query);
	}

	//返回结果集中一个单元的内容
	function result($query, $row) {
		$query = @mysql_result($query, $row);
		return $query;
	}

	//释放内存
	function free_result($query) {
		$query = mysql_free_result($query);
		return $query;
	}

	//返回 MySQL 的版本号
	function version() {
		return mysql_get_server_info();
	}

	//关闭数据库连接
	function close() {
		return mysql_close();
	}

	//错误提示
	function halt($msg, $sql=''){
		global $php_self,$timestamp,$onlineip;

		if ($sql) {
			@$fp = fopen(ROOT.'cache/log/dberrorlog.php', 'a');
			@fwrite($fp, "<?PHP exit('Access Denied'); ?>\t$timestamp\t$onlineip\t".basename($php_self)."\t".htmlspecialchars($this->geterrdesc())."\t".str_replace(array("\r", "\n", "\t"), array(' ', ' ', ' '), trim(htmlspecialchars($sql)))."\n");
			@fclose($fp);
		}

		$message = "<html>\n<head>\n";
		$message .= "<meta content=\"text/html; charset=utf-8\" http-equiv=\"Content-Type\">\n";
		$message .= "<style type=\"text/css\">\n";
		$message .=  "body,p,pre {\n";
		$message .=  "font:12px Verdana;\n";
		$message .=  "}\n";
		$message .=  "</style>\n";
		$message .= "</head>\n";
		$message .= "<body bgcolor=\"#FFFFFF\" text=\"#000000\" link=\"#006699\" vlink=\"#5493B4\">\n";

		$message .= "<p>数据库出错:</p><pre><b>".htmlspecialchars($msg)."</b></pre>\n";
		$message .= "<b>Mysql error description</b>: ".htmlspecialchars($this->geterrdesc())."\n<br />";
		$message .= "<b>Mysql error number</b>: ".$this->geterrno()."\n<br />";
		$message .= "<b>Date</b>: ".date("Y-m-d @ H:i")."\n<br />";
		$message .= "<b>Script</b>: http://".$_SERVER['HTTP_HOST'].getenv("REQUEST_URI")."\n<br />";

		$message .= "</body>\n</html>";
		echo $message;
		exit;
	}
}
?>