<?php
/**
* FILE_NAME : global.fun.php
*
* @copyright Copyright (c) www.shuangyulin.com
* @author shuangyulin  Design
* @package 全局公用函数库
* @subpackage
* @version QQ:287307421 或 254540457
*/

if(!defined('IN_WEB')) {
	exit('Access Denied');
}

/**
* 加密算法，用的是base64加密，分别能加密和解密。通过传入$operation = 'ENCODE'|'DECODE'来实现。
* @para string $string 要加/解密的string
* @para string $operation 方法 
* @para string $key 用来加密的key
* 
* @return string
*/
function authcode($string, $operation = 'DECODE', $key = '', $expiry = 0) {

	$ckey_length = 4;
	$key = md5($key ? $key : 'WEB_ROOT');
	$keya = md5(substr($key, 0, 16));
	$keyb = md5(substr($key, 16, 16));
	$keyc = $ckey_length ? ($operation == 'DECODE' ? substr($string, 0, $ckey_length): substr(md5(microtime()), -$ckey_length)) : '';

	$cryptkey = $keya.md5($keya.$keyc);
	$key_length = strlen($cryptkey);

	$string = $operation == 'DECODE' ? base64_decode(substr($string, $ckey_length)) : sprintf('%010d', $expiry ? $expiry + time() : 0).substr(md5($string.$keyb), 0, 16).$string;
	$string_length = strlen($string);

	$result = '';
	$box = range(0, 255);

	$rndkey = array();
	for($i = 0; $i <= 255; $i++) {
		$rndkey[$i] = ord($cryptkey[$i % $key_length]);
	}

	for($j = $i = 0; $i < 256; $i++) {
		$j = ($j + $box[$i] + $rndkey[$i]) % 256;
		$tmp = $box[$i];
		$box[$i] = $box[$j];
		$box[$j] = $tmp;
	}

	for($a = $j = $i = 0; $i < $string_length; $i++) {
		$a = ($a + 1) % 256;
		$j = ($j + $box[$a]) % 256;
		$tmp = $box[$a];
		$box[$a] = $box[$j];
		$box[$j] = $tmp;
		$result .= chr(ord($string[$i]) ^ ($box[($box[$a] + $box[$j]) % 256]));
	}

	if($operation == 'DECODE') {
		if((substr($result, 0, 10) == 0 || substr($result, 0, 10) - time() > 0) && substr($result, 10, 16) == substr(md5(substr($result, 26).$keyb), 0, 16)) {
			return substr($result, 26);
		} else {
			return '';
		}
	} else {
		return $keyc.str_replace('=', '', base64_encode($result));
	}

}

/**
* 用来格式化文件大小，将文件用 M 等表示
* @para string $input 文件的字节数
* @para int $dec 四舍五入的位数
* 
* @return string
*/
function formatbyte($input, $dec=0) {   
	$prefix_arr = array(' B', 'K', 'M', 'G', 'T');  
	$value = round($input, $dec);  
	$i=0;  
	while ($value>1024) {   
		$value /= 1024;  
		$i++;  
	}  
	$return_str = round($value, $dec).$prefix_arr[$i];  
	return $return_str;  
}

/**
* 用来完美分词的，也就是把一段中文字只取前面一段，再加一个…
* @para string $string 用来分词的串
* @para int $length 保留的长度
* @para string $dot 最后加点什么
* 
* @return string
*/
function cutstr($string, $length, $dot = ' ...') {
	global $charset;

	if(strlen($string) <= $length) {
		return $string;
	}

	$string = str_replace(array('&amp;', '&quot;', '&lt;', '&gt;'), array('&', '"', '<', '>'), $string);

	$strcut = '';
	if(strtolower($charset) == 'utf-8') {

		$n = $tn = $noc = 0;
		while($n < strlen($string)) {

			$t = ord($string[$n]);
			if($t == 9 || $t == 10 || (32 <= $t && $t <= 126)) {
				$tn = 1; $n++; $noc++;
			} elseif(194 <= $t && $t <= 223) {
				$tn = 2; $n += 2; $noc += 2;
			} elseif(224 <= $t && $t <= 239) {
				$tn = 3; $n += 3; $noc += 2;
			} elseif(240 <= $t && $t <= 247) {
				$tn = 4; $n += 4; $noc += 2;
			} elseif(248 <= $t && $t <= 251) {
				$tn = 5; $n += 5; $noc += 2;
			} elseif($t == 252 || $t == 253) {
				$tn = 6; $n += 6; $noc += 2;
			} else {
				$n++;
			}

			if($noc >= $length) {
				break;
			}

		}
		if($noc > $length) {
			$n -= $tn;
		}

		$strcut = substr($string, 0, $n);

	} else {
		for($i = 0; $i < $length; $i++) {
			$strcut .= ord($string[$i]) > 127 ? $string[$i].$string[++$i] : $string[$i];
		}
	}

	$strcut = str_replace(array('&', '"', '<', '>'), array('&amp;', '&quot;', '&lt;', '&gt;'), $strcut);

	return $strcut.$dot;
}

/**
* 用来过滤字串的，之所以要这样一个函数是考虑到是不是打开了magic_quotes_gpc.
* @para string $string 要过滤的字串
* @para int $force 强制过滤
* 
* @return string
*/
function daddslashes($string, $force = 0) {
	!defined('MAGIC_QUOTES_GPC') && define('MAGIC_QUOTES_GPC', get_magic_quotes_gpc());
	if(!MAGIC_QUOTES_GPC || $force) {
		if(is_array($string)) {
			foreach($string as $key => $val) {
				$string[$key] = daddslashes($val, $force);
			}
		} else {
			$string = addslashes($string);
		}
	}
	return $string;
}

/**        
* 过滤HTML代码的
* @para string $string
* 
* @return string
*/
function dhtmlspecialchars($string) {
	if(is_array($string)) {
		foreach($string as $key => $val) {
			$string[$key] = dhtmlspecialchars($val);
		}
	} else {
		$string = preg_replace('/&amp;((#(\d{3,5}|x[a-fA-F0-9]{4}));)/', '&\\1',
		//$string = preg_replace('/&amp;((#(\d{3,5}|x[a-fA-F0-9]{4})|[a-zA-Z][a-z0-9]{2,5});)/', '&\\1',
		str_replace(array('&', '"', '<', '>'), array('&amp;', '&quot;', '&lt;', '&gt;'), $string));
	}
	return $string;
}

/**
 * 格式化时间
 *
 * @return  integer
 */
function formatdate($format,$timestamp = '')
{
    return (date($format,$timestamp));
}

/**
 * 获得当前本地时间的时间戳
 *
 * @return  integer
 */
function gmtime() {
	date_default_timezone_set('PRC');
    return (time());
}

/**
 * 获得在线IP
 *
 * @return  integer
 */
function getonlineip() {
	if(getenv('HTTP_CLIENT_IP') && strcasecmp(getenv('HTTP_CLIENT_IP'), 'unknown')) {
		$onlineip = getenv('HTTP_CLIENT_IP');
	} 
	elseif(getenv('HTTP_X_FORWARDED_FOR') && strcasecmp(getenv('HTTP_X_FORWARDED_FOR'), 'unknown')) {
		$onlineip = getenv('HTTP_X_FORWARDED_FOR');
	} 
	elseif(getenv('REMOTE_ADDR') && strcasecmp(getenv('REMOTE_ADDR'), 'unknown')) {
		$onlineip = getenv('REMOTE_ADDR');
	} 
	elseif(isset($_SERVER['REMOTE_ADDR']) && $_SERVER['REMOTE_ADDR'] && strcasecmp($_SERVER['REMOTE_ADDR'], 'unknown')) {
		$onlineip = $_SERVER['REMOTE_ADDR'];
	}
	
	//正则判断IP是不是点分段
	preg_match("/[\d\.]{7,15}/", $onlineip, $onlineipmatches);
	$onlineip = $onlineipmatches ? $onlineipmatches : 'unknown';
	unset($onlineipmatches);
	
	return $onlineip;
}

/**
* 用来得到上一个页面的地址，也就是来路。
* @para string $default 这个参数是直接设置一个refer，不用判断得到
*
* @return string
*/
function dreferer($default = '') {
	global $referer, $indexname;

	$default = empty($default) ? $indexname : '';
	if(empty($referer) && isset($GLOBALS['_SERVER']['HTTP_REFERER'])) {
		$referer = preg_replace("/([\?&])((sid\=[a-z0-9]{6})(&|$))/i", '\\1', $GLOBALS['_SERVER']['HTTP_REFERER']);
		$referer = substr($referer, -1) == '?' ? substr($referer, 0, -1) : $referer;
	} else {
		$referer = dhtmlspecialchars($referer);
	}

	if(!preg_match("/(\.php|[a-z]+(\-\d+)+\.html)/", $referer) || strpos($referer, 'logging.php')) {
		$referer = $default;
	}
	return $referer;
}

/**
* 对文件名进行截断处理，输入文件名，取得文件扩展名
* @para string $filename 文件名
*
* @return string
*/
function fileext($filename) {
	return trim(substr(strrchr($filename, '.'), 1, 10));
}

/**
 * 前台提示信息，跳转窗口
 *
 * @param   string   $msg        显示信息
 * @param   string   $gourl      跳转的url
 *
 * @return  string
 */
function showmessage($msg, $gourl='goback') {
 	global $template;
 	$template->caching = false;
 	$template->assign("msg",$msg);
 	$template->assign("gourl",$gourl);
 	$template->display("showmessage.html");
 	
 	exit();
}

/**
 * 分页函数
 *
 * @param   int      $num        总数
 * @param   int      $perpage    每页显示数量
 * @param   int      $curpage    当前页
 * @param   string   $mpurl      传递的URL
 * @param   int      $page       显示的页数，默认为10
 *
 * @return  string
 */
function multi($num, $perpage, $curpage, $mpurl, $page = 10) {

	$curpage = $curpage ? $curpage : 1;
	$multipage = '';
	$mpurl .= strpos($mpurl, '?') ? '&amp;' : '?';
	$pages = 1;//总页数
	if($num > $perpage) {
		$offset = $page - 1;

		$pages = @ceil($num / $perpage);

		if($page > $pages) {
			$from = 1;
			$to = $pages;
		} else {
			$from = $curpage - $offset;
			$to = $from + $page - 1;
			if($from < 1) {
				$to = $page;//$curpage + 1 - $from;
				$from = 1;
				if($to - $from < $page) {
					$to = $page;
				}
			} elseif($to > $pages) {
				$from = $pages - $page + 1;
				$to = $pages;
			}
		}

		$curpage = $curpage <= $pages ? $curpage : $pages;

		$multipage = ($curpage > 1 ? '<li><a href="'.$mpurl.'page='.($curpage - 1).'">上一页</a></li>' : '').
            ($curpage - $offset > 1 && $pages > $page ? '<li><a href="'.$mpurl.'page=1" class="first">1</a></li>' : '').
            ($curpage > $page+1 ? '<li class="point">...</li>' : '');
		for($i = $from; $i <= $to; $i++) {
			$multipage .= $i == $curpage ? '<li class="thisclass"><a>'.$i.'</a></li>' :
				'<li><a href="'.$mpurl.'page='.$i.'">'.$i.'</a></li>';
		}

		$multipage .= ($curpage < $pages-1 ? '<li class="point">...</li>' : '').
            ($to < $pages ? '<li><a href="'.$mpurl.'page='.$pages.'" class="last">'.$pages.'</a><li>' : '').
            ($curpage < $pages ? '<li><a href="'.$mpurl.'page='.($curpage + 1).'">下一页</a><?li>' : '').
			($pages > $page ? '<li><a>转到：</a></li><input type="text" name="custompage" size="3" onkeydown="if(event.keyCode==13) {window.location=\''.$mpurl.'page=\'+this.value; return false;}" />' : '');

		$multipage = $multipage ? '<div class="pages"><ul class="pagelist">'.('<li><a>共&nbsp;'.$pages.'&nbsp;页</a></li>').$multipage.'</ul></div>' : '';
	}

	return $multipage;
}


?>