VERSION 5.00
Object = "{34FA473A-90C5-4F95-95AF-9C31E57D183C}#69.1#0"; "PicViewer.ocx"
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Begin VB.Form Form1 
   AutoRedraw      =   -1  'True
   Caption         =   "Demo For PicView.Ocx"
   ClientHeight    =   6270
   ClientLeft      =   165
   ClientTop       =   555
   ClientWidth     =   8175
   LinkTopic       =   "Form1"
   ScaleHeight     =   6270
   ScaleWidth      =   8175
   StartUpPosition =   2  'CenterScreen
   Begin MSComDlg.CommonDialog CommonDialog1 
      Left            =   3840
      Top             =   2640
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin PicViewer.PicView PicView1 
      Height          =   3375
      Left            =   1920
      TabIndex        =   0
      Top             =   1320
      Width           =   4455
      _ExtentX        =   7858
      _ExtentY        =   5953
   End
   Begin VB.Menu idm_File 
      Caption         =   "&File"
      Begin VB.Menu idm_New 
         Caption         =   "New"
      End
      Begin VB.Menu idm_Open 
         Caption         =   "&Open"
      End
      Begin VB.Menu idm_Palette 
         Caption         =   "Palette"
      End
      Begin VB.Menu idm_Change 
         Caption         =   "Change Pixels"
      End
      Begin VB.Menu idm_Change2 
         Caption         =   "Invert RGB"
      End
      Begin VB.Menu idm_SaveAs 
         Caption         =   "SaveAs"
      End
      Begin VB.Menu idm_SaveTC 
         Caption         =   "SaveAs true Color"
      End
      Begin VB.Menu idm_About 
         Caption         =   "About"
      End
      Begin VB.Menu idm_Sep 
         Caption         =   "-"
      End
      Begin VB.Menu idm_Exit 
         Caption         =   "E&xit"
      End
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Sub Form_Load()
   SetPanel
End Sub

Private Sub SetPanel()
   With PicView1
     .Left = 0
     .Top = 0
     .Width = Me.ScaleWidth
     .Height = Me.ScaleHeight
   End With
End Sub

Private Sub Form_Resize()
   SetPanel
End Sub

Private Sub Form_Unload(Cancel As Integer)
   End
End Sub

Private Sub idm_About_Click()
   PicView1.About
End Sub

Private Sub idm_Change_Click()
   Dim i As Long, j As Long, pix As Long
   Dim cRgb(0 To 3) As Byte
   
   For i = PicView1.PicHeight / 4 To PicView1.PicHeight / 4 * 3 - 1
      For j = PicView1.PicWidth / 4 To PicView1.PicWidth / 4 * 3 - 1
         pix = PicView1.GetPicPixel(j, i, cRgb)
         If pix >= 0 Then
            Select Case PicView1.PicBits
               Case 1
                  cRgb(0) = 1 - pix
               Case 2
                  cRgb(0) = 3 - pix
               Case 4
                  cRgb(0) = 15 - pix
               Case 8
                  cRgb(0) = 255 - pix
               Case 16
                 cRgb(0) = 255 - cRgb(0)
                 cRgb(1) = 255 - cRgb(1)
                 cRgb(2) = 255 - cRgb(2)
               Case 24
                 cRgb(0) = 255 - cRgb(0)
                 cRgb(1) = 255 - cRgb(1)
                 cRgb(2) = 255 - cRgb(2)
               Case Else
                  Exit Sub
            End Select
            PicView1.SetPicPixel j, i, cRgb
         End If
      Next j
   Next i
   
   PicView1.PicUpdate
End Sub

Private Sub idm_Change2_Click()
  PicView1.InvertColor
End Sub

Private Sub idm_Exit_Click()
   Unload Me
End Sub

Private Sub idm_New_Click()
   Dim pos As Long, n As Long
   Dim i As Long, row As Long
   Dim TmpFile As String
   
   If Right(App.Path, 1) = "\" Then
      TmpFile = App.Path & "NewBmp.bmp"
   Else
      TmpFile = App.Path & "\NewBmp.bmp"
   End If
   
   n = PicView1.PicCreate(311, 512, 8, TmpFile)
   PicView1.OpenPicture TmpFile
   
   n = PicView1.PicLineBytes
   ReDim b(0 To n) As Byte
   
   For row = 0 To PicView1.PicHeight - 1
      For i = 0 To n - 1
         If (i Mod 20) = 0 Then
             b(i) = 0
         Else
             b(i) = 255
         End If
      Next i
      
      pos = row * PicView1.PicLineBytes2
      PicView1.SetBitmapData pos, n, b
   Next row
   
   PicView1.PicUpdate
End Sub

Private Sub idm_Open_Click()
   Dim Fname As String
   
   With CommonDialog1
      .DialogTitle = "Open Picture File"
      .Filter = "Available Pictures|*.jpg;*.bmp;*.gif|All Files|*.*"
      .FilterIndex = 1
      .CancelError = True
      On Error Resume Next
      .ShowOpen
      If Err = 0 Then
         Fname = .FileName
      Else
         Exit Sub
      End If
   End With
   
   If PicView1.OpenPicture(Fname) > 0 Then
      Me.Caption = Fname
   End If
End Sub

Private Sub idm_Palette_Click()
   Dim pal(0 To 768) As Byte
   Dim iRet As Long
   
   iRet = PicView1.GetPal(pal)
   
   If iRet > 0 Then
      PicView1.Visible = False
   
      Dim i As Long, j As Long, k As Long
      Dim x As Long, y As Long, Color As Long
      
      k = 0
      For i = 0 To 15
         For j = 0 To 15
            x = Me.ScaleWidth / 16 * j
            y = Me.ScaleHeight / 16 * i
            Color = CLng(pal(k * 3)) + CLng(pal(k * 3 + 1)) * 256 + CLng(pal(k * 3 + 2)) * 65536
            
            Me.Line (x, y)-(x + Me.ScaleWidth / 16, y + Me.ScaleHeight / 16), Color, BF
            
            k = k + 1
         Next j
      Next i
   
      MsgBox "Number of palette is " & iRet, vbOKOnly + vbInformation, "Message"
      PicView1.Visible = True
   End If
End Sub

Private Sub idm_SaveAs_Click()
   Dim Fname As String
   Dim dpath As String, pure As String, prefix As String, suffix As String
   
   With CommonDialog1
      .DialogTitle = "Save Bitmap Image"
      .Filter = "BMP|*.bmp|TIF|*.tif|PCX|*.pcx|GIF|*.gif|TGA|*.tga|JPEG|*.jpg|All files|*.*"
      .FilterIndex = 1
      dpath = PicView1.SeparateFilename(PicView1.PicFile, pure, prefix, suffix)
      .FileName = prefix
      .CancelError = True
      On Error Resume Next
      .ShowSave
      If Err = 0 Then
         Fname = .FileName
      Else
         Exit Sub
      End If
   End With
   
   Dim i As Long
   
   i = PicView1.SaveAs(Fname)
   MsgBox "Return Value is " & i, vbOKOnly + vbInformation, "Information"
End Sub

Private Sub idm_SaveTC_Click()
   Dim Fname As String
   Dim dpath As String, pure As String, prefix As String, suffix As String
   
   With CommonDialog1
      .DialogTitle = "Save Bitmap Image"
      .Filter = "BMP|*.bmp|TIF|*.tif|PCX|*.pcx|TGA|*.tga|JPEG|*.jpg|All files|*.*"
      .FilterIndex = 1
      dpath = PicView1.SeparateFilename(PicView1.PicFile, pure, prefix, suffix)
      .FileName = prefix
      .CancelError = True
      On Error Resume Next
      .ShowSave
      If Err = 0 Then
         Fname = .FileName
      Else
         Exit Sub
      End If
   End With
   
   Dim i As Long
   
   i = PicView1.SaveAsTrueColor(Fname)
   MsgBox "Return Value is " & i, vbOKOnly + vbInformation, "Information"
End Sub

Private Sub PicView1_PictureManipulation(Manipulation As PicViewer.PicManiID)
   Select Case Manipulation
      Case pmiNextPicture, pmiPrevPicture  '1,2
         Me.Caption = PicView1.PicFile
   End Select
End Sub
