/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.autoconfig.factory;

import info.loenwind.autoconfig.factory.ByteBufAdapterRegistry;
import info.loenwind.autoconfig.factory.ByteBufAdapters;
import info.loenwind.autoconfig.factory.IByteBufAdapter;
import info.loenwind.autoconfig.factory.IValue;
import info.loenwind.autoconfig.factory.IValueFactory;
import info.loenwind.autoconfig.util.Lang;
import info.loenwind.autoconfig.util.Log;
import info.loenwind.autoconfig.util.NullHelper;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractValue<T>
implements IValue<T> {
    protected final IValueFactory owner;
    protected int valueGeneration = 0;
    protected final String section;
    protected final String keyname;
    private final String text;
    protected final T defaultValue;
    @Nullable
    protected T value = null;
    @Nullable
    protected Double minValue;
    @Nullable
    protected Double maxValue;
    private boolean isSynced = false;
    protected boolean isStartup = false;

    protected AbstractValue(IValueFactory owner, String section, String keyname, T defaultValue, String text) {
        this.owner = owner;
        this.section = section;
        this.keyname = keyname;
        this.text = text;
        this.defaultValue = defaultValue;
    }

    @Override
    @Nonnull
    public T get() {
        if (this.value == null || this.valueGeneration != this.owner.getGeneration()) {
            Map<String, Object> serverConfig = this.owner.getServerConfig();
            if (serverConfig != null && serverConfig.containsKey(this.keyname)) {
                try {
                    this.value = serverConfig.get(this.keyname);
                }
                catch (ClassCastException e) {
                    Log.error("Server config value ", this.keyname, " is invalid");
                    this.value = null;
                }
            } else {
                this.value = this.makeValue();
                if (!this.owner.isInInit() && this.owner.getConfig().hasChanged()) {
                    this.owner.getConfig().save();
                }
            }
            this.valueGeneration = this.owner.getGeneration();
        }
        return (T)NullHelper.first(this.value, this.defaultValue);
    }

    @Nullable
    protected abstract T makeValue();

    @Override
    @Nonnull
    public IValue<T> setMin(double min) {
        this.minValue = min;
        return this;
    }

    @Override
    @Nonnull
    public IValue<T> setMax(double max) {
        this.maxValue = max;
        return this;
    }

    @Override
    @Nonnull
    public IValue<T> sync() {
        if (!this.isSynced) {
            this.isSynced = true;
            this.owner.addSyncValue(this);
        }
        return this;
    }

    @Override
    @Nonnull
    public IValue<T> startup() {
        this.isStartup = true;
        return this.sync();
    }

    @SideOnly(value=Side.CLIENT)
    public void onServerSync(Map<String, Object> serverConfig) {
        if (this.isStartup && serverConfig.containsKey(this.keyname)) {
            Object serverValue = serverConfig.get(this.keyname);
            T clientValue = this.get();
            if (!clientValue.equals(serverValue)) {
                Log.error(Lang.NETWORK_BAD_CONFIG.get(this.section, this.keyname, serverValue));
                Minecraft.func_71410_x().field_71439_g.field_71174_a.func_147298_b().func_150718_a(Lang.NETWORK_BAD_CONFIG.toChat(this.section, this.keyname, serverValue));
            }
        }
    }

    public IValue<T> preload() {
        this.owner.addValue(this);
        return this;
    }

    public void save(ByteBuf buf) {
        ByteBufAdapters.STRING127.saveValue(buf, this.keyname);
        IByteBufAdapter<T> dataType = this.getDataType();
        buf.writeByte(ByteBufAdapterRegistry.getID(dataType));
        dataType.saveValue(buf, this.get());
    }

    protected abstract IByteBufAdapter<T> getDataType();

    protected String getText() {
        return this.text + (this.isStartup ? " (must be kept in sync with server)" : (this.isSynced ? " (synced from server)" : ""));
    }
}

