/*
 * Decompiled with CFR 0.152.
 */
package ca.wescook.nutrition.nutrients;

import ca.wescook.nutrition.nutrients.Nutrient;
import ca.wescook.nutrition.nutrients.NutrientList;
import ca.wescook.nutrition.utility.Config;
import ca.wescook.nutrition.utility.Log;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockCake;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBlockSpecial;
import net.minecraft.item.ItemBucketMilk;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class NutrientUtils {
    public static List<Nutrient> getFoodNutrients(ItemStack eatingFood) {
        ArrayList<Nutrient> nutrientsFound = new ArrayList<Nutrient>();
        block0: for (Nutrient nutrient : NutrientList.get()) {
            for (ItemStack listedFood : nutrient.foodItems) {
                if (!listedFood.func_77969_a(eatingFood)) continue;
                nutrientsFound.add(nutrient);
                continue block0;
            }
            for (String listedOreDict : nutrient.foodOreDict) {
                for (ItemStack itemStack : OreDictionary.getOres((String)listedOreDict)) {
                    if (!itemStack.func_77969_a(eatingFood)) continue;
                    nutrientsFound.add(nutrient);
                    continue block0;
                }
            }
        }
        return nutrientsFound;
    }

    public static float calculateNutrition(ItemStack itemStack, List<Nutrient> nutrients) {
        Item item = itemStack.func_77973_b();
        int foodValue = 0;
        if (item instanceof ItemFood) {
            foodValue = ((ItemFood)item).func_150905_g(itemStack);
        } else if (item instanceof ItemBlock || item instanceof ItemBlockSpecial) {
            foodValue = 2;
        } else if (item instanceof ItemBucketMilk) {
            foodValue = 4;
        }
        float adjustedFoodValue = (float)((double)foodValue * 0.5);
        float lossPercentage = (float)Config.lossPerNutrient / 100.0f;
        float foodLoss = (adjustedFoodValue *= Config.nutritionMultiplier) * lossPercentage * (float)(nutrients.size() - 1);
        float nutritionValue = Math.max(0.0f, adjustedFoodValue - foodLoss);
        return nutritionValue;
    }

    public static boolean isValidFood(ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        if (item instanceof ItemFood) {
            return true;
        }
        if (item instanceof ItemBlock && ((ItemBlock)item).func_179223_d() instanceof BlockCake) {
            return true;
        }
        if (item instanceof ItemBlockSpecial && ((ItemBlockSpecial)item).getBlock() instanceof BlockCake) {
            return true;
        }
        return item instanceof ItemBucketMilk;
    }

    public static void findRegisteredFoods() {
        for (Item item : Item.field_150901_e) {
            ItemStack itemStack = new ItemStack(item);
            if (!NutrientUtils.isValidFood(itemStack) || NutrientUtils.getFoodNutrients(itemStack).size() != 0) continue;
            Log.warn("Registered food without nutrients: " + item.getRegistryName());
        }
    }
}

