/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics;

import appeng.api.definitions.IItemDefinition;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.apache.logging.log4j.Logger;
import thaumicenergistics.ThaumicEnergisticsApi;
import thaumicenergistics.api.IThEBlocks;
import thaumicenergistics.api.IThEItems;
import thaumicenergistics.api.IThEUpgrades;
import thaumicenergistics.api.ThEApi;
import thaumicenergistics.client.ThEItemColors;
import thaumicenergistics.client.gui.GuiHandler;
import thaumicenergistics.client.render.ArcaneAssemblerRenderer;
import thaumicenergistics.command.CommandAddVis;
import thaumicenergistics.command.CommandDrainVis;
import thaumicenergistics.init.ModGlobals;
import thaumicenergistics.integration.ThEIntegrationLoader;
import thaumicenergistics.network.PacketHandler;
import thaumicenergistics.tile.TileArcaneAssembler;
import thaumicenergistics.util.ForgeUtil;

@Mod(modid="thaumicenergistics", name="Thaumic Energistics", version="2.2.3", dependencies="required-after:appliedenergistics2@[rv6-stable-6,);required-after:thaumcraft@[6.1.BETA26,);after:thaumicjei;after:inventorytweaks;after:waila;after:theoneprobe", acceptedMinecraftVersions="[1.12.2]")
@Mod.EventBusSubscriber
public class ThaumicEnergistics {
    @Mod.Instance(value="thaumicenergistics")
    public static ThaumicEnergistics INSTANCE;
    @SidedProxy
    public static IProxy proxy;
    public static Logger LOGGER;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        LOGGER = event.getModLog();
        ThEApi.instance();
        MinecraftForge.EVENT_BUS.register((Object)this);
        PacketHandler.register();
        proxy.preInit(event);
        ThEIntegrationLoader.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)INSTANCE, (IGuiHandler)new GuiHandler());
        if (ForgeUtil.isClient()) {
            ThEItemColors.registerItemColors();
        }
        IThEUpgrades upgrades = ThaumicEnergisticsApi.instance().upgrades();
        IThEItems items = ThaumicEnergisticsApi.instance().items();
        IThEBlocks blocks = ThaumicEnergisticsApi.instance().blocks();
        upgrades.registerUpgrade(items.arcaneTerminal(), upgrades.arcaneCharger(), 1);
        upgrades.registerUpgrade(items.arcaneInscriber(), upgrades.blankKnowledgeCore(), 1);
        upgrades.registerUpgrade(items.arcaneInscriber(), upgrades.knowledgeCore(), 1);
        upgrades.registerUpgrade((IItemDefinition)blocks.arcaneAssembler(), upgrades.knowledgeCore(), 1);
        upgrades.registerUpgrade((IItemDefinition)blocks.arcaneAssembler(), upgrades.arcaneCharger(), 1);
        upgrades.registerUpgrade((IItemDefinition)blocks.arcaneAssembler(), upgrades.cardSpeed(), 5);
        proxy.init(event);
        ThEIntegrationLoader.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
        ThEIntegrationLoader.postInit();
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        if (ModGlobals.DEBUG_MODE) {
            event.registerServerCommand((ICommand)new CommandAddVis());
            event.registerServerCommand((ICommand)new CommandDrainVis());
        }
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
    }

    @SubscribeEvent
    public void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("thaumicenergistics")) {
            ConfigManager.sync((String)"thaumicenergistics", (Config.Type)Config.Type.INSTANCE);
        }
    }

    public static interface IProxy {
        default public void preInit(FMLPreInitializationEvent event) {
        }

        default public void init(FMLInitializationEvent event) {
        }

        default public void postInit(FMLPostInitializationEvent event) {
        }

        public EntityPlayer getPlayerEntFromCtx(MessageContext var1);
    }

    public static class ServerProxy
    implements IProxy {
        @Override
        public EntityPlayer getPlayerEntFromCtx(MessageContext ctx) {
            return ctx.getServerHandler().field_147369_b;
        }
    }

    public static class ClientProxy
    implements IProxy {
        @Override
        public void init(FMLInitializationEvent event) {
            ClientRegistry.bindTileEntitySpecialRenderer(TileArcaneAssembler.class, (TileEntitySpecialRenderer)new ArcaneAssemblerRenderer());
        }

        @Override
        public EntityPlayer getPlayerEntFromCtx(MessageContext ctx) {
            return ctx.side.isClient() ? Minecraft.func_71410_x().field_71439_g : ctx.getServerHandler().field_147369_b;
        }
    }
}

