/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.client.gui.component;

import java.awt.Color;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;
import thaumicenergistics.api.ThEApi;

public class GuiSearchField
extends GuiTextField {
    private static final String ASPECT_SEARCH_PREFIX = ThEApi.instance().config().aspectSearchPrefix();
    private static final String MOD_SEARCH_PREFIX = ThEApi.instance().config().modSearchPrefix();
    protected int enabledTextColor = -2039584;
    protected int disabledTextColor = -9408400;
    protected int aspectSearchTextColor = -1657857;
    protected int modSearchTextColor = -10599;
    protected int focusedBGColor = -10461088;
    protected int normalBGColor = -5723992;
    protected int cursorColor = -1442801357;
    protected int selectedTextColor = -16777088;
    protected Color selectionColor;
    protected final FontRenderer field_146211_a;
    protected int field_146225_q;
    protected boolean doBGDrawing = true;
    protected boolean field_146226_p = true;
    protected int field_146214_l = 0;

    public GuiSearchField(FontRenderer fontRenderer, int x, int y, int w, int h) {
        super(0, fontRenderer, x, y, w, h);
        super.func_146185_a(false);
        this.field_146211_a = fontRenderer;
        this.setSelectionColor(-6316129);
    }

    public void func_146185_a(boolean enableBackgroundDrawingIn) {
        this.doBGDrawing = enableBackgroundDrawingIn;
    }

    public void func_146184_c(boolean enabled) {
        super.func_146184_c(enabled);
        this.field_146226_p = enabled;
    }

    public void func_146193_g(int color) {
        super.func_146193_g(color);
        this.enabledTextColor = color;
    }

    public void func_146204_h(int color) {
        super.func_146204_h(color);
        this.disabledTextColor = color;
    }

    public void setAspectSearchTextColor(int aspectSearchTextColor) {
        this.aspectSearchTextColor = aspectSearchTextColor;
    }

    public void setModSearchTextColor(int modSearchTextColor) {
        this.modSearchTextColor = modSearchTextColor;
    }

    public void setFocusedBGColor(int focusedBGColor) {
        this.focusedBGColor = focusedBGColor;
    }

    public void setNormalBGColor(int normalBGColor) {
        this.normalBGColor = normalBGColor;
    }

    public void setCursorColor(int cursorColor) {
        this.cursorColor = cursorColor;
    }

    public void setSelectedTextColor(int selectedTextColor) {
        this.selectedTextColor = selectedTextColor;
    }

    public void setSelectionColor(int selectionColor) {
        this.selectionColor = new Color(selectionColor, true);
    }

    public void selectAll() {
        this.func_146190_e(0);
        this.func_146199_i(this.func_146208_g());
    }

    public void selectNone() {
        this.func_146199_i(this.func_146198_h());
    }

    public void func_146199_i(int position) {
        super.func_146199_i(position);
        if (this.field_146211_a == null) {
            return;
        }
        int len = this.func_146179_b().length();
        position = MathHelper.func_76125_a((int)position, (int)0, (int)len);
        this.field_146225_q = Math.min(this.field_146225_q, len);
        int trimmedStrLen = this.field_146211_a.func_78269_a(this.func_146179_b().substring(this.field_146225_q), this.field_146218_h).length() + this.field_146225_q;
        if (position == this.field_146225_q) {
            this.field_146225_q -= this.field_146211_a.func_78262_a(this.func_146179_b(), this.field_146218_h, true).length();
        }
        if (position > trimmedStrLen) {
            this.field_146225_q += position - trimmedStrLen;
        } else if (position <= this.field_146225_q) {
            this.field_146225_q -= this.field_146225_q - position;
        }
        this.field_146225_q = MathHelper.func_76125_a((int)this.field_146225_q, (int)0, (int)len);
    }

    public void func_146195_b(boolean isFocusedIn) {
        super.func_146195_b(isFocusedIn);
        if (isFocusedIn && !this.func_146206_l()) {
            this.field_146214_l = 0;
        }
    }

    public void func_146178_a() {
        super.func_146178_a();
        ++this.field_146214_l;
    }

    public void func_146194_f() {
        if (this.func_146176_q()) {
            if (this.doBGDrawing) {
                if (this.func_146206_l()) {
                    GuiSearchField.func_73734_a((int)(this.field_146209_f - 1), (int)(this.field_146210_g - 1), (int)(this.field_146209_f + this.field_146218_h), (int)(this.field_146210_g + this.field_146219_i - 1), (int)this.focusedBGColor);
                } else {
                    GuiSearchField.func_73734_a((int)(this.field_146209_f - 1), (int)(this.field_146210_g - 1), (int)(this.field_146209_f + this.field_146218_h), (int)(this.field_146210_g + this.field_146219_i - 1), (int)this.normalBGColor);
                }
            }
            String visibleText = this.field_146211_a.func_78269_a(this.func_146179_b().substring(this.field_146225_q), this.field_146218_h);
            this.drawText(visibleText);
            if (this.func_146206_l()) {
                this.drawSelectionBox(visibleText);
                this.drawCursor(visibleText);
            }
        }
    }

    protected int getTextColor() {
        if (!this.field_146226_p) {
            return this.disabledTextColor;
        }
        if (this.func_146179_b().startsWith(ASPECT_SEARCH_PREFIX)) {
            return this.aspectSearchTextColor;
        }
        if (this.func_146179_b().startsWith(MOD_SEARCH_PREFIX)) {
            return this.modSearchTextColor;
        }
        return this.enabledTextColor;
    }

    protected void drawText(String visibleText) {
        if (!visibleText.isEmpty()) {
            this.field_146211_a.func_175063_a(visibleText, (float)this.field_146209_f, (float)this.field_146210_g, this.getTextColor());
        }
    }

    protected void drawCursor(String visibleText) {
        boolean isAtEnd;
        int curPos = this.func_146198_h() - this.field_146225_q;
        boolean curInVisBounds = curPos >= 0 && curPos <= visibleText.length();
        boolean drawCursor = this.field_146214_l / 6 % 2 == 0 && curInVisBounds;
        boolean bl = isAtEnd = this.func_146198_h() >= this.func_146179_b().length() && this.func_146179_b().length() < this.func_146208_g();
        if (drawCursor) {
            int curX = this.field_146209_f + this.field_146211_a.func_78256_a(visibleText.substring(0, curPos));
            if (isAtEnd) {
                this.field_146211_a.func_175063_a("_", (float)curX, (float)this.field_146210_g, this.cursorColor);
            } else {
                Gui.func_73734_a((int)curX, (int)(this.field_146210_g - 1), (int)(curX + 1), (int)(this.field_146210_g + this.field_146211_a.field_78288_b), (int)this.cursorColor);
            }
        }
    }

    protected void drawSelectionBox(String visibleText) {
        if (this.func_146198_h() == this.func_146186_n()) {
            return;
        }
        int selStartIndex = Math.min(this.func_146198_h(), this.func_146186_n()) - this.field_146225_q;
        int selEndIndex = Math.max(this.func_146198_h(), this.func_146186_n()) - this.field_146225_q;
        if (selStartIndex < 0) {
            selStartIndex = 0;
        }
        if (selEndIndex > visibleText.length()) {
            selEndIndex = visibleText.length();
        }
        String unselectedStart = visibleText.substring(0, selStartIndex);
        String selectedText = visibleText.substring(unselectedStart.length(), selEndIndex);
        int startX = this.field_146209_f + this.field_146211_a.func_78256_a(unselectedStart);
        int startY = this.field_146210_g - 1;
        int endX = startX + this.field_146211_a.func_78256_a(selectedText);
        int endY = startY + this.field_146211_a.field_78288_b;
        this.func_146188_c(startX, startY, endX, endY);
        this.field_146211_a.func_78276_b(selectedText, startX, this.field_146210_g, this.selectedTextColor);
    }

    protected void func_146188_c(int startX, int startY, int endX, int endY) {
        if (startX == endX || startY == endY) {
            return;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179131_c((float)((float)this.selectionColor.getRed() / 255.0f), (float)((float)this.selectionColor.getGreen() / 255.0f), (float)((float)this.selectionColor.getBlue() / 255.0f), (float)((float)this.selectionColor.getAlpha() / 255.0f));
        GlStateManager.func_179090_x();
        GlStateManager.func_179115_u();
        GlStateManager.func_187422_a((GlStateManager.LogicOp)GlStateManager.LogicOp.AND_REVERSE);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferbuilder.func_181662_b((double)startX, (double)endY, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)endX, (double)endY, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)endX, (double)startY, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)startX, (double)startY, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179134_v();
        GlStateManager.func_179098_w();
    }
}

