/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.client.gui.part;

import appeng.api.config.ActionItems;
import appeng.api.config.SearchBoxMode;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.TerminalStyle;
import appeng.api.config.ViewItems;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.client.gui.widgets.GuiImgButton;
import appeng.client.gui.widgets.GuiTabButton;
import appeng.core.localization.GuiText;
import java.awt.Color;
import java.io.IOException;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;
import thaumicenergistics.api.ThEApi;
import thaumicenergistics.client.gui.component.GuiSearchField;
import thaumicenergistics.client.gui.helpers.GuiScrollBar;
import thaumicenergistics.client.gui.helpers.MERepo;
import thaumicenergistics.client.gui.part.GuiAbstractTerminal;
import thaumicenergistics.config.ThEConfig;
import thaumicenergistics.container.ActionType;
import thaumicenergistics.container.part.ContainerArcaneTerminal;
import thaumicenergistics.container.slot.SlotME;
import thaumicenergistics.container.slot.ThESlot;
import thaumicenergistics.init.ModGUIs;
import thaumicenergistics.integration.appeng.util.ThEConfigManager;
import thaumicenergistics.integration.jei.ThEJEI;
import thaumicenergistics.network.PacketHandler;
import thaumicenergistics.network.packets.PacketOpenGUI;
import thaumicenergistics.network.packets.PacketUIAction;
import thaumicenergistics.util.AEUtil;

public class GuiArcaneTerminal
extends GuiAbstractTerminal<IAEItemStack, IItemStorageChannel> {
    protected ContainerArcaneTerminal container;
    private GuiSearchField searchField;
    protected GuiScrollBar scrollBar;
    private GuiImgButton sortByButton;
    private GuiImgButton viewItemsButton;
    private GuiImgButton sortDirButton;
    private GuiImgButton searchModeButton;
    private GuiImgButton terminalSizeButton;
    private GuiImgButton clearButton;
    private GuiTabButton craftingStatusBtn;
    private boolean isAutoFocus = false;
    private static String memoryText = "";
    protected int rows = 6;
    private float visAvailable = -1.0f;
    protected float visRequired = -1.0f;
    private float discount = 0.0f;

    public GuiArcaneTerminal(ContainerArcaneTerminal container) {
        super(container);
        this.container = container;
        this.field_146289_q = Minecraft.func_71410_x().field_71466_p;
        this.repo = new MERepo(IItemStorageChannel.class);
    }

    public void initSearchField() {
        SearchBoxMode searchModeSetting = ThEApi.instance().config().searchBoxMode();
        this.repo.setSearchBoxMode(searchModeSetting);
        this.isAutoFocus = Stream.of(SearchBoxMode.AUTOSEARCH, SearchBoxMode.JEI_AUTOSEARCH, SearchBoxMode.AUTOSEARCH_KEEP, SearchBoxMode.JEI_AUTOSEARCH_KEEP).anyMatch(m -> m == searchModeSetting);
        boolean isKeepFilter = Stream.of(SearchBoxMode.AUTOSEARCH_KEEP, SearchBoxMode.JEI_AUTOSEARCH_KEEP, SearchBoxMode.MANUAL_SEARCH_KEEP, SearchBoxMode.JEI_MANUAL_SEARCH_KEEP).anyMatch(m -> m == searchModeSetting);
        boolean isJEIEnabled = Stream.of(SearchBoxMode.JEI_AUTOSEARCH, SearchBoxMode.JEI_MANUAL_SEARCH).anyMatch(m -> m == searchModeSetting);
        this.searchField.func_146180_a("");
        this.searchField.func_146195_b(this.isAutoFocus);
        if (isJEIEnabled) {
            memoryText = ThEJEI.getSearchText();
        }
        if (isKeepFilter && !memoryText.isEmpty()) {
            this.searchField.func_146180_a(memoryText);
            this.searchField.selectAll();
            this.repo.setSearchString(memoryText);
            this.repo.updateView();
            this.updateScroll();
        }
    }

    public void func_73866_w_() {
        this.field_146999_f = 201;
        this.field_147000_g = 190;
        double remainingY = this.field_146295_m - this.field_147000_g;
        int maxRows = (int)Math.floor(remainingY / 18.0);
        this.rows = ThEApi.instance().config().terminalStyle() != TerminalStyle.TALL ? Math.min(maxRows, 6) : maxRows;
        this.field_147000_g += 18 * this.rows;
        this.scrollBar = new GuiScrollBar(175, 18, 18 * this.rows - 2);
        this.repo.setScrollBar(this.scrollBar);
        this.updateScroll();
        this.field_147002_h.field_75151_b.removeIf(slot -> slot instanceof SlotME);
        this.addTerminalSlots(8, 18);
        this.field_146292_n.clear();
        super.func_73866_w_();
        this.searchField = new GuiSearchField(this.field_146289_q, this.getGuiLeft() + 98, this.getGuiTop() + 6, 70, 10);
        this.searchField.func_146189_e(true);
        this.searchField.func_146203_f(25);
        this.searchField.func_146193_g(0xFFFFFF);
        this.initSearchField();
        ThEConfigManager cm = this.getConfigManager();
        this.sortByButton = new GuiImgButton(this.getGuiLeft() - 18, this.getGuiTop() + 8, (Enum)Settings.SORT_BY, cm.getSetting(Settings.SORT_BY));
        this.viewItemsButton = new GuiImgButton(this.getGuiLeft() - 18, this.getGuiTop() + 28, (Enum)Settings.VIEW_MODE, cm.getSetting(Settings.VIEW_MODE));
        this.sortDirButton = new GuiImgButton(this.getGuiLeft() - 18, this.getGuiTop() + 48, (Enum)Settings.SORT_DIRECTION, cm.getSetting(Settings.SORT_DIRECTION));
        this.searchModeButton = new GuiImgButton(this.getGuiLeft() - 18, this.getGuiTop() + 68, (Enum)Settings.SEARCH_MODE, (Enum)ThEApi.instance().config().searchBoxMode());
        this.terminalSizeButton = new GuiImgButton(this.getGuiLeft() - 18, this.getGuiTop() + 88, (Enum)Settings.TERMINAL_STYLE, (Enum)ThEApi.instance().config().terminalStyle());
        this.clearButton = new GuiImgButton(this.getGuiLeft() + 87, this.getGuiTop() + this.getYSize() - 156, (Enum)Settings.ACTIONS, (Enum)ActionItems.STASH);
        this.clearButton.setHalfSize(true);
        this.craftingStatusBtn = new GuiTabButton(this.field_147003_i + 170, this.field_147009_r - 4, 178, GuiText.CraftingStatus.getLocal(), this.field_146296_j);
        this.craftingStatusBtn.setHideEdge(13);
        this.func_189646_b((GuiButton)this.sortByButton);
        this.func_189646_b((GuiButton)this.viewItemsButton);
        this.func_189646_b((GuiButton)this.sortDirButton);
        this.func_189646_b((GuiButton)this.searchModeButton);
        this.func_189646_b((GuiButton)this.terminalSizeButton);
        this.func_189646_b((GuiButton)this.clearButton);
        this.func_189646_b((GuiButton)this.craftingStatusBtn);
        this.field_147002_h.field_75151_b.forEach(this::recalcSlotY);
    }

    protected void recalcSlotY(Slot slot) {
        if (slot instanceof ThESlot) {
            ((ThESlot)slot).recalculateY(this.rows);
        }
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.field_146289_q.func_78276_b(ThEApi.instance().lang().guiVisRequiredOutOf().getLocalizedKey(Float.valueOf(this.visRequired > -1.0f ? this.visRequired : 0.0f), (int)(this.visAvailable > -1.0f ? this.visAvailable : 0.0f)), 35, this.getYSize() - 168, this.visRequired > this.visAvailable ? Color.RED.getRGB() : 0x404040);
        if (this.discount > 0.0f) {
            this.field_146289_q.func_78276_b(ThEApi.instance().lang().guiVisDiscount().getLocalizedKey((int)(this.discount * 100.0f)), 90, this.getYSize() - 94, 0x404040);
        }
        this.field_146289_q.func_78276_b(ThEApi.instance().lang().guiArcaneTerminal().getLocalizedKey(new Object[0]), 8, 6, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, this.getYSize() - 91, 0x404040);
        if (this.scrollBar != null) {
            this.scrollBar.draw(this);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.field_146297_k.func_110434_K().func_110577_a(this.getGuiBackground());
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.getXSize(), 18);
        for (int i = 0; i < this.rows; ++i) {
            this.func_73729_b(this.field_147003_i, this.field_147009_r + 18 + i * 18, 0, 18, this.getXSize(), 18);
        }
        this.func_73729_b(this.field_147003_i, this.field_147009_r + 16 + this.rows * 18, 0, 70, this.getXSize(), 176);
        this.searchField.func_146194_f();
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        if (button == 1 && this.mouseWithin(this.searchField)) {
            this.searchField.func_146180_a("");
            this.repo.setSearchString("");
            this.repo.updateView();
        }
        this.searchField.func_146192_a(mouseX, mouseY, button);
        if (this.scrollBar != null) {
            if (this.mouseWithin(this.scrollBar)) {
                this.scrollBar.click(mouseY - this.getGuiTop());
            }
            this.repo.updateView();
            this.updateScroll();
        }
        super.func_73864_a(mouseX, mouseY, button);
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        if (this.scrollBar != null && this.mouseWithin(this.scrollBar)) {
            this.scrollBar.click(mouseY - this.getGuiTop());
            this.repo.updateView();
            this.updateScroll();
        }
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
    }

    protected void func_184098_a(Slot slot, int slotId, int mouseButton, ClickType type) {
        EntityPlayerSP player = this.field_146297_k.field_71439_g;
        if (slot instanceof SlotME) {
            ActionType action = null;
            IAEStack stack = null;
            switch (type) {
                case PICKUP: {
                    action = mouseButton == 1 ? ActionType.SPLIT_OR_PLACE_SINGLE : ActionType.PICKUP_OR_SETDOWN;
                    stack = (IAEStack)((SlotME)slot).getAEStack();
                    if (stack == null || action != ActionType.PICKUP_OR_SETDOWN || stack.getStackSize() != 0L || !player.field_71071_by.func_70445_o().func_190926_b()) break;
                    action = ActionType.AUTO_CRAFT;
                    break;
                }
                case QUICK_MOVE: {
                    action = mouseButton == 1 ? ActionType.PICKUP_SINGLE : ActionType.SHIFT_MOVE;
                    stack = (IAEStack)((SlotME)slot).getAEStack();
                    break;
                }
                case CLONE: {
                    action = ActionType.AUTO_CRAFT;
                    stack = (IAEStack)((SlotME)slot).getAEStack();
                    break;
                }
            }
            if (action != null) {
                PacketHandler.sendToServer(new PacketUIAction(action, stack));
            }
            return;
        }
        super.func_184098_a(slot, slotId, mouseButton, type);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.func_146983_a(keyCode) && this.container.field_75151_b.stream().filter(slot -> !(slot instanceof SlotME)).anyMatch(this::mouseWithin)) {
            return;
        }
        if (typedChar == 'B' && this.scrollBar != null) {
            this.scrollBar.wheel(1.0f);
        }
        if (AEUtil.getFocusKeyBinding().isActiveAndMatches(keyCode)) {
            this.searchField.func_146195_b(!this.searchField.func_146206_l());
        }
        if (this.searchField.func_146206_l() && keyCode == 28) {
            this.searchField.func_146195_b(false);
            return;
        }
        if (this.isAutoFocus && !this.searchField.func_146206_l() && this.mouseWithin()) {
            this.searchField.func_146195_b(true);
        }
        if (this.searchField.func_146201_a(typedChar, keyCode)) {
            this.repo.setSearchString(this.searchField.func_146179_b());
            this.repo.updateView();
            this.updateScroll();
            return;
        }
        super.func_73869_a(typedChar, keyCode);
    }

    @Override
    public void reload() {
        this.func_73866_w_();
    }

    public void func_146281_b() {
        super.func_146281_b();
        memoryText = this.searchField.func_146179_b();
    }

    @Override
    public void updateSetting(Settings setting, Enum value) {
        super.updateSetting(setting, value);
        ThEConfigManager cm = this.getConfigManager();
        this.repo.setSortOrder((SortOrder)cm.getSetting(Settings.SORT_BY));
        this.repo.setViewMode((ViewItems)cm.getSetting(Settings.VIEW_MODE));
        this.repo.setSortDir((SortDir)cm.getSetting(Settings.SORT_DIRECTION));
        this.repo.updateView();
        this.updateScroll();
    }

    @Override
    protected ResourceLocation getGuiBackground() {
        return new ResourceLocation("thaumicenergistics", "textures/gui/arcane_crafting_no_side.png");
    }

    @Override
    protected void func_146284_a(GuiButton button) {
        if (button == this.clearButton) {
            PacketHandler.sendToServer(new PacketUIAction(ActionType.CLEAR_GRID));
            return;
        }
        if (button == this.craftingStatusBtn) {
            PacketHandler.sendToServer(new PacketOpenGUI(ModGUIs.AE2_CRAFT_STATUS, this.container.getPartPos(), this.container.getPartSide()));
            return;
        }
        super.func_146284_a(button);
    }

    @Override
    protected boolean imgBtnActionOverride(GuiImgButton btn, Enum next) {
        if (btn.getSetting() == Settings.TERMINAL_STYLE) {
            ThEConfig.client.terminalStyle = (TerminalStyle)next;
            ThEConfig.save();
            this.reload();
            return true;
        }
        if (btn.getSetting() == Settings.SEARCH_MODE) {
            ThEConfig.client.searchBoxMode = (SearchBoxMode)next;
            ThEConfig.save();
            this.initSearchField();
            return true;
        }
        return false;
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int delta = Mouse.getEventDWheel();
        if (delta != 0) {
            if (GuiArcaneTerminal.func_146272_n()) {
                Slot slot = this.getSlotUnderMouse();
                if (slot instanceof SlotME && slot.func_75216_d()) {
                    delta /= Math.abs(delta);
                    for (int k = 0; k < Math.abs(delta); ++k) {
                        PacketHandler.sendToServer(new PacketUIAction(delta > 0 ? ActionType.SCROLL_DOWN : ActionType.SCROLL_UP, (IAEStack)((SlotME)slot).getAEStack()));
                    }
                }
            } else if (this.scrollBar != null) {
                this.scrollBar.wheel(delta);
            }
        }
    }

    private void addTerminalSlots(int offsetX, int offsetY) {
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < 9; ++c) {
                this.addMESlot(new SlotME(this.repo, c + r * 9, offsetX + c * 18, offsetY + r * 18));
            }
        }
    }

    public void onMEStorageUpdate(IItemList<IAEItemStack> list) {
        this.repo.clear();
        for (IAEItemStack stack : list) {
            this.repo.postUpdate(stack);
        }
        this.repo.updateView();
        this.updateScroll();
    }

    public void setVisInfo(float chunkVis, float visRequired, float discount) {
        this.visAvailable = chunkVis;
        this.visRequired = visRequired;
        this.discount = discount;
    }

    public void updateScroll() {
        this.scrollBar.setRows(this.rows);
        this.scrollBar.setRange(0, (this.repo.size() + 8) / 9 - this.rows, Math.max(1, this.rows / 6));
    }
}

