/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.integration.jei;

import com.google.common.base.Strings;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IIngredientBlacklist;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import thaumicenergistics.api.IThEItems;
import thaumicenergistics.api.ThEApi;
import thaumicenergistics.integration.jei.ACIRecipeTransferHandler;
import thaumicenergistics.integration.jei.ACTRecipeTransferHandler;

@JEIPlugin
public class ThEJEI
implements IModPlugin {
    private static IJeiRuntime runtime;

    @ParametersAreNonnullByDefault
    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        runtime = jeiRuntime;
    }

    public static String getSearchText() {
        return Strings.nullToEmpty((String)runtime.getIngredientFilter().getFilterText());
    }

    public static void setSearchText(String searchText) {
        runtime.getIngredientFilter().setFilterText(Strings.nullToEmpty((String)searchText));
    }

    public void register(IModRegistry registry) {
        IRecipeTransferHandlerHelper rthh = registry.getJeiHelpers().recipeTransferHandlerHelper();
        IIngredientBlacklist blacklist = registry.getJeiHelpers().getIngredientBlacklist();
        IThEItems items = ThEApi.instance().items();
        items.arcaneTerminal().maybeStack(1).ifPresent(stack -> this.registerWorkbenchCatalyst(registry, new ACTRecipeTransferHandler(rthh), (ItemStack)stack));
        items.arcaneInscriber().maybeStack(1).ifPresent(stack -> this.registerWorkbenchCatalyst(registry, new ACIRecipeTransferHandler(rthh), (ItemStack)stack));
        items.dummyAspect().maybeStack(1).ifPresent(arg_0 -> ((IIngredientBlacklist)blacklist).addIngredientToBlacklist(arg_0));
    }

    public void registerWorkbenchCatalyst(IModRegistry registry, IRecipeTransferHandler<? extends Container> handler, ItemStack stack) {
        registry.getRecipeTransferRegistry().addRecipeTransferHandler(handler, "minecraft.crafting");
        registry.getRecipeTransferRegistry().addRecipeTransferHandler(handler, "THAUMCRAFT_ARCANE_WORKBENCH");
        registry.addRecipeCatalyst((Object)stack, new String[]{"THAUMCRAFT_ARCANE_WORKBENCH"});
    }
}

