/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.part;

import appeng.api.parts.IPartCollisionHelper;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEStack;
import appeng.me.GridAccessException;
import net.minecraft.nbt.NBTTagCompound;
import thaumicenergistics.init.ModGUIs;
import thaumicenergistics.integration.appeng.grid.GridUtil;
import thaumicenergistics.item.ItemPartBase;
import thaumicenergistics.part.PartBase;

public abstract class PartSharedTerminal
extends PartBase
implements ITerminalHost {
    protected final ModGUIs gui;

    public PartSharedTerminal(ItemPartBase item, ModGUIs gui) {
        super(item);
        this.gui = gui;
    }

    public ModGUIs getGui() {
        return this.gui;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.getConfigManager().readFromNBT(nbt);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        this.getConfigManager().writeToNBT(nbt);
    }

    public <T extends IAEStack<T>> IMEMonitor<T> getInventory(IStorageChannel<T> channel) {
        try {
            return GridUtil.getStorageGrid(this).getInventory(channel);
        }
        catch (GridAccessException gridAccessException) {
            return null;
        }
    }

    @Override
    public double getIdlePowerUsage() {
        return 0.5;
    }

    @Override
    public final void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
        bch.addBox(4.0, 4.0, 13.0, 12.0, 12.0, 14.0);
    }

    @Override
    public int getLightLevel() {
        return this.blockLight(this.isPowered() ? 9 : 0);
    }
}

