import crafttweaker.item.IIngredient;
#priority 4

#loader crafttweaker reloadable

/* 

List of character that has barely same width for most monospace fonts

!"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`abcdefghijklmnopqrstuvwxyz{|}~¡¢£¤¥¦§¨©ª«¬®¯°±²³´µ¶·¸¹º»¼½¾¿ÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏÐÑÒÓÔÕÖ×ØÙÚÛÜÝÞßàáâãäåæçèéêëìíîïðñòóôõö÷øùúûüýþÿĀāĂăĄąĆćĈĉĊċČčĎďĐđĒēĔĕĖėĘęĚěĜĝĞğĠġĢģĤĥĦħĨĩĪīĬĭĮįİıĲĳĴĵĶķĸĹĺĻļĽľĿŀŁłŃńŅņŇňŉŊŋŌōŎŏŐőŒœŔŕŖŗŘřŚśŜŝŞşŠšŢţŤťŦŧŨũŪūŬŭŮůŰűŲųŴŵŶŷŸŹźŻżŽžƎƒƬƮƵǍǎǏǐǑǒǓǔǕǖǗǘǙǚǛǜǞǟǠǡǢǣǦǧǨǩǰǴǵǸǹǺǻǼǽǾǿȀȁȄȅȆȈȉȌȍȐȑȔȕȘșȚțȞȟȢȤȦȧȨȩȪȫȬȭȮȯȰȱȲȳȷȽȾɆɚɶʮʯʹʺʼˆˇˉ˘˙˚˛˜˝ͰͱͲͳʹ͵Ͷͷͺͻͼͽ;Ϳ΄΅Ά·ΈΉΊ΋Ό΍ΎΏΐΑΒΓΔΕΖΗΘΙΚΛΜΝΞΟΠΡ΢ΣΤΥΦΧΨΩΪΫάέήίΰαβγδεζηθικλμνξοπρςστυφχψωϊϋόύώϏϐϑϒϓϔϕϖϗϘϙϚϛϜϝϞϟϠϡϤϰϱϲϳϴϵ϶ϷϸϹϺϻϼϽϾϿЀЁЂЃЄЅІЇЈЉЊЋЌЍЎЏАБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯабвгдежзийклмнопрстуфхцчшщъыьэюяѐёђѓєѕіїјљњћќѝўџѠѡѢѣѤѥѦѧѨѩѪѫѬѭѮѯѰѱѲѳѴѵѶѷѸѹѿҊҋҌҍҎҏҐґҒғҔҕҖҗҘҙҚқҜҝҞҟҠҡҢңҤҥҦҧҨҩҪҫҬҭҮүҰұҲҳҴҵҶҷҸҹҺһҼҽҾҿӀӁӂӃӄӅӆӇӈӉӊӋӌӍӎӏӐӑӒӓӔӕӖӗӘәӚӛӜӝӞӟӠӡӢӣӤӥӦӧӨөӪӫӬӭӮӯӰӱӲӳӴӵӶӷӸӹӺӻӼӽӾӿԀԁԂԃԄԅԆԇԈԉԊԋԌԍԎԏԐԑԒԓԔԕԖԗԘԙԚԛԜԝԞԟԠԡԢԣԤԥԦԧԨԩԪԫԬԭԮԯḂḃḈḉḊḋḐḑḔḕḖḗḘḚḜḝḞḟḠḡḢḣḦḧḨḩḮḯḰḱḶḸḺḼḾḿṀṁṄṅṌṍṎṏṐṑṒṓṔṕṖṗṘṙṠṡṤṥṦṧṪṫṬṮṰṸṹṺṻṼṽẀẁẂẃẄẅẆẇẊẋẌẍẎẏẐẑẒẔẗẘẙẞẤấẦầẪẫẮắẰằẴẵẸẺẼẽẾếỀềỂỄễỆỐốỒồỖỗỲỳỸỹἀἁἂἃἄἅἆἇἈἉἊἋἌἍἎἏἐἑἒἓἔἕἘἙἚἛἜἝἠἡἢἣἤἥἦἧἨἩἪἫἬἭἮἯἰἱἲἳἴἵἶἷἸἹἺἻἼἽἾἿὀὁὂὃὄὅὈὉὊὋὌὍὐὑὒὓὔὕὖὗ὘Ὑ὚Ὓ὜Ὕ὞ὟὠὡὢὣὤὥὦὧὨὩὪὫὬὭὮὯὰάὲέὴήὶίὸόὺύὼώ὾὿ᾀᾁᾂᾃᾄᾅᾆᾇᾈᾉᾊᾋᾌᾍᾎᾏᾐᾑᾒᾓᾔᾕᾖᾗᾘᾙᾚᾛᾜᾝᾞᾟᾠᾡᾢᾣᾤᾥᾦᾧᾨᾩᾪᾫᾬᾭᾮᾯᾰᾱᾲᾳᾴᾶᾷᾸᾹᾺΆᾼ᾽ι᾿῀῁ῂῃῄ῅ῆῇῈΈῊΉῌ῍῎῏ῐῑῒΐ῔῕ῖῗῘῙῚΊ῜῝῞῟ῠῡῢΰῤῥῦῧῨῩῪΎῬ῭΅`῰῱ῲῳῴ῵ῶῷῸΌῺΏῼ´῾  ‒–—―‖‗‘’‚“”„†‡•…‰‹›⁰⁲⁳⁴⁵⁶⁷⁸⁹⁺⁻⁼⁽⁾ⁿ₀₁₂₃₄₅₆₇₈₉₊₋₌₍₎₠€₮₯₸₹₺₽ℓ№ℙ™ΩKÅ℮⅓⅔⅕⅖⅗⅘⅙⅚⅛⅜⅝⅞←↑→↓↔↕∂∆∊∍∏∑−∕∙√∞∩∫≈≠≡≢≤≥⌀⌂⌃⌄⌅⌆⌐⌠⌡─━│┃┄┅┆┇┈┉┊┋┌┍┎┏┐┑┒┓└┕┖┗┘┙┚┛├┝┞┟┠┡┢┣┤┥┦┧┨┩┪┫┬┭┮┯┰┱┲┳┴┵┶┷┸┹┺┻┼┽┾┿╀╁╂╃╄╅╆╇╈╉╊╋╌╍╎╏═║╒╓╔╕╖╗╘╙╚╛╜╝╞╟╠╡╢╣╤╥╦╧╨╩╪╫╬╭╮╯╰╱╲╳╴╵╶╷╸╹╺╻╼╽╾╿▀▄█▌▐░▒▓■□▪▫▬▲►▼◄◊○●◘◙☺☻☼♀♂♠♣♥♦♪♫

*/

zenClass CharacterManager { zenConstructor() {}
  # Symbols that would be used in case first letters cant be used
  static symbols as string = 
    "○●⌀☻♀♂∞ͻ♪♫†‡®£¥+⌆⌅" ~
    "Ͳαβγζξ¢!$%:;<>@«₠€₮₯₸₹₺₽ℓ№ℙ™‖¦∏" ~
    "↑←→↔↕∊∍∫≤≥►◄“”…▪▫•°"
  as string;

  # Unused:
  # 0123456789₀₁₂₃₄₅₆₇₈₉¹²³⁴⁵⁶⁷⁸⁹

  static keywords as string[][] = [
    ["cobblestone", "░▒▓"    ],
    ["ingot",       "▬-_‗=≡Ξ"],
    ["block",       "■▄▀"    ],
    ["plate",       "□п"     ],
    ["casing",      "⌂"      ],
    ["cell",        "◘"      ],
    ["frame",       "◙"      ],
    ["dust",        "▲♠♣∆"   ],
    ["gem",         "◊♦θΘ"   ],
    ["gear",        "¤☼"     ],
    ["chunk",       "∩∂&"    ],
    ["crystal",     "*╳"     ],
    ["energy",      "Ϟ√∑"    ],
    ["power",       "ΣΨΩ"    ],
    ["bucket",      "~≈‰"    ],
    ["redstone",    "♥▼⌄↓"   ],
    ["quartz",      "⌃^"     ],
    ["coal",        "©☺"     ],
    ["stick",       "╱/|"    ],
    ["rod",         "/|╱"    ],
    ["shaft",       "|/╱"    ],
    ["wood",        "#≢≠"    ],
    ["fruit",       "ͼͽ"     ],
    ["nugget",      "‚˛͵ͺι"  ],
  ] as string[][];

  # Words that would not be used to find letter
  static wordsBlacklist as string[] = [
    "the", "a", "in"
  ] as string[];

  var usedChars as string = "";
  var usedItems as string[IIngredient] = {};

  function getMap(map_weight as int[IIngredient]) as IIngredient[string] {
    var ingrs as IIngredient[] = [];
    var weights as int[] = [];
    var len = 0;
    for ingr, weight in map_weight {
      ingrs += ingr;
      weights += weight;
      len += 1;
    }
    if(len == 1) return {getCharacter(ingrs[0]): ingrs[0]};

    val sorted_indexes = scripts.craft.craft_utils.sortInt(weights);
    val result as IIngredient[string] = {};
    for i, k in sorted_indexes {
      val ingr = ingrs[k];
      val c = getCharacter(ingr);
      result[c] = ingr;
    }
    return result;
  }

  function getCharacter(ingredient as IIngredient) as string {
    if(isNull(ingredient)) return " ";

    var ingr as IIngredient = null;
    var targetStr as string = null;
    var oreName = "";
    val itemStack = ingredient.itemArray[0];
    val ores = itemStack.ores;
    var isOre = false;

    # Find target lookup string
    if(!isNull(ores) && ores.length > 0) {
      isOre = true;
      ingr = ores[0] * itemStack.amount;
      oreName = ores[0].name;
      val replaced = oreName.replaceAll("^[a-z]+", "");
      targetStr = (replaced != "") ? replaced : oreName;
    } else {
      ingr = itemStack;
      targetStr = itemStack.displayName;
    }

    # Check if we already know this item
    var c = usedItems[ingr];
    if(!isNull(c)) return c;

    c = getBy_Rule(targetStr);
    if(isNull(c))
      if(isOre)   c = getBy_Ore(oreName);
      else        c = getBy_Words(targetStr.split(" "));
    if(isNull(c)) c = getBy_Importantcy(targetStr);
    // if(isNull(c)) c = getBy_Hash(targetStr);
    if(isNull(c)) c = getBy_Any(targetStr);

    # Add char to used
    usedChars = usedChars + c;
    usedItems[ingr] = c;
    return c;
  }

  function getBy_Rule(str as string) as string {
    return null;
  }

  function getBy_Ore(str as string) as string {
    val words = str
      .replaceAll("([A-Z])", " $1") // Add spaces instead camelCase
      .replaceAll("\\dx|\\d+", "") // Remove digits
      .split(" ");
    var reversed as string[] = [];
    for i in 0 to words.length {
      val word = words[words.length - i - 1];
      reversed += word;
    }
    return getBy_Words(reversed);
  }

  function getBy_Words(words as string[]) as string {
    for word in words {
      val _word = word.toLowerCase();
      if(wordsBlacklist has _word) continue;

      for pair in keywords {
        val keyword = pair[0];
        val letters = pair[1];
        if(keyword == _word) {
          for i in 0 to letters.length {
            val c = letters[i];
            if(!usedChars.contains(c))
              return c;
          }
        }
      }
    }
    
    return null;
  }

  function getBy_Any(str as string) as string {
    for i in 0 to symbols.length {
      val c = symbols[i];
      if(!usedChars.contains(c)) return c;
    }
    return "?";
  }

  function getBy_Hash(str as string) as string {
    val cstart = abs(str.hashCode()) % symbols.length;
    var k = cstart;
    var c = symbols[k];
    while (usedChars.contains(c)) {
      k = (k + 1) % symbols.length;
      if(k == cstart) return "?";
      c = symbols[k];
    }
    return c;
  }

  function getBy_Importantcy(str as string) as string {
    var k = 0;
    var c = str[k];
    val tryLetters = 3;
    while (usedChars.contains(c) || c == " ") {
      k += 1;
      if(k >= str.length || k > tryLetters) return null;
      c = str[k];
    }
    return c;
  }

  # utils
  function abs(n as int) as int {return n < 0 ? -n : n;} #>
}
