/*
 * Decompiled with CFR 0.152.
 */
package grim3212.mc.core.util;

import cpw.mods.fml.common.FMLLog;
import grim3212.mc.core.util.Utils;
import java.net.URL;
import java.util.logging.Logger;

public class VersionChecker {
    private URL versionURL;
    private final String modName;
    private final String newVer;
    private final String oldVer;
    private String updateURL;
    private String[] loadMsg;
    private String[] inGameMsg;
    private int remoteBeginIndex;
    private int remoteEndIndex = -1;
    private boolean useRemoteStringIndices = false;

    @Deprecated
    public VersionChecker(String modName, String oldVer, String versionURL, String updateURL, String[] loadMsg, String[] inGameMsg, Logger logger) {
        this(modName, oldVer, versionURL, updateURL, loadMsg, inGameMsg);
    }

    public VersionChecker(String modName, String oldVer, String versionURL, String updateURL, String[] loadMsg, String[] inGameMsg) {
        this(modName, oldVer, versionURL, updateURL, loadMsg, inGameMsg, 500);
    }

    public VersionChecker(String modName, String oldVer, String versionURL, String updateURL, String[] loadMsg, String[] inGameMsg, int timeoutMS) {
        this.modName = modName;
        this.oldVer = oldVer;
        this.updateURL = updateURL;
        this.loadMsg = loadMsg;
        this.inGameMsg = inGameMsg;
        try {
            this.versionURL = new URL(versionURL);
            FMLLog.info((String)"Initializing Version Checker for %s", (Object[])new Object[]{modName});
        }
        catch (Throwable e) {
            FMLLog.warning((String)"Error initializing Version Checker for %s: %s", (Object[])new Object[]{modName, e.getMessage()});
        }
        String[] versionLines = Utils.loadTextFromURL(this.versionURL, Logger.getLogger("Grim3212Core"), new String[]{oldVer}, timeoutMS);
        this.newVer = versionLines[0].trim();
        if (versionLines.length > 1 && versionLines[1].trim().length() != 0) {
            this.updateURL = versionLines[1];
        }
        if (versionLines.length > 2 && versionLines[2].trim().length() != 0 && versionLines[2].contains(",")) {
            try {
                String[] indices = versionLines[2].split(",");
                this.remoteBeginIndex = Integer.parseInt(indices[0]);
                this.remoteEndIndex = Integer.parseInt(indices[1]);
                this.useRemoteStringIndices = this.remoteBeginIndex <= this.remoteEndIndex;
            }
            catch (Throwable e) {
                this.remoteEndIndex = -1;
                this.remoteBeginIndex = -1;
            }
        }
        this.setLoadMessage(loadMsg);
        this.setInGameMessage(inGameMsg);
    }

    public VersionChecker(String modName, String oldVer, String versionURL, String updateURL) {
        this(modName, oldVer, versionURL, updateURL, new String[]{"{modName} {oldVer} is out of date! Visit {updateURL} to download the latest release ({newVer})."}, new String[]{"{modName} {newVer}"});
    }

    public void checkVersionWithLogging() {
        if (!this.isCurrentVersion()) {
            for (String msg : this.loadMsg) {
                FMLLog.info((String)msg, (Object[])new Object[0]);
            }
        }
    }

    public void checkVersionWithLoggingBySubStringAsFloat(int beginIndex, int endIndex) {
        if (!this.isCurrentVersionBySubStringAsFloatNewer(beginIndex, endIndex)) {
            for (String msg : this.loadMsg) {
                FMLLog.info((String)msg, (Object[])new Object[0]);
            }
        }
    }

    public void setLoadMessage(String[] loadMsg) {
        this.loadMsg = loadMsg;
        for (int i = 0; i < this.loadMsg.length; ++i) {
            this.loadMsg[i] = this.replaceAllTags(this.loadMsg[i]);
        }
    }

    public void setInGameMessage(String[] inGameMsg) {
        this.inGameMsg = inGameMsg;
        for (int i = 0; i < this.inGameMsg.length; ++i) {
            this.inGameMsg[i] = this.replaceAllTags(this.inGameMsg[i]);
        }
    }

    public String[] getLoadMessage() {
        return this.loadMsg;
    }

    public String[] getInGameMessage() {
        return this.inGameMsg;
    }

    public boolean isCurrentVersion() {
        return this.newVer.equalsIgnoreCase(this.oldVer);
    }

    public boolean isCurrentVersionBySubStringAsFloatNewer(int beginIndex, int endIndex) {
        try {
            if (this.useRemoteStringIndices) {
                return Float.valueOf(this.newVer.substring(this.remoteBeginIndex, this.remoteEndIndex)).floatValue() <= Float.valueOf(this.oldVer.substring(beginIndex, endIndex)).floatValue();
            }
            return Float.valueOf(this.newVer.substring(beginIndex, endIndex)).floatValue() <= Float.valueOf(this.oldVer.substring(beginIndex, endIndex)).floatValue();
        }
        catch (Throwable e) {
            FMLLog.warning((String)"Method isCurrentVersionBySubStringAsFloatNewer() encountered an error while comparing version substrings for mod %s: %s", (Object[])new Object[]{this.modName, e.getMessage()});
            return true;
        }
    }

    private String replaceAllTags(String s) {
        return s.replace("{oldVer}", this.oldVer).replace("{newVer}", this.newVer).replace("{modName}", this.modName).replace("{updateURL}", this.updateURL);
    }
}

