/*
 * Decompiled with CFR 0.152.
 */
package grim3212.mc.core.manual.pages;

import cpw.mods.fml.relauncher.ReflectionHelper;
import grim3212.mc.core.manual.ModSubSectionPage;
import grim3212.mc.core.manual.gui.GuiSubSectionPage;
import grim3212.mc.core.manual.pages.PageInfo;
import grim3212.mc.core.util.RecipeHelper;
import grim3212.mc.core.util.TooltipHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.lwjgl.opengl.GL11;

public class PageCrafting
extends ModSubSectionPage {
    private ResourceLocation craftingOverlay = new ResourceLocation("grim3212core", "textures/gui/craftingOverlay.png");
    private int recipeShown = 0;
    private int update = 0;
    private int updateTime = 1;
    private List<IRecipe> outputRecipes = new ArrayList<IRecipe>();
    private boolean isArray = false;

    public PageCrafting(String pageName, IRecipe output) {
        super(pageName);
        this.outputRecipes.add(output);
    }

    public PageCrafting(String pageName, List<IRecipe> outputs, int updateTime) {
        super(pageName);
        for (int i = 0; i < outputs.size(); ++i) {
            if (outputs.get(i) == null) continue;
            this.outputRecipes.add(outputs.get(i));
        }
        this.updateTime = updateTime;
        this.isArray = true;
    }

    public PageCrafting(String pageName, ItemStack output) {
        super(pageName);
        this.outputRecipes.add(RecipeHelper.getQuickIRecipeForItemStack(output));
    }

    public boolean isArray() {
        return this.isArray;
    }

    @Override
    public void drawScreen(GuiSubSectionPage gui, int mouseX, int mouseY) {
        super.drawScreen(gui, mouseX, mouseY);
        this.relativeMouseX = mouseX;
        this.relativeMouseY = mouseY;
        int x = gui.getX() + 15;
        int y = gui.getY() + 28;
        PageInfo.drawText(x, y, this.getPageName());
        TextureManager render = Minecraft.func_71410_x().field_71446_o;
        render.func_110577_a(this.craftingOverlay);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        gui.func_73729_b(gui.getX(), gui.getY(), 0, 0, gui.getManualWidth(), gui.getManualHeight());
        this.renderRecipe(gui, this.outputRecipes);
        if (this.tooltipItem != null) {
            TooltipHelper.renderToolTip(this.tooltipItem, mouseX, mouseY);
        }
        this.tooltipItem = null;
    }

    public void renderRecipe(GuiSubSectionPage gui, List<IRecipe> output) {
        this.renderItem(gui, output.get(this.recipeShown).func_77571_b(), gui.getX() + 143, gui.getY() + 154);
        this.drawIngredientList(gui, output.get(this.recipeShown));
        FontRenderer renderer = Minecraft.func_71410_x().field_71466_p;
        renderer.func_85187_a(output.get(this.recipeShown).func_77571_b().func_82833_r(), gui.getManualWidth() / 2 - renderer.func_78256_a(output.get(this.recipeShown).func_77571_b().func_82833_r()) / 2 + gui.getX(), gui.getY() + 210, Color.BLACK.getRGB(), false);
    }

    @Override
    public void updateScreen() {
        if (this.update % this.updateTime == 0) {
            ++this.recipeShown;
            if (this.recipeShown == this.outputRecipes.size()) {
                this.recipeShown = 0;
            }
        }
        ++this.update;
    }

    public void drawIngredientList(GuiSubSectionPage gui, IRecipe recipe) {
        block11: {
            block13: {
                block12: {
                    block10: {
                        if (!(recipe instanceof ShapedRecipes)) break block10;
                        ShapedRecipes shaped = (ShapedRecipes)recipe;
                        for (int y = 0; y < shaped.field_77577_c; ++y) {
                            for (int x = 0; x < shaped.field_77576_b; ++x) {
                                this.renderItemCutWild(gui, shaped.field_77574_d[x + y * shaped.field_77576_b], gui.getX() + x * 29 + 27, gui.getY() + y * 28 + 128);
                            }
                        }
                        break block11;
                    }
                    if (!(recipe instanceof ShapelessRecipes)) break block12;
                    ShapelessRecipes shapeless = (ShapelessRecipes)recipe;
                    for (int i = 0; i < shapeless.field_77579_b.size(); ++i) {
                        if (i < 3) {
                            this.renderItemCutWild(gui, (ItemStack)shapeless.field_77579_b.get(i), gui.getX() + i * 29 + 27, gui.getY() + 128);
                            continue;
                        }
                        if (i < 6) {
                            this.renderItemCutWild(gui, (ItemStack)shapeless.field_77579_b.get(i), gui.getX() + (i - 3) * 29 + 27, gui.getY() + 155);
                            continue;
                        }
                        this.renderItemCutWild(gui, (ItemStack)shapeless.field_77579_b.get(i), gui.getX() + (i - 6) * 29 + 27, gui.getY() + 183);
                    }
                    break block11;
                }
                if (!(recipe instanceof ShapedOreRecipe)) break block13;
                ShapedOreRecipe shapedOre = (ShapedOreRecipe)recipe;
                int width = (Integer)ReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)shapedOre, (int)4);
                int height = (Integer)ReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)shapedOre, (int)5);
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        Object item = shapedOre.getInput()[x + y * width];
                        if (item == null) continue;
                        this.renderItemCutWild(gui, item instanceof ItemStack ? (ItemStack)item : (ItemStack)((ArrayList)item).get(0), gui.getX() + x * 29 + 27, gui.getY() + y * 28 + 128);
                    }
                }
                break block11;
            }
            if (!(recipe instanceof ShapelessOreRecipe)) break block11;
            ShapelessOreRecipe shapelessOre = (ShapelessOreRecipe)recipe;
            for (int i = 0; i < shapelessOre.getInput().size(); ++i) {
                if (i < 3) {
                    this.renderItemCutWild(gui, shapelessOre.getInput().get(i) instanceof ItemStack ? (ItemStack)shapelessOre.getInput().get(i) : (ItemStack)((ArrayList)shapelessOre.getInput().get(i)).get(0), gui.getX() + i * 29 + 27, gui.getY() + 128);
                    continue;
                }
                if (i < 6) {
                    this.renderItemCutWild(gui, shapelessOre.getInput().get(i) instanceof ItemStack ? (ItemStack)shapelessOre.getInput().get(i) : (ItemStack)((ArrayList)shapelessOre.getInput().get(i)).get(0), gui.getX() + (i - 3) * 29 + 27, gui.getY() + 155);
                    continue;
                }
                this.renderItemCutWild(gui, shapelessOre.getInput().get(i) instanceof ItemStack ? (ItemStack)shapelessOre.getInput().get(i) : (ItemStack)((ArrayList)shapelessOre.getInput().get(i)).get(0), gui.getX() + (i - 6) * 29 + 27, gui.getY() + 183);
            }
        }
    }
}

