/*
 * Decompiled with CFR 0.152.
 */
package grim3212.mc.core.util;

import cpw.mods.fml.common.FMLCommonHandler;
import grim3212.mc.core.util.Config;
import grim3212.mc.core.util.GrimLog;
import grim3212.mc.core.util.VersionDisplayEvent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;

public class VersionChecker {
    private String modID;
    private String localModVersion;
    private String urlModVersion;

    public VersionChecker(String modID, String localModVersion) {
        this.modID = modID;
        this.localModVersion = localModVersion;
        if (Config.allowVersionCheckGlobal) {
            try {
                String inputLine;
                URL versionURL = new URL("https://dl.dropboxusercontent.com/u/37637724/MinecraftModVersions/" + modID + ".version");
                BufferedReader in = new BufferedReader(new InputStreamReader(versionURL.openStream()));
                StringBuilder lines = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    lines.append(inputLine);
                }
                this.urlModVersion = lines.substring(0, 13);
                in.close();
                GrimLog.info("Grim3212 Core", "Initializing Version Checker for " + modID);
                this.checkVersion(lines.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                GrimLog.error("Grim3212 Core", "Error retrieving version check data for " + modID);
            }
        }
    }

    private void checkVersion(String updateText) {
        if (this.localModVersion.equals(this.urlModVersion)) {
            GrimLog.info("Grim3212 Core", "No update found for " + this.modID);
        } else {
            this.printUpdate(updateText);
        }
    }

    private void printUpdate(String updateText) {
        GrimLog.info("Grim3212 Core", updateText);
        FMLCommonHandler.instance().bus().register((Object)new VersionDisplayEvent(updateText, this.modID));
    }
}

