import random
from bpy.types import Panel, PropertyGroup, Operator
from bpy.props import IntProperty, PointerProperty, FloatProperty
import bpy
bl_info = {
    "name": "PolyDamage for blender",
    "author": "PolyDesign",
    "version": (1, 0),
    "blender": (2, 91, 0),
    "location": "View3d > Toolbar > PolyDesign",
    "warning": "",
    "wiki_url": "https://www.cgtrader.com/batuhanozer52",
    "category": "Object"
}
class PolyDamageProps(PropertyGroup):
    lIIIIlIlIll0O0000O00OlIIIIlIlIll0O0000O00OlIIIIlIlIll0O0000O00O: IntProperty(name="Resolution", default=64, min=16, max=4096)
    lIIllllIIIl0OOOOOOOOOlIIllllIIIl0OOOOOOOOOlIIllllIIIl0OOOOOOOOO: FloatProperty(name="Edge Relax", default=3.0, min=0, max=2048)
    lIIIIllllIl00OO00O00OlIIIIllllIl00OO00O00OlIIIIllllIl00OO00O00O: FloatProperty(name="Edge Push", default=0.7, min=0.0, max=1.0)
    llllIlllIlI0O000000O0llllIlllIlI0O000000O0llllIlllIlI0O000000O0: FloatProperty(name="Noise Scale", default=40, min=0, max=8192)
    llIIIllIlllO0O0000O00llIIIllIlllO0O0000O00llIIIllIlllO0O0000O00: FloatProperty(name="Noise Strength", default=8.0, min=0, max=8192)
    llllllIIIll000O0000OOllllllIIIll000O0000OOllllllIIIll000O0000OO: FloatProperty(name="Noise Contrast", default=1.0, min=0, max=1024)
    lIlIIIIlllIOO0O0O00O0lIlIIIIlllIOO0O0O00O0lIlIIIIlllIOO0O0O00O0: IntProperty(name="Seed", default=0, min=0, max=999999)
    llIIIllIIllO0OOOO0OO0llIIIllIIllO0OOOO0OO0llIIIllIIllO0OOOO0OO0: bpy.props.BoolProperty(name="Random Seed", default=True)
class PolyDamagePanel(Panel):
    bl_label = "PolyDamage"
    bl_idname = "PT_PolyDamage"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = 'PolyDesign'
    def draw(self, context):
        lIIIlIIIIIl00OO0OOOOOlIIIlIIIIIl00OO0OOOOOlIIIlIIIIIl00OO0OOOOO = self.layout
        lIIIlllIllIOOO0O0OO00lIIIlllIllIOOO0O0OO00lIIIlllIllIOOO0O0OO00 = context.scene
        lIllIIlIllI0000OOOO00lIllIIlIllI0000OOOO00lIllIIlIllI0000OOOO00 = lIIIlllIllIOOO0O0OO00lIIIlllIllIOOO0O0OO00lIIIlllIllIOOO0O0OO00.llIlllllIlIO0OO00O00O
        lllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OO = lIIIlIIIIIl00OO0OOOOOlIIIlIIIIIl00OO0OOOOOlIIIlIIIIIl00OO0OOOOO.column()
        lllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OO.label(text="PolyDamage for Blender", icon='CUBE')
        lllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OO = lIIIlIIIIIl00OO0OOOOOlIIIlIIIIIl00OO0OOOOOlIIIlIIIIIl00OO0OOOOO.column(align=True)
        lllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OO.label(text="Settings:")
        lllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OO.prop(lIllIIlIllI0000OOOO00lIllIIlIllI0000OOOO00lIllIIlIllI0000OOOO00, "lIIIIlIlIll0O0000O00OlIIIIlIlIll0O0000O00OlIIIIlIlIll0O0000O00O")
        lllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OO = lIIIlIIIIIl00OO0OOOOOlIIIlIIIIIl00OO0OOOOOlIIIlIIIIIl00OO0OOOOO.column(align=True)
        lllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OO.prop(lIllIIlIllI0000OOOO00lIllIIlIllI0000OOOO00lIllIIlIllI0000OOOO00, "lIIllllIIIl0OOOOOOOOOlIIllllIIIl0OOOOOOOOOlIIllllIIIl0OOOOOOOOO")
        lllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OO.prop(lIllIIlIllI0000OOOO00lIllIIlIllI0000OOOO00lIllIIlIllI0000OOOO00, "lIIIIllllIl00OO00O00OlIIIIllllIl00OO00O00OlIIIIllllIl00OO00O00O")
        lllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OO = lIIIlIIIIIl00OO0OOOOOlIIIlIIIIIl00OO0OOOOOlIIIlIIIIIl00OO0OOOOO.column(align=True)
        lllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OO.prop(lIllIIlIllI0000OOOO00lIllIIlIllI0000OOOO00lIllIIlIllI0000OOOO00, "llllIlllIlI0O000000O0llllIlllIlI0O000000O0llllIlllIlI0O000000O0")
        lllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OO.prop(lIllIIlIllI0000OOOO00lIllIIlIllI0000OOOO00lIllIIlIllI0000OOOO00, "llIIIllIlllO0O0000O00llIIIllIlllO0O0000O00llIIIllIlllO0O0000O00")
        lllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OO.prop(lIllIIlIllI0000OOOO00lIllIIlIllI0000OOOO00lIllIIlIllI0000OOOO00, "llllllIIIll000O0000OOllllllIIIll000O0000OOllllllIIIll000O0000OO")
        lllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OO = lIIIlIIIIIl00OO0OOOOOlIIIlIIIIIl00OO0OOOOOlIIIlIIIIIl00OO0OOOOO.column(align=True)
        lllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OO.prop(lIllIIlIllI0000OOOO00lIllIIlIllI0000OOOO00lIllIIlIllI0000OOOO00, "lIlIIIIlllIOO0O0O00O0lIlIIIIlllIOO0O0O00O0lIlIIIIlllIOO0O0O00O0")
        lllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OO.prop(lIllIIlIllI0000OOOO00lIllIIlIllI0000OOOO00lIllIIlIllI0000OOOO00, "llIIIllIIllO0OOOO0OO0llIIIllIIllO0OOOO0OO0llIIIllIIllO0OOOO0OO0")
        lllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OO.operator("polydamage.op_resetsettings")
        lllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OO = lIIIlIIIIIl00OO0OOOOOlIIIlIIIIIl00OO0OOOOOlIIIlIIIIIl00OO0OOOOO.column()
        lllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OO.label(text="Selected objects: " + str(
            [lIIlIlllIIIOOOOOO0OO0lIIlIlllIIIOOOOOO0OO0lIIlIlllIIIOOOOOO0OO0.name for lIIlIlllIIIOOOOOO0OO0lIIlIlllIIIOOOOOO0OO0lIIlIlllIIIOOOOOO0OO0 in context.selected_objects if lIIlIlllIIIOOOOOO0OO0lIIlIlllIIIOOOOOO0OO0lIIlIlllIIIOOOOOO0OO0.type == 'MESH']))
        lllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OO = lIIIlIIIIIl00OO0OOOOOlIIIlIIIIIl00OO0OOOOOlIIIlIIIIIl00OO0OOOOO.column(align=True)
        lllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OO.scale_y = 1.5
        lllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OO.operator("polydamage.op_removedamage")
        lllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OO.operator("polydamage.op_applydamage")
class PolyDamageInfoPanel(Panel):
    bl_label = "Info"
    bl_idname = "PT_PolyDamageInfo"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = 'PolyDesign'
    bl_parent_id = 'PT_PolyDamage'
    bl_options = {'DEFAULT_CLOSED'}
    def draw(self, context):
        lIIIlIIIIIl00OO0OOOOOlIIIlIIIIIl00OO0OOOOOlIIIlIIIIIl00OO0OOOOO = self.layout
        lllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OO = lIIIlIIIIIl00OO0OOOOOlIIIlIIIIIl00OO0OOOOOlIIIlIIIIIl00OO0OOOOO.column()
        lllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OO.label(text="About PolyDamage", icon='INFO')
        lllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OO.label(text="PolyDamage by PolyDesign3D")
        lIllIlIIIIlOOO0O00O0OlIllIlIIIIlOOO0O00O0OlIllIlIIIIlOOO0O00O0O = lIIIlIIIIIl00OO0OOOOOlIIIlIIIIIl00OO0OOOOOlIIIlIIIIIl00OO0OOOOO.separator()
        lllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OO = lIIIlIIIIIl00OO0OOOOOlIIIlIIIIIl00OO0OOOOOlIIIlIIIIIl00OO0OOOOO.column(align=True)
        lllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OO.label(text="cgtrader.com/batuhanozer52")
        lllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OO.label(text="youtube.com/polydesigntutorials")
        lllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OOlllIllIllII0OOO00O0OO.label(text="facebook.com/3DPolyDesign")
class POLYDAMAGE_OP_resetsettings(Operator):
    bl_label = "Reset Settings"
    bl_idname = "polydamage.op_resetsettings"
    def execute(self, context):
        llIlllllIlIO0OO00O00O = context.scene.llIlllllIlIO0OO00O00O
        llIlllllIlIO0OO00O00O.lIIIIlIlIll0O0000O00OlIIIIlIlIll0O0000O00OlIIIIlIlIll0O0000O00O = 64
        llIlllllIlIO0OO00O00O.lIIllllIIIl0OOOOOOOOOlIIllllIIIl0OOOOOOOOOlIIllllIIIl0OOOOOOOOO = 3.0
        llIlllllIlIO0OO00O00O.lIIIIllllIl00OO00O00OlIIIIllllIl00OO00O00OlIIIIllllIl00OO00O00O = 0.7
        llIlllllIlIO0OO00O00O.llllIlllIlI0O000000O0llllIlllIlI0O000000O0llllIlllIlI0O000000O0 = 40
        llIlllllIlIO0OO00O00O.llIIIllIlllO0O0000O00llIIIllIlllO0O0000O00llIIIllIlllO0O0000O00 = 8.0
        llIlllllIlIO0OO00O00O.llllllIIIll000O0000OOllllllIIIll000O0000OOllllllIIIll000O0000OO = 1.0
        llIlllllIlIO0OO00O00O.lIlIIIIlllIOO0O0O00O0lIlIIIIlllIOO0O0O00O0lIlIIIIlllIOO0O0O00O0 = 0
        llIlllllIlIO0OO00O00O.llIIIllIIllO0OOOO0OO0llIIIllIIllO0OOOO0OO0llIIIllIIllO0OOOO0OO0 = True
        return {'FINISHED'}
class POLYDAMAGE_OP_removedamage(Operator):
    bl_label = "Remove Damage"
    bl_idname = "polydamage.op_removedamage"
    bl_options = {'REGISTER', 'UNDO'}
    def llIlIIllIlIOOOO000O0OllIlIIllIlIOOOO000O0OllIlIIllIlIOOOO000O0O(self, context, lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0):
        if '_polydamaged' in lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0.data.name:
            lIlllllIIIlO00OOOOOO0lIlllllIIIlO00OOOOOO0lIlllllIIIlO00OOOOOO0 = lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0.data.name
            lIllIlIllllOO0O0OOO00lIllIlIllllOO0O0OOO00lIllIlIllllOO0O0OOO00 = lIlllllIIIlO00OOOOOO0lIlllllIIIlO00OOOOOO0lIlllllIIIlO00OOOOOO0.split('_polydamaged', 1)[0]
            if bpy.data.meshes.find(lIllIlIllllOO0O0OOO00lIllIlIllllOO0O0OOO00lIllIlIllllOO0O0OOO00) != -1:
                lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0.data = bpy.data.meshes[lIllIlIllllOO0O0OOO00lIllIlIllllOO0O0OOO00lIllIlIllllOO0O0OOO00]
                bpy.data.meshes.remove(
                    bpy.data.meshes[lIlllllIIIlO00OOOOOO0lIlllllIIIlO00OOOOOO0lIlllllIIIlO00OOOOOO0], do_unlink=True)
            elif bpy.data.meshes.find(lIllIlIllllOO0O0OOO00lIllIlIllllOO0O0OOO00lIllIlIllllOO0O0OOO00.rsplit('.', 1)[0]) != -1:
                lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0.data = bpy.data.meshes[lIllIlIllllOO0O0OOO00lIllIlIllllOO0O0OOO00lIllIlIllllOO0O0OOO00.rsplit('.', 1)[
                    0]]
                bpy.data.meshes.remove(
                    bpy.data.meshes[lIlllllIIIlO00OOOOOO0lIlllllIIIlO00OOOOOO0lIlllllIIIlO00OOOOOO0], do_unlink=True)
            else:
                pass
    def execute(self, context):
        bpy.ops.object.mode_set(mode='OBJECT')
        lIIIlllIllIOOO0O0OO00lIIIlllIllIOOO0O0OO00lIIIlllIllIOOO0O0OO00 = context.scene
        lllIIIIIlllOOOOO0O0OOlllIIIIIlllOOOOO0O0OOlllIIIIIlllOOOOO0O0OO = [
            lIIlIlllIIIOOOOOO0OO0lIIlIlllIIIOOOOOO0OO0lIIlIlllIIIOOOOOO0OO0 for lIIlIlllIIIOOOOOO0OO0lIIlIlllIIIOOOOOO0OO0lIIlIlllIIIOOOOOO0OO0 in context.selected_objects if lIIlIlllIIIOOOOOO0OO0lIIlIlllIIIOOOOOO0OO0lIIlIlllIIIOOOOOO0OO0.type == 'MESH']
        for lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0 in lllIIIIIlllOOOOO0O0OOlllIIIIIlllOOOOO0O0OOlllIIIIIlllOOOOO0O0OO:
            self.llIlIIllIlIOOOO000O0OllIlIIllIlIOOOO000O0OllIlIIllIlIOOOO000O0O(context, lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0)
        return {'FINISHED'}
class POLYDAMAGE_OP_applydamage(Operator):
    bl_label = "Apply Damage"
    bl_idname = "polydamage.op_applydamage"
    bl_options = {'REGISTER', 'UNDO'}
    def llIlIIllIlIOOOO000O0OllIlIIllIlIOOOO000O0OllIlIIllIlIOOOO000O0O(self, context, lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0):
        if '_polydamaged' in lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0.data.name:
            lIlllllIIIlO00OOOOOO0lIlllllIIIlO00OOOOOO0lIlllllIIIlO00OOOOOO0 = lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0.data.name
            # assign the original mesh back
            lIllIlIllllOO0O0OOO00lIllIlIllllOO0O0OOO00lIllIlIllllOO0O0OOO00 = lIlllllIIIlO00OOOOOO0lIlllllIIIlO00OOOOOO0lIlllllIIIlO00OOOOOO0.split('_polydamaged', 1)[0]
            if bpy.data.meshes.find(lIllIlIllllOO0O0OOO00lIllIlIllllOO0O0OOO00lIllIlIllllOO0O0OOO00) != -1:
                lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0.data = bpy.data.meshes[lIllIlIllllOO0O0OOO00lIllIlIllllOO0O0OOO00lIllIlIllllOO0O0OOO00]
                bpy.data.meshes.remove(
                    bpy.data.meshes[lIlllllIIIlO00OOOOOO0lIlllllIIIlO00OOOOOO0lIlllllIIIlO00OOOOOO0], do_unlink=True)
            elif bpy.data.meshes.find(lIllIlIllllOO0O0OOO00lIllIlIllllOO0O0OOO00lIllIlIllllOO0O0OOO00.rsplit('.', 1)[0]) != -1:
                lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0.data = bpy.data.meshes[lIllIlIllllOO0O0OOO00lIllIlIllllOO0O0OOO00lIllIlIllllOO0O0OOO00.rsplit('.', 1)[0]]
                bpy.data.meshes.remove(
                    bpy.data.meshes[lIlllllIIIlO00OOOOOO0lIlllllIIIlO00OOOOOO0lIlllllIIIlO00OOOOOO0], do_unlink=True)
            else:
                pass
    def lllllllIIIlOOOOO0OOO0lllllllIIIlOOOOO0OOO0lllllllIIIlOOOOO0OOO0(self, context, lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0):
        context.view_layer.objects.active = lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0
        bpy.ops.object.convert(target='MESH')
        lIIIlllIllIOOO0O0OO00lIIIlllIllIOOO0O0OO00lIIIlllIllIOOO0O0OO00 = context.scene
        lllIIIIlllIO00OO0OOOOlllIIIIlllIO00OO0OOOOlllIIIIlllIO00OO0OOOO = lIIIlllIllIOOO0O0OO00lIIIlllIllIOOO0O0OO00lIIIlllIllIOOO0O0OO00.llIlllllIlIO0OO00O00O.lIIIIlIlIll0O0000O00OlIIIIlIlIll0O0000O00OlIIIIlIlIll0O0000O00O
        lIllIIIIIII0OO00OOOOOlIllIIIIIII0OO00OOOOOlIllIIIIIII0OO00OOOOO = lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0.dimensions
        lIIllIIllIlOO000O0OO0lIIllIIllIlOO000O0OO0lIIllIIllIlOO000O0OO0 = lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0.scale
        lIlIlIIlllIOOO00O000OlIlIlIIlllIOOO00O000OlIlIlIIlllIOOO00O000O = max(lIllIIIIIII0OO00OOOOOlIllIIIIIII0OO00OOOOOlIllIIIIIII0OO00OOOOO.x/lIIllIIllIlOO000O0OO0lIIllIIllIlOO000O0OO0lIIllIIllIlOO000O0OO0.x, max(
            lIllIIIIIII0OO00OOOOOlIllIIIIIII0OO00OOOOOlIllIIIIIII0OO00OOOOO.y/lIIllIIllIlOO000O0OO0lIIllIIllIlOO000O0OO0lIIllIIllIlOO000O0OO0.y, lIllIIIIIII0OO00OOOOOlIllIIIIIII0OO00OOOOOlIllIIIIIII0OO00OOOOO.z/lIIllIIllIlOO000O0OO0lIIllIIllIlOO000O0OO0lIIllIIllIlOO000O0OO0.z))
        llIllIIIllI0OO0O0OO00llIllIIIllI0OO0O0OO00llIllIIIllI0OO0O0OO00 = lIlIlIIlllIOOO00O000OlIlIlIIlllIOOO00O000OlIlIlIIlllIOOO00O000O / lllIIIIlllIO00OO0OOOOlllIIIIlllIO00OO0OOOOlllIIIIlllIO00OO0OOOO
        lIlllIIIlll0O0OO000O0lIlllIIIlll0O0OO000O0lIlllIIIlll0O0OO000O0 = lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0.modifiers.new("Remesh", 'REMESH')
        lIlllIIIlll0O0OO000O0lIlllIIIlll0O0OO000O0lIlllIIIlll0O0OO000O0.voxel_size = llIllIIIllI0OO0O0OO00llIllIIIllI0OO0O0OO00llIllIIIllI0OO0O0OO00
        lIlllIIIlll0O0OO000O0lIlllIIIlll0O0OO000O0lIlllIIIlll0O0OO000O0.use_smooth_shade = True
        lllllllllII0O0O0000OOlllllllllII0O0O0000OOlllllllllII0O0O0000OO = lIIIlllIllIOOO0O0OO00lIIIlllIllIOOO0O0OO00lIIIlllIllIOOO0O0OO00.llIlllllIlIO0OO00O00O.lIIllllIIIl0OOOOOOOOOlIIllllIIIl0OOOOOOOOOlIIllllIIIl0OOOOOOOOO
        lIIlIlIIIIIOOO0O0O00OlIIlIlIIIIIOOO0O0O00OlIIlIlIIIIIOOO0O0O00O = lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0.modifiers.new("Smooth", 'SMOOTH')
        lIIlIlIIIIIOOO0O0O00OlIIlIlIIIIIOOO0O0O00OlIIlIlIIIIIOOO0O0O00O.iterations = int(
            lllIIIIlllIO00OO0OOOOlllIIIIlllIO00OO0OOOOlllIIIIlllIO00OO0OOOO*lllllllllII0O0O0000OOlllllllllII0O0O0000OOlllllllllII0O0O0000OO)
        llllllIllll0O000O0000llllllIllll0O000O0000llllllIllll0O000O0000 = lIIIlllIllIOOO0O0OO00lIIIlllIllIOOO0O0OO00lIIIlllIllIOOO0O0OO00.llIlllllIlIO0OO00O00O.lIIIIllllIl00OO00O00OlIIIIllllIl00OO00O00OlIIIIllllIl00OO00O00O
        lllIIllIlllO0O000O0OOlllIIllIlllO0O000O0OOlllIIllIlllO0O000O0OO = lIIIlllIllIOOO0O0OO00lIIIlllIllIOOO0O0OO00lIIIlllIllIOOO0O0OO00.llIlllllIlIO0OO00O00O.llIIIllIlllO0O0000O00llIIIllIlllO0O0000O00llIIIllIlllO0O0000O00 * \
            llIllIIIllI0OO0O0OO00llIllIIIllI0OO0O0OO00llIllIIIllI0OO0O0OO00
        lIIllIlIIll000O0OO0O0lIIllIlIIll000O0OO0O0lIIllIlIIll000O0OO0O0 = lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0.modifiers.new(
            "Displace", 'DISPLACE')
        lIIllIlIIll000O0OO0O0lIIllIlIIll000O0OO0O0lIIllIlIIll000O0OO0O0.strength = lllIIllIlllO0O000O0OOlllIIllIlllO0O000O0OOlllIIllIlllO0O000O0OO / 2
        lIIllIlIIll000O0OO0O0lIIllIlIIll000O0OO0O0lIIllIlIIll000O0OO0O0.mid_level = 1.0 - llllllIllll0O000O0000llllllIllll0O000O0000llllllIllll0O000O0000
        lIIllIlIIll000O0OO0O0lIIllIlIIll000O0OO0O0lIIllIlIIll000O0OO0O0.texture_coords = 'GLOBAL'
        random.seed(
            lIIIlllIllIOOO0O0OO00lIIIlllIllIOOO0O0OO00lIIIlllIllIOOO0O0OO00.llIlllllIlIO0OO00O00O.lIlIIIIlllIOO0O0O00O0lIlIIIIlllIOO0O0O00O0lIlIIIIlllIOO0O0O00O0)
        lIlIIIllIlIO0OO00O0OOlIlIIIllIlIO0OO00O0OOlIlIIIllIlIO0OO00O0OO = random.uniform(-99.9, 99.9)
        llllIIlIlIlOO0O0O0O0OllllIIlIlIlOO0O0O0O0OllllIIlIlIlOO0O0O0O0O = random.uniform(-99.9, 99.9)
        llIIllllIIl0OO0O0OO0OllIIllllIIl0OO0O0OO0OllIIllllIIl0OO0O0OO0O = random.uniform(-99.9, 99.9)
        lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0.location.x += lIlIIIllIlIO0OO00O0OOlIlIIIllIlIO0OO00O0OOlIlIIIllIlIO0OO00O0OO
        lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0.location.y += llllIIlIlIlOO0O0O0O0OllllIIlIlIlOO0O0O0O0OllllIIlIlIlOO0O0O0O0O
        lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0.location.z += llIIllllIIl0OO0O0OO0OllIIllllIIl0OO0O0OO0OllIIllllIIl0OO0O0OO0O
        lIIIllIIllIOOO000O000lIIIllIIllIOOO000O000lIIIllIIllIOOO000O000 = 4
        lIIlIIIlIIIO00OOO0O00lIIlIIIlIIIO00OOO0O00lIIlIIIlIIIO00OOO0O00 = lIIIlllIllIOOO0O0OO00lIIIlllIllIOOO0O0OO00lIIIlllIllIOOO0O0OO00.llIlllllIlIO0OO00O00O.llllIlllIlI0O000000O0llllIlllIlI0O000000O0llllIlllIlI0O000000O0 / \
            200 * max(lIllIIIIIII0OO00OOOOOlIllIIIIIII0OO00OOOOOlIllIIIIIII0OO00OOOOO.x,
                      max(lIllIIIIIII0OO00OOOOOlIllIIIIIII0OO00OOOOOlIllIIIIIII0OO00OOOOO.y, lIllIIIIIII0OO00OOOOOlIllIIIIIII0OO00OOOOOlIllIIIIIII0OO00OOOOO.z))
        lIIlIlIllIIOO0OOOO0OOlIIlIlIllIIOO0OOOO0OOlIIlIlIllIIOO0OOOO0OO = lIIIlllIllIOOO0O0OO00lIIIlllIllIOOO0O0OO00lIIIlllIllIOOO0O0OO00.llIlllllIlIO0OO00O00O.llllllIIIll000O0000OOllllllIIIll000O0000OOllllllIIIll000O0000OO
        lIllIllIllI00O0O000OOlIllIllIllI00O0O000OOlIllIllIllI00O0O000OO = bpy.data.textures.new('Clouds', type='CLOUDS')
        lIllIllIllI00O0O000OOlIllIllIllI00O0O000OOlIllIllIllI00O0O000OO.noise_basis = 'IMPROVED_PERLIN'
        lIllIllIllI00O0O000OOlIllIllIllI00O0O000OOlIllIllIllI00O0O000OO.noise_scale = lIIlIIIlIIIO00OOO0O00lIIlIIIlIIIO00OOO0O00lIIlIIIlIIIO00OOO0O00
        lIllIllIllI00O0O000OOlIllIllIllI00O0O000OOlIllIllIllI00O0O000OO.noise_depth = lIIIllIIllIOOO000O000lIIIllIIllIOOO000O000lIIIllIIllIOOO000O000
        lIllIllIllI00O0O000OOlIllIllIllI00O0O000OOlIllIllIllI00O0O000OO.contrast = lIIlIlIllIIOO0OOOO0OOlIIlIlIllIIOO0OOOO0OOlIIlIlIllIIOO0OOOO0OO
        lIIllIlIIll000O0OO0O0lIIllIlIIll000O0OO0O0lIIllIlIIll000O0OO0O0.texture = lIllIllIllI00O0O000OOlIllIllIllI00O0O000OOlIllIllIllI00O0O000OO
        bpy.ops.object.convert(target='MESH')
        bpy.data.textures.remove(lIllIllIllI00O0O000OOlIllIllIllI00O0O000OOlIllIllIllI00O0O000OO)
        lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0.location.x -= lIlIIIllIlIO0OO00O0OOlIlIIIllIlIO0OO00O0OOlIlIIIllIlIO0OO00O0OO
        lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0.location.y -= llllIIlIlIlOO0O0O0O0OllllIIlIlIlOO0O0O0O0OllllIIlIlIlOO0O0O0O0O
        lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0.location.z -= llIIllllIIl0OO0O0OO0OllIIllllIIl0OO0O0OO0OllIIllllIIl0OO0O0OO0O
    def lIlIIIIIllIO0O0OOOO00lIlIIIIIllIO0O0OOOO00lIlIIIIIllIO0O0OOOO00(self, context, lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0):
        llllIlIIIlI0OOO0OO000llllIlIIIlI0OOO0OO000llllIlIIIlI0OOO0OO000 = lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0.copy()
        llllIlIIIlI0OOO0OO000llllIlIIIlI0OOO0OO000llllIlIIIlI0OOO0OO000.data = lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0.data.copy()
        llllIlIIIlI0OOO0OO000llllIlIIIlI0OOO0OO000llllIlIIIlI0OOO0OO000.animation_data_clear()
        context.collection.objects.link(llllIlIIIlI0OOO0OO000llllIlIIIlI0OOO0OO000llllIlIIIlI0OOO0OO000)
        return llllIlIIIlI0OOO0OO000llllIlIIIlI0OOO0OO000llllIlIIIlI0OOO0OO000
    def llIlIlIIllI000OO000O0llIlIlIIllI000OO000O0llIlIlIIllI000OO000O0(self, context, lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0, llIllIlllIl0O0O0O0O0OllIllIlllIl0O0O0O0O0OllIllIlllIl0O0O0O0O0O):
        lIlIllIlIlIO000OO0000lIlIllIlIlIO000OO0000lIlIllIlIlIO000OO0000 = lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0lIlllllIIIlO0OO00O0O0.modifiers.new(
            "Boolean", 'BOOLEAN')
        lIlIllIlIlIO000OO0000lIlIllIlIlIO000OO0000lIlIllIlIlIO000OO0000.operation = 'INTERSECT'
        lIlIllIlIlIO000OO0000lIlIllIlIlIO000OO0000lIlIllIlIlIO000OO0000.solver = 'FAST'
        lllIIllllIIO00O0O0OO0lllIIllllIIO00O0O0OO0lllIIllllIIO00O0O0OO0 = self.lIlIIIIIllIO0O0OOOO00lIlIIIIIllIO0O0OOOO00lIlIIIIIllIO0O0OOOO00(
            context, llIllIlllIl0O0O0O0O0OllIllIlllIl0O0O0O0O0OllIllIlllIl0O0O0O0O0O)
        lIlIllIlIlIO000OO0000lIlIllIlIlIO000OO0000lIlIllIlIlIO000OO0000.object = lllIIllllIIO00O0O0OO0lllIIllllIIO00O0O0OO0lllIIllllIIO00O0O0OO0
        bpy.ops.object.convert(target='MESH')
        bpy.data.meshes.remove(lllIIllllIIO00O0O0OO0lllIIllllIIO00O0O0OO0lllIIllllIIO00O0O0OO0.data, do_unlink=True)
    def execute(self, context):
        lIIIlllIllIOOO0O0OO00lIIIlllIllIOOO0O0OO00lIIIlllIllIOOO0O0OO00 = context.scene
        bpy.ops.object.mode_set(mode='OBJECT')
        lllIIIIIlllOOOOO0O0OOlllIIIIIlllOOOOO0O0OOlllIIIIIlllOOOOO0O0OO = [
            lIIlIlllIIIOOOOOO0OO0lIIlIlllIIIOOOOOO0OO0lIIlIlllIIIOOOOOO0OO0 for lIIlIlllIIIOOOOOO0OO0lIIlIlllIIIOOOOOO0OO0lIIlIlllIIIOOOOOO0OO0 in context.selected_objects if lIIlIlllIIIOOOOOO0OO0lIIlIlllIIIOOOOOO0OO0lIIlIlllIIIOOOOOO0OO0.type == 'MESH']
        llIIllIIIIlO00OO00O00llIIllIIIIlO00OO00O00llIIllIIIIlO00OO00O00 = context.view_layer.objects.active
        for llIIlllIIIlO0OO0OOO00llIIlllIIIlO0OO0OOO00llIIlllIIIlO0OO0OOO00 in lllIIIIIlllOOOOO0O0OOlllIIIIIlllOOOOO0O0OOlllIIIIIlllOOOOO0O0OO:
            if lIIIlllIllIOOO0O0OO00lIIIlllIllIOOO0O0OO00lIIIlllIllIOOO0O0OO00.llIlllllIlIO0OO00O00O.llIIIllIIllO0OOOO0OO0llIIIllIIllO0OOOO0OO0llIIIllIIllO0OOOO0OO0:
                lIIIlllIllIOOO0O0OO00lIIIlllIllIOOO0O0OO00lIIIlllIllIOOO0O0OO00.llIlllllIlIO0OO00O00O.lIlIIIIlllIOO0O0O00O0lIlIIIIlllIOO0O0O00O0lIlIIIIlllIOO0O0O00O0 = random.randint(0, 999999)
            self.llIlIIllIlIOOOO000O0OllIlIIllIlIOOOO000O0OllIlIIllIlIOOOO000O0O(context, llIIlllIIIlO0OO0OOO00llIIlllIIIlO0OO0OOO00llIIlllIIIlO0OO0OOO00)
            context.view_layer.objects.active = llIIlllIIIlO0OO0OOO00llIIlllIIIlO0OO0OOO00llIIlllIIIlO0OO0OOO00
            context.object.data.use_auto_smooth = False
            bpy.ops.object.shade_flat()
            llllIlIIIlI0OOO0OO000llllIlIIIlI0OOO0OO000llllIlIIIlI0OOO0OO000 = self.lIlIIIIIllIO0O0OOOO00lIlIIIIIllIO0O0OOOO00lIlIIIIIllIO0O0OOOO00(
                context, llIIlllIIIlO0OO0OOO00llIIlllIIIlO0OO0OOO00llIIlllIIIlO0OO0OOO00)
            llllIlIIIlI0OOO0OO000llllIlIIIlI0OOO0OO000llllIlIIIlI0OOO0OO000.data.name = llIIlllIIIlO0OO0OOO00llIIlllIIIlO0OO0OOO00llIIlllIIIlO0OO0OOO00.data.name + '_polydamaged'
            lIllIllIIll000000000OlIllIllIIll000000000OlIllIllIIll000000000O = llllIlIIIlI0OOO0OO000llllIlIIIlI0OOO0OO000llllIlIIIlI0OOO0OO000.matrix_basis.copy()
            if hasattr(llllIlIIIlI0OOO0OO000llllIlIIIlI0OOO0OO000llllIlIIIlI0OOO0OO000.data, "transform"):
                llllIlIIIlI0OOO0OO000llllIlIIIlI0OOO0OO000llllIlIIIlI0OOO0OO000.data.transform(lIllIllIIll000000000OlIllIllIIll000000000OlIllIllIIll000000000O)
            self.lllllllIIIlOOOOO0OOO0lllllllIIIlOOOOO0OOO0lllllllIIIlOOOOO0OOO0(context, llllIlIIIlI0OOO0OO000llllIlIIIlI0OOO0OO000llllIlIIIlI0OOO0OO000)
            lIllIllIIll000000000OlIllIllIIll000000000OlIllIllIIll000000000O.invert()
            if hasattr(llllIlIIIlI0OOO0OO000llllIlIIIlI0OOO0OO000llllIlIIIlI0OOO0OO000.data, "transform"):
                llllIlIIIlI0OOO0OO000llllIlIIIlI0OOO0OO000llllIlIIIlI0OOO0OO000.data.transform(lIllIllIIll000000000OlIllIllIIll000000000OlIllIllIIll000000000O)
            self.llIlIlIIllI000OO000O0llIlIlIIllI000OO000O0llIlIlIIllI000OO000O0(
                context, llllIlIIIlI0OOO0OO000llllIlIIIlI0OOO0OO000llllIlIIIlI0OOO0OO000, llIIlllIIIlO0OO0OOO00llIIlllIIIlO0OO0OOO00llIIlllIIIlO0OO0OOO00)
            llIIlllIIIlO0OO0OOO00llIIlllIIIlO0OO0OOO00llIIlllIIIlO0OO0OOO00.data.use_fake_user = True
            llllIlIIIlI0OOO0OO000llllIlIIIlI0OOO0OO000llllIlIIIlI0OOO0OO000.name = "PolyDamage_tempObject"
            llIIlllIIIlO0OO0OOO00llIIlllIIIlO0OO0OOO00llIIlllIIIlO0OO0OOO00.data = llllIlIIIlI0OOO0OO000llllIlIIIlI0OOO0OO000llllIlIIIlI0OOO0OO000.data
            bpy.data.objects.remove(llllIlIIIlI0OOO0OO000llllIlIIIlI0OOO0OO000llllIlIIIlI0OOO0OO000, do_unlink=True)
            llIIlllIIIlO0OO0OOO00llIIlllIIIlO0OO0OOO00llIIlllIIIlO0OO0OOO00.data.use_fake_user = True
            bpy.ops.wm.redraw_timer(type='DRAW_WIN_SWAP', iterations=1)
            llIIlllIIIlO0OO0OOO00llIIlllIIIlO0OO0OOO00llIIlllIIIlO0OO0OOO00.select_set(False)
        for llIIlllIIIlO0OO0OOO00llIIlllIIIlO0OO0OOO00llIIlllIIIlO0OO0OOO00 in lllIIIIIlllOOOOO0O0OOlllIIIIIlllOOOOO0O0OOlllIIIIIlllOOOOO0O0OO:
            llIIlllIIIlO0OO0OOO00llIIlllIIIlO0OO0OOO00llIIlllIIIlO0OO0OOO00.select_set(True)
        context.view_layer.objects.active = llIIllIIIIlO00OO00O00llIIllIIIIlO00OO00O00llIIllIIIIlO00OO00O00
        return {'FINISHED'}
classes = [PolyDamageProps, PolyDamagePanel, PolyDamageInfoPanel,
           POLYDAMAGE_OP_applydamage, POLYDAMAGE_OP_removedamage, POLYDAMAGE_OP_resetsettings]
def register():
    for cls in classes:
        bpy.utils.register_class(cls)
        bpy.types.Scene.llIlllllIlIO0OO00O00O = PointerProperty(
            type=PolyDamageProps)
def unregister():
    for cls in classes:
        bpy.utils.unregister_class(cls)
        del bpy.types.Scene.llIlllllIlIO0OO00O00O
if __name__ == "__main__":
    register()
