/* Automatically generated from OpenXR xr.xml; DO NOT EDIT!
 *
 * This file is generated from OpenXR xr.xml file covered
 * by the following copyright and permission notice:
 *
 * Copyright (c) 2017-2021, The Khronos Group Inc.
 *
 * SPDX-License-Identifier: Apache-2.0 OR MIT
 *
 * ------------------------------------------------------------------------
 *
 * This file, xr.xml, is the OpenXR API Registry. It is a critically important
 * and normative part of the OpenXR Specification, including a canonical
 * machine-readable definition of the API, parameter and member validation
 * language incorporated into the Specification and reference pages, and other
 * material which is registered by Khronos, such as tags used by extension and
 * layer authors. The only authoritative version of xr.xml is the one
 * maintained in the default branch of the Khronos OpenXR GitHub project.
 *
 */

#ifndef __WINE_OPENXR_H
#define __WINE_OPENXR_H

#include <windef.h>
#include <stdint.h>

/* Define WINE_XR_HOST to get 'host' headers. */
#ifdef WINE_XR_HOST
#define XRAPI_CALL
#define WINE_XR_ALIGN(x)
#endif

#ifndef XRAPI_CALL
#define XRAPI_CALL __stdcall
#endif

#ifndef XRAPI_PTR
#define XRAPI_PTR XRAPI_CALL
#endif

#ifndef WINE_XR_ALIGN
#define WINE_XR_ALIGN DECLSPEC_ALIGN
#endif

#define XR_TRUE 1
#define XR_FALSE 0
#define XR_MAX_EXTENSION_NAME_SIZE 128
#define XR_MAX_API_LAYER_NAME_SIZE 256
#define XR_MAX_API_LAYER_DESCRIPTION_SIZE 256
#define XR_MAX_SYSTEM_NAME_SIZE 256
#define XR_MAX_APPLICATION_NAME_SIZE 128
#define XR_MAX_ENGINE_NAME_SIZE 128
#define XR_MAX_RUNTIME_NAME_SIZE 128
#define XR_MAX_PATH_LENGTH 256
#define XR_MAX_STRUCTURE_NAME_SIZE 64
#define XR_MAX_RESULT_STRING_SIZE 64
#define XR_MAX_GRAPHICS_APIS_SUPPORTED 32
#define XR_MAX_ACTION_SET_NAME_SIZE 64
#define XR_MAX_ACTION_NAME_SIZE 64
#define XR_MAX_LOCALIZED_ACTION_SET_NAME_SIZE 128
#define XR_MAX_LOCALIZED_ACTION_NAME_SIZE 128
#define XR_MIN_COMPOSITION_LAYERS_SUPPORTED 16
#define XR_KHR_composition_layer_cube_SPEC_VERSION 8
#define XR_KHR_COMPOSITION_LAYER_CUBE_EXTENSION_NAME "XR_KHR_composition_layer_cube"
#define XR_KHR_composition_layer_depth_SPEC_VERSION 5
#define XR_KHR_COMPOSITION_LAYER_DEPTH_EXTENSION_NAME "XR_KHR_composition_layer_depth"
#define XR_KHR_vulkan_swapchain_format_list_SPEC_VERSION 4
#define XR_KHR_VULKAN_SWAPCHAIN_FORMAT_LIST_EXTENSION_NAME "XR_KHR_vulkan_swapchain_format_list"
#define XR_EXT_performance_settings_SPEC_VERSION 3
#define XR_EXT_PERFORMANCE_SETTINGS_EXTENSION_NAME "XR_EXT_performance_settings"
#define XR_EXT_thermal_query_SPEC_VERSION 2
#define XR_EXT_THERMAL_QUERY_EXTENSION_NAME "XR_EXT_thermal_query"
#define XR_KHR_composition_layer_cylinder_SPEC_VERSION 4
#define XR_KHR_COMPOSITION_LAYER_CYLINDER_EXTENSION_NAME "XR_KHR_composition_layer_cylinder"
#define XR_KHR_composition_layer_equirect_SPEC_VERSION 3
#define XR_KHR_COMPOSITION_LAYER_EQUIRECT_EXTENSION_NAME "XR_KHR_composition_layer_equirect"
#define XR_KHR_opengl_enable_SPEC_VERSION 10
#define XR_KHR_OPENGL_ENABLE_EXTENSION_NAME "XR_KHR_opengl_enable"
#define XR_KHR_vulkan_enable_SPEC_VERSION 8
#define XR_KHR_VULKAN_ENABLE_EXTENSION_NAME "XR_KHR_vulkan_enable"
#define XR_KHR_D3D11_enable_SPEC_VERSION 8
#define XR_KHR_D3D11_ENABLE_EXTENSION_NAME "XR_KHR_D3D11_enable"
#define XR_KHR_D3D12_enable_SPEC_VERSION 8
#define XR_KHR_D3D12_ENABLE_EXTENSION_NAME "XR_KHR_D3D12_enable"
#define XR_EXT_eye_gaze_interaction_SPEC_VERSION 1
#define XR_EXT_EYE_GAZE_INTERACTION_EXTENSION_NAME "XR_EXT_eye_gaze_interaction"
#define XR_KHR_visibility_mask_SPEC_VERSION 2
#define XR_KHR_VISIBILITY_MASK_EXTENSION_NAME "XR_KHR_visibility_mask"
#define XR_EXTX_overlay_SPEC_VERSION 5
#define XR_EXTX_OVERLAY_EXTENSION_NAME "XR_EXTX_overlay"
#define XR_KHR_composition_layer_color_scale_bias_SPEC_VERSION 5
#define XR_KHR_COMPOSITION_LAYER_COLOR_SCALE_BIAS_EXTENSION_NAME "XR_KHR_composition_layer_color_scale_bias"
#define XR_KHR_win32_convert_performance_counter_time_SPEC_VERSION 1
#define XR_KHR_WIN32_CONVERT_PERFORMANCE_COUNTER_TIME_EXTENSION_NAME "XR_KHR_win32_convert_performance_counter_time"
#define XR_VARJO_quad_views_SPEC_VERSION 1
#define XR_VARJO_QUAD_VIEWS_EXTENSION_NAME "XR_VARJO_quad_views"
#define XR_MSFT_unbounded_reference_space_SPEC_VERSION 1
#define XR_MSFT_UNBOUNDED_REFERENCE_SPACE_EXTENSION_NAME "XR_MSFT_unbounded_reference_space"
#define XR_MSFT_spatial_anchor_SPEC_VERSION 2
#define XR_MSFT_SPATIAL_ANCHOR_EXTENSION_NAME "XR_MSFT_spatial_anchor"
#define XR_FB_composition_layer_image_layout_SPEC_VERSION 1
#define XR_FB_COMPOSITION_LAYER_IMAGE_LAYOUT_EXTENSION_NAME "XR_FB_composition_layer_image_layout"
#define XR_FB_composition_layer_alpha_blend_SPEC_VERSION 2
#define XR_FB_COMPOSITION_LAYER_ALPHA_BLEND_EXTENSION_NAME "XR_FB_composition_layer_alpha_blend"
#define XR_MND_headless_SPEC_VERSION 2
#define XR_MND_HEADLESS_EXTENSION_NAME "XR_MND_headless"
#define XR_OCULUS_android_session_state_enable_SPEC_VERSION 1
#define XR_OCULUS_ANDROID_SESSION_STATE_ENABLE_EXTENSION_NAME "XR_OCULUS_android_session_state_enable"
#define XR_EXT_view_configuration_depth_range_SPEC_VERSION 1
#define XR_EXT_VIEW_CONFIGURATION_DEPTH_RANGE_EXTENSION_NAME "XR_EXT_view_configuration_depth_range"
#define XR_EXT_conformance_automation_SPEC_VERSION 3
#define XR_EXT_CONFORMANCE_AUTOMATION_EXTENSION_NAME "XR_EXT_conformance_automation"
#define XR_MSFT_spatial_graph_bridge_SPEC_VERSION 1
#define XR_MSFT_SPATIAL_GRAPH_BRIDGE_EXTENSION_NAME "XR_MSFT_spatial_graph_bridge"
#define XR_MSFT_hand_interaction_SPEC_VERSION 1
#define XR_MSFT_HAND_INTERACTION_EXTENSION_NAME "XR_MSFT_hand_interaction"
#define XR_EXT_hand_tracking_SPEC_VERSION 4
#define XR_EXT_HAND_TRACKING_EXTENSION_NAME "XR_EXT_hand_tracking"
#define XR_MSFT_hand_tracking_mesh_SPEC_VERSION 3
#define XR_MSFT_HAND_TRACKING_MESH_EXTENSION_NAME "XR_MSFT_hand_tracking_mesh"
#define XR_MSFT_secondary_view_configuration_SPEC_VERSION 1
#define XR_MSFT_SECONDARY_VIEW_CONFIGURATION_EXTENSION_NAME "XR_MSFT_secondary_view_configuration"
#define XR_MSFT_first_person_observer_SPEC_VERSION 1
#define XR_MSFT_FIRST_PERSON_OBSERVER_EXTENSION_NAME "XR_MSFT_first_person_observer"
#define XR_MSFT_controller_model_SPEC_VERSION 2
#define XR_MSFT_CONTROLLER_MODEL_EXTENSION_NAME "XR_MSFT_controller_model"
#define XR_MAX_CONTROLLER_MODEL_NODE_NAME_SIZE_MSFT 64
#define XR_EXT_win32_appcontainer_compatible_SPEC_VERSION 1
#define XR_EXT_WIN32_APPCONTAINER_COMPATIBLE_EXTENSION_NAME "XR_EXT_win32_appcontainer_compatible"
#define XR_EPIC_view_configuration_fov_SPEC_VERSION 2
#define XR_EPIC_VIEW_CONFIGURATION_FOV_EXTENSION_NAME "XR_EPIC_view_configuration_fov"
#define XR_MSFT_holographic_window_attachment_SPEC_VERSION 1
#define XR_MSFT_HOLOGRAPHIC_WINDOW_ATTACHMENT_EXTENSION_NAME "XR_MSFT_holographic_window_attachment"
#define XR_MSFT_composition_layer_reprojection_SPEC_VERSION 1
#define XR_MSFT_COMPOSITION_LAYER_REPROJECTION_EXTENSION_NAME "XR_MSFT_composition_layer_reprojection"
#define XR_HUAWEI_controller_interaction_SPEC_VERSION 1
#define XR_HUAWEI_CONTROLLER_INTERACTION_EXTENSION_NAME "XR_HUAWEI_controller_interaction"
#define XR_FB_swapchain_update_state_SPEC_VERSION 3
#define XR_FB_SWAPCHAIN_UPDATE_STATE_EXTENSION_NAME "XR_FB_swapchain_update_state"
#define XR_FB_composition_layer_secure_content_SPEC_VERSION 1
#define XR_FB_COMPOSITION_LAYER_SECURE_CONTENT_EXTENSION_NAME "XR_FB_composition_layer_secure_content"
#define XR_VALVE_analog_threshold_SPEC_VERSION 2
#define XR_VALVE_ANALOG_THRESHOLD_EXTENSION_NAME "XR_VALVE_analog_threshold"
#define XR_EXT_hand_joints_motion_range_SPEC_VERSION 1
#define XR_EXT_HAND_JOINTS_MOTION_RANGE_EXTENSION_NAME "XR_EXT_hand_joints_motion_range"
#define XR_KHR_vulkan_enable2_SPEC_VERSION 2
#define XR_KHR_VULKAN_ENABLE2_EXTENSION_NAME "XR_KHR_vulkan_enable2"
#define XR_KHR_composition_layer_equirect2_SPEC_VERSION 1
#define XR_KHR_COMPOSITION_LAYER_EQUIRECT2_EXTENSION_NAME "XR_KHR_composition_layer_equirect2"
#define XR_EXT_samsung_odyssey_controller_SPEC_VERSION 1
#define XR_EXT_SAMSUNG_ODYSSEY_CONTROLLER_EXTENSION_NAME "XR_EXT_samsung_odyssey_controller"
#define XR_EXT_hp_mixed_reality_controller_SPEC_VERSION 1
#define XR_EXT_HP_MIXED_REALITY_CONTROLLER_EXTENSION_NAME "XR_EXT_hp_mixed_reality_controller"
#define XR_MND_swapchain_usage_input_attachment_bit_SPEC_VERSION 2
#define XR_MND_SWAPCHAIN_USAGE_INPUT_ATTACHMENT_BIT_EXTENSION_NAME "XR_MND_swapchain_usage_input_attachment_bit"
#define XR_MSFT_scene_understanding_SPEC_VERSION 1
#define XR_MSFT_SCENE_UNDERSTANDING_EXTENSION_NAME "XR_MSFT_scene_understanding"
#define XR_MSFT_scene_understanding_serialization_SPEC_VERSION 1
#define XR_MSFT_SCENE_UNDERSTANDING_SERIALIZATION_EXTENSION_NAME "XR_MSFT_scene_understanding_serialization"
#define XR_FB_display_refresh_rate_SPEC_VERSION 1
#define XR_FB_DISPLAY_REFRESH_RATE_EXTENSION_NAME "XR_FB_display_refresh_rate"
#define XR_HTC_vive_cosmos_controller_interaction_SPEC_VERSION 1
#define XR_HTC_VIVE_COSMOS_CONTROLLER_INTERACTION_EXTENSION_NAME "XR_HTC_vive_cosmos_controller_interaction"
#define XR_HTCX_vive_tracker_interaction_SPEC_VERSION 1
#define XR_HTCX_VIVE_TRACKER_INTERACTION_EXTENSION_NAME "XR_HTCX_vive_tracker_interaction"
#define XR_FB_color_space_SPEC_VERSION 2
#define XR_FB_COLOR_SPACE_EXTENSION_NAME "XR_FB_color_space"
#define XR_FB_hand_tracking_mesh_SPEC_VERSION 1
#define XR_FB_HAND_TRACKING_MESH_EXTENSION_NAME "XR_FB_hand_tracking_mesh"
#define XR_FB_hand_tracking_aim_SPEC_VERSION 1
#define XR_FB_HAND_TRACKING_AIM_EXTENSION_NAME "XR_FB_hand_tracking_aim"
#define XR_FB_hand_tracking_capsules_SPEC_VERSION 1
#define XR_FB_HAND_TRACKING_CAPSULES_EXTENSION_NAME "XR_FB_hand_tracking_capsules"
#define XR_FB_HAND_TRACKING_CAPSULE_POINT_COUNT 2
#define XR_FB_HAND_TRACKING_CAPSULE_COUNT 19
#define XR_FB_foveation_SPEC_VERSION 1
#define XR_FB_FOVEATION_EXTENSION_NAME "XR_FB_foveation"
#define XR_FB_foveation_configuration_SPEC_VERSION 1
#define XR_FB_FOVEATION_CONFIGURATION_EXTENSION_NAME "XR_FB_foveation_configuration"
#define XR_FB_triangle_mesh_SPEC_VERSION 1
#define XR_FB_TRIANGLE_MESH_EXTENSION_NAME "XR_FB_triangle_mesh"
#define XR_FB_passthrough_SPEC_VERSION 1
#define XR_FB_PASSTHROUGH_EXTENSION_NAME "XR_FB_passthrough"
#define XR_PASSTHROUGH_COLOR_MAP_MONO_SIZE_FB 256
#define XR_KHR_binding_modification_SPEC_VERSION 1
#define XR_KHR_BINDING_MODIFICATION_EXTENSION_NAME "XR_KHR_binding_modification"
#define XR_VARJO_foveated_rendering_SPEC_VERSION 2
#define XR_VARJO_FOVEATED_RENDERING_EXTENSION_NAME "XR_VARJO_foveated_rendering"
#define XR_VARJO_composition_layer_depth_test_SPEC_VERSION 2
#define XR_VARJO_COMPOSITION_LAYER_DEPTH_TEST_EXTENSION_NAME "XR_VARJO_composition_layer_depth_test"
#define XR_VARJO_environment_depth_estimation_SPEC_VERSION 1
#define XR_VARJO_ENVIRONMENT_DEPTH_ESTIMATION_EXTENSION_NAME "XR_VARJO_environment_depth_estimation"
#define XR_VARJO_marker_tracking_SPEC_VERSION 1
#define XR_VARJO_MARKER_TRACKING_EXTENSION_NAME "XR_VARJO_marker_tracking"
#define XR_MSFT_spatial_anchor_persistence_SPEC_VERSION 2
#define XR_MSFT_SPATIAL_ANCHOR_PERSISTENCE_EXTENSION_NAME "XR_MSFT_spatial_anchor_persistence"
#define XR_MAX_SPATIAL_ANCHOR_NAME_SIZE_MSFT 256
#define XR_OCULUS_audio_device_guid_SPEC_VERSION 1
#define XR_OCULUS_AUDIO_DEVICE_GUID_EXTENSION_NAME "XR_OCULUS_audio_device_guid"
#define XR_MAX_AUDIO_DEVICE_STR_SIZE_OCULUS 128
#define XR_FB_foveation_vulkan_SPEC_VERSION 1
#define XR_FB_FOVEATION_VULKAN_EXTENSION_NAME "XR_FB_foveation_vulkan"
#define XR_FB_swapchain_update_state_vulkan_SPEC_VERSION 1
#define XR_FB_SWAPCHAIN_UPDATE_STATE_VULKAN_EXTENSION_NAME "XR_FB_swapchain_update_state_vulkan"
#define XR_KHR_swapchain_usage_input_attachment_bit_SPEC_VERSION 3
#define XR_KHR_SWAPCHAIN_USAGE_INPUT_ATTACHMENT_BIT_EXTENSION_NAME "XR_KHR_swapchain_usage_input_attachment_bit"
#define XR_FB_space_warp_SPEC_VERSION 1
#define XR_FB_SPACE_WARP_EXTENSION_NAME "XR_FB_space_warp"


#define XR_MAKE_VERSION(major, minor, patch) \
    ((((major) & 0xffffULL) << 48) | (((minor) & 0xffffULL) << 32) | ((patch) & 0xffffffffULL))

#define XR_VERSION_MAJOR(version) (uint16_t)(((uint64_t)(version) >> 48)& 0xffffULL)

#define XR_VERSION_MINOR(version) (uint16_t)(((uint64_t)(version) >> 32) & 0xffffULL)

#define XR_VERSION_PATCH(version) (uint32_t)((uint64_t)(version) & 0xffffffffULL)


#define XR_CURRENT_API_VERSION XR_MAKE_VERSION(1, 0, 20)


#if !defined(XR_MAY_ALIAS)
#if defined(__clang__) || (defined(__GNUC__) && (__GNUC__ > 4))
#define XR_MAY_ALIAS __attribute__((__may_alias__))
#else
#define XR_MAY_ALIAS
#endif
#endif


#if !defined(XR_DEFINE_HANDLE)
#if (XR_PTR_SIZE == 8)
    #define XR_DEFINE_HANDLE(object) typedef struct object##_T* object;
#else
    #define XR_DEFINE_HANDLE(object) typedef uint64_t object;
#endif
#endif



#if !defined(XR_NULL_HANDLE)
#if (XR_PTR_SIZE == 8) && XR_CPP_NULLPTR_SUPPORTED
    #define XR_NULL_HANDLE nullptr
#else
    #define XR_NULL_HANDLE 0
#endif
#endif



#if !defined(XR_DEFINE_ATOM)
    #define XR_DEFINE_ATOM(object) typedef uint64_t object;
#endif



#define XR_NULL_PATH 0


#define XR_NULL_SYSTEM_ID 0


#define XR_SUCCEEDED(result) ((result) >= 0)


#define XR_UNQUALIFIED_SUCCESS(result) ((result) == 0)


#define XR_FAILED(result) ((result) < 0)


#define XR_NO_DURATION 0


#define XR_INFINITE_DURATION 0x7fffffffffffffffLL


#define XR_MIN_HAPTIC_DURATION -1


#define XR_FREQUENCY_UNSPECIFIED 0


#define XR_MAX_EVENT_DATA_SIZE sizeof(XrEventDataBuffer)


#define XR_HAND_JOINT_COUNT_EXT 26


#define XR_NULL_CONTROLLER_MODEL_KEY_MSFT 0
XR_DEFINE_HANDLE(XrAction)
XR_DEFINE_HANDLE(XrActionSet)
XR_DEFINE_HANDLE(XrFoveationProfileFB)
XR_DEFINE_HANDLE(XrGeometryInstanceFB)
XR_DEFINE_HANDLE(XrHandTrackerEXT)
XR_DEFINE_HANDLE(XrInstance)
XR_DEFINE_HANDLE(XrPassthroughFB)
XR_DEFINE_HANDLE(XrPassthroughLayerFB)
XR_DEFINE_HANDLE(XrSceneMSFT)
XR_DEFINE_HANDLE(XrSceneObserverMSFT)
XR_DEFINE_HANDLE(XrSession)
XR_DEFINE_HANDLE(XrSpace)
XR_DEFINE_HANDLE(XrSpatialAnchorMSFT)
XR_DEFINE_HANDLE(XrSpatialAnchorStoreConnectionMSFT)
XR_DEFINE_HANDLE(XrSwapchain)
XR_DEFINE_HANDLE(XrTriangleMeshFB)

typedef uint32_t XrBool32;
XR_DEFINE_ATOM(XrControllerModelKeyMSFT)
typedef int64_t XrDuration;
typedef uint64_t XrFlags64;
XR_DEFINE_ATOM(XrPath)
XR_DEFINE_ATOM(XrSystemId)
typedef int64_t XrTime;
typedef uint64_t XrVersion;

typedef XrFlags64 XrAndroidSurfaceSwapchainFlagsFB;
typedef XrFlags64 XrCompositionLayerFlags;
typedef XrFlags64 XrCompositionLayerImageLayoutFlagsFB;
typedef XrFlags64 XrCompositionLayerSecureContentFlagsFB;
typedef XrFlags64 XrCompositionLayerSpaceWarpInfoFlagsFB;
typedef XrFlags64 XrDebugUtilsMessageSeverityFlagsEXT;
typedef XrFlags64 XrDebugUtilsMessageTypeFlagsEXT;
typedef XrFlags64 XrHandTrackingAimFlagsFB;
typedef XrFlags64 XrInputSourceLocalizedNameFlags;
typedef XrFlags64 XrInstanceCreateFlags;
typedef XrFlags64 XrOverlayMainSessionFlagsEXTX;
typedef XrFlags64 XrOverlaySessionCreateFlagsEXTX;
typedef XrFlags64 XrPassthroughFlagsFB;
typedef XrFlags64 XrPassthroughStateChangedFlagsFB;
typedef XrFlags64 XrSessionCreateFlags;
typedef XrFlags64 XrSpaceLocationFlags;
typedef XrFlags64 XrSpaceVelocityFlags;
typedef XrFlags64 XrSwapchainCreateFlags;
typedef XrFlags64 XrSwapchainCreateFoveationFlagsFB;
typedef XrFlags64 XrSwapchainStateFoveationFlagsFB;
typedef XrFlags64 XrSwapchainUsageFlags;
typedef XrFlags64 XrTriangleMeshFlagsFB;
typedef XrFlags64 XrViewStateFlags;
typedef XrFlags64 XrVulkanDeviceCreateFlagsKHR;
typedef XrFlags64 XrVulkanInstanceCreateFlagsKHR;

typedef enum XrActionType
{
    XR_ACTION_TYPE_BOOLEAN_INPUT = 1,
    XR_ACTION_TYPE_FLOAT_INPUT = 2,
    XR_ACTION_TYPE_VECTOR2F_INPUT = 3,
    XR_ACTION_TYPE_POSE_INPUT = 4,
    XR_ACTION_TYPE_VIBRATION_OUTPUT = 100,
    XR_ACTION_TYPE_MAX_ENUM = 0x7fffffff,
} XrActionType;

typedef enum XrBlendFactorFB
{
    XR_BLEND_FACTOR_ZERO_FB = 0,
    XR_BLEND_FACTOR_ONE_FB = 1,
    XR_BLEND_FACTOR_SRC_ALPHA_FB = 2,
    XR_BLEND_FACTOR_ONE_MINUS_SRC_ALPHA_FB = 3,
    XR_BLEND_FACTOR_DST_ALPHA_FB = 4,
    XR_BLEND_FACTOR_ONE_MINUS_DST_ALPHA_FB = 5,
    XR_BLEND_FACTOR_FB_MAX_ENUM = 0x7fffffff,
} XrBlendFactorFB;

typedef enum XrColorSpaceFB
{
    XR_COLOR_SPACE_UNMANAGED_FB = 0,
    XR_COLOR_SPACE_REC2020_FB = 1,
    XR_COLOR_SPACE_REC709_FB = 2,
    XR_COLOR_SPACE_RIFT_CV1_FB = 3,
    XR_COLOR_SPACE_RIFT_S_FB = 4,
    XR_COLOR_SPACE_QUEST_FB = 5,
    XR_COLOR_SPACE_P3_FB = 6,
    XR_COLOR_SPACE_ADOBE_RGB_FB = 7,
    XR_COLOR_SPACE_FB_MAX_ENUM = 0x7fffffff,
} XrColorSpaceFB;

typedef enum XrEnvironmentBlendMode
{
    XR_ENVIRONMENT_BLEND_MODE_OPAQUE = 1,
    XR_ENVIRONMENT_BLEND_MODE_ADDITIVE = 2,
    XR_ENVIRONMENT_BLEND_MODE_ALPHA_BLEND = 3,
    XR_ENVIRONMENT_BLEND_MODE_MAX_ENUM = 0x7fffffff,
} XrEnvironmentBlendMode;

typedef enum XrEyeVisibility
{
    XR_EYE_VISIBILITY_BOTH = 0,
    XR_EYE_VISIBILITY_LEFT = 1,
    XR_EYE_VISIBILITY_RIGHT = 2,
    XR_EYE_VISIBILITY_MAX_ENUM = 0x7fffffff,
} XrEyeVisibility;

typedef enum XrFormFactor
{
    XR_FORM_FACTOR_HEAD_MOUNTED_DISPLAY = 1,
    XR_FORM_FACTOR_HANDHELD_DISPLAY = 2,
    XR_FORM_FACTOR_MAX_ENUM = 0x7fffffff,
} XrFormFactor;

typedef enum XrFoveationDynamicFB
{
    XR_FOVEATION_DYNAMIC_DISABLED_FB = 0,
    XR_FOVEATION_DYNAMIC_LEVEL_ENABLED_FB = 1,
    XR_FOVEATION_DYNAMIC_FB_MAX_ENUM = 0x7fffffff,
} XrFoveationDynamicFB;

typedef enum XrFoveationLevelFB
{
    XR_FOVEATION_LEVEL_NONE_FB = 0,
    XR_FOVEATION_LEVEL_LOW_FB = 1,
    XR_FOVEATION_LEVEL_MEDIUM_FB = 2,
    XR_FOVEATION_LEVEL_HIGH_FB = 3,
    XR_FOVEATION_LEVEL_FB_MAX_ENUM = 0x7fffffff,
} XrFoveationLevelFB;

typedef enum XrHandEXT
{
    XR_HAND_LEFT_EXT = 1,
    XR_HAND_RIGHT_EXT = 2,
    XR_HAND_EXT_MAX_ENUM = 0x7fffffff,
} XrHandEXT;

typedef enum XrHandJointEXT
{
    XR_HAND_JOINT_PALM_EXT = 0,
    XR_HAND_JOINT_WRIST_EXT = 1,
    XR_HAND_JOINT_THUMB_METACARPAL_EXT = 2,
    XR_HAND_JOINT_THUMB_PROXIMAL_EXT = 3,
    XR_HAND_JOINT_THUMB_DISTAL_EXT = 4,
    XR_HAND_JOINT_THUMB_TIP_EXT = 5,
    XR_HAND_JOINT_INDEX_METACARPAL_EXT = 6,
    XR_HAND_JOINT_INDEX_PROXIMAL_EXT = 7,
    XR_HAND_JOINT_INDEX_INTERMEDIATE_EXT = 8,
    XR_HAND_JOINT_INDEX_DISTAL_EXT = 9,
    XR_HAND_JOINT_INDEX_TIP_EXT = 10,
    XR_HAND_JOINT_MIDDLE_METACARPAL_EXT = 11,
    XR_HAND_JOINT_MIDDLE_PROXIMAL_EXT = 12,
    XR_HAND_JOINT_MIDDLE_INTERMEDIATE_EXT = 13,
    XR_HAND_JOINT_MIDDLE_DISTAL_EXT = 14,
    XR_HAND_JOINT_MIDDLE_TIP_EXT = 15,
    XR_HAND_JOINT_RING_METACARPAL_EXT = 16,
    XR_HAND_JOINT_RING_PROXIMAL_EXT = 17,
    XR_HAND_JOINT_RING_INTERMEDIATE_EXT = 18,
    XR_HAND_JOINT_RING_DISTAL_EXT = 19,
    XR_HAND_JOINT_RING_TIP_EXT = 20,
    XR_HAND_JOINT_LITTLE_METACARPAL_EXT = 21,
    XR_HAND_JOINT_LITTLE_PROXIMAL_EXT = 22,
    XR_HAND_JOINT_LITTLE_INTERMEDIATE_EXT = 23,
    XR_HAND_JOINT_LITTLE_DISTAL_EXT = 24,
    XR_HAND_JOINT_LITTLE_TIP_EXT = 25,
    XR_HAND_JOINT_EXT_MAX_ENUM = 0x7fffffff,
} XrHandJointEXT;

typedef enum XrHandJointSetEXT
{
    XR_HAND_JOINT_SET_DEFAULT_EXT = 0,
    XR_HAND_JOINT_SET_EXT_MAX_ENUM = 0x7fffffff,
} XrHandJointSetEXT;

typedef enum XrHandJointsMotionRangeEXT
{
    XR_HAND_JOINTS_MOTION_RANGE_UNOBSTRUCTED_EXT = 1,
    XR_HAND_JOINTS_MOTION_RANGE_CONFORMING_TO_CONTROLLER_EXT = 2,
    XR_HAND_JOINTS_MOTION_RANGE_EXT_MAX_ENUM = 0x7fffffff,
} XrHandJointsMotionRangeEXT;

typedef enum XrHandPoseTypeMSFT
{
    XR_HAND_POSE_TYPE_TRACKED_MSFT = 0,
    XR_HAND_POSE_TYPE_REFERENCE_OPEN_PALM_MSFT = 1,
    XR_HAND_POSE_TYPE_MSFT_MAX_ENUM = 0x7fffffff,
} XrHandPoseTypeMSFT;

typedef enum XrMeshComputeLodMSFT
{
    XR_MESH_COMPUTE_LOD_COARSE_MSFT = 1,
    XR_MESH_COMPUTE_LOD_MEDIUM_MSFT = 2,
    XR_MESH_COMPUTE_LOD_FINE_MSFT = 3,
    XR_MESH_COMPUTE_LOD_UNLIMITED_MSFT = 4,
    XR_MESH_COMPUTE_LOD_MSFT_MAX_ENUM = 0x7fffffff,
} XrMeshComputeLodMSFT;

typedef enum XrObjectType
{
    XR_OBJECT_TYPE_UNKNOWN = 0,
    XR_OBJECT_TYPE_INSTANCE = 1,
    XR_OBJECT_TYPE_SESSION = 2,
    XR_OBJECT_TYPE_SWAPCHAIN = 3,
    XR_OBJECT_TYPE_SPACE = 4,
    XR_OBJECT_TYPE_ACTION_SET = 5,
    XR_OBJECT_TYPE_ACTION = 6,
    XR_OBJECT_TYPE_SPATIAL_ANCHOR_MSFT = 1000039000,
    XR_OBJECT_TYPE_HAND_TRACKER_EXT = 1000051000,
    XR_OBJECT_TYPE_SCENE_OBSERVER_MSFT = 1000097000,
    XR_OBJECT_TYPE_SCENE_MSFT = 1000097001,
    XR_OBJECT_TYPE_FOVEATION_PROFILE_FB = 1000114000,
    XR_OBJECT_TYPE_TRIANGLE_MESH_FB = 1000117000,
    XR_OBJECT_TYPE_PASSTHROUGH_FB = 1000118000,
    XR_OBJECT_TYPE_PASSTHROUGH_LAYER_FB = 1000118002,
    XR_OBJECT_TYPE_GEOMETRY_INSTANCE_FB = 1000118004,
    XR_OBJECT_TYPE_SPATIAL_ANCHOR_STORE_CONNECTION_MSFT = 1000142000,
    XR_OBJECT_TYPE_MAX_ENUM = 0x7fffffff,
} XrObjectType;

typedef enum XrPassthroughLayerPurposeFB
{
    XR_PASSTHROUGH_LAYER_PURPOSE_RECONSTRUCTION_FB = 0,
    XR_PASSTHROUGH_LAYER_PURPOSE_PROJECTED_FB = 1,
    XR_PASSTHROUGH_LAYER_PURPOSE_FB_MAX_ENUM = 0x7fffffff,
} XrPassthroughLayerPurposeFB;

typedef enum XrPerfSettingsDomainEXT
{
    XR_PERF_SETTINGS_DOMAIN_CPU_EXT = 1,
    XR_PERF_SETTINGS_DOMAIN_GPU_EXT = 2,
    XR_PERF_SETTINGS_DOMAIN_EXT_MAX_ENUM = 0x7fffffff,
} XrPerfSettingsDomainEXT;

typedef enum XrPerfSettingsLevelEXT
{
    XR_PERF_SETTINGS_LEVEL_POWER_SAVINGS_EXT = 0,
    XR_PERF_SETTINGS_LEVEL_SUSTAINED_LOW_EXT = 25,
    XR_PERF_SETTINGS_LEVEL_SUSTAINED_HIGH_EXT = 50,
    XR_PERF_SETTINGS_LEVEL_BOOST_EXT = 75,
    XR_PERF_SETTINGS_LEVEL_EXT_MAX_ENUM = 0x7fffffff,
} XrPerfSettingsLevelEXT;

typedef enum XrPerfSettingsNotificationLevelEXT
{
    XR_PERF_SETTINGS_NOTIF_LEVEL_NORMAL_EXT = 0,
    XR_PERF_SETTINGS_NOTIF_LEVEL_WARNING_EXT = 25,
    XR_PERF_SETTINGS_NOTIF_LEVEL_IMPAIRED_EXT = 75,
    XR_PERF_SETTINGS_NOTIFICATION_LEVEL_EXT_MAX_ENUM = 0x7fffffff,
} XrPerfSettingsNotificationLevelEXT;

typedef enum XrPerfSettingsSubDomainEXT
{
    XR_PERF_SETTINGS_SUB_DOMAIN_COMPOSITING_EXT = 1,
    XR_PERF_SETTINGS_SUB_DOMAIN_RENDERING_EXT = 2,
    XR_PERF_SETTINGS_SUB_DOMAIN_THERMAL_EXT = 3,
    XR_PERF_SETTINGS_SUB_DOMAIN_EXT_MAX_ENUM = 0x7fffffff,
} XrPerfSettingsSubDomainEXT;

typedef enum XrReferenceSpaceType
{
    XR_REFERENCE_SPACE_TYPE_VIEW = 1,
    XR_REFERENCE_SPACE_TYPE_LOCAL = 2,
    XR_REFERENCE_SPACE_TYPE_STAGE = 3,
    XR_REFERENCE_SPACE_TYPE_UNBOUNDED_MSFT = 1000038000,
    XR_REFERENCE_SPACE_TYPE_COMBINED_EYE_VARJO = 1000121000,
    XR_REFERENCE_SPACE_TYPE_MAX_ENUM = 0x7fffffff,
} XrReferenceSpaceType;

typedef enum XrReprojectionModeMSFT
{
    XR_REPROJECTION_MODE_DEPTH_MSFT = 1,
    XR_REPROJECTION_MODE_PLANAR_FROM_DEPTH_MSFT = 2,
    XR_REPROJECTION_MODE_PLANAR_MANUAL_MSFT = 3,
    XR_REPROJECTION_MODE_ORIENTATION_ONLY_MSFT = 4,
    XR_REPROJECTION_MODE_MSFT_MAX_ENUM = 0x7fffffff,
} XrReprojectionModeMSFT;

typedef enum XrResult
{
    XR_ERROR_SPATIAL_ANCHOR_NAME_INVALID_MSFT = -1000142002,
    XR_ERROR_SPATIAL_ANCHOR_NAME_NOT_FOUND_MSFT = -1000142001,
    XR_ERROR_MARKER_ID_INVALID_VARJO = -1000124001,
    XR_ERROR_MARKER_NOT_TRACKED_VARJO = -1000124000,
    XR_ERROR_UNKNOWN_PASSTHROUGH_FB = -1000118050,
    XR_ERROR_INSUFFICIENT_RESOURCES_PASSTHROUGH_FB = -1000118004,
    XR_ERROR_NOT_PERMITTED_PASSTHROUGH_FB = -1000118003,
    XR_ERROR_FEATURE_REQUIRED_PASSTHROUGH_FB = -1000118002,
    XR_ERROR_FEATURE_ALREADY_CREATED_PASSTHROUGH_FB = -1000118001,
    XR_ERROR_UNEXPECTED_STATE_PASSTHROUGH_FB = -1000118000,
    XR_ERROR_COLOR_SPACE_UNSUPPORTED_FB = -1000108000,
    XR_ERROR_DISPLAY_REFRESH_RATE_UNSUPPORTED_FB = -1000101000,
    XR_ERROR_SCENE_COMPUTE_CONSISTENCY_MISMATCH_MSFT = -1000097005,
    XR_ERROR_SCENE_COMPUTE_FEATURE_INCOMPATIBLE_MSFT = -1000097004,
    XR_ERROR_SCENE_MESH_BUFFER_ID_INVALID_MSFT = -1000097003,
    XR_ERROR_SCENE_COMPONENT_TYPE_MISMATCH_MSFT = -1000097002,
    XR_ERROR_SCENE_COMPONENT_ID_INVALID_MSFT = -1000097001,
    XR_ERROR_COMPUTE_NEW_SCENE_NOT_COMPLETED_MSFT = -1000097000,
    XR_ERROR_REPROJECTION_MODE_UNSUPPORTED_MSFT = -1000066000,
    XR_ERROR_CONTROLLER_MODEL_KEY_INVALID_MSFT = -1000055000,
    XR_ERROR_SECONDARY_VIEW_CONFIGURATION_TYPE_NOT_ENABLED_MSFT = -1000053000,
    XR_ERROR_CREATE_SPATIAL_ANCHOR_FAILED_MSFT = -1000039001,
    XR_ERROR_RUNTIME_UNAVAILABLE = -51,
    XR_ERROR_GRAPHICS_REQUIREMENTS_CALL_MISSING = -50,
    XR_ERROR_LOCALIZED_NAME_INVALID = -49,
    XR_ERROR_LOCALIZED_NAME_DUPLICATED = -48,
    XR_ERROR_ACTIONSETS_ALREADY_ATTACHED = -47,
    XR_ERROR_ACTIONSET_NOT_ATTACHED = -46,
    XR_ERROR_NAME_INVALID = -45,
    XR_ERROR_NAME_DUPLICATED = -44,
    XR_ERROR_ENVIRONMENT_BLEND_MODE_UNSUPPORTED = -42,
    XR_ERROR_VIEW_CONFIGURATION_TYPE_UNSUPPORTED = -41,
    XR_ERROR_INDEX_OUT_OF_RANGE = -40,
    XR_ERROR_POSE_INVALID = -39,
    XR_ERROR_GRAPHICS_DEVICE_INVALID = -38,
    XR_ERROR_CALL_ORDER_INVALID = -37,
    XR_ERROR_API_LAYER_NOT_PRESENT = -36,
    XR_ERROR_FORM_FACTOR_UNAVAILABLE = -35,
    XR_ERROR_FORM_FACTOR_UNSUPPORTED = -34,
    XR_ERROR_FILE_CONTENTS_INVALID = -33,
    XR_ERROR_FILE_ACCESS_ERROR = -32,
    XR_ERROR_REFERENCE_SPACE_UNSUPPORTED = -31,
    XR_ERROR_TIME_INVALID = -30,
    XR_ERROR_SESSION_NOT_STOPPING = -29,
    XR_ERROR_SESSION_NOT_READY = -28,
    XR_ERROR_ACTION_TYPE_MISMATCH = -27,
    XR_ERROR_SWAPCHAIN_FORMAT_UNSUPPORTED = -26,
    XR_ERROR_SWAPCHAIN_RECT_INVALID = -25,
    XR_ERROR_LAYER_LIMIT_EXCEEDED = -24,
    XR_ERROR_LAYER_INVALID = -23,
    XR_ERROR_PATH_UNSUPPORTED = -22,
    XR_ERROR_PATH_FORMAT_INVALID = -21,
    XR_ERROR_PATH_COUNT_EXCEEDED = -20,
    XR_ERROR_PATH_INVALID = -19,
    XR_ERROR_SYSTEM_INVALID = -18,
    XR_ERROR_SESSION_LOST = -17,
    XR_ERROR_SESSION_NOT_RUNNING = -16,
    XR_ERROR_SESSION_RUNNING = -14,
    XR_ERROR_INSTANCE_LOST = -13,
    XR_ERROR_HANDLE_INVALID = -12,
    XR_ERROR_SIZE_INSUFFICIENT = -11,
    XR_ERROR_LIMIT_REACHED = -10,
    XR_ERROR_EXTENSION_NOT_PRESENT = -9,
    XR_ERROR_FEATURE_UNSUPPORTED = -8,
    XR_ERROR_FUNCTION_UNSUPPORTED = -7,
    XR_ERROR_INITIALIZATION_FAILED = -6,
    XR_ERROR_API_VERSION_UNSUPPORTED = -4,
    XR_ERROR_OUT_OF_MEMORY = -3,
    XR_ERROR_RUNTIME_FAILURE = -2,
    XR_ERROR_VALIDATION_FAILURE = -1,
    XR_SUCCESS = 0,
    XR_TIMEOUT_EXPIRED = 1,
    XR_SESSION_LOSS_PENDING = 3,
    XR_EVENT_UNAVAILABLE = 4,
    XR_SPACE_BOUNDS_UNAVAILABLE = 7,
    XR_SESSION_NOT_FOCUSED = 8,
    XR_FRAME_DISCARDED = 9,
    XR_RESULT_MAX_ENUM = 0x7fffffff,
} XrResult;

typedef enum XrSceneComponentTypeMSFT
{
    XR_SCENE_COMPONENT_TYPE_INVALID_MSFT = -1,
    XR_SCENE_COMPONENT_TYPE_OBJECT_MSFT = 1,
    XR_SCENE_COMPONENT_TYPE_PLANE_MSFT = 2,
    XR_SCENE_COMPONENT_TYPE_VISUAL_MESH_MSFT = 3,
    XR_SCENE_COMPONENT_TYPE_COLLIDER_MESH_MSFT = 4,
    XR_SCENE_COMPONENT_TYPE_SERIALIZED_SCENE_FRAGMENT_MSFT = 1000098000,
    XR_SCENE_COMPONENT_TYPE_MSFT_MAX_ENUM = 0x7fffffff,
} XrSceneComponentTypeMSFT;

typedef enum XrSceneComputeConsistencyMSFT
{
    XR_SCENE_COMPUTE_CONSISTENCY_SNAPSHOT_COMPLETE_MSFT = 1,
    XR_SCENE_COMPUTE_CONSISTENCY_SNAPSHOT_INCOMPLETE_FAST_MSFT = 2,
    XR_SCENE_COMPUTE_CONSISTENCY_OCCLUSION_OPTIMIZED_MSFT = 3,
    XR_SCENE_COMPUTE_CONSISTENCY_MSFT_MAX_ENUM = 0x7fffffff,
} XrSceneComputeConsistencyMSFT;

typedef enum XrSceneComputeFeatureMSFT
{
    XR_SCENE_COMPUTE_FEATURE_PLANE_MSFT = 1,
    XR_SCENE_COMPUTE_FEATURE_PLANE_MESH_MSFT = 2,
    XR_SCENE_COMPUTE_FEATURE_VISUAL_MESH_MSFT = 3,
    XR_SCENE_COMPUTE_FEATURE_COLLIDER_MESH_MSFT = 4,
    XR_SCENE_COMPUTE_FEATURE_SERIALIZE_SCENE_MSFT = 1000098000,
    XR_SCENE_COMPUTE_FEATURE_MSFT_MAX_ENUM = 0x7fffffff,
} XrSceneComputeFeatureMSFT;

typedef enum XrSceneComputeStateMSFT
{
    XR_SCENE_COMPUTE_STATE_NONE_MSFT = 0,
    XR_SCENE_COMPUTE_STATE_UPDATING_MSFT = 1,
    XR_SCENE_COMPUTE_STATE_COMPLETED_MSFT = 2,
    XR_SCENE_COMPUTE_STATE_COMPLETED_WITH_ERROR_MSFT = 3,
    XR_SCENE_COMPUTE_STATE_MSFT_MAX_ENUM = 0x7fffffff,
} XrSceneComputeStateMSFT;

typedef enum XrSceneObjectTypeMSFT
{
    XR_SCENE_OBJECT_TYPE_UNCATEGORIZED_MSFT = -1,
    XR_SCENE_OBJECT_TYPE_BACKGROUND_MSFT = 1,
    XR_SCENE_OBJECT_TYPE_WALL_MSFT = 2,
    XR_SCENE_OBJECT_TYPE_FLOOR_MSFT = 3,
    XR_SCENE_OBJECT_TYPE_CEILING_MSFT = 4,
    XR_SCENE_OBJECT_TYPE_PLATFORM_MSFT = 5,
    XR_SCENE_OBJECT_TYPE_INFERRED_MSFT = 6,
    XR_SCENE_OBJECT_TYPE_MSFT_MAX_ENUM = 0x7fffffff,
} XrSceneObjectTypeMSFT;

typedef enum XrScenePlaneAlignmentTypeMSFT
{
    XR_SCENE_PLANE_ALIGNMENT_TYPE_NON_ORTHOGONAL_MSFT = 0,
    XR_SCENE_PLANE_ALIGNMENT_TYPE_HORIZONTAL_MSFT = 1,
    XR_SCENE_PLANE_ALIGNMENT_TYPE_VERTICAL_MSFT = 2,
    XR_SCENE_PLANE_ALIGNMENT_TYPE_MSFT_MAX_ENUM = 0x7fffffff,
} XrScenePlaneAlignmentTypeMSFT;

typedef enum XrSessionState
{
    XR_SESSION_STATE_UNKNOWN = 0,
    XR_SESSION_STATE_IDLE = 1,
    XR_SESSION_STATE_READY = 2,
    XR_SESSION_STATE_SYNCHRONIZED = 3,
    XR_SESSION_STATE_VISIBLE = 4,
    XR_SESSION_STATE_FOCUSED = 5,
    XR_SESSION_STATE_STOPPING = 6,
    XR_SESSION_STATE_LOSS_PENDING = 7,
    XR_SESSION_STATE_EXITING = 8,
    XR_SESSION_STATE_MAX_ENUM = 0x7fffffff,
} XrSessionState;

typedef enum XrSpatialGraphNodeTypeMSFT
{
    XR_SPATIAL_GRAPH_NODE_TYPE_STATIC_MSFT = 1,
    XR_SPATIAL_GRAPH_NODE_TYPE_DYNAMIC_MSFT = 2,
    XR_SPATIAL_GRAPH_NODE_TYPE_MSFT_MAX_ENUM = 0x7fffffff,
} XrSpatialGraphNodeTypeMSFT;

typedef enum XrStructureType
{
    XR_TYPE_UNKNOWN = 0,
    XR_TYPE_API_LAYER_PROPERTIES = 1,
    XR_TYPE_EXTENSION_PROPERTIES = 2,
    XR_TYPE_INSTANCE_CREATE_INFO = 3,
    XR_TYPE_SYSTEM_GET_INFO = 4,
    XR_TYPE_SYSTEM_PROPERTIES = 5,
    XR_TYPE_VIEW_LOCATE_INFO = 6,
    XR_TYPE_VIEW = 7,
    XR_TYPE_SESSION_CREATE_INFO = 8,
    XR_TYPE_SWAPCHAIN_CREATE_INFO = 9,
    XR_TYPE_SESSION_BEGIN_INFO = 10,
    XR_TYPE_VIEW_STATE = 11,
    XR_TYPE_FRAME_END_INFO = 12,
    XR_TYPE_HAPTIC_VIBRATION = 13,
    XR_TYPE_EVENT_DATA_BUFFER = 16,
    XR_TYPE_EVENT_DATA_INSTANCE_LOSS_PENDING = 17,
    XR_TYPE_EVENT_DATA_SESSION_STATE_CHANGED = 18,
    XR_TYPE_ACTION_STATE_BOOLEAN = 23,
    XR_TYPE_ACTION_STATE_FLOAT = 24,
    XR_TYPE_ACTION_STATE_VECTOR2F = 25,
    XR_TYPE_ACTION_STATE_POSE = 27,
    XR_TYPE_ACTION_SET_CREATE_INFO = 28,
    XR_TYPE_ACTION_CREATE_INFO = 29,
    XR_TYPE_INSTANCE_PROPERTIES = 32,
    XR_TYPE_FRAME_WAIT_INFO = 33,
    XR_TYPE_COMPOSITION_LAYER_PROJECTION = 35,
    XR_TYPE_COMPOSITION_LAYER_QUAD = 36,
    XR_TYPE_REFERENCE_SPACE_CREATE_INFO = 37,
    XR_TYPE_ACTION_SPACE_CREATE_INFO = 38,
    XR_TYPE_EVENT_DATA_REFERENCE_SPACE_CHANGE_PENDING = 40,
    XR_TYPE_VIEW_CONFIGURATION_VIEW = 41,
    XR_TYPE_SPACE_LOCATION = 42,
    XR_TYPE_SPACE_VELOCITY = 43,
    XR_TYPE_FRAME_STATE = 44,
    XR_TYPE_VIEW_CONFIGURATION_PROPERTIES = 45,
    XR_TYPE_FRAME_BEGIN_INFO = 46,
    XR_TYPE_COMPOSITION_LAYER_PROJECTION_VIEW = 48,
    XR_TYPE_EVENT_DATA_EVENTS_LOST = 49,
    XR_TYPE_INTERACTION_PROFILE_SUGGESTED_BINDING = 51,
    XR_TYPE_EVENT_DATA_INTERACTION_PROFILE_CHANGED = 52,
    XR_TYPE_INTERACTION_PROFILE_STATE = 53,
    XR_TYPE_SWAPCHAIN_IMAGE_ACQUIRE_INFO = 55,
    XR_TYPE_SWAPCHAIN_IMAGE_WAIT_INFO = 56,
    XR_TYPE_SWAPCHAIN_IMAGE_RELEASE_INFO = 57,
    XR_TYPE_ACTION_STATE_GET_INFO = 58,
    XR_TYPE_HAPTIC_ACTION_INFO = 59,
    XR_TYPE_SESSION_ACTION_SETS_ATTACH_INFO = 60,
    XR_TYPE_ACTIONS_SYNC_INFO = 61,
    XR_TYPE_BOUND_SOURCES_FOR_ACTION_ENUMERATE_INFO = 62,
    XR_TYPE_INPUT_SOURCE_LOCALIZED_NAME_GET_INFO = 63,
    XR_TYPE_COMPOSITION_LAYER_CUBE_KHR = 1000006000,
    XR_TYPE_COMPOSITION_LAYER_DEPTH_INFO_KHR = 1000010000,
    XR_TYPE_VULKAN_SWAPCHAIN_FORMAT_LIST_CREATE_INFO_KHR = 1000014000,
    XR_TYPE_EVENT_DATA_PERF_SETTINGS_EXT = 1000015000,
    XR_TYPE_COMPOSITION_LAYER_CYLINDER_KHR = 1000017000,
    XR_TYPE_COMPOSITION_LAYER_EQUIRECT_KHR = 1000018000,
    XR_TYPE_GRAPHICS_BINDING_OPENGL_WIN32_KHR = 1000023000,
    XR_TYPE_GRAPHICS_BINDING_OPENGL_XLIB_KHR = 1000023001,
    XR_TYPE_GRAPHICS_BINDING_OPENGL_XCB_KHR = 1000023002,
    XR_TYPE_GRAPHICS_BINDING_OPENGL_WAYLAND_KHR = 1000023003,
    XR_TYPE_SWAPCHAIN_IMAGE_OPENGL_KHR = 1000023004,
    XR_TYPE_GRAPHICS_REQUIREMENTS_OPENGL_KHR = 1000023005,
    XR_TYPE_GRAPHICS_BINDING_VULKAN_KHR = 1000025000,
    XR_TYPE_SWAPCHAIN_IMAGE_VULKAN_KHR = 1000025001,
    XR_TYPE_GRAPHICS_REQUIREMENTS_VULKAN_KHR = 1000025002,
    XR_TYPE_GRAPHICS_BINDING_D3D11_KHR = 1000027000,
    XR_TYPE_SWAPCHAIN_IMAGE_D3D11_KHR = 1000027001,
    XR_TYPE_GRAPHICS_REQUIREMENTS_D3D11_KHR = 1000027002,
    XR_TYPE_GRAPHICS_BINDING_D3D12_KHR = 1000028000,
    XR_TYPE_SWAPCHAIN_IMAGE_D3D12_KHR = 1000028001,
    XR_TYPE_GRAPHICS_REQUIREMENTS_D3D12_KHR = 1000028002,
    XR_TYPE_SYSTEM_EYE_GAZE_INTERACTION_PROPERTIES_EXT = 1000030000,
    XR_TYPE_EYE_GAZE_SAMPLE_TIME_EXT = 1000030001,
    XR_TYPE_VISIBILITY_MASK_KHR = 1000031000,
    XR_TYPE_EVENT_DATA_VISIBILITY_MASK_CHANGED_KHR = 1000031001,
    XR_TYPE_SESSION_CREATE_INFO_OVERLAY_EXTX = 1000033000,
    XR_TYPE_EVENT_DATA_MAIN_SESSION_VISIBILITY_CHANGED_EXTX = 1000033003,
    XR_TYPE_COMPOSITION_LAYER_COLOR_SCALE_BIAS_KHR = 1000034000,
    XR_TYPE_SPATIAL_ANCHOR_CREATE_INFO_MSFT = 1000039000,
    XR_TYPE_SPATIAL_ANCHOR_SPACE_CREATE_INFO_MSFT = 1000039001,
    XR_TYPE_COMPOSITION_LAYER_IMAGE_LAYOUT_FB = 1000040000,
    XR_TYPE_COMPOSITION_LAYER_ALPHA_BLEND_FB = 1000041001,
    XR_TYPE_VIEW_CONFIGURATION_DEPTH_RANGE_EXT = 1000046000,
    XR_TYPE_SPATIAL_GRAPH_NODE_SPACE_CREATE_INFO_MSFT = 1000049000,
    XR_TYPE_SYSTEM_HAND_TRACKING_PROPERTIES_EXT = 1000051000,
    XR_TYPE_HAND_TRACKER_CREATE_INFO_EXT = 1000051001,
    XR_TYPE_HAND_JOINTS_LOCATE_INFO_EXT = 1000051002,
    XR_TYPE_HAND_JOINT_LOCATIONS_EXT = 1000051003,
    XR_TYPE_HAND_JOINT_VELOCITIES_EXT = 1000051004,
    XR_TYPE_SYSTEM_HAND_TRACKING_MESH_PROPERTIES_MSFT = 1000052000,
    XR_TYPE_HAND_MESH_SPACE_CREATE_INFO_MSFT = 1000052001,
    XR_TYPE_HAND_MESH_UPDATE_INFO_MSFT = 1000052002,
    XR_TYPE_HAND_MESH_MSFT = 1000052003,
    XR_TYPE_HAND_POSE_TYPE_INFO_MSFT = 1000052004,
    XR_TYPE_SECONDARY_VIEW_CONFIGURATION_SESSION_BEGIN_INFO_MSFT = 1000053000,
    XR_TYPE_SECONDARY_VIEW_CONFIGURATION_STATE_MSFT = 1000053001,
    XR_TYPE_SECONDARY_VIEW_CONFIGURATION_FRAME_STATE_MSFT = 1000053002,
    XR_TYPE_SECONDARY_VIEW_CONFIGURATION_FRAME_END_INFO_MSFT = 1000053003,
    XR_TYPE_SECONDARY_VIEW_CONFIGURATION_LAYER_INFO_MSFT = 1000053004,
    XR_TYPE_SECONDARY_VIEW_CONFIGURATION_SWAPCHAIN_CREATE_INFO_MSFT = 1000053005,
    XR_TYPE_CONTROLLER_MODEL_KEY_STATE_MSFT = 1000055000,
    XR_TYPE_CONTROLLER_MODEL_NODE_PROPERTIES_MSFT = 1000055001,
    XR_TYPE_CONTROLLER_MODEL_PROPERTIES_MSFT = 1000055002,
    XR_TYPE_CONTROLLER_MODEL_NODE_STATE_MSFT = 1000055003,
    XR_TYPE_CONTROLLER_MODEL_STATE_MSFT = 1000055004,
    XR_TYPE_VIEW_CONFIGURATION_VIEW_FOV_EPIC = 1000059000,
    XR_TYPE_HOLOGRAPHIC_WINDOW_ATTACHMENT_MSFT = 1000063000,
    XR_TYPE_COMPOSITION_LAYER_REPROJECTION_INFO_MSFT = 1000066000,
    XR_TYPE_COMPOSITION_LAYER_REPROJECTION_PLANE_OVERRIDE_MSFT = 1000066001,
    XR_TYPE_COMPOSITION_LAYER_SECURE_CONTENT_FB = 1000072000,
    XR_TYPE_INTERACTION_PROFILE_ANALOG_THRESHOLD_VALVE = 1000079000,
    XR_TYPE_HAND_JOINTS_MOTION_RANGE_INFO_EXT = 1000080000,
    XR_TYPE_VULKAN_INSTANCE_CREATE_INFO_KHR = 1000090000,
    XR_TYPE_VULKAN_DEVICE_CREATE_INFO_KHR = 1000090001,
    XR_TYPE_VULKAN_GRAPHICS_DEVICE_GET_INFO_KHR = 1000090003,
    XR_TYPE_COMPOSITION_LAYER_EQUIRECT2_KHR = 1000091000,
    XR_TYPE_SCENE_OBSERVER_CREATE_INFO_MSFT = 1000097000,
    XR_TYPE_SCENE_CREATE_INFO_MSFT = 1000097001,
    XR_TYPE_NEW_SCENE_COMPUTE_INFO_MSFT = 1000097002,
    XR_TYPE_VISUAL_MESH_COMPUTE_LOD_INFO_MSFT = 1000097003,
    XR_TYPE_SCENE_COMPONENTS_MSFT = 1000097004,
    XR_TYPE_SCENE_COMPONENTS_GET_INFO_MSFT = 1000097005,
    XR_TYPE_SCENE_COMPONENT_LOCATIONS_MSFT = 1000097006,
    XR_TYPE_SCENE_COMPONENTS_LOCATE_INFO_MSFT = 1000097007,
    XR_TYPE_SCENE_OBJECTS_MSFT = 1000097008,
    XR_TYPE_SCENE_COMPONENT_PARENT_FILTER_INFO_MSFT = 1000097009,
    XR_TYPE_SCENE_OBJECT_TYPES_FILTER_INFO_MSFT = 1000097010,
    XR_TYPE_SCENE_PLANES_MSFT = 1000097011,
    XR_TYPE_SCENE_PLANE_ALIGNMENT_FILTER_INFO_MSFT = 1000097012,
    XR_TYPE_SCENE_MESHES_MSFT = 1000097013,
    XR_TYPE_SCENE_MESH_BUFFERS_GET_INFO_MSFT = 1000097014,
    XR_TYPE_SCENE_MESH_BUFFERS_MSFT = 1000097015,
    XR_TYPE_SCENE_MESH_VERTEX_BUFFER_MSFT = 1000097016,
    XR_TYPE_SCENE_MESH_INDICES_UINT32_MSFT = 1000097017,
    XR_TYPE_SCENE_MESH_INDICES_UINT16_MSFT = 1000097018,
    XR_TYPE_SERIALIZED_SCENE_FRAGMENT_DATA_GET_INFO_MSFT = 1000098000,
    XR_TYPE_SCENE_DESERIALIZE_INFO_MSFT = 1000098001,
    XR_TYPE_EVENT_DATA_DISPLAY_REFRESH_RATE_CHANGED_FB = 1000101000,
    XR_TYPE_VIVE_TRACKER_PATHS_HTCX = 1000103000,
    XR_TYPE_EVENT_DATA_VIVE_TRACKER_CONNECTED_HTCX = 1000103001,
    XR_TYPE_SYSTEM_COLOR_SPACE_PROPERTIES_FB = 1000108000,
    XR_TYPE_HAND_TRACKING_MESH_FB = 1000110001,
    XR_TYPE_HAND_TRACKING_SCALE_FB = 1000110003,
    XR_TYPE_HAND_TRACKING_AIM_STATE_FB = 1000111001,
    XR_TYPE_HAND_TRACKING_CAPSULES_STATE_FB = 1000112000,
    XR_TYPE_FOVEATION_PROFILE_CREATE_INFO_FB = 1000114000,
    XR_TYPE_SWAPCHAIN_CREATE_INFO_FOVEATION_FB = 1000114001,
    XR_TYPE_SWAPCHAIN_STATE_FOVEATION_FB = 1000114002,
    XR_TYPE_FOVEATION_LEVEL_PROFILE_CREATE_INFO_FB = 1000115000,
    XR_TYPE_TRIANGLE_MESH_CREATE_INFO_FB = 1000117001,
    XR_TYPE_SYSTEM_PASSTHROUGH_PROPERTIES_FB = 1000118000,
    XR_TYPE_PASSTHROUGH_CREATE_INFO_FB = 1000118001,
    XR_TYPE_PASSTHROUGH_LAYER_CREATE_INFO_FB = 1000118002,
    XR_TYPE_COMPOSITION_LAYER_PASSTHROUGH_FB = 1000118003,
    XR_TYPE_GEOMETRY_INSTANCE_CREATE_INFO_FB = 1000118004,
    XR_TYPE_GEOMETRY_INSTANCE_TRANSFORM_FB = 1000118005,
    XR_TYPE_PASSTHROUGH_STYLE_FB = 1000118020,
    XR_TYPE_PASSTHROUGH_COLOR_MAP_MONO_TO_RGBA_FB = 1000118021,
    XR_TYPE_PASSTHROUGH_COLOR_MAP_MONO_TO_MONO_FB = 1000118022,
    XR_TYPE_EVENT_DATA_PASSTHROUGH_STATE_CHANGED_FB = 1000118030,
    XR_TYPE_BINDING_MODIFICATIONS_KHR = 1000120000,
    XR_TYPE_VIEW_LOCATE_FOVEATED_RENDERING_VARJO = 1000121000,
    XR_TYPE_FOVEATED_VIEW_CONFIGURATION_VIEW_VARJO = 1000121001,
    XR_TYPE_SYSTEM_FOVEATED_RENDERING_PROPERTIES_VARJO = 1000121002,
    XR_TYPE_COMPOSITION_LAYER_DEPTH_TEST_VARJO = 1000122000,
    XR_TYPE_SYSTEM_MARKER_TRACKING_PROPERTIES_VARJO = 1000124000,
    XR_TYPE_EVENT_DATA_MARKER_TRACKING_UPDATE_VARJO = 1000124001,
    XR_TYPE_MARKER_SPACE_CREATE_INFO_VARJO = 1000124002,
    XR_TYPE_SPATIAL_ANCHOR_PERSISTENCE_INFO_MSFT = 1000142000,
    XR_TYPE_SPATIAL_ANCHOR_FROM_PERSISTED_ANCHOR_CREATE_INFO_MSFT = 1000142001,
    XR_TYPE_SWAPCHAIN_IMAGE_FOVEATION_VULKAN_FB = 1000160000,
    XR_TYPE_SWAPCHAIN_STATE_SAMPLER_VULKAN_FB = 1000163000,
    XR_TYPE_COMPOSITION_LAYER_SPACE_WARP_INFO_FB = 1000171000,
    XR_TYPE_SYSTEM_SPACE_WARP_PROPERTIES_FB = 1000171001,
    XR_TYPE_GRAPHICS_BINDING_VULKAN2_KHR = XR_TYPE_GRAPHICS_BINDING_VULKAN_KHR,
    XR_TYPE_SWAPCHAIN_IMAGE_VULKAN2_KHR = XR_TYPE_SWAPCHAIN_IMAGE_VULKAN_KHR,
    XR_TYPE_GRAPHICS_REQUIREMENTS_VULKAN2_KHR = XR_TYPE_GRAPHICS_REQUIREMENTS_VULKAN_KHR,
    XR_STRUCTURE_TYPE_MAX_ENUM = 0x7fffffff,
} XrStructureType;

typedef enum XrViewConfigurationType
{
    XR_VIEW_CONFIGURATION_TYPE_PRIMARY_MONO = 1,
    XR_VIEW_CONFIGURATION_TYPE_PRIMARY_STEREO = 2,
    XR_VIEW_CONFIGURATION_TYPE_PRIMARY_QUAD_VARJO = 1000037000,
    XR_VIEW_CONFIGURATION_TYPE_SECONDARY_MONO_FIRST_PERSON_OBSERVER_MSFT = 1000054000,
    XR_VIEW_CONFIGURATION_TYPE_MAX_ENUM = 0x7fffffff,
} XrViewConfigurationType;

typedef enum XrVisibilityMaskTypeKHR
{
    XR_VISIBILITY_MASK_TYPE_HIDDEN_TRIANGLE_MESH_KHR = 1,
    XR_VISIBILITY_MASK_TYPE_VISIBLE_TRIANGLE_MESH_KHR = 2,
    XR_VISIBILITY_MASK_TYPE_LINE_LOOP_KHR = 3,
    XR_VISIBILITY_MASK_TYPE_KHR_MAX_ENUM = 0x7fffffff,
} XrVisibilityMaskTypeKHR;

typedef enum XrWindingOrderFB
{
    XR_WINDING_ORDER_UNKNOWN_FB = 0,
    XR_WINDING_ORDER_CW_FB = 1,
    XR_WINDING_ORDER_CCW_FB = 2,
    XR_WINDING_ORDER_FB_MAX_ENUM = 0x7fffffff,
} XrWindingOrderFB;

typedef struct XrActionCreateInfo XrActionCreateInfo;
typedef struct XrActionStateBoolean XrActionStateBoolean;
typedef struct XrActionStateGetInfo XrActionStateGetInfo;
typedef struct XrActionSuggestedBinding XrActionSuggestedBinding;
typedef struct XrActiveActionSet XrActiveActionSet;
typedef struct XrApplicationInfo XrApplicationInfo;
typedef struct XrBaseOutStructure XrBaseOutStructure;
typedef struct XrBoundSourcesForActionEnumerateInfo XrBoundSourcesForActionEnumerateInfo;
typedef struct XrCompositionLayerAlphaBlendFB XrCompositionLayerAlphaBlendFB;
typedef struct XrCompositionLayerDepthTestVARJO XrCompositionLayerDepthTestVARJO;
typedef struct XrCompositionLayerImageLayoutFB XrCompositionLayerImageLayoutFB;
typedef struct XrCompositionLayerReprojectionInfoMSFT XrCompositionLayerReprojectionInfoMSFT;
typedef struct XrCompositionLayerSecureContentFB XrCompositionLayerSecureContentFB;
typedef struct XrControllerModelKeyStateMSFT XrControllerModelKeyStateMSFT;
typedef struct XrDebugUtilsLabelEXT XrDebugUtilsLabelEXT;
typedef struct XrDeserializeSceneFragmentMSFT XrDeserializeSceneFragmentMSFT;
typedef struct XrEventDataBuffer XrEventDataBuffer;
typedef struct XrEventDataEventsLost XrEventDataEventsLost;
typedef struct XrEventDataInteractionProfileChanged XrEventDataInteractionProfileChanged;
typedef struct XrEventDataMarkerTrackingUpdateVARJO XrEventDataMarkerTrackingUpdateVARJO;
typedef struct XrEventDataPerfSettingsEXT XrEventDataPerfSettingsEXT;
typedef struct XrEventDataSessionStateChanged XrEventDataSessionStateChanged;
typedef struct XrExtensionProperties XrExtensionProperties;
typedef struct XrExtent2Di XrExtent2Di;
typedef struct XrFoveatedViewConfigurationViewVARJO XrFoveatedViewConfigurationViewVARJO;
typedef struct XrFoveationProfileCreateInfoFB XrFoveationProfileCreateInfoFB;
typedef struct XrFrameBeginInfo XrFrameBeginInfo;
typedef struct XrFrameState XrFrameState;
typedef struct XrGraphicsBindingD3D11KHR XrGraphicsBindingD3D11KHR;
typedef struct XrGraphicsRequirementsD3D11KHR XrGraphicsRequirementsD3D11KHR;
typedef struct XrHandJointsLocateInfoEXT XrHandJointsLocateInfoEXT;
typedef struct XrHandMeshIndexBufferMSFT XrHandMeshIndexBufferMSFT;
typedef struct XrHandMeshUpdateInfoMSFT XrHandMeshUpdateInfoMSFT;
typedef struct XrHandPoseTypeInfoMSFT XrHandPoseTypeInfoMSFT;
typedef struct XrHandTrackingScaleFB XrHandTrackingScaleFB;
typedef struct XrHapticBaseHeader XrHapticBaseHeader;
typedef struct XrHolographicWindowAttachmentMSFT XrHolographicWindowAttachmentMSFT;
typedef struct XrInstanceCreateInfo XrInstanceCreateInfo;
typedef struct XrInstanceProperties XrInstanceProperties;
typedef struct XrInteractionProfileState XrInteractionProfileState;
typedef struct XrOffset2Df XrOffset2Df;
typedef struct XrPassthroughColorMapMonoToMonoFB XrPassthroughColorMapMonoToMonoFB;
typedef struct XrPassthroughCreateInfoFB XrPassthroughCreateInfoFB;
typedef struct XrQuaternionf XrQuaternionf;
typedef struct XrSceneComponentsGetInfoMSFT XrSceneComponentsGetInfoMSFT;
typedef struct XrSceneCreateInfoMSFT XrSceneCreateInfoMSFT;
typedef struct XrSceneMeshBuffersGetInfoMSFT XrSceneMeshBuffersGetInfoMSFT;
typedef struct XrSceneMeshIndicesUint16MSFT XrSceneMeshIndicesUint16MSFT;
typedef struct XrSceneMeshMSFT XrSceneMeshMSFT;
typedef struct XrSceneMeshesMSFT XrSceneMeshesMSFT;
typedef struct XrSceneObjectTypesFilterInfoMSFT XrSceneObjectTypesFilterInfoMSFT;
typedef struct XrSceneObserverCreateInfoMSFT XrSceneObserverCreateInfoMSFT;
typedef struct XrScenePlaneAlignmentFilterInfoMSFT XrScenePlaneAlignmentFilterInfoMSFT;
typedef struct XrSecondaryViewConfigurationSessionBeginInfoMSFT XrSecondaryViewConfigurationSessionBeginInfoMSFT;
typedef struct XrSecondaryViewConfigurationSwapchainCreateInfoMSFT XrSecondaryViewConfigurationSwapchainCreateInfoMSFT;
typedef struct XrSessionActionSetsAttachInfo XrSessionActionSetsAttachInfo;
typedef struct XrSessionCreateInfo XrSessionCreateInfo;
typedef struct XrSpatialAnchorPersistenceNameMSFT XrSpatialAnchorPersistenceNameMSFT;
typedef struct XrSwapchainCreateInfo XrSwapchainCreateInfo;
typedef struct XrSwapchainImageAcquireInfo XrSwapchainImageAcquireInfo;
typedef struct XrSwapchainImageD3D11KHR XrSwapchainImageD3D11KHR;
typedef struct XrSwapchainImageFoveationVulkanFB XrSwapchainImageFoveationVulkanFB;
typedef struct XrSwapchainImageOpenGLKHR XrSwapchainImageOpenGLKHR;
typedef struct XrSwapchainImageWaitInfo XrSwapchainImageWaitInfo;
typedef struct XrSwapchainStateFoveationFB XrSwapchainStateFoveationFB;
typedef struct XrSystemColorSpacePropertiesFB XrSystemColorSpacePropertiesFB;
typedef struct XrSystemFoveatedRenderingPropertiesVARJO XrSystemFoveatedRenderingPropertiesVARJO;
typedef struct XrSystemGraphicsProperties XrSystemGraphicsProperties;
typedef struct XrSystemHandTrackingPropertiesEXT XrSystemHandTrackingPropertiesEXT;
typedef struct XrSystemPassthroughPropertiesFB XrSystemPassthroughPropertiesFB;
typedef struct XrSystemSpaceWarpPropertiesFB XrSystemSpaceWarpPropertiesFB;
typedef struct XrUuidMSFT XrUuidMSFT;
typedef struct XrVector3f XrVector3f;
typedef struct XrVector4sFB XrVector4sFB;
typedef struct XrViewConfigurationDepthRangeEXT XrViewConfigurationDepthRangeEXT;
typedef struct XrViewConfigurationView XrViewConfigurationView;
typedef struct XrViewLocateFoveatedRenderingVARJO XrViewLocateFoveatedRenderingVARJO;
typedef struct XrViewState XrViewState;
typedef struct XrVisualMeshComputeLodInfoMSFT XrVisualMeshComputeLodInfoMSFT;
typedef struct XrVulkanDeviceCreateInfoKHR XrVulkanDeviceCreateInfoKHR;
typedef struct XrVulkanInstanceCreateInfoKHR XrVulkanInstanceCreateInfoKHR;
typedef struct XrActionSetCreateInfo XrActionSetCreateInfo;
typedef struct XrActionStateFloat XrActionStateFloat;
typedef struct XrActionsSyncInfo XrActionsSyncInfo;
typedef struct XrBaseInStructure XrBaseInStructure;
typedef struct XrColor4f XrColor4f;
typedef struct XrCompositionLayerColorScaleBiasKHR XrCompositionLayerColorScaleBiasKHR;
typedef struct XrCompositionLayerPassthroughFB XrCompositionLayerPassthroughFB;
typedef struct XrCompositionLayerReprojectionPlaneOverrideMSFT XrCompositionLayerReprojectionPlaneOverrideMSFT;
typedef struct XrControllerModelNodePropertiesMSFT XrControllerModelNodePropertiesMSFT;
typedef struct XrControllerModelPropertiesMSFT XrControllerModelPropertiesMSFT;
typedef struct XrDebugUtilsObjectNameInfoEXT XrDebugUtilsObjectNameInfoEXT;
typedef struct XrEventDataDisplayRefreshRateChangedFB XrEventDataDisplayRefreshRateChangedFB;
typedef struct XrEventDataMainSessionVisibilityChangedEXTX XrEventDataMainSessionVisibilityChangedEXTX;
typedef struct XrEventDataVisibilityMaskChangedKHR XrEventDataVisibilityMaskChangedKHR;
typedef struct XrExtent2Df XrExtent2Df;
typedef struct XrFoveationLevelProfileCreateInfoFB XrFoveationLevelProfileCreateInfoFB;
typedef struct XrFrameWaitInfo XrFrameWaitInfo;
typedef struct XrGraphicsBindingD3D12KHR XrGraphicsBindingD3D12KHR;
typedef struct XrGraphicsBindingVulkanKHR XrGraphicsBindingVulkanKHR;
typedef XrGraphicsBindingVulkanKHR XrGraphicsBindingVulkan2KHR;
typedef struct XrGraphicsRequirementsOpenGLKHR XrGraphicsRequirementsOpenGLKHR;
typedef struct XrHandCapsuleFB XrHandCapsuleFB;
typedef struct XrHandJointVelocityEXT XrHandJointVelocityEXT;
typedef struct XrHandMeshVertexMSFT XrHandMeshVertexMSFT;
typedef struct XrHandTrackingCapsulesStateFB XrHandTrackingCapsulesStateFB;
typedef struct XrHapticActionInfo XrHapticActionInfo;
typedef struct XrInputSourceLocalizedNameGetInfo XrInputSourceLocalizedNameGetInfo;
typedef struct XrInteractionProfileAnalogThresholdVALVE XrInteractionProfileAnalogThresholdVALVE;
typedef struct XrOffset2Di XrOffset2Di;
typedef struct XrPassthroughLayerCreateInfoFB XrPassthroughLayerCreateInfoFB;
typedef struct XrPosef XrPosef;
typedef struct XrRect2Di XrRect2Di;
typedef struct XrSceneComponentLocationMSFT XrSceneComponentLocationMSFT;
typedef struct XrSceneComponentMSFT XrSceneComponentMSFT;
typedef struct XrSceneComponentsLocateInfoMSFT XrSceneComponentsLocateInfoMSFT;
typedef struct XrSceneDeserializeInfoMSFT XrSceneDeserializeInfoMSFT;
typedef struct XrSceneMeshBuffersMSFT XrSceneMeshBuffersMSFT;
typedef struct XrSceneMeshVertexBufferMSFT XrSceneMeshVertexBufferMSFT;
typedef struct XrSceneOrientedBoxBoundMSFT XrSceneOrientedBoxBoundMSFT;
typedef struct XrSceneSphereBoundMSFT XrSceneSphereBoundMSFT;
typedef struct XrSecondaryViewConfigurationStateMSFT XrSecondaryViewConfigurationStateMSFT;
typedef struct XrSessionBeginInfo XrSessionBeginInfo;
typedef struct XrSpaceLocation XrSpaceLocation;
typedef struct XrSpatialAnchorCreateInfoMSFT XrSpatialAnchorCreateInfoMSFT;
typedef struct XrSpatialAnchorPersistenceInfoMSFT XrSpatialAnchorPersistenceInfoMSFT;
typedef struct XrSpatialGraphNodeSpaceCreateInfoMSFT XrSpatialGraphNodeSpaceCreateInfoMSFT;
typedef struct XrSwapchainImageBaseHeader XrSwapchainImageBaseHeader;
typedef struct XrSwapchainImageVulkanKHR XrSwapchainImageVulkanKHR;
typedef XrSwapchainImageVulkanKHR XrSwapchainImageVulkan2KHR;
typedef struct XrSwapchainStateSamplerVulkanFB XrSwapchainStateSamplerVulkanFB;
typedef struct XrSystemEyeGazeInteractionPropertiesEXT XrSystemEyeGazeInteractionPropertiesEXT;
typedef struct XrSystemHandTrackingMeshPropertiesMSFT XrSystemHandTrackingMeshPropertiesMSFT;
typedef struct XrSystemTrackingProperties XrSystemTrackingProperties;
typedef struct XrVector2f XrVector2f;
typedef struct XrViewConfigurationProperties XrViewConfigurationProperties;
typedef struct XrViewLocateInfo XrViewLocateInfo;
typedef struct XrViveTrackerPathsHTCX XrViveTrackerPathsHTCX;
typedef struct XrVulkanSwapchainFormatListCreateInfoKHR XrVulkanSwapchainFormatListCreateInfoKHR;
typedef struct XrActionSpaceCreateInfo XrActionSpaceCreateInfo;
typedef struct XrActionStateVector2f XrActionStateVector2f;
typedef struct XrBindingModificationBaseHeaderKHR XrBindingModificationBaseHeaderKHR;
typedef struct XrCompositionLayerBaseHeader XrCompositionLayerBaseHeader;
typedef struct XrControllerModelNodeStateMSFT XrControllerModelNodeStateMSFT;
typedef struct XrDebugUtilsMessengerCallbackDataEXT XrDebugUtilsMessengerCallbackDataEXT;
typedef struct XrEventDataInstanceLossPending XrEventDataInstanceLossPending;
typedef struct XrEventDataReferenceSpaceChangePending XrEventDataReferenceSpaceChangePending;
typedef struct XrEyeGazeSampleTimeEXT XrEyeGazeSampleTimeEXT;
typedef struct XrFrameEndInfo XrFrameEndInfo;
typedef struct XrGeometryInstanceTransformFB XrGeometryInstanceTransformFB;
typedef struct XrGraphicsRequirementsD3D12KHR XrGraphicsRequirementsD3D12KHR;
typedef struct XrHandJointLocationEXT XrHandJointLocationEXT;
typedef struct XrHandJointVelocitiesEXT XrHandJointVelocitiesEXT;
typedef struct XrHandMeshSpaceCreateInfoMSFT XrHandMeshSpaceCreateInfoMSFT;
typedef struct XrHandTrackerCreateInfoEXT XrHandTrackerCreateInfoEXT;
typedef struct XrHapticVibration XrHapticVibration;
typedef struct XrInteractionProfileSuggestedBinding XrInteractionProfileSuggestedBinding;
typedef struct XrPassthroughColorMapMonoToRgbaFB XrPassthroughColorMapMonoToRgbaFB;
typedef struct XrRect2Df XrRect2Df;
typedef struct XrSceneComponentLocationsMSFT XrSceneComponentLocationsMSFT;
typedef struct XrSceneComponentsMSFT XrSceneComponentsMSFT;
typedef struct XrSceneMeshIndicesUint32MSFT XrSceneMeshIndicesUint32MSFT;
typedef struct XrScenePlaneMSFT XrScenePlaneMSFT;
typedef struct XrSecondaryViewConfigurationFrameStateMSFT XrSecondaryViewConfigurationFrameStateMSFT;
typedef struct XrSerializedSceneFragmentDataGetInfoMSFT XrSerializedSceneFragmentDataGetInfoMSFT;
typedef struct XrSpaceVelocity XrSpaceVelocity;
typedef struct XrSpatialAnchorSpaceCreateInfoMSFT XrSpatialAnchorSpaceCreateInfoMSFT;
typedef struct XrSwapchainImageD3D12KHR XrSwapchainImageD3D12KHR;
typedef struct XrSwapchainStateBaseHeaderFB XrSwapchainStateBaseHeaderFB;
typedef struct XrSystemGetInfo XrSystemGetInfo;
typedef struct XrSystemProperties XrSystemProperties;
typedef struct XrVector4f XrVector4f;
typedef struct XrVisibilityMaskKHR XrVisibilityMaskKHR;
typedef struct XrActionStatePose XrActionStatePose;
typedef struct XrBindingModificationsKHR XrBindingModificationsKHR;
typedef struct XrControllerModelStateMSFT XrControllerModelStateMSFT;
typedef struct XrEventDataPassthroughStateChangedFB XrEventDataPassthroughStateChangedFB;
typedef struct XrFovf XrFovf;
typedef struct XrGraphicsBindingOpenGLWin32KHR XrGraphicsBindingOpenGLWin32KHR;
typedef struct XrHandJointLocationsEXT XrHandJointLocationsEXT;
typedef struct XrHandMeshVertexBufferMSFT XrHandMeshVertexBufferMSFT;
typedef struct XrHandTrackingMeshFB XrHandTrackingMeshFB;
typedef struct XrMarkerSpaceCreateInfoVARJO XrMarkerSpaceCreateInfoVARJO;
typedef struct XrPassthroughStyleFB XrPassthroughStyleFB;
typedef struct XrSceneComponentParentFilterInfoMSFT XrSceneComponentParentFilterInfoMSFT;
typedef struct XrSceneObjectMSFT XrSceneObjectMSFT;
typedef struct XrScenePlanesMSFT XrScenePlanesMSFT;
typedef struct XrSecondaryViewConfigurationLayerInfoMSFT XrSecondaryViewConfigurationLayerInfoMSFT;
typedef struct XrSpatialAnchorFromPersistedAnchorCreateInfoMSFT XrSpatialAnchorFromPersistedAnchorCreateInfoMSFT;
typedef struct XrSwapchainImageReleaseInfo XrSwapchainImageReleaseInfo;
typedef struct XrSystemMarkerTrackingPropertiesVARJO XrSystemMarkerTrackingPropertiesVARJO;
typedef struct XrView XrView;
typedef struct XrVulkanGraphicsDeviceGetInfoKHR XrVulkanGraphicsDeviceGetInfoKHR;
typedef struct XrApiLayerProperties XrApiLayerProperties;
typedef struct XrEventDataBaseHeader XrEventDataBaseHeader;
typedef struct XrGeometryInstanceCreateInfoFB XrGeometryInstanceCreateInfoFB;
typedef struct XrHandJointsMotionRangeInfoEXT XrHandJointsMotionRangeInfoEXT;
typedef struct XrHandTrackingAimStateFB XrHandTrackingAimStateFB;
typedef struct XrReferenceSpaceCreateInfo XrReferenceSpaceCreateInfo;
typedef struct XrSceneFrustumBoundMSFT XrSceneFrustumBoundMSFT;
typedef struct XrSecondaryViewConfigurationFrameEndInfoMSFT XrSecondaryViewConfigurationFrameEndInfoMSFT;
typedef struct XrSwapchainCreateInfoFoveationFB XrSwapchainCreateInfoFoveationFB;
typedef struct XrTriangleMeshCreateInfoFB XrTriangleMeshCreateInfoFB;
typedef struct XrCompositionLayerCubeKHR XrCompositionLayerCubeKHR;
typedef struct XrEventDataViveTrackerConnectedHTCX XrEventDataViveTrackerConnectedHTCX;
typedef struct XrHandMeshMSFT XrHandMeshMSFT;
typedef struct XrSceneBoundsMSFT XrSceneBoundsMSFT;
typedef struct XrSessionCreateInfoOverlayEXTX XrSessionCreateInfoOverlayEXTX;
typedef struct XrViewConfigurationViewFovEPIC XrViewConfigurationViewFovEPIC;
typedef struct XrGraphicsRequirementsVulkanKHR XrGraphicsRequirementsVulkanKHR;
typedef XrGraphicsRequirementsVulkanKHR XrGraphicsRequirementsVulkan2KHR;
typedef struct XrNewSceneComputeInfoMSFT XrNewSceneComputeInfoMSFT;
typedef struct XrSwapchainSubImage XrSwapchainSubImage;
typedef struct XrCompositionLayerCylinderKHR XrCompositionLayerCylinderKHR;
typedef struct XrCompositionLayerEquirect2KHR XrCompositionLayerEquirect2KHR;
typedef struct XrCompositionLayerProjectionView XrCompositionLayerProjectionView;
typedef struct XrCompositionLayerSpaceWarpInfoFB XrCompositionLayerSpaceWarpInfoFB;
typedef struct XrSceneObjectsMSFT XrSceneObjectsMSFT;
typedef struct XrCompositionLayerDepthInfoKHR XrCompositionLayerDepthInfoKHR;
typedef struct XrCompositionLayerProjection XrCompositionLayerProjection;
typedef struct XrCompositionLayerEquirectKHR XrCompositionLayerEquirectKHR;
typedef struct XrCompositionLayerQuad XrCompositionLayerQuad;
typedef XrBool32 (XRAPI_PTR * PFN_xrDebugUtilsMessengerCallbackEXT)(
    XrDebugUtilsMessageSeverityFlagsEXT messageSeverity,
    XrDebugUtilsMessageTypeFlagsEXT messageTypes,
    const XrDebugUtilsMessengerCallbackDataEXT *callbackData,
    void *userData);
typedef void (XRAPI_PTR * PFN_xrVoidFunction)(
void);

struct XrActionCreateInfo
{
    XrStructureType type;
    const void *next;
    char actionName[XR_MAX_ACTION_NAME_SIZE];
    XrActionType actionType;
    uint32_t countSubactionPaths;
    const XrPath *subactionPaths;
    char localizedActionName[XR_MAX_LOCALIZED_ACTION_NAME_SIZE];
};

struct XrActionStateBoolean
{
    XrStructureType type;
    void *next;
    XrBool32 currentState;
    XrBool32 changedSinceLastSync;
    XrTime lastChangeTime;
    XrBool32 isActive;
};

struct XrActionStateGetInfo
{
    XrStructureType type;
    const void *next;
    XrAction action;
    XrPath subactionPath;
};

struct XrActionSuggestedBinding
{
    XrAction action;
    XrPath binding;
};

struct XrActiveActionSet
{
    XrActionSet actionSet;
    XrPath subactionPath;
};

struct XrApplicationInfo
{
    char applicationName[XR_MAX_APPLICATION_NAME_SIZE];
    uint32_t applicationVersion;
    char engineName[XR_MAX_ENGINE_NAME_SIZE];
    uint32_t engineVersion;
    XrVersion apiVersion;
};

struct XrBaseOutStructure
{
    XrStructureType type;
    struct XrBaseOutStructure *next;
};

struct XrBoundSourcesForActionEnumerateInfo
{
    XrStructureType type;
    const void *next;
    XrAction action;
};

struct XrCompositionLayerAlphaBlendFB
{
    XrStructureType type;
    void *next;
    XrBlendFactorFB srcFactorColor;
    XrBlendFactorFB dstFactorColor;
    XrBlendFactorFB srcFactorAlpha;
    XrBlendFactorFB dstFactorAlpha;
};

struct XrCompositionLayerDepthTestVARJO
{
    XrStructureType type;
    const void *next;
    float depthTestRangeNearZ;
    float depthTestRangeFarZ;
};

struct XrCompositionLayerImageLayoutFB
{
    XrStructureType type;
    void *next;
    XrCompositionLayerImageLayoutFlagsFB flags;
};

struct XrCompositionLayerReprojectionInfoMSFT
{
    XrStructureType type;
    const void *next;
    XrReprojectionModeMSFT reprojectionMode;
};

struct XrCompositionLayerSecureContentFB
{
    XrStructureType type;
    const void *next;
    XrCompositionLayerSecureContentFlagsFB flags;
};

struct XrControllerModelKeyStateMSFT
{
    XrStructureType type;
    void *next;
    XrControllerModelKeyMSFT modelKey;
};

struct XrDebugUtilsLabelEXT
{
    XrStructureType type;
    const void *next;
    const char *labelName;
};

struct XrDeserializeSceneFragmentMSFT
{
    uint32_t bufferSize;
    const uint8_t *buffer;
};

struct XrEventDataBuffer
{
    XrStructureType type;
    const void *next;
    uint8_t varying[4000];
};

struct XrEventDataEventsLost
{
    XrStructureType type;
    const void *next;
    uint32_t lostEventCount;
};

struct XrEventDataInteractionProfileChanged
{
    XrStructureType type;
    const void *next;
    XrSession session;
};

struct XrEventDataMarkerTrackingUpdateVARJO
{
    XrStructureType type;
    const void *next;
    uint64_t WINE_XR_ALIGN(8) markerId;
    XrBool32 isActive;
    XrBool32 isPredicted;
    XrTime time;
};

struct XrEventDataPerfSettingsEXT
{
    XrStructureType type;
    const void *next;
    XrPerfSettingsDomainEXT domain;
    XrPerfSettingsSubDomainEXT subDomain;
    XrPerfSettingsNotificationLevelEXT fromLevel;
    XrPerfSettingsNotificationLevelEXT toLevel;
};

struct XrEventDataSessionStateChanged
{
    XrStructureType type;
    const void *next;
    XrSession session;
    XrSessionState state;
    XrTime time;
};

struct XrExtensionProperties
{
    XrStructureType type;
    void *next;
    char extensionName[XR_MAX_EXTENSION_NAME_SIZE];
    uint32_t extensionVersion;
};

struct XrExtent2Di
{
    int32_t width;
    int32_t height;
};

struct XrFoveatedViewConfigurationViewVARJO
{
    XrStructureType type;
    void *next;
    XrBool32 foveatedRenderingActive;
};

struct XrFoveationProfileCreateInfoFB
{
    XrStructureType type;
    void *next;
};

struct XrFrameBeginInfo
{
    XrStructureType type;
    const void *next;
};

struct XrFrameState
{
    XrStructureType type;
    void *next;
    XrTime predictedDisplayTime;
    XrDuration predictedDisplayPeriod;
    XrBool32 shouldRender;
};

struct XrGraphicsBindingD3D11KHR
{
    XrStructureType type;
    const void *next;
    ID3D11Device *device;
};

struct XrGraphicsRequirementsD3D11KHR
{
    XrStructureType type;
    void *next;
    LUID adapterLuid;
    D3D_FEATURE_LEVEL minFeatureLevel;
};

struct XrHandJointsLocateInfoEXT
{
    XrStructureType type;
    const void *next;
    XrSpace baseSpace;
    XrTime time;
};

struct XrHandMeshIndexBufferMSFT
{
    uint32_t indexBufferKey;
    uint32_t indexCapacityInput;
    uint32_t indexCountOutput;
    uint32_t *indices;
};

struct XrHandMeshUpdateInfoMSFT
{
    XrStructureType type;
    const void *next;
    XrTime time;
    XrHandPoseTypeMSFT handPoseType;
};

struct XrHandPoseTypeInfoMSFT
{
    XrStructureType type;
    const void *next;
    XrHandPoseTypeMSFT handPoseType;
};

struct XrHandTrackingScaleFB
{
    XrStructureType type;
    void *next;
    float sensorOutput;
    float currentOutput;
    XrBool32 overrideHandScale;
    float overrideValueInput;
};

struct XrHapticBaseHeader
{
    XrStructureType type;
    const void *next;
};

struct XrHolographicWindowAttachmentMSFT
{
    XrStructureType type;
    const void *next;
    IUnknown *holographicSpace;
    IUnknown *coreWindow;
};

struct XrInstanceCreateInfo
{
    XrStructureType type;
    const void *next;
    XrInstanceCreateFlags createFlags;
    XrApplicationInfo applicationInfo;
    uint32_t enabledApiLayerCount;
    const char * const*enabledApiLayerNames;
    uint32_t enabledExtensionCount;
    const char * const*enabledExtensionNames;
};

struct XrInstanceProperties
{
    XrStructureType type;
    void *next;
    XrVersion runtimeVersion;
    char runtimeName[XR_MAX_RUNTIME_NAME_SIZE];
};

struct XrInteractionProfileState
{
    XrStructureType type;
    void *next;
    XrPath interactionProfile;
};

struct XrOffset2Df
{
    float x;
    float y;
};

struct XrPassthroughColorMapMonoToMonoFB
{
    XrStructureType type;
    const void *next;
    uint8_t textureColorMap[XR_PASSTHROUGH_COLOR_MAP_MONO_SIZE_FB];
};

struct XrPassthroughCreateInfoFB
{
    XrStructureType type;
    const void *next;
    XrPassthroughFlagsFB flags;
};

struct XrQuaternionf
{
    float x;
    float y;
    float z;
    float w;
};

struct XrSceneComponentsGetInfoMSFT
{
    XrStructureType type;
    const void *next;
    XrSceneComponentTypeMSFT componentType;
};

struct XrSceneCreateInfoMSFT
{
    XrStructureType type;
    const void *next;
};

struct XrSceneMeshBuffersGetInfoMSFT
{
    XrStructureType type;
    const void *next;
    uint64_t WINE_XR_ALIGN(8) meshBufferId;
};

struct XrSceneMeshIndicesUint16MSFT
{
    XrStructureType type;
    void *next;
    uint32_t indexCapacityInput;
    uint32_t indexCountOutput;
    uint16_t *indices;
};

struct XrSceneMeshMSFT
{
    uint64_t WINE_XR_ALIGN(8) meshBufferId;
    XrBool32 supportsIndicesUint16;
};

struct XrSceneMeshesMSFT
{
    XrStructureType type;
    void *next;
    uint32_t sceneMeshCount;
    XrSceneMeshMSFT *sceneMeshes;
};

struct XrSceneObjectTypesFilterInfoMSFT
{
    XrStructureType type;
    const void *next;
    uint32_t objectTypeCount;
    const XrSceneObjectTypeMSFT *objectTypes;
};

struct XrSceneObserverCreateInfoMSFT
{
    XrStructureType type;
    const void *next;
};

struct XrScenePlaneAlignmentFilterInfoMSFT
{
    XrStructureType type;
    const void *next;
    uint32_t alignmentCount;
    const XrScenePlaneAlignmentTypeMSFT *alignments;
};

struct XrSecondaryViewConfigurationSessionBeginInfoMSFT
{
    XrStructureType type;
    const void *next;
    uint32_t viewConfigurationCount;
    const XrViewConfigurationType *enabledViewConfigurationTypes;
};

struct XrSecondaryViewConfigurationSwapchainCreateInfoMSFT
{
    XrStructureType type;
    const void *next;
    XrViewConfigurationType viewConfigurationType;
};

struct XrSessionActionSetsAttachInfo
{
    XrStructureType type;
    const void *next;
    uint32_t countActionSets;
    const XrActionSet *actionSets;
};

struct XrSessionCreateInfo
{
    XrStructureType type;
    const void *next;
    XrSessionCreateFlags createFlags;
    XrSystemId systemId;
};

struct XrSpatialAnchorPersistenceNameMSFT
{
    char name[XR_MAX_SPATIAL_ANCHOR_NAME_SIZE_MSFT];
};

struct XrSwapchainCreateInfo
{
    XrStructureType type;
    const void *next;
    XrSwapchainCreateFlags createFlags;
    XrSwapchainUsageFlags usageFlags;
    int64_t format;
    uint32_t sampleCount;
    uint32_t width;
    uint32_t height;
    uint32_t faceCount;
    uint32_t arraySize;
    uint32_t mipCount;
};

struct XrSwapchainImageAcquireInfo
{
    XrStructureType type;
    const void *next;
};

struct XrSwapchainImageD3D11KHR
{
    XrStructureType type;
    void *next;
    ID3D11Texture2D *texture;
};

struct XrSwapchainImageFoveationVulkanFB
{
    XrStructureType type;
    void *next;
    VkImage image;
    uint32_t width;
    uint32_t height;
};

struct XrSwapchainImageOpenGLKHR
{
    XrStructureType type;
    void *next;
    uint32_t image;
};

struct XrSwapchainImageWaitInfo
{
    XrStructureType type;
    const void *next;
    XrDuration timeout;
};

struct XrSwapchainStateFoveationFB
{
    XrStructureType type;
    void *next;
    XrSwapchainStateFoveationFlagsFB flags;
    XrFoveationProfileFB profile;
};

struct XrSystemColorSpacePropertiesFB
{
    XrStructureType type;
    void *next;
    XrColorSpaceFB colorSpace;
};

struct XrSystemFoveatedRenderingPropertiesVARJO
{
    XrStructureType type;
    void *next;
    XrBool32 supportsFoveatedRendering;
};

struct XrSystemGraphicsProperties
{
    uint32_t maxSwapchainImageHeight;
    uint32_t maxSwapchainImageWidth;
    uint32_t maxLayerCount;
};

struct XrSystemHandTrackingPropertiesEXT
{
    XrStructureType type;
    void *next;
    XrBool32 supportsHandTracking;
};

struct XrSystemPassthroughPropertiesFB
{
    XrStructureType type;
    const void *next;
    XrBool32 supportsPassthrough;
};

struct XrSystemSpaceWarpPropertiesFB
{
    XrStructureType type;
    void *next;
    uint32_t recommendedMotionVectorImageRectWidth;
    uint32_t recommendedMotionVectorImageRectHeight;
};

struct XrUuidMSFT
{
    uint8_t bytes[16];
};

struct XrVector3f
{
    float x;
    float y;
    float z;
};

struct XrVector4sFB
{
    int16_t x;
    int16_t y;
    int16_t z;
    int16_t w;
};

struct XrViewConfigurationDepthRangeEXT
{
    XrStructureType type;
    void *next;
    float recommendedNearZ;
    float minNearZ;
    float recommendedFarZ;
    float maxFarZ;
};

struct XrViewConfigurationView
{
    XrStructureType type;
    void *next;
    uint32_t recommendedImageRectWidth;
    uint32_t maxImageRectWidth;
    uint32_t recommendedImageRectHeight;
    uint32_t maxImageRectHeight;
    uint32_t recommendedSwapchainSampleCount;
    uint32_t maxSwapchainSampleCount;
};

struct XrViewLocateFoveatedRenderingVARJO
{
    XrStructureType type;
    const void *next;
    XrBool32 foveatedRenderingActive;
};

struct XrViewState
{
    XrStructureType type;
    void *next;
    XrViewStateFlags viewStateFlags;
};

struct XrVisualMeshComputeLodInfoMSFT
{
    XrStructureType type;
    const void *next;
    XrMeshComputeLodMSFT lod;
};

struct XrVulkanDeviceCreateInfoKHR
{
    XrStructureType type;
    const void *next;
    XrSystemId systemId;
    XrVulkanDeviceCreateFlagsKHR createFlags;
    PFN_vkGetInstanceProcAddr pfnGetInstanceProcAddr;
    VkPhysicalDevice vulkanPhysicalDevice;
    const VkDeviceCreateInfo *vulkanCreateInfo;
    const VkAllocationCallbacks *vulkanAllocator;
};

struct XrVulkanInstanceCreateInfoKHR
{
    XrStructureType type;
    const void *next;
    XrSystemId systemId;
    XrVulkanInstanceCreateFlagsKHR createFlags;
    PFN_vkGetInstanceProcAddr pfnGetInstanceProcAddr;
    const VkInstanceCreateInfo *vulkanCreateInfo;
    const VkAllocationCallbacks *vulkanAllocator;
};

struct XrActionSetCreateInfo
{
    XrStructureType type;
    const void *next;
    char actionSetName[XR_MAX_ACTION_SET_NAME_SIZE];
    char localizedActionSetName[XR_MAX_LOCALIZED_ACTION_SET_NAME_SIZE];
    uint32_t priority;
};

struct XrActionStateFloat
{
    XrStructureType type;
    void *next;
    float currentState;
    XrBool32 changedSinceLastSync;
    XrTime lastChangeTime;
    XrBool32 isActive;
};

struct XrActionsSyncInfo
{
    XrStructureType type;
    const void *next;
    uint32_t countActiveActionSets;
    const XrActiveActionSet *activeActionSets;
};

struct XrBaseInStructure
{
    XrStructureType type;
    const struct XrBaseInStructure *next;
};

struct XrColor4f
{
    float r;
    float g;
    float b;
    float a;
};

struct XrCompositionLayerColorScaleBiasKHR
{
    XrStructureType type;
    const void *next;
    XrColor4f colorScale;
    XrColor4f colorBias;
};

struct XrCompositionLayerPassthroughFB
{
    XrStructureType type;
    const void *next;
    XrCompositionLayerFlags flags;
    XrSpace space;
    XrPassthroughLayerFB layerHandle;
};

struct XrCompositionLayerReprojectionPlaneOverrideMSFT
{
    XrStructureType type;
    const void *next;
    XrVector3f position;
    XrVector3f normal;
    XrVector3f velocity;
};

struct XrControllerModelNodePropertiesMSFT
{
    XrStructureType type;
    void *next;
    char parentNodeName[XR_MAX_CONTROLLER_MODEL_NODE_NAME_SIZE_MSFT];
    char nodeName[XR_MAX_CONTROLLER_MODEL_NODE_NAME_SIZE_MSFT];
};

struct XrControllerModelPropertiesMSFT
{
    XrStructureType type;
    void *next;
    uint32_t nodeCapacityInput;
    uint32_t nodeCountOutput;
    XrControllerModelNodePropertiesMSFT *nodeProperties;
};

struct XrDebugUtilsObjectNameInfoEXT
{
    XrStructureType type;
    const void *next;
    XrObjectType objectType;
    uint64_t WINE_XR_ALIGN(8) objectHandle;
    const char *objectName;
};

struct XrEventDataDisplayRefreshRateChangedFB
{
    XrStructureType type;
    const void *next;
    float fromDisplayRefreshRate;
    float toDisplayRefreshRate;
};

struct XrEventDataMainSessionVisibilityChangedEXTX
{
    XrStructureType type;
    const void *next;
    XrBool32 visible;
    XrOverlayMainSessionFlagsEXTX flags;
};

struct XrEventDataVisibilityMaskChangedKHR
{
    XrStructureType type;
    const void *next;
    XrSession session;
    XrViewConfigurationType viewConfigurationType;
    uint32_t viewIndex;
};

struct XrExtent2Df
{
    float width;
    float height;
};

struct XrFoveationLevelProfileCreateInfoFB
{
    XrStructureType type;
    void *next;
    XrFoveationLevelFB level;
    float verticalOffset;
    XrFoveationDynamicFB dynamic;
};

struct XrFrameWaitInfo
{
    XrStructureType type;
    const void *next;
};

struct XrGraphicsBindingD3D12KHR
{
    XrStructureType type;
    const void *next;
    ID3D12Device *device;
    ID3D12CommandQueue *queue;
};

struct XrGraphicsBindingVulkanKHR
{
    XrStructureType type;
    const void *next;
    VkInstance instance;
    VkPhysicalDevice physicalDevice;
    VkDevice device;
    uint32_t queueFamilyIndex;
    uint32_t queueIndex;
};

struct XrGraphicsRequirementsOpenGLKHR
{
    XrStructureType type;
    void *next;
    XrVersion minApiVersionSupported;
    XrVersion maxApiVersionSupported;
};

struct XrHandCapsuleFB
{
    XrVector3f points[XR_FB_HAND_TRACKING_CAPSULE_POINT_COUNT];
    float radius;
    XrHandJointEXT joint;
};

struct XrHandJointVelocityEXT
{
    XrSpaceVelocityFlags velocityFlags;
    XrVector3f linearVelocity;
    XrVector3f angularVelocity;
};

struct XrHandMeshVertexMSFT
{
    XrVector3f position;
    XrVector3f normal;
};

struct XrHandTrackingCapsulesStateFB
{
    XrStructureType type;
    void *next;
    XrHandCapsuleFB capsules[XR_FB_HAND_TRACKING_CAPSULE_COUNT];
};

struct XrHapticActionInfo
{
    XrStructureType type;
    const void *next;
    XrAction action;
    XrPath subactionPath;
};

struct XrInputSourceLocalizedNameGetInfo
{
    XrStructureType type;
    const void *next;
    XrPath sourcePath;
    XrInputSourceLocalizedNameFlags whichComponents;
};

struct XrInteractionProfileAnalogThresholdVALVE
{
    XrStructureType type;
    const void *next;
    XrAction action;
    XrPath binding;
    float onThreshold;
    float offThreshold;
    const XrHapticBaseHeader *onHaptic;
    const XrHapticBaseHeader *offHaptic;
};

struct XrOffset2Di
{
    int32_t x;
    int32_t y;
};

struct XrPassthroughLayerCreateInfoFB
{
    XrStructureType type;
    const void *next;
    XrPassthroughFB passthrough;
    XrPassthroughFlagsFB flags;
    XrPassthroughLayerPurposeFB purpose;
};

struct XrPosef
{
    XrQuaternionf orientation;
    XrVector3f position;
};

struct XrRect2Di
{
    XrOffset2Di offset;
    XrExtent2Di extent;
};

struct XrSceneComponentLocationMSFT
{
    XrSpaceLocationFlags flags;
    XrPosef pose;
};

struct XrSceneComponentMSFT
{
    XrSceneComponentTypeMSFT componentType;
    XrUuidMSFT id;
    XrUuidMSFT parentId;
    XrTime updateTime;
};

struct XrSceneComponentsLocateInfoMSFT
{
    XrStructureType type;
    const void *next;
    XrSpace baseSpace;
    XrTime time;
    uint32_t componentIdCount;
    const XrUuidMSFT *componentIds;
};

struct XrSceneDeserializeInfoMSFT
{
    XrStructureType type;
    const void *next;
    uint32_t fragmentCount;
    const XrDeserializeSceneFragmentMSFT *fragments;
};

struct XrSceneMeshBuffersMSFT
{
    XrStructureType type;
    void *next;
};

struct XrSceneMeshVertexBufferMSFT
{
    XrStructureType type;
    void *next;
    uint32_t vertexCapacityInput;
    uint32_t vertexCountOutput;
    XrVector3f *vertices;
};

struct XrSceneOrientedBoxBoundMSFT
{
    XrPosef pose;
    XrVector3f extents;
};

struct XrSceneSphereBoundMSFT
{
    XrVector3f center;
    float radius;
};

struct XrSecondaryViewConfigurationStateMSFT
{
    XrStructureType type;
    void *next;
    XrViewConfigurationType viewConfigurationType;
    XrBool32 active;
};

struct XrSessionBeginInfo
{
    XrStructureType type;
    const void *next;
    XrViewConfigurationType primaryViewConfigurationType;
};

struct XrSpaceLocation
{
    XrStructureType type;
    void *next;
    XrSpaceLocationFlags locationFlags;
    XrPosef pose;
};

struct XrSpatialAnchorCreateInfoMSFT
{
    XrStructureType type;
    const void *next;
    XrSpace space;
    XrPosef pose;
    XrTime time;
};

struct XrSpatialAnchorPersistenceInfoMSFT
{
    XrStructureType type;
    const void *next;
    XrSpatialAnchorPersistenceNameMSFT spatialAnchorPersistenceName;
    XrSpatialAnchorMSFT spatialAnchor;
};

struct XrSpatialGraphNodeSpaceCreateInfoMSFT
{
    XrStructureType type;
    const void *next;
    XrSpatialGraphNodeTypeMSFT nodeType;
    uint8_t nodeId[16];
    XrPosef pose;
};

struct XrSwapchainImageBaseHeader
{
    XrStructureType type;
    void *next;
};

struct XrSwapchainImageVulkanKHR
{
    XrStructureType type;
    void *next;
    VkImage image;
};

struct XrSwapchainStateSamplerVulkanFB
{
    XrStructureType type;
    void *next;
    VkFilter minFilter;
    VkFilter magFilter;
    VkSamplerMipmapMode mipmapMode;
    VkSamplerAddressMode wrapModeS;
    VkSamplerAddressMode wrapModeT;
    VkComponentSwizzle swizzleRed;
    VkComponentSwizzle swizzleGreen;
    VkComponentSwizzle swizzleBlue;
    VkComponentSwizzle swizzleAlpha;
    float maxAnisotropy;
    XrColor4f borderColor;
};

struct XrSystemEyeGazeInteractionPropertiesEXT
{
    XrStructureType type;
    void *next;
    XrBool32 supportsEyeGazeInteraction;
};

struct XrSystemHandTrackingMeshPropertiesMSFT
{
    XrStructureType type;
    void *next;
    XrBool32 supportsHandTrackingMesh;
    uint32_t maxHandMeshIndexCount;
    uint32_t maxHandMeshVertexCount;
};

struct XrSystemTrackingProperties
{
    XrBool32 orientationTracking;
    XrBool32 positionTracking;
};

struct XrVector2f
{
    float x;
    float y;
};

struct XrViewConfigurationProperties
{
    XrStructureType type;
    void *next;
    XrViewConfigurationType viewConfigurationType;
    XrBool32 fovMutable;
};

struct XrViewLocateInfo
{
    XrStructureType type;
    const void *next;
    XrViewConfigurationType viewConfigurationType;
    XrTime displayTime;
    XrSpace space;
};

struct XrViveTrackerPathsHTCX
{
    XrStructureType type;
    void *next;
    XrPath persistentPath;
    XrPath rolePath;
};

struct XrVulkanSwapchainFormatListCreateInfoKHR
{
    XrStructureType type;
    const void *next;
    uint32_t viewFormatCount;
    const VkFormat *viewFormats;
};

struct XrActionSpaceCreateInfo
{
    XrStructureType type;
    const void *next;
    XrAction action;
    XrPath subactionPath;
    XrPosef poseInActionSpace;
};

struct XrActionStateVector2f
{
    XrStructureType type;
    void *next;
    XrVector2f currentState;
    XrBool32 changedSinceLastSync;
    XrTime lastChangeTime;
    XrBool32 isActive;
};

struct XrBindingModificationBaseHeaderKHR
{
    XrStructureType type;
    const void *next;
};

struct XrCompositionLayerBaseHeader
{
    XrStructureType type;
    const void *next;
    XrCompositionLayerFlags layerFlags;
    XrSpace space;
};

struct XrControllerModelNodeStateMSFT
{
    XrStructureType type;
    void *next;
    XrPosef nodePose;
};

struct XrDebugUtilsMessengerCallbackDataEXT
{
    XrStructureType type;
    const void *next;
    const char *messageId;
    const char *functionName;
    const char *message;
    uint32_t objectCount;
    XrDebugUtilsObjectNameInfoEXT *objects;
    uint32_t sessionLabelCount;
    XrDebugUtilsLabelEXT *sessionLabels;
};

struct XrEventDataInstanceLossPending
{
    XrStructureType type;
    const void *next;
    XrTime lossTime;
};

struct XrEventDataReferenceSpaceChangePending
{
    XrStructureType type;
    const void *next;
    XrSession session;
    XrReferenceSpaceType referenceSpaceType;
    XrTime changeTime;
    XrBool32 poseValid;
    XrPosef poseInPreviousSpace;
};

struct XrEyeGazeSampleTimeEXT
{
    XrStructureType type;
    void *next;
    XrTime time;
};

struct XrFrameEndInfo
{
    XrStructureType type;
    const void *next;
    XrTime displayTime;
    XrEnvironmentBlendMode environmentBlendMode;
    uint32_t layerCount;
    const XrCompositionLayerBaseHeader * const*layers;
};

struct XrGeometryInstanceTransformFB
{
    XrStructureType type;
    const void *next;
    XrSpace baseSpace;
    XrTime time;
    XrPosef pose;
    XrVector3f scale;
};

struct XrGraphicsRequirementsD3D12KHR
{
    XrStructureType type;
    void *next;
    LUID adapterLuid;
    D3D_FEATURE_LEVEL minFeatureLevel;
};

struct XrHandJointLocationEXT
{
    XrSpaceLocationFlags locationFlags;
    XrPosef pose;
    float radius;
};

struct XrHandJointVelocitiesEXT
{
    XrStructureType type;
    void *next;
    uint32_t jointCount;
    XrHandJointVelocityEXT *jointVelocities;
};

struct XrHandMeshSpaceCreateInfoMSFT
{
    XrStructureType type;
    const void *next;
    XrHandPoseTypeMSFT handPoseType;
    XrPosef poseInHandMeshSpace;
};

struct XrHandTrackerCreateInfoEXT
{
    XrStructureType type;
    const void *next;
    XrHandEXT hand;
    XrHandJointSetEXT handJointSet;
};

struct XrHapticVibration
{
    XrStructureType type;
    const void *next;
    XrDuration duration;
    float frequency;
    float amplitude;
};

struct XrInteractionProfileSuggestedBinding
{
    XrStructureType type;
    const void *next;
    XrPath interactionProfile;
    uint32_t countSuggestedBindings;
    const XrActionSuggestedBinding *suggestedBindings;
};

struct XrPassthroughColorMapMonoToRgbaFB
{
    XrStructureType type;
    const void *next;
    XrColor4f textureColorMap[XR_PASSTHROUGH_COLOR_MAP_MONO_SIZE_FB];
};

struct XrRect2Df
{
    XrOffset2Df offset;
    XrExtent2Df extent;
};

struct XrSceneComponentLocationsMSFT
{
    XrStructureType type;
    void *next;
    uint32_t locationCount;
    XrSceneComponentLocationMSFT *locations;
};

struct XrSceneComponentsMSFT
{
    XrStructureType type;
    void *next;
    uint32_t componentCapacityInput;
    uint32_t componentCountOutput;
    XrSceneComponentMSFT *components;
};

struct XrSceneMeshIndicesUint32MSFT
{
    XrStructureType type;
    void *next;
    uint32_t indexCapacityInput;
    uint32_t indexCountOutput;
    uint32_t *indices;
};

struct XrScenePlaneMSFT
{
    XrScenePlaneAlignmentTypeMSFT alignment;
    XrExtent2Df size;
    uint64_t WINE_XR_ALIGN(8) meshBufferId;
    XrBool32 supportsIndicesUint16;
};

struct XrSecondaryViewConfigurationFrameStateMSFT
{
    XrStructureType type;
    void *next;
    uint32_t viewConfigurationCount;
    XrSecondaryViewConfigurationStateMSFT *viewConfigurationStates;
};

struct XrSerializedSceneFragmentDataGetInfoMSFT
{
    XrStructureType type;
    const void *next;
    XrUuidMSFT sceneFragmentId;
};

struct XrSpaceVelocity
{
    XrStructureType type;
    void *next;
    XrSpaceVelocityFlags velocityFlags;
    XrVector3f linearVelocity;
    XrVector3f angularVelocity;
};

struct XrSpatialAnchorSpaceCreateInfoMSFT
{
    XrStructureType type;
    const void *next;
    XrSpatialAnchorMSFT anchor;
    XrPosef poseInAnchorSpace;
};

struct XrSwapchainImageD3D12KHR
{
    XrStructureType type;
    void *next;
    ID3D12Resource *texture;
};

struct XrSwapchainStateBaseHeaderFB
{
    XrStructureType type;
    void *next;
};

struct XrSystemGetInfo
{
    XrStructureType type;
    const void *next;
    XrFormFactor formFactor;
};

struct XrSystemProperties
{
    XrStructureType type;
    void *next;
    XrSystemId systemId;
    uint32_t vendorId;
    char systemName[XR_MAX_SYSTEM_NAME_SIZE];
    XrSystemGraphicsProperties graphicsProperties;
    XrSystemTrackingProperties trackingProperties;
};

struct XrVector4f
{
    float x;
    float y;
    float z;
    float w;
};

struct XrVisibilityMaskKHR
{
    XrStructureType type;
    void *next;
    uint32_t vertexCapacityInput;
    uint32_t vertexCountOutput;
    XrVector2f *vertices;
    uint32_t indexCapacityInput;
    uint32_t indexCountOutput;
    uint32_t *indices;
};

struct XrActionStatePose
{
    XrStructureType type;
    void *next;
    XrBool32 isActive;
};

struct XrBindingModificationsKHR
{
    XrStructureType type;
    const void *next;
    uint32_t bindingModificationCount;
    const XrBindingModificationBaseHeaderKHR * const*bindingModifications;
};

struct XrControllerModelStateMSFT
{
    XrStructureType type;
    void *next;
    uint32_t nodeCapacityInput;
    uint32_t nodeCountOutput;
    XrControllerModelNodeStateMSFT *nodeStates;
};

struct XrEventDataPassthroughStateChangedFB
{
    XrStructureType type;
    const void *next;
    XrPassthroughStateChangedFlagsFB flags;
};

struct XrFovf
{
    float angleLeft;
    float angleRight;
    float angleUp;
    float angleDown;
};

struct XrGraphicsBindingOpenGLWin32KHR
{
    XrStructureType type;
    const void *next;
    HDC hDC;
    HGLRC hGLRC;
};

struct XrHandJointLocationsEXT
{
    XrStructureType type;
    void *next;
    XrBool32 isActive;
    uint32_t jointCount;
    XrHandJointLocationEXT *jointLocations;
};

struct XrHandMeshVertexBufferMSFT
{
    XrTime vertexUpdateTime;
    uint32_t vertexCapacityInput;
    uint32_t vertexCountOutput;
    XrHandMeshVertexMSFT *vertices;
};

struct XrHandTrackingMeshFB
{
    XrStructureType type;
    void *next;
    uint32_t jointCapacityInput;
    uint32_t jointCountOutput;
    XrPosef *jointBindPoses;
    float *jointRadii;
    XrHandJointEXT *jointParents;
    uint32_t vertexCapacityInput;
    uint32_t vertexCountOutput;
    XrVector3f *vertexPositions;
    XrVector3f *vertexNormals;
    XrVector2f *vertexUVs;
    XrVector4sFB *vertexBlendIndices;
    XrVector4f *vertexBlendWeights;
    uint32_t indexCapacityInput;
    uint32_t indexCountOutput;
    int16_t *indices;
};

struct XrMarkerSpaceCreateInfoVARJO
{
    XrStructureType type;
    const void *next;
    uint64_t WINE_XR_ALIGN(8) markerId;
    XrPosef poseInMarkerSpace;
};

struct XrPassthroughStyleFB
{
    XrStructureType type;
    const void *next;
    float textureOpacityFactor;
    XrColor4f edgeColor;
};

struct XrSceneComponentParentFilterInfoMSFT
{
    XrStructureType type;
    const void *next;
    XrUuidMSFT parentId;
};

struct XrSceneObjectMSFT
{
    XrSceneObjectTypeMSFT objectType;
};

struct XrScenePlanesMSFT
{
    XrStructureType type;
    void *next;
    uint32_t scenePlaneCount;
    XrScenePlaneMSFT *scenePlanes;
};

struct XrSecondaryViewConfigurationLayerInfoMSFT
{
    XrStructureType type;
    const void *next;
    XrViewConfigurationType viewConfigurationType;
    XrEnvironmentBlendMode environmentBlendMode;
    uint32_t layerCount;
    const XrCompositionLayerBaseHeader * const*layers;
};

struct XrSpatialAnchorFromPersistedAnchorCreateInfoMSFT
{
    XrStructureType type;
    const void *next;
    XrSpatialAnchorStoreConnectionMSFT spatialAnchorStore;
    XrSpatialAnchorPersistenceNameMSFT spatialAnchorPersistenceName;
};

struct XrSwapchainImageReleaseInfo
{
    XrStructureType type;
    const void *next;
};

struct XrSystemMarkerTrackingPropertiesVARJO
{
    XrStructureType type;
    void *next;
    XrBool32 supportsMarkerTracking;
};

struct XrView
{
    XrStructureType type;
    void *next;
    XrPosef pose;
    XrFovf fov;
};

struct XrVulkanGraphicsDeviceGetInfoKHR
{
    XrStructureType type;
    const void *next;
    XrSystemId systemId;
    VkInstance vulkanInstance;
};

struct XrApiLayerProperties
{
    XrStructureType type;
    void *next;
    char layerName[XR_MAX_API_LAYER_NAME_SIZE];
    XrVersion specVersion;
    uint32_t layerVersion;
    char description[XR_MAX_API_LAYER_DESCRIPTION_SIZE];
};

struct XrEventDataBaseHeader
{
    XrStructureType type;
    const void *next;
};

struct XrGeometryInstanceCreateInfoFB
{
    XrStructureType type;
    const void *next;
    XrPassthroughLayerFB layer;
    XrTriangleMeshFB mesh;
    XrSpace baseSpace;
    XrPosef pose;
    XrVector3f scale;
};

struct XrHandJointsMotionRangeInfoEXT
{
    XrStructureType type;
    const void *next;
    XrHandJointsMotionRangeEXT handJointsMotionRange;
};

struct XrHandTrackingAimStateFB
{
    XrStructureType type;
    void *next;
    XrHandTrackingAimFlagsFB status;
    XrPosef aimPose;
    float pinchStrengthIndex;
    float pinchStrengthMiddle;
    float pinchStrengthRing;
    float pinchStrengthLittle;
};

struct XrReferenceSpaceCreateInfo
{
    XrStructureType type;
    const void *next;
    XrReferenceSpaceType referenceSpaceType;
    XrPosef poseInReferenceSpace;
};

struct XrSceneFrustumBoundMSFT
{
    XrPosef pose;
    XrFovf fov;
    float farDistance;
};

struct XrSecondaryViewConfigurationFrameEndInfoMSFT
{
    XrStructureType type;
    const void *next;
    uint32_t viewConfigurationCount;
    const XrSecondaryViewConfigurationLayerInfoMSFT *viewConfigurationLayersInfo;
};

struct XrSwapchainCreateInfoFoveationFB
{
    XrStructureType type;
    void *next;
    XrSwapchainCreateFoveationFlagsFB flags;
};

struct XrTriangleMeshCreateInfoFB
{
    XrStructureType type;
    const void *next;
    XrTriangleMeshFlagsFB flags;
    XrWindingOrderFB windingOrder;
    uint32_t vertexCount;
    const XrVector3f *vertexBuffer;
    uint32_t triangleCount;
    const uint32_t *indexBuffer;
};

struct XrCompositionLayerCubeKHR
{
    XrStructureType type;
    const void *next;
    XrCompositionLayerFlags layerFlags;
    XrSpace space;
    XrEyeVisibility eyeVisibility;
    XrSwapchain swapchain;
    uint32_t imageArrayIndex;
    XrQuaternionf orientation;
};

struct XrEventDataViveTrackerConnectedHTCX
{
    XrStructureType type;
    const void *next;
    XrViveTrackerPathsHTCX *paths;
};

struct XrHandMeshMSFT
{
    XrStructureType type;
    void *next;
    XrBool32 isActive;
    XrBool32 indexBufferChanged;
    XrBool32 vertexBufferChanged;
    XrHandMeshIndexBufferMSFT indexBuffer;
    XrHandMeshVertexBufferMSFT vertexBuffer;
};

struct XrSceneBoundsMSFT
{
    XrSpace space;
    XrTime time;
    uint32_t sphereCount;
    const XrSceneSphereBoundMSFT *spheres;
    uint32_t boxCount;
    const XrSceneOrientedBoxBoundMSFT *boxes;
    uint32_t frustumCount;
    const XrSceneFrustumBoundMSFT *frustums;
};

struct XrSessionCreateInfoOverlayEXTX
{
    XrStructureType type;
    const void *next;
    XrOverlaySessionCreateFlagsEXTX createFlags;
    uint32_t sessionLayersPlacement;
};

struct XrViewConfigurationViewFovEPIC
{
    XrStructureType type;
    const void *next;
    XrFovf recommendedFov;
    XrFovf maxMutableFov;
};

struct XrGraphicsRequirementsVulkanKHR
{
    XrStructureType type;
    void *next;
    XrVersion minApiVersionSupported;
    XrVersion maxApiVersionSupported;
};

struct XrNewSceneComputeInfoMSFT
{
    XrStructureType type;
    const void *next;
    uint32_t requestedFeatureCount;
    const XrSceneComputeFeatureMSFT *requestedFeatures;
    XrSceneComputeConsistencyMSFT consistency;
    XrSceneBoundsMSFT bounds;
};

struct XrSwapchainSubImage
{
    XrSwapchain swapchain;
    XrRect2Di imageRect;
    uint32_t imageArrayIndex;
};

struct XrCompositionLayerCylinderKHR
{
    XrStructureType type;
    const void *next;
    XrCompositionLayerFlags layerFlags;
    XrSpace space;
    XrEyeVisibility eyeVisibility;
    XrSwapchainSubImage subImage;
    XrPosef pose;
    float radius;
    float centralAngle;
    float aspectRatio;
};

struct XrCompositionLayerEquirect2KHR
{
    XrStructureType type;
    const void *next;
    XrCompositionLayerFlags layerFlags;
    XrSpace space;
    XrEyeVisibility eyeVisibility;
    XrSwapchainSubImage subImage;
    XrPosef pose;
    float radius;
    float centralHorizontalAngle;
    float upperVerticalAngle;
    float lowerVerticalAngle;
};

struct XrCompositionLayerProjectionView
{
    XrStructureType type;
    const void *next;
    XrPosef pose;
    XrFovf fov;
    XrSwapchainSubImage subImage;
};

struct XrCompositionLayerSpaceWarpInfoFB
{
    XrStructureType type;
    const void *next;
    XrCompositionLayerSpaceWarpInfoFlagsFB layerFlags;
    XrSwapchainSubImage motionVectorSubImage;
    XrPosef appSpaceDeltaPose;
    XrSwapchainSubImage depthSubImage;
    float minDepth;
    float maxDepth;
    float nearZ;
    float farZ;
};

struct XrSceneObjectsMSFT
{
    XrStructureType type;
    void *next;
    uint32_t sceneObjectCount;
    XrSceneObjectMSFT *sceneObjects;
};

struct XrCompositionLayerDepthInfoKHR
{
    XrStructureType type;
    const void *next;
    XrSwapchainSubImage subImage;
    float minDepth;
    float maxDepth;
    float nearZ;
    float farZ;
};

struct XrCompositionLayerProjection
{
    XrStructureType type;
    const void *next;
    XrCompositionLayerFlags layerFlags;
    XrSpace space;
    uint32_t viewCount;
    const XrCompositionLayerProjectionView *views;
};

struct XrCompositionLayerEquirectKHR
{
    XrStructureType type;
    const void *next;
    XrCompositionLayerFlags layerFlags;
    XrSpace space;
    XrEyeVisibility eyeVisibility;
    XrSwapchainSubImage subImage;
    XrPosef pose;
    float radius;
    XrVector2f scale;
    XrVector2f bias;
};

struct XrCompositionLayerQuad
{
    XrStructureType type;
    const void *next;
    XrCompositionLayerFlags layerFlags;
    XrSpace space;
    XrEyeVisibility eyeVisibility;
    XrSwapchainSubImage subImage;
    XrPosef pose;
    XrExtent2Df size;
};

typedef XrResult (XRAPI_PTR *PFN_xrAcquireSwapchainImage)(XrSwapchain, const XrSwapchainImageAcquireInfo *, uint32_t *);
typedef XrResult (XRAPI_PTR *PFN_xrApplyHapticFeedback)(XrSession, const XrHapticActionInfo *, const XrHapticBaseHeader *);
typedef XrResult (XRAPI_PTR *PFN_xrAttachSessionActionSets)(XrSession, const XrSessionActionSetsAttachInfo *);
typedef XrResult (XRAPI_PTR *PFN_xrBeginFrame)(XrSession, const XrFrameBeginInfo *);
typedef XrResult (XRAPI_PTR *PFN_xrBeginSession)(XrSession, const XrSessionBeginInfo *);
typedef XrResult (XRAPI_PTR *PFN_xrClearSpatialAnchorStoreMSFT)(XrSpatialAnchorStoreConnectionMSFT);
typedef XrResult (XRAPI_PTR *PFN_xrComputeNewSceneMSFT)(XrSceneObserverMSFT, const XrNewSceneComputeInfoMSFT *);
typedef XrResult (XRAPI_PTR *PFN_xrConvertTimeToWin32PerformanceCounterKHR)(XrInstance, XrTime, LARGE_INTEGER *);
typedef XrResult (XRAPI_PTR *PFN_xrConvertWin32PerformanceCounterToTimeKHR)(XrInstance, const LARGE_INTEGER *, XrTime *);
typedef XrResult (XRAPI_PTR *PFN_xrCreateAction)(XrActionSet, const XrActionCreateInfo *, XrAction *);
typedef XrResult (XRAPI_PTR *PFN_xrCreateActionSet)(XrInstance, const XrActionSetCreateInfo *, XrActionSet *);
typedef XrResult (XRAPI_PTR *PFN_xrCreateActionSpace)(XrSession, const XrActionSpaceCreateInfo *, XrSpace *);
typedef XrResult (XRAPI_PTR *PFN_xrCreateFoveationProfileFB)(XrSession, const XrFoveationProfileCreateInfoFB *, XrFoveationProfileFB *);
typedef XrResult (XRAPI_PTR *PFN_xrCreateGeometryInstanceFB)(XrSession, const XrGeometryInstanceCreateInfoFB *, XrGeometryInstanceFB *);
typedef XrResult (XRAPI_PTR *PFN_xrCreateHandMeshSpaceMSFT)(XrHandTrackerEXT, const XrHandMeshSpaceCreateInfoMSFT *, XrSpace *);
typedef XrResult (XRAPI_PTR *PFN_xrCreateHandTrackerEXT)(XrSession, const XrHandTrackerCreateInfoEXT *, XrHandTrackerEXT *);
typedef XrResult (XRAPI_PTR *PFN_xrCreateInstance)(const XrInstanceCreateInfo *, XrInstance *);
typedef XrResult (XRAPI_PTR *PFN_xrCreateMarkerSpaceVARJO)(XrSession, const XrMarkerSpaceCreateInfoVARJO *, XrSpace *);
typedef XrResult (XRAPI_PTR *PFN_xrCreatePassthroughFB)(XrSession, const XrPassthroughCreateInfoFB *, XrPassthroughFB *);
typedef XrResult (XRAPI_PTR *PFN_xrCreatePassthroughLayerFB)(XrSession, const XrPassthroughLayerCreateInfoFB *, XrPassthroughLayerFB *);
typedef XrResult (XRAPI_PTR *PFN_xrCreateReferenceSpace)(XrSession, const XrReferenceSpaceCreateInfo *, XrSpace *);
typedef XrResult (XRAPI_PTR *PFN_xrCreateSceneMSFT)(XrSceneObserverMSFT, const XrSceneCreateInfoMSFT *, XrSceneMSFT *);
typedef XrResult (XRAPI_PTR *PFN_xrCreateSceneObserverMSFT)(XrSession, const XrSceneObserverCreateInfoMSFT *, XrSceneObserverMSFT *);
typedef XrResult (XRAPI_PTR *PFN_xrCreateSession)(XrInstance, const XrSessionCreateInfo *, XrSession *);
typedef XrResult (XRAPI_PTR *PFN_xrCreateSpatialAnchorFromPersistedNameMSFT)(XrSession, const XrSpatialAnchorFromPersistedAnchorCreateInfoMSFT *, XrSpatialAnchorMSFT *);
typedef XrResult (XRAPI_PTR *PFN_xrCreateSpatialAnchorMSFT)(XrSession, const XrSpatialAnchorCreateInfoMSFT *, XrSpatialAnchorMSFT *);
typedef XrResult (XRAPI_PTR *PFN_xrCreateSpatialAnchorSpaceMSFT)(XrSession, const XrSpatialAnchorSpaceCreateInfoMSFT *, XrSpace *);
typedef XrResult (XRAPI_PTR *PFN_xrCreateSpatialAnchorStoreConnectionMSFT)(XrSession, XrSpatialAnchorStoreConnectionMSFT *);
typedef XrResult (XRAPI_PTR *PFN_xrCreateSpatialGraphNodeSpaceMSFT)(XrSession, const XrSpatialGraphNodeSpaceCreateInfoMSFT *, XrSpace *);
typedef XrResult (XRAPI_PTR *PFN_xrCreateSwapchain)(XrSession, const XrSwapchainCreateInfo *, XrSwapchain *);
typedef XrResult (XRAPI_PTR *PFN_xrCreateTriangleMeshFB)(XrSession, const XrTriangleMeshCreateInfoFB *, XrTriangleMeshFB *);
typedef XrResult (XRAPI_PTR *PFN_xrCreateVulkanDeviceKHR)(XrInstance, const XrVulkanDeviceCreateInfoKHR *, VkDevice *, VkResult *);
typedef XrResult (XRAPI_PTR *PFN_xrCreateVulkanInstanceKHR)(XrInstance, const XrVulkanInstanceCreateInfoKHR *, VkInstance *, VkResult *);
typedef XrResult (XRAPI_PTR *PFN_xrDeserializeSceneMSFT)(XrSceneObserverMSFT, const XrSceneDeserializeInfoMSFT *);
typedef XrResult (XRAPI_PTR *PFN_xrDestroyAction)(XrAction);
typedef XrResult (XRAPI_PTR *PFN_xrDestroyActionSet)(XrActionSet);
typedef XrResult (XRAPI_PTR *PFN_xrDestroyFoveationProfileFB)(XrFoveationProfileFB);
typedef XrResult (XRAPI_PTR *PFN_xrDestroyGeometryInstanceFB)(XrGeometryInstanceFB);
typedef XrResult (XRAPI_PTR *PFN_xrDestroyHandTrackerEXT)(XrHandTrackerEXT);
typedef XrResult (XRAPI_PTR *PFN_xrDestroyInstance)(XrInstance);
typedef XrResult (XRAPI_PTR *PFN_xrDestroyPassthroughFB)(XrPassthroughFB);
typedef XrResult (XRAPI_PTR *PFN_xrDestroyPassthroughLayerFB)(XrPassthroughLayerFB);
typedef XrResult (XRAPI_PTR *PFN_xrDestroySceneMSFT)(XrSceneMSFT);
typedef XrResult (XRAPI_PTR *PFN_xrDestroySceneObserverMSFT)(XrSceneObserverMSFT);
typedef XrResult (XRAPI_PTR *PFN_xrDestroySession)(XrSession);
typedef XrResult (XRAPI_PTR *PFN_xrDestroySpace)(XrSpace);
typedef XrResult (XRAPI_PTR *PFN_xrDestroySpatialAnchorMSFT)(XrSpatialAnchorMSFT);
typedef XrResult (XRAPI_PTR *PFN_xrDestroySpatialAnchorStoreConnectionMSFT)(XrSpatialAnchorStoreConnectionMSFT);
typedef XrResult (XRAPI_PTR *PFN_xrDestroySwapchain)(XrSwapchain);
typedef XrResult (XRAPI_PTR *PFN_xrDestroyTriangleMeshFB)(XrTriangleMeshFB);
typedef XrResult (XRAPI_PTR *PFN_xrEndFrame)(XrSession, const XrFrameEndInfo *);
typedef XrResult (XRAPI_PTR *PFN_xrEndSession)(XrSession);
typedef XrResult (XRAPI_PTR *PFN_xrEnumerateApiLayerProperties)(uint32_t, uint32_t *, XrApiLayerProperties *);
typedef XrResult (XRAPI_PTR *PFN_xrEnumerateBoundSourcesForAction)(XrSession, const XrBoundSourcesForActionEnumerateInfo *, uint32_t, uint32_t *, XrPath *);
typedef XrResult (XRAPI_PTR *PFN_xrEnumerateColorSpacesFB)(XrSession, uint32_t, uint32_t *, XrColorSpaceFB *);
typedef XrResult (XRAPI_PTR *PFN_xrEnumerateDisplayRefreshRatesFB)(XrSession, uint32_t, uint32_t *, float *);
typedef XrResult (XRAPI_PTR *PFN_xrEnumerateEnvironmentBlendModes)(XrInstance, XrSystemId, XrViewConfigurationType, uint32_t, uint32_t *, XrEnvironmentBlendMode *);
typedef XrResult (XRAPI_PTR *PFN_xrEnumerateInstanceExtensionProperties)(const char *, uint32_t, uint32_t *, XrExtensionProperties *);
typedef XrResult (XRAPI_PTR *PFN_xrEnumeratePersistedSpatialAnchorNamesMSFT)(XrSpatialAnchorStoreConnectionMSFT, uint32_t, uint32_t *, XrSpatialAnchorPersistenceNameMSFT *);
typedef XrResult (XRAPI_PTR *PFN_xrEnumerateReferenceSpaces)(XrSession, uint32_t, uint32_t *, XrReferenceSpaceType *);
typedef XrResult (XRAPI_PTR *PFN_xrEnumerateReprojectionModesMSFT)(XrInstance, XrSystemId, XrViewConfigurationType, uint32_t, uint32_t *, XrReprojectionModeMSFT *);
typedef XrResult (XRAPI_PTR *PFN_xrEnumerateSceneComputeFeaturesMSFT)(XrInstance, XrSystemId, uint32_t, uint32_t *, XrSceneComputeFeatureMSFT *);
typedef XrResult (XRAPI_PTR *PFN_xrEnumerateSwapchainFormats)(XrSession, uint32_t, uint32_t *, int64_t *);
typedef XrResult (XRAPI_PTR *PFN_xrEnumerateSwapchainImages)(XrSwapchain, uint32_t, uint32_t *, XrSwapchainImageBaseHeader *);
typedef XrResult (XRAPI_PTR *PFN_xrEnumerateViewConfigurationViews)(XrInstance, XrSystemId, XrViewConfigurationType, uint32_t, uint32_t *, XrViewConfigurationView *);
typedef XrResult (XRAPI_PTR *PFN_xrEnumerateViewConfigurations)(XrInstance, XrSystemId, uint32_t, uint32_t *, XrViewConfigurationType *);
typedef XrResult (XRAPI_PTR *PFN_xrEnumerateViveTrackerPathsHTCX)(XrInstance, uint32_t, uint32_t *, XrViveTrackerPathsHTCX *);
typedef XrResult (XRAPI_PTR *PFN_xrGeometryInstanceSetTransformFB)(XrGeometryInstanceFB, const XrGeometryInstanceTransformFB *);
typedef XrResult (XRAPI_PTR *PFN_xrGetActionStateBoolean)(XrSession, const XrActionStateGetInfo *, XrActionStateBoolean *);
typedef XrResult (XRAPI_PTR *PFN_xrGetActionStateFloat)(XrSession, const XrActionStateGetInfo *, XrActionStateFloat *);
typedef XrResult (XRAPI_PTR *PFN_xrGetActionStatePose)(XrSession, const XrActionStateGetInfo *, XrActionStatePose *);
typedef XrResult (XRAPI_PTR *PFN_xrGetActionStateVector2f)(XrSession, const XrActionStateGetInfo *, XrActionStateVector2f *);
typedef XrResult (XRAPI_PTR *PFN_xrGetAudioInputDeviceGuidOculus)(XrInstance, wchar_t[]);
typedef XrResult (XRAPI_PTR *PFN_xrGetAudioOutputDeviceGuidOculus)(XrInstance, wchar_t[]);
typedef XrResult (XRAPI_PTR *PFN_xrGetControllerModelKeyMSFT)(XrSession, XrPath, XrControllerModelKeyStateMSFT *);
typedef XrResult (XRAPI_PTR *PFN_xrGetControllerModelPropertiesMSFT)(XrSession, XrControllerModelKeyMSFT, XrControllerModelPropertiesMSFT *);
typedef XrResult (XRAPI_PTR *PFN_xrGetControllerModelStateMSFT)(XrSession, XrControllerModelKeyMSFT, XrControllerModelStateMSFT *);
typedef XrResult (XRAPI_PTR *PFN_xrGetCurrentInteractionProfile)(XrSession, XrPath, XrInteractionProfileState *);
typedef XrResult (XRAPI_PTR *PFN_xrGetD3D11GraphicsRequirementsKHR)(XrInstance, XrSystemId, XrGraphicsRequirementsD3D11KHR *);
typedef XrResult (XRAPI_PTR *PFN_xrGetD3D12GraphicsRequirementsKHR)(XrInstance, XrSystemId, XrGraphicsRequirementsD3D12KHR *);
typedef XrResult (XRAPI_PTR *PFN_xrGetDisplayRefreshRateFB)(XrSession, float *);
typedef XrResult (XRAPI_PTR *PFN_xrGetHandMeshFB)(XrHandTrackerEXT, XrHandTrackingMeshFB *);
typedef XrResult (XRAPI_PTR *PFN_xrGetInputSourceLocalizedName)(XrSession, const XrInputSourceLocalizedNameGetInfo *, uint32_t, uint32_t *, char *);
typedef XrResult (XRAPI_PTR *PFN_xrGetInstanceProcAddr)(XrInstance, const char *, PFN_xrVoidFunction *);
typedef XrResult (XRAPI_PTR *PFN_xrGetInstanceProperties)(XrInstance, XrInstanceProperties *);
typedef XrResult (XRAPI_PTR *PFN_xrGetMarkerSizeVARJO)(XrSession, uint64_t, XrExtent2Df *);
typedef XrResult (XRAPI_PTR *PFN_xrGetOpenGLGraphicsRequirementsKHR)(XrInstance, XrSystemId, XrGraphicsRequirementsOpenGLKHR *);
typedef XrResult (XRAPI_PTR *PFN_xrGetReferenceSpaceBoundsRect)(XrSession, XrReferenceSpaceType, XrExtent2Df *);
typedef XrResult (XRAPI_PTR *PFN_xrGetSceneComponentsMSFT)(XrSceneMSFT, const XrSceneComponentsGetInfoMSFT *, XrSceneComponentsMSFT *);
typedef XrResult (XRAPI_PTR *PFN_xrGetSceneComputeStateMSFT)(XrSceneObserverMSFT, XrSceneComputeStateMSFT *);
typedef XrResult (XRAPI_PTR *PFN_xrGetSceneMeshBuffersMSFT)(XrSceneMSFT, const XrSceneMeshBuffersGetInfoMSFT *, XrSceneMeshBuffersMSFT *);
typedef XrResult (XRAPI_PTR *PFN_xrGetSerializedSceneFragmentDataMSFT)(XrSceneMSFT, const XrSerializedSceneFragmentDataGetInfoMSFT *, uint32_t, uint32_t *, uint8_t *);
typedef XrResult (XRAPI_PTR *PFN_xrGetSwapchainStateFB)(XrSwapchain, XrSwapchainStateBaseHeaderFB *);
typedef XrResult (XRAPI_PTR *PFN_xrGetSystem)(XrInstance, const XrSystemGetInfo *, XrSystemId *);
typedef XrResult (XRAPI_PTR *PFN_xrGetSystemProperties)(XrInstance, XrSystemId, XrSystemProperties *);
typedef XrResult (XRAPI_PTR *PFN_xrGetViewConfigurationProperties)(XrInstance, XrSystemId, XrViewConfigurationType, XrViewConfigurationProperties *);
typedef XrResult (XRAPI_PTR *PFN_xrGetVisibilityMaskKHR)(XrSession, XrViewConfigurationType, uint32_t, XrVisibilityMaskTypeKHR, XrVisibilityMaskKHR *);
typedef XrResult (XRAPI_PTR *PFN_xrGetVulkanDeviceExtensionsKHR)(XrInstance, XrSystemId, uint32_t, uint32_t *, char *);
typedef XrResult (XRAPI_PTR *PFN_xrGetVulkanGraphicsDevice2KHR)(XrInstance, const XrVulkanGraphicsDeviceGetInfoKHR *, VkPhysicalDevice *);
typedef XrResult (XRAPI_PTR *PFN_xrGetVulkanGraphicsDeviceKHR)(XrInstance, XrSystemId, VkInstance, VkPhysicalDevice *);
typedef XrResult (XRAPI_PTR *PFN_xrGetVulkanGraphicsRequirements2KHR)(XrInstance, XrSystemId, XrGraphicsRequirementsVulkanKHR *);
typedef XrResult (XRAPI_PTR *PFN_xrGetVulkanGraphicsRequirementsKHR)(XrInstance, XrSystemId, XrGraphicsRequirementsVulkanKHR *);
typedef XrResult (XRAPI_PTR *PFN_xrGetVulkanInstanceExtensionsKHR)(XrInstance, XrSystemId, uint32_t, uint32_t *, char *);
typedef XrResult (XRAPI_PTR *PFN_xrLoadControllerModelMSFT)(XrSession, XrControllerModelKeyMSFT, uint32_t, uint32_t *, uint8_t *);
typedef XrResult (XRAPI_PTR *PFN_xrLocateHandJointsEXT)(XrHandTrackerEXT, const XrHandJointsLocateInfoEXT *, XrHandJointLocationsEXT *);
typedef XrResult (XRAPI_PTR *PFN_xrLocateSceneComponentsMSFT)(XrSceneMSFT, const XrSceneComponentsLocateInfoMSFT *, XrSceneComponentLocationsMSFT *);
typedef XrResult (XRAPI_PTR *PFN_xrLocateSpace)(XrSpace, XrSpace, XrTime, XrSpaceLocation *);
typedef XrResult (XRAPI_PTR *PFN_xrLocateViews)(XrSession, const XrViewLocateInfo *, XrViewState *, uint32_t, uint32_t *, XrView *);
typedef XrResult (XRAPI_PTR *PFN_xrPassthroughLayerPauseFB)(XrPassthroughLayerFB);
typedef XrResult (XRAPI_PTR *PFN_xrPassthroughLayerResumeFB)(XrPassthroughLayerFB);
typedef XrResult (XRAPI_PTR *PFN_xrPassthroughLayerSetStyleFB)(XrPassthroughLayerFB, const XrPassthroughStyleFB *);
typedef XrResult (XRAPI_PTR *PFN_xrPassthroughPauseFB)(XrPassthroughFB);
typedef XrResult (XRAPI_PTR *PFN_xrPassthroughStartFB)(XrPassthroughFB);
typedef XrResult (XRAPI_PTR *PFN_xrPathToString)(XrInstance, XrPath, uint32_t, uint32_t *, char *);
typedef XrResult (XRAPI_PTR *PFN_xrPerfSettingsSetPerformanceLevelEXT)(XrSession, XrPerfSettingsDomainEXT, XrPerfSettingsLevelEXT);
typedef XrResult (XRAPI_PTR *PFN_xrPersistSpatialAnchorMSFT)(XrSpatialAnchorStoreConnectionMSFT, const XrSpatialAnchorPersistenceInfoMSFT *);
typedef XrResult (XRAPI_PTR *PFN_xrPollEvent)(XrInstance, XrEventDataBuffer *);
typedef XrResult (XRAPI_PTR *PFN_xrReleaseSwapchainImage)(XrSwapchain, const XrSwapchainImageReleaseInfo *);
typedef XrResult (XRAPI_PTR *PFN_xrRequestDisplayRefreshRateFB)(XrSession, float);
typedef XrResult (XRAPI_PTR *PFN_xrRequestExitSession)(XrSession);
typedef XrResult (XRAPI_PTR *PFN_xrResultToString)(XrInstance, XrResult, char[]);
typedef XrResult (XRAPI_PTR *PFN_xrSetColorSpaceFB)(XrSession, const XrColorSpaceFB);
typedef XrResult (XRAPI_PTR *PFN_xrSetEnvironmentDepthEstimationVARJO)(XrSession, XrBool32);
typedef XrResult (XRAPI_PTR *PFN_xrSetInputDeviceActiveEXT)(XrSession, XrPath, XrPath, XrBool32);
typedef XrResult (XRAPI_PTR *PFN_xrSetInputDeviceLocationEXT)(XrSession, XrPath, XrPath, XrSpace, XrPosef);
typedef XrResult (XRAPI_PTR *PFN_xrSetInputDeviceStateBoolEXT)(XrSession, XrPath, XrPath, XrBool32);
typedef XrResult (XRAPI_PTR *PFN_xrSetInputDeviceStateFloatEXT)(XrSession, XrPath, XrPath, float);
typedef XrResult (XRAPI_PTR *PFN_xrSetInputDeviceStateVector2fEXT)(XrSession, XrPath, XrPath, XrVector2f);
typedef XrResult (XRAPI_PTR *PFN_xrSetMarkerTrackingPredictionVARJO)(XrSession, uint64_t, XrBool32);
typedef XrResult (XRAPI_PTR *PFN_xrSetMarkerTrackingTimeoutVARJO)(XrSession, uint64_t, XrDuration);
typedef XrResult (XRAPI_PTR *PFN_xrSetMarkerTrackingVARJO)(XrSession, XrBool32);
typedef XrResult (XRAPI_PTR *PFN_xrStopHapticFeedback)(XrSession, const XrHapticActionInfo *);
typedef XrResult (XRAPI_PTR *PFN_xrStringToPath)(XrInstance, const char *, XrPath *);
typedef XrResult (XRAPI_PTR *PFN_xrStructureTypeToString)(XrInstance, XrStructureType, char[]);
typedef XrResult (XRAPI_PTR *PFN_xrSuggestInteractionProfileBindings)(XrInstance, const XrInteractionProfileSuggestedBinding *);
typedef XrResult (XRAPI_PTR *PFN_xrSyncActions)(XrSession, const XrActionsSyncInfo *);
typedef XrResult (XRAPI_PTR *PFN_xrThermalGetTemperatureTrendEXT)(XrSession, XrPerfSettingsDomainEXT, XrPerfSettingsNotificationLevelEXT *, float *, float *);
typedef XrResult (XRAPI_PTR *PFN_xrTriangleMeshBeginUpdateFB)(XrTriangleMeshFB);
typedef XrResult (XRAPI_PTR *PFN_xrTriangleMeshBeginVertexBufferUpdateFB)(XrTriangleMeshFB, uint32_t *);
typedef XrResult (XRAPI_PTR *PFN_xrTriangleMeshEndUpdateFB)(XrTriangleMeshFB, uint32_t, uint32_t);
typedef XrResult (XRAPI_PTR *PFN_xrTriangleMeshEndVertexBufferUpdateFB)(XrTriangleMeshFB);
typedef XrResult (XRAPI_PTR *PFN_xrTriangleMeshGetIndexBufferFB)(XrTriangleMeshFB, uint32_t **);
typedef XrResult (XRAPI_PTR *PFN_xrTriangleMeshGetVertexBufferFB)(XrTriangleMeshFB, XrVector3f **);
typedef XrResult (XRAPI_PTR *PFN_xrUnpersistSpatialAnchorMSFT)(XrSpatialAnchorStoreConnectionMSFT, const XrSpatialAnchorPersistenceNameMSFT *);
typedef XrResult (XRAPI_PTR *PFN_xrUpdateHandMeshMSFT)(XrHandTrackerEXT, const XrHandMeshUpdateInfoMSFT *, XrHandMeshMSFT *);
typedef XrResult (XRAPI_PTR *PFN_xrUpdateSwapchainFB)(XrSwapchain, const XrSwapchainStateBaseHeaderFB *);
typedef XrResult (XRAPI_PTR *PFN_xrWaitFrame)(XrSession, const XrFrameWaitInfo *, XrFrameState *);
typedef XrResult (XRAPI_PTR *PFN_xrWaitSwapchainImage)(XrSwapchain, const XrSwapchainImageWaitInfo *);

#ifndef XR_NO_PROTOTYPES
XrResult XRAPI_CALL xrAcquireSwapchainImage(XrSwapchain swapchain, const XrSwapchainImageAcquireInfo *acquireInfo, uint32_t *index);
XrResult XRAPI_CALL xrApplyHapticFeedback(XrSession session, const XrHapticActionInfo *hapticActionInfo, const XrHapticBaseHeader *hapticFeedback);
XrResult XRAPI_CALL xrAttachSessionActionSets(XrSession session, const XrSessionActionSetsAttachInfo *attachInfo);
XrResult XRAPI_CALL xrBeginFrame(XrSession session, const XrFrameBeginInfo *frameBeginInfo);
XrResult XRAPI_CALL xrBeginSession(XrSession session, const XrSessionBeginInfo *beginInfo);
XrResult XRAPI_CALL xrClearSpatialAnchorStoreMSFT(XrSpatialAnchorStoreConnectionMSFT spatialAnchorStore);
XrResult XRAPI_CALL xrComputeNewSceneMSFT(XrSceneObserverMSFT sceneObserver, const XrNewSceneComputeInfoMSFT *computeInfo);
XrResult XRAPI_CALL xrConvertTimeToWin32PerformanceCounterKHR(XrInstance instance, XrTime time, LARGE_INTEGER *performanceCounter);
XrResult XRAPI_CALL xrConvertWin32PerformanceCounterToTimeKHR(XrInstance instance, const LARGE_INTEGER *performanceCounter, XrTime *time);
XrResult XRAPI_CALL xrCreateAction(XrActionSet actionSet, const XrActionCreateInfo *createInfo, XrAction *action);
XrResult XRAPI_CALL xrCreateActionSet(XrInstance instance, const XrActionSetCreateInfo *createInfo, XrActionSet *actionSet);
XrResult XRAPI_CALL xrCreateActionSpace(XrSession session, const XrActionSpaceCreateInfo *createInfo, XrSpace *space);
XrResult XRAPI_CALL xrCreateFoveationProfileFB(XrSession session, const XrFoveationProfileCreateInfoFB *createInfo, XrFoveationProfileFB *profile);
XrResult XRAPI_CALL xrCreateGeometryInstanceFB(XrSession session, const XrGeometryInstanceCreateInfoFB *createInfo, XrGeometryInstanceFB *outGeometryInstance);
XrResult XRAPI_CALL xrCreateHandMeshSpaceMSFT(XrHandTrackerEXT handTracker, const XrHandMeshSpaceCreateInfoMSFT *createInfo, XrSpace *space);
XrResult XRAPI_CALL xrCreateHandTrackerEXT(XrSession session, const XrHandTrackerCreateInfoEXT *createInfo, XrHandTrackerEXT *handTracker);
XrResult XRAPI_CALL xrCreateInstance(const XrInstanceCreateInfo *createInfo, XrInstance *instance);
XrResult XRAPI_CALL xrCreateMarkerSpaceVARJO(XrSession session, const XrMarkerSpaceCreateInfoVARJO *createInfo, XrSpace *space);
XrResult XRAPI_CALL xrCreatePassthroughFB(XrSession session, const XrPassthroughCreateInfoFB *createInfo, XrPassthroughFB *outPassthrough);
XrResult XRAPI_CALL xrCreatePassthroughLayerFB(XrSession session, const XrPassthroughLayerCreateInfoFB *createInfo, XrPassthroughLayerFB *outLayer);
XrResult XRAPI_CALL xrCreateReferenceSpace(XrSession session, const XrReferenceSpaceCreateInfo *createInfo, XrSpace *space);
XrResult XRAPI_CALL xrCreateSceneMSFT(XrSceneObserverMSFT sceneObserver, const XrSceneCreateInfoMSFT *createInfo, XrSceneMSFT *scene);
XrResult XRAPI_CALL xrCreateSceneObserverMSFT(XrSession session, const XrSceneObserverCreateInfoMSFT *createInfo, XrSceneObserverMSFT *sceneObserver);
XrResult XRAPI_CALL xrCreateSession(XrInstance instance, const XrSessionCreateInfo *createInfo, XrSession *session);
XrResult XRAPI_CALL xrCreateSpatialAnchorFromPersistedNameMSFT(XrSession session, const XrSpatialAnchorFromPersistedAnchorCreateInfoMSFT *spatialAnchorCreateInfo, XrSpatialAnchorMSFT *spatialAnchor);
XrResult XRAPI_CALL xrCreateSpatialAnchorMSFT(XrSession session, const XrSpatialAnchorCreateInfoMSFT *createInfo, XrSpatialAnchorMSFT *anchor);
XrResult XRAPI_CALL xrCreateSpatialAnchorSpaceMSFT(XrSession session, const XrSpatialAnchorSpaceCreateInfoMSFT *createInfo, XrSpace *space);
XrResult XRAPI_CALL xrCreateSpatialAnchorStoreConnectionMSFT(XrSession session, XrSpatialAnchorStoreConnectionMSFT *spatialAnchorStore);
XrResult XRAPI_CALL xrCreateSpatialGraphNodeSpaceMSFT(XrSession session, const XrSpatialGraphNodeSpaceCreateInfoMSFT *createInfo, XrSpace *space);
XrResult XRAPI_CALL xrCreateSwapchain(XrSession session, const XrSwapchainCreateInfo *createInfo, XrSwapchain *swapchain);
XrResult XRAPI_CALL xrCreateTriangleMeshFB(XrSession session, const XrTriangleMeshCreateInfoFB *createInfo, XrTriangleMeshFB *outTriangleMesh);
XrResult XRAPI_CALL xrCreateVulkanDeviceKHR(XrInstance instance, const XrVulkanDeviceCreateInfoKHR *createInfo, VkDevice *vulkanDevice, VkResult *vulkanResult);
XrResult XRAPI_CALL xrCreateVulkanInstanceKHR(XrInstance instance, const XrVulkanInstanceCreateInfoKHR *createInfo, VkInstance *vulkanInstance, VkResult *vulkanResult);
XrResult XRAPI_CALL xrDeserializeSceneMSFT(XrSceneObserverMSFT sceneObserver, const XrSceneDeserializeInfoMSFT *deserializeInfo);
XrResult XRAPI_CALL xrDestroyAction(XrAction action);
XrResult XRAPI_CALL xrDestroyActionSet(XrActionSet actionSet);
XrResult XRAPI_CALL xrDestroyFoveationProfileFB(XrFoveationProfileFB profile);
XrResult XRAPI_CALL xrDestroyGeometryInstanceFB(XrGeometryInstanceFB instance);
XrResult XRAPI_CALL xrDestroyHandTrackerEXT(XrHandTrackerEXT handTracker);
XrResult XRAPI_CALL xrDestroyInstance(XrInstance instance);
XrResult XRAPI_CALL xrDestroyPassthroughFB(XrPassthroughFB passthrough);
XrResult XRAPI_CALL xrDestroyPassthroughLayerFB(XrPassthroughLayerFB layer);
XrResult XRAPI_CALL xrDestroySceneMSFT(XrSceneMSFT scene);
XrResult XRAPI_CALL xrDestroySceneObserverMSFT(XrSceneObserverMSFT sceneObserver);
XrResult XRAPI_CALL xrDestroySession(XrSession session);
XrResult XRAPI_CALL xrDestroySpace(XrSpace space);
XrResult XRAPI_CALL xrDestroySpatialAnchorMSFT(XrSpatialAnchorMSFT anchor);
XrResult XRAPI_CALL xrDestroySpatialAnchorStoreConnectionMSFT(XrSpatialAnchorStoreConnectionMSFT spatialAnchorStore);
XrResult XRAPI_CALL xrDestroySwapchain(XrSwapchain swapchain);
XrResult XRAPI_CALL xrDestroyTriangleMeshFB(XrTriangleMeshFB mesh);
XrResult XRAPI_CALL xrEndFrame(XrSession session, const XrFrameEndInfo *frameEndInfo);
XrResult XRAPI_CALL xrEndSession(XrSession session);
XrResult XRAPI_CALL xrEnumerateApiLayerProperties(uint32_t propertyCapacityInput, uint32_t *propertyCountOutput, XrApiLayerProperties *properties);
XrResult XRAPI_CALL xrEnumerateBoundSourcesForAction(XrSession session, const XrBoundSourcesForActionEnumerateInfo *enumerateInfo, uint32_t sourceCapacityInput, uint32_t *sourceCountOutput, XrPath *sources);
XrResult XRAPI_CALL xrEnumerateColorSpacesFB(XrSession session, uint32_t colorSpaceCapacityInput, uint32_t *colorSpaceCountOutput, XrColorSpaceFB *colorSpaces);
XrResult XRAPI_CALL xrEnumerateDisplayRefreshRatesFB(XrSession session, uint32_t displayRefreshRateCapacityInput, uint32_t *displayRefreshRateCountOutput, float *displayRefreshRates);
XrResult XRAPI_CALL xrEnumerateEnvironmentBlendModes(XrInstance instance, XrSystemId systemId, XrViewConfigurationType viewConfigurationType, uint32_t environmentBlendModeCapacityInput, uint32_t *environmentBlendModeCountOutput, XrEnvironmentBlendMode *environmentBlendModes);
XrResult XRAPI_CALL xrEnumerateInstanceExtensionProperties(const char *layerName, uint32_t propertyCapacityInput, uint32_t *propertyCountOutput, XrExtensionProperties *properties);
XrResult XRAPI_CALL xrEnumeratePersistedSpatialAnchorNamesMSFT(XrSpatialAnchorStoreConnectionMSFT spatialAnchorStore, uint32_t spatialAnchorNamesCapacityInput, uint32_t *spatialAnchorNamesCountOutput, XrSpatialAnchorPersistenceNameMSFT *persistedAnchorNames);
XrResult XRAPI_CALL xrEnumerateReferenceSpaces(XrSession session, uint32_t spaceCapacityInput, uint32_t *spaceCountOutput, XrReferenceSpaceType *spaces);
XrResult XRAPI_CALL xrEnumerateReprojectionModesMSFT(XrInstance instance, XrSystemId systemId, XrViewConfigurationType viewConfigurationType, uint32_t modeCapacityInput, uint32_t *modeCountOutput, XrReprojectionModeMSFT *modes);
XrResult XRAPI_CALL xrEnumerateSceneComputeFeaturesMSFT(XrInstance instance, XrSystemId systemId, uint32_t featureCapacityInput, uint32_t *featureCountOutput, XrSceneComputeFeatureMSFT *features);
XrResult XRAPI_CALL xrEnumerateSwapchainFormats(XrSession session, uint32_t formatCapacityInput, uint32_t *formatCountOutput, int64_t *formats);
XrResult XRAPI_CALL xrEnumerateSwapchainImages(XrSwapchain swapchain, uint32_t imageCapacityInput, uint32_t *imageCountOutput, XrSwapchainImageBaseHeader *images);
XrResult XRAPI_CALL xrEnumerateViewConfigurationViews(XrInstance instance, XrSystemId systemId, XrViewConfigurationType viewConfigurationType, uint32_t viewCapacityInput, uint32_t *viewCountOutput, XrViewConfigurationView *views);
XrResult XRAPI_CALL xrEnumerateViewConfigurations(XrInstance instance, XrSystemId systemId, uint32_t viewConfigurationTypeCapacityInput, uint32_t *viewConfigurationTypeCountOutput, XrViewConfigurationType *viewConfigurationTypes);
XrResult XRAPI_CALL xrEnumerateViveTrackerPathsHTCX(XrInstance instance, uint32_t pathCapacityInput, uint32_t *pathCountOutput, XrViveTrackerPathsHTCX *paths);
XrResult XRAPI_CALL xrGeometryInstanceSetTransformFB(XrGeometryInstanceFB instance, const XrGeometryInstanceTransformFB *transformation);
XrResult XRAPI_CALL xrGetActionStateBoolean(XrSession session, const XrActionStateGetInfo *getInfo, XrActionStateBoolean *state);
XrResult XRAPI_CALL xrGetActionStateFloat(XrSession session, const XrActionStateGetInfo *getInfo, XrActionStateFloat *state);
XrResult XRAPI_CALL xrGetActionStatePose(XrSession session, const XrActionStateGetInfo *getInfo, XrActionStatePose *state);
XrResult XRAPI_CALL xrGetActionStateVector2f(XrSession session, const XrActionStateGetInfo *getInfo, XrActionStateVector2f *state);
XrResult XRAPI_CALL xrGetAudioInputDeviceGuidOculus(XrInstance instance, wchar_t buffer[]);
XrResult XRAPI_CALL xrGetAudioOutputDeviceGuidOculus(XrInstance instance, wchar_t buffer[]);
XrResult XRAPI_CALL xrGetControllerModelKeyMSFT(XrSession session, XrPath topLevelUserPath, XrControllerModelKeyStateMSFT *controllerModelKeyState);
XrResult XRAPI_CALL xrGetControllerModelPropertiesMSFT(XrSession session, XrControllerModelKeyMSFT modelKey, XrControllerModelPropertiesMSFT *properties);
XrResult XRAPI_CALL xrGetControllerModelStateMSFT(XrSession session, XrControllerModelKeyMSFT modelKey, XrControllerModelStateMSFT *state);
XrResult XRAPI_CALL xrGetCurrentInteractionProfile(XrSession session, XrPath topLevelUserPath, XrInteractionProfileState *interactionProfile);
XrResult XRAPI_CALL xrGetD3D11GraphicsRequirementsKHR(XrInstance instance, XrSystemId systemId, XrGraphicsRequirementsD3D11KHR *graphicsRequirements);
XrResult XRAPI_CALL xrGetD3D12GraphicsRequirementsKHR(XrInstance instance, XrSystemId systemId, XrGraphicsRequirementsD3D12KHR *graphicsRequirements);
XrResult XRAPI_CALL xrGetDisplayRefreshRateFB(XrSession session, float *displayRefreshRate);
XrResult XRAPI_CALL xrGetHandMeshFB(XrHandTrackerEXT handTracker, XrHandTrackingMeshFB *mesh);
XrResult XRAPI_CALL xrGetInputSourceLocalizedName(XrSession session, const XrInputSourceLocalizedNameGetInfo *getInfo, uint32_t bufferCapacityInput, uint32_t *bufferCountOutput, char *buffer);
XrResult XRAPI_CALL xrGetInstanceProcAddr(XrInstance instance, const char *name, PFN_xrVoidFunction *function);
XrResult XRAPI_CALL xrGetInstanceProperties(XrInstance instance, XrInstanceProperties *instanceProperties);
XrResult XRAPI_CALL xrGetMarkerSizeVARJO(XrSession session, uint64_t markerId, XrExtent2Df *size);
XrResult XRAPI_CALL xrGetOpenGLGraphicsRequirementsKHR(XrInstance instance, XrSystemId systemId, XrGraphicsRequirementsOpenGLKHR *graphicsRequirements);
XrResult XRAPI_CALL xrGetReferenceSpaceBoundsRect(XrSession session, XrReferenceSpaceType referenceSpaceType, XrExtent2Df *bounds);
XrResult XRAPI_CALL xrGetSceneComponentsMSFT(XrSceneMSFT scene, const XrSceneComponentsGetInfoMSFT *getInfo, XrSceneComponentsMSFT *components);
XrResult XRAPI_CALL xrGetSceneComputeStateMSFT(XrSceneObserverMSFT sceneObserver, XrSceneComputeStateMSFT *state);
XrResult XRAPI_CALL xrGetSceneMeshBuffersMSFT(XrSceneMSFT scene, const XrSceneMeshBuffersGetInfoMSFT *getInfo, XrSceneMeshBuffersMSFT *buffers);
XrResult XRAPI_CALL xrGetSerializedSceneFragmentDataMSFT(XrSceneMSFT scene, const XrSerializedSceneFragmentDataGetInfoMSFT *getInfo, uint32_t countInput, uint32_t *readOutput, uint8_t *buffer);
XrResult XRAPI_CALL xrGetSwapchainStateFB(XrSwapchain swapchain, XrSwapchainStateBaseHeaderFB *state);
XrResult XRAPI_CALL xrGetSystem(XrInstance instance, const XrSystemGetInfo *getInfo, XrSystemId *systemId);
XrResult XRAPI_CALL xrGetSystemProperties(XrInstance instance, XrSystemId systemId, XrSystemProperties *properties);
XrResult XRAPI_CALL xrGetViewConfigurationProperties(XrInstance instance, XrSystemId systemId, XrViewConfigurationType viewConfigurationType, XrViewConfigurationProperties *configurationProperties);
XrResult XRAPI_CALL xrGetVisibilityMaskKHR(XrSession session, XrViewConfigurationType viewConfigurationType, uint32_t viewIndex, XrVisibilityMaskTypeKHR visibilityMaskType, XrVisibilityMaskKHR *visibilityMask);
XrResult XRAPI_CALL xrGetVulkanDeviceExtensionsKHR(XrInstance instance, XrSystemId systemId, uint32_t bufferCapacityInput, uint32_t *bufferCountOutput, char *buffer);
XrResult XRAPI_CALL xrGetVulkanGraphicsDevice2KHR(XrInstance instance, const XrVulkanGraphicsDeviceGetInfoKHR *getInfo, VkPhysicalDevice *vulkanPhysicalDevice);
XrResult XRAPI_CALL xrGetVulkanGraphicsDeviceKHR(XrInstance instance, XrSystemId systemId, VkInstance vkInstance, VkPhysicalDevice *vkPhysicalDevice);
XrResult XRAPI_CALL xrGetVulkanGraphicsRequirements2KHR(XrInstance instance, XrSystemId systemId, XrGraphicsRequirementsVulkanKHR *graphicsRequirements);
XrResult XRAPI_CALL xrGetVulkanGraphicsRequirementsKHR(XrInstance instance, XrSystemId systemId, XrGraphicsRequirementsVulkanKHR *graphicsRequirements);
XrResult XRAPI_CALL xrGetVulkanInstanceExtensionsKHR(XrInstance instance, XrSystemId systemId, uint32_t bufferCapacityInput, uint32_t *bufferCountOutput, char *buffer);
XrResult XRAPI_CALL xrLoadControllerModelMSFT(XrSession session, XrControllerModelKeyMSFT modelKey, uint32_t bufferCapacityInput, uint32_t *bufferCountOutput, uint8_t *buffer);
XrResult XRAPI_CALL xrLocateHandJointsEXT(XrHandTrackerEXT handTracker, const XrHandJointsLocateInfoEXT *locateInfo, XrHandJointLocationsEXT *locations);
XrResult XRAPI_CALL xrLocateSceneComponentsMSFT(XrSceneMSFT scene, const XrSceneComponentsLocateInfoMSFT *locateInfo, XrSceneComponentLocationsMSFT *locations);
XrResult XRAPI_CALL xrLocateSpace(XrSpace space, XrSpace baseSpace, XrTime time, XrSpaceLocation *location);
XrResult XRAPI_CALL xrLocateViews(XrSession session, const XrViewLocateInfo *viewLocateInfo, XrViewState *viewState, uint32_t viewCapacityInput, uint32_t *viewCountOutput, XrView *views);
XrResult XRAPI_CALL xrPassthroughLayerPauseFB(XrPassthroughLayerFB layer);
XrResult XRAPI_CALL xrPassthroughLayerResumeFB(XrPassthroughLayerFB layer);
XrResult XRAPI_CALL xrPassthroughLayerSetStyleFB(XrPassthroughLayerFB layer, const XrPassthroughStyleFB *style);
XrResult XRAPI_CALL xrPassthroughPauseFB(XrPassthroughFB passthrough);
XrResult XRAPI_CALL xrPassthroughStartFB(XrPassthroughFB passthrough);
XrResult XRAPI_CALL xrPathToString(XrInstance instance, XrPath path, uint32_t bufferCapacityInput, uint32_t *bufferCountOutput, char *buffer);
XrResult XRAPI_CALL xrPerfSettingsSetPerformanceLevelEXT(XrSession session, XrPerfSettingsDomainEXT domain, XrPerfSettingsLevelEXT level);
XrResult XRAPI_CALL xrPersistSpatialAnchorMSFT(XrSpatialAnchorStoreConnectionMSFT spatialAnchorStore, const XrSpatialAnchorPersistenceInfoMSFT *spatialAnchorPersistenceInfo);
XrResult XRAPI_CALL xrPollEvent(XrInstance instance, XrEventDataBuffer *eventData);
XrResult XRAPI_CALL xrReleaseSwapchainImage(XrSwapchain swapchain, const XrSwapchainImageReleaseInfo *releaseInfo);
XrResult XRAPI_CALL xrRequestDisplayRefreshRateFB(XrSession session, float displayRefreshRate);
XrResult XRAPI_CALL xrRequestExitSession(XrSession session);
XrResult XRAPI_CALL xrResultToString(XrInstance instance, XrResult value, char buffer[]);
XrResult XRAPI_CALL xrSetColorSpaceFB(XrSession session, const XrColorSpaceFB colorspace);
XrResult XRAPI_CALL xrSetEnvironmentDepthEstimationVARJO(XrSession session, XrBool32 enabled);
XrResult XRAPI_CALL xrSetInputDeviceActiveEXT(XrSession session, XrPath interactionProfile, XrPath topLevelPath, XrBool32 isActive);
XrResult XRAPI_CALL xrSetInputDeviceLocationEXT(XrSession session, XrPath topLevelPath, XrPath inputSourcePath, XrSpace space, XrPosef pose);
XrResult XRAPI_CALL xrSetInputDeviceStateBoolEXT(XrSession session, XrPath topLevelPath, XrPath inputSourcePath, XrBool32 state);
XrResult XRAPI_CALL xrSetInputDeviceStateFloatEXT(XrSession session, XrPath topLevelPath, XrPath inputSourcePath, float state);
XrResult XRAPI_CALL xrSetInputDeviceStateVector2fEXT(XrSession session, XrPath topLevelPath, XrPath inputSourcePath, XrVector2f state);
XrResult XRAPI_CALL xrSetMarkerTrackingPredictionVARJO(XrSession session, uint64_t markerId, XrBool32 enabled);
XrResult XRAPI_CALL xrSetMarkerTrackingTimeoutVARJO(XrSession session, uint64_t markerId, XrDuration timeout);
XrResult XRAPI_CALL xrSetMarkerTrackingVARJO(XrSession session, XrBool32 enabled);
XrResult XRAPI_CALL xrStopHapticFeedback(XrSession session, const XrHapticActionInfo *hapticActionInfo);
XrResult XRAPI_CALL xrStringToPath(XrInstance instance, const char *pathString, XrPath *path);
XrResult XRAPI_CALL xrStructureTypeToString(XrInstance instance, XrStructureType value, char buffer[]);
XrResult XRAPI_CALL xrSuggestInteractionProfileBindings(XrInstance instance, const XrInteractionProfileSuggestedBinding *suggestedBindings);
XrResult XRAPI_CALL xrSyncActions(XrSession session, const XrActionsSyncInfo *syncInfo);
XrResult XRAPI_CALL xrThermalGetTemperatureTrendEXT(XrSession session, XrPerfSettingsDomainEXT domain, XrPerfSettingsNotificationLevelEXT *notificationLevel, float *tempHeadroom, float *tempSlope);
XrResult XRAPI_CALL xrTriangleMeshBeginUpdateFB(XrTriangleMeshFB mesh);
XrResult XRAPI_CALL xrTriangleMeshBeginVertexBufferUpdateFB(XrTriangleMeshFB mesh, uint32_t *outVertexCount);
XrResult XRAPI_CALL xrTriangleMeshEndUpdateFB(XrTriangleMeshFB mesh, uint32_t vertexCount, uint32_t triangleCount);
XrResult XRAPI_CALL xrTriangleMeshEndVertexBufferUpdateFB(XrTriangleMeshFB mesh);
XrResult XRAPI_CALL xrTriangleMeshGetIndexBufferFB(XrTriangleMeshFB mesh, uint32_t **outIndexBuffer);
XrResult XRAPI_CALL xrTriangleMeshGetVertexBufferFB(XrTriangleMeshFB mesh, XrVector3f **outVertexBuffer);
XrResult XRAPI_CALL xrUnpersistSpatialAnchorMSFT(XrSpatialAnchorStoreConnectionMSFT spatialAnchorStore, const XrSpatialAnchorPersistenceNameMSFT *spatialAnchorPersistenceName);
XrResult XRAPI_CALL xrUpdateHandMeshMSFT(XrHandTrackerEXT handTracker, const XrHandMeshUpdateInfoMSFT *updateInfo, XrHandMeshMSFT *handMesh);
XrResult XRAPI_CALL xrUpdateSwapchainFB(XrSwapchain swapchain, const XrSwapchainStateBaseHeaderFB *state);
XrResult XRAPI_CALL xrWaitFrame(XrSession session, const XrFrameWaitInfo *frameWaitInfo, XrFrameState *frameState);
XrResult XRAPI_CALL xrWaitSwapchainImage(XrSwapchain swapchain, const XrSwapchainImageWaitInfo *waitInfo);
#endif /* XR_NO_PROTOTYPES */

#endif /* __WINE_OPENXR_H */
