local require = GLOBAL.require
local SpawnPrefab = GLOBAL.SpawnPrefab
--
require "class"

local Ingredient = GLOBAL.Ingredient
local RECIPETABS = GLOBAL.RECIPETABS
local STRINGS = GLOBAL.STRINGS
local ACTIONS = GLOBAL.ACTIONS
local Action = GLOBAL.Action
        TECH = GLOBAL.TECH

GLOBAL.STRINGS.NAMES.PUMPKIN_PET = "Pumpkin Lord"		
GLOBAL.STRINGS.RECIPE_DESC.PUMPKIN_PET = "Revive the spirit of the pumpkin!"

GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.PUMPKIN_PET = "Fight for me, living pumpkin!"

GLOBAL.STRINGS.CHARACTERS.WILLOW.DESCRIBE.PUMPKIN_PET = "He is strong, but he's easy to burn."

GLOBAL.STRINGS.CHARACTERS.WOLFGANG.DESCRIBE.PUMPKIN_PET = "Not that strong as Wolfgang!"

GLOBAL.STRINGS.CHARACTERS.WENDY.DESCRIBE.PUMPKIN_PET = "I sense unknown dark energy."

GLOBAL.STRINGS.CHARACTERS.WX78.DESCRIBE.PUMPKIN_PET = "VEGGIE MINION READY FOR BATTLE."

GLOBAL.STRINGS.CHARACTERS.WICKERBOTTOM.DESCRIBE.PUMPKIN_PET = "Interesting. I've never seen such aggressive vegetable."

GLOBAL.STRINGS.CHARACTERS.WOODIE.DESCRIBE.PUMPKIN_PET = "My wooden servant. Too bad he can't chop with me."

GLOBAL.STRINGS.CHARACTERS.WAXWELL.DESCRIBE.PUMPKIN_PET = "Another mindless servant willing to die for me."

	if GLOBAL.IsDLCEnabled(GLOBAL.REIGN_OF_GIANTS) then 

GLOBAL.STRINGS.CHARACTERS.WATHGRITHR.DESCRIBE.PUMPKIN_PET = "Good warrior by my side!"

GLOBAL.STRINGS.CHARACTERS.WEBBER.DESCRIBE.PUMPKIN_PET = "We fear that he will turn against us."
	end
	
PrefabFiles = {"pumpkin_pet",}

local assets=
{
	Asset("ATLAS", "images/inventoryimages/pumpkin_pet.xml"),
	Asset("IMAGE", "images/inventoryimages/pumpkin_pet.tex"),	
	
}

AddMinimapAtlas("images/inventoryimages/pumpkin_pet.xml")


local pumpkin_petrecipe = GLOBAL.Recipe( ("pumpkin_pet"), { Ingredient("pumpkin_lantern", 1), Ingredient("twigs", 30), Ingredient("redgem", 1) }, RECIPETABS.MAGIC,  {MAGIC = 2} )
pumpkin_petrecipe.atlas = "images/inventoryimages/pumpkin_pet.xml"
	   
	   
	   
function lootdropperpostinit(inst)

	inst.GenerateLoot = function(self)
    local loots = {}
    
    if self.numrandomloot and math.random() <= (self.chancerandomloot or 1) then
		for k = 1, self.numrandomloot do
		    local loot = self:PickRandomLoot()
		    if loot then
			    table.insert(loots, loot)
			end
		end
	end
    
    if self.chanceloot then
		for k,v in pairs(self.chanceloot) do
			if math.random() < v.chance then
				table.insert(loots, v.prefab)
				self.droppingchanceloot = true
			end
		end
	end

    if self.chanceloottable then
    	local loot_table = GLOBAL.LootTables[self.chanceloottable]
    	if loot_table then
    		for i, entry in ipairs(loot_table) do
    			local prefab = entry[1]
    			local chance = entry[2]    			
				if math.random() <= chance then
					table.insert(loots, prefab)
					self.droppingchanceloot = true
				end
			end
		end
	end

	if not self.droppingchanceloot and self.ifnotchanceloot then
		self.inst:PushEvent("ifnotchanceloot")
		for k,v in pairs(self.ifnotchanceloot) do
			table.insert(loots, v.prefab)
		end
	end


    
    if self.loot then
		for k,v in ipairs(self.loot) do
			table.insert(loots, v)
		end
	end
	
	local recipe = GLOBAL.GetRecipe(self.inst.prefab)

	if recipe and not self.inst.components.norecipelootdrop then
	

		
		local percent = 1

		if self.inst.components.finiteuses then
			percent = self.inst.components.finiteuses:GetPercent()
		end

		for k,v in ipairs(recipe.ingredients) do
			local amt = math.ceil( (v.amount * TUNING.HAMMER_LOOT_PERCENT) * percent)
			for n = 1, amt do
				table.insert(loots, v.type)
			end
		end
	end
    
    return loots

    end


end	   
	   
local function Pumpkin_pet_health( inst )

	inst:DoTaskInTime( 0, function() 
		local controls = inst.HUD.controls
		local Pumpkin_pet_health = require "widgets/pumpkin_pet_health"
		controls.petStatus = controls:AddChild(Pumpkin_pet_health(inst))
		controls.petStatus:SetPosition(0, -250, 0)
	end)

end	   

AddSimPostInit( Pumpkin_pet_health )	  

AddComponentPostInit("lootdropper", lootdropperpostinit)
	   
function HF_addtradablecomponenttoprefab(inst)
	if not inst.components.tradable then
		inst:AddComponent("tradable")
	end
end	 

ACTIONS.GIVE.priority = 4

--AddPrefabPostInit("emerald", HF_addtradablecomponenttoprefab)
--AddPrefabPostInit("emerald_sword", HF_addtradablecomponenttoprefab)  -- work only with changed action priority.
--AddPrefabPostInit("emerald_crown", HF_addtradablecomponenttoprefab)  -- working.
--AddPrefabPostInit("emerald_armor", HF_addtradablecomponenttoprefab)  -- working.
--AddPrefabPostInit("emerald_crown", HF_addtradablecomponenttoprefab)  -- working.

AddPrefabPostInit("axe", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("goldenaxe", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("pickaxe", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("goldenpickaxe", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("shovel", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("goldenshovel", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("hammer", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("pitchfork", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("multitool_axe_pickaxe", HF_addtradablecomponenttoprefab)

AddPrefabPostInit("grass_umbrella", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("umbrella", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("torch", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("bugnet", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("fishingrod", HF_addtradablecomponenttoprefab)

AddPrefabPostInit("spear", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("hambat", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("tentaclespike", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("ruins_bat", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("nightsword", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("boomerang", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("cane", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("batbat", HF_addtradablecomponenttoprefab)

AddPrefabPostInit("armorgrass", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("armorwood", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("armormarble", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("armor_sanity", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("armorsnurtleshell", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("armorslurper", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("armorruins", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("sweatervest", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("trunkvest_summer", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("trunkvest_winter", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("reflectivevest", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("raincoat", HF_addtradablecomponenttoprefab)

AddPrefabPostInit("lighter", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("nightstick", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("lucy", HF_addtradablecomponenttoprefab)

AddPrefabPostInit("spear_wathgrithr", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("beargervest", HF_addtradablecomponenttoprefab)
AddPrefabPostInit("armordragonfly", HF_addtradablecomponenttoprefab)