require "behaviours/faceentity"
require "behaviours/chaseandattack"
require "behaviours/follow"
require "behaviours/attackwall"
require "behaviours/runaway"

local Pumpkin_PetBrain = Class(Brain, function(self, inst)
    Brain._ctor(self, inst)
end)

local MIN_FOLLOW_DIST = 1
local TARGET_FOLLOW_DIST = 7
local MAX_FOLLOW_DIST = 12

local RUN_AWAY_DIST = 6
local STOP_RUN_AWAY_DIST = 12

local START_FACE_DIST = 8
local KEEP_FACE_DIST = 10

local MAX_CHASE_TIME = 10
local MAX_CHASE_DIST = 30

local function HasStateTags(inst, tags)
    for k,v in pairs(tags) do
        if inst.sg:HasStateTag(v) then
            return true
        end
    end
end

local function GetLeader(inst)
    return inst.components.follower.leader 
end

function Pumpkin_PetBrain:OnAttacked(attacker)
    self.inst.components.combat:SetTarget(attacker)
    self.inst.components.combat:ShareTarget(attacker, 30, function(dude) return dude:HasTag("no_one") and dude.components.follower.leader == GetPlayer() end, 5)
end

function Pumpkin_PetBrain:OnAttackOther(target)
    self.inst.components.combat:ShareTarget(target, 30, function(dude) return dude:HasTag("no_one") and dude.components.follower.leader == GetPlayer() end, 5)
end


local function GetFaceTargetFn(inst)
    return inst.components.follower.leader
end

local function KeepFaceTargetFn(inst, target)
    return inst.components.follower.leader == target
end


local function GetFaceTargetFn(inst)
    local target = GetClosestInstWithTag("player", inst, START_FACE_DIST)
    if target and not target:HasTag("notarget") then
        return target
    end
end

local function KeepFaceTargetFn(inst, target)
    return inst:IsNear(target, KEEP_FACE_DIST) and not target:HasTag("notarget")
end

function Pumpkin_PetBrain:OnStart()
    local root = PriorityNode(
    {
                WhileNode( function() return self.inst.components.combat.target == nil or not self.inst.components.combat:InCooldown() end, "AttackMomentarily",
                    ChaseAndAttack(self.inst, MAX_CHASE_TIME, MAX_CHASE_DIST) ),
            WhileNode( function() return self.inst.components.combat.target and self.inst.components.combat:InCooldown() end, "Dodge",
                    RunAway(self.inst, function() return self.inst.components.combat.target end, RUN_AWAY_DIST, STOP_RUN_AWAY_DIST) ),
        Follow(self.inst, GetLeader, MIN_FOLLOW_DIST, TARGET_FOLLOW_DIST, MAX_FOLLOW_DIST),
        IfNode(function() return GetLeader(self.inst) end, "has leader",            
            FaceEntity(self.inst, GetFaceTargetFn, KeepFaceTargetFn )),

    }, .25)
    
    self.bt = BT(self.inst, root) 

    self.inst:ListenForEvent("attacked", function(inst, data) self:OnAttacked(data.attacker) end)  
    self.inst:ListenForEvent("onattackother", function(inst, data) self:OnAttackOther(data.target) end)	
end

return Pumpkin_PetBrain