# ------------------------------------------------------
# RBC云管理器
# - 山西云联智达网络科有限责任公司
#
# 联系我们：
#   电话：13244826572
#   QQ：932180146
#   邮箱：932180146@qq.com
#   地址：侯马经济开发区锦茂国际C座5104室
#   智达云网址：www.zhidayun.net
#
#
# RBC Group
# 腾讯QQ群: 397192573
# Facebook: www.facebook.com/groups/RBC.Sugar
# RBC官网(中文地区): www.rbc321.cn
# RBC官网(English): www.rbctools.com
#
# RBC云插件平台的目标
# * 做好Sketchup使用的基础环境。
# * 致力于降低Sketchup基础插件的使用门槛，并提高体验，方便设计师等。
# * 降低Sketchup基础插件带来的问题。
# * 给广大Sketchup爱好者提供便利。
# * 优化插件。尽量保持统一的操作习惯。
# * 提供最好的兼容性。
# * RBC云插件平台不允许出现盗版插件。
# * 多语言支持，可以跨国使用。
#
# 合作
# * RBC云管理器有标准的接口可以接入云端。
# * RBC有优秀的Sketchup使用的基础环境，可以作为公司协调设计资源使用。
# * 可以合作进行专业方面开发。
#
# ------------------------------------------------------

module RBC
  module Extensions
    module PluginsManager

      # @since 7.8.0
      def self.c_ver(a, b)
        if a[0] < b[0]
          return false
        end
        if a[0] > b[0]
          return true
        end
        if a[1] >= b[1]
          true
        else
          a[2] >= b[2]
        end
      end

      # @param[String] ext_name
      # @param[Integer] mv
      # @param[Integer] rv
      # @param[Integer] fv
      #
      # check lib extension.
      #
      # @since 1.0.0
      def self.check_lib?(ext_name, mv, rv, fv)
        return false if Sketchup.version.to_i < 15
        unless defined?(RBC::RBC_EXTENSION)
          # require RBC library.
          begin
            require 'RBC_Library_load.rb'
          rescue LoadError => e
            p e
          end
        end
        if defined?(RBC::RBC_VERSION_)
          update = !self.c_ver(RBC::RBC_VERSION_, [mv, rv, fv])
        else
          update = true
        end
        # check version.
        if update && (defined?(RBC::LIB_UPDATE_) && !RBC::LIB_UPDATE_)
          msg = "#{ext_name}: RBC Library(#{mv}.#{rv}.#{fv}) must be installed!(必须安装使用#{mv}.#{rv}.#{fv}版本以上的RBC Library!)"
          Sketchup.set_status_text(msg, SB_PROMPT)
          UI.messagebox(msg)
          RBC.const_set(:LIB_UPDATE_, true)
          false
        end
        !update
      end

      # @param[String] path
      # @param[String] grep
      #
      # @return[Array]
      #
      # @since 7.7.45
      def self.find_files(path, grep = '*')
        Dir[File.join(path, grep)]
      end

      NAME = 'RBC_PluginsManager'.freeze
      PM_VERSION_ = [10, 9, 207].freeze
      VERSION = PM_VERSION_.join('.').freeze
      DIR_NAME = (NAME + '_v' + VERSION).freeze
      EXTENSION_DIR = File.join(Sketchup.find_support_file('Plugins'), DIR_NAME).freeze
      EXT_DIR_ = __dir__
      EXT_LOADER_ = __FILE__

      if self.check_lib?(DIR_NAME, 7, 7, 218)

        # 先加载Enscape
        ens_loader = File.join(Sketchup.find_support_file('Plugins'), 'enscape.rb')
        if File.file?(ens_loader)
          require(ens_loader)
        end

        LH = RBC::LanguageHandler.new(File.join(EXTENSION_DIR, 'lang'))
        LH.name = LH[NAME]

        EXTENSION = SketchupExtension.new(NAME, File.join(EXTENSION_DIR, 'core'))
        EXTENSION.description = LH['RBC Cloud Manager.']
        EXTENSION.copyright = "Copyright (c) #{Time.new.year} 山西云联智达网络科技有限公司 All rights reserved."
        EXTENSION.version = VERSION
        EXTENSION.creator = '山西云联智达网络科技有限公司'
        Sketchup.register_extension(EXTENSION, true)
        EXTENSION.check

      end # if

    end # module PluginsManager
  end # module Extensions
end # module RBC