/*
 * --------------------------------------------
 *
 * ChromeDialog项目
 * YUN框架谷歌浏览器接口。
 * 用来在Sketchup窗口内JavaScripe和Ruby互相传递消息。
 *
 * @since 7.7.209
 *
 * Copyright:: Copyright 2019 山西云联智达网络科技有限公司.
 *
 * Log:
 * 2019.10.09: 开始此接口项目
 * 2019.10.23: 完成全部设计和测试工作并正式投入使用。
 * 2019.11.11: 添加控制台打印接口。
 * 2019.12.6: 添加语言接口。
 * --------------------------------------------
 */

SU = {
    /**/
    debug: false,
    isSu: /SketchUp/i.test(navigator.userAgent),
    isWin: navigator.appVersion.indexOf("Win") !== -1,
    isMac: navigator.appVersion.indexOf("Mac") !== -1,

    _interfaces: {},

    on: function (interface_name, success) {
        this._interfaces[interface_name] = success;
    },

    _exeInterface: function (params) {
        // Create the function
        var fn = this._interfaces[params.action];
        try {
            // alternative only for global functions: window[functionName]
            if (fn) {
                returnValue = fn(params.value);
                if(params.callback){
                    this.connect('_call_action', {
                        'id': params.id,
                        'value': returnValue
                    });
                }
            } else {
                this.error("No find this action:  "+params.action)
            }
        } catch (e) {
            this.error(e)
        }
    },

    /*
     * close dialog.
     * @method: close
     * */
    close: function () {
        this.connect('_close', true)
    },

    /*
    *
    * */
    ready: function (complete) {
        if(typeof(complete) == 'function' ){
            window.setTimeout(function () {
                SU.request('_ready', true, complete);
            }, 50);
        }else{
            this.error('Not a function for ready!')
        }
    },

    /*
    *
    * */
    fastRequest: function (interface_name, string) {
        if (SU.isSu) {
            var js_command = 'sketchup.' + interface_name + '("' + string + '")';
            try {
                eval(js_command);
                return true;
            } catch (e) {
                this.error('ERROR(J): An exception occurred with the JS method:(sketchup.action);ActionName:(' + interface_name + ') ->' + e.toString());
                return false;
            }
        } else {
            console.log('Error(J): Please add the Test function key!(' + interface_name + ')');
            return false;
        }
    },

    /*
    * 弹唱提示警告信息
    *
    * @param[String] info
    *
    * @since 2019.11.11
    * */
    warning:function(info){
        console.warn(info);
        if(sketchup._warning){
            sketchup._warning(info)
        }else{
            alert(info)
        }
    },

    /*
    * 往控制台打印信息。
    *
    * @param[String] info
    *
    * @since 2019.11.11
    * */
    log:function(info){
        console.log(info);
        if(sketchup._log){
            sketchup._log(info)
        }
    },

    /*
    * 弹唱提示信息
    *
    * @param[String] info
    *
    * @since 2019.11.11
    * */
    tip:function(info){
        console.log(info);
        if(sketchup._tip){
            sketchup._tip(info)
        }else{
            alert(info)
        }
    },

    /*
    * 弹错窗口并终止执行程序。
    *
    * @param[String] info
    *
    * @since 2019.11.11
    * */
    error:function(info){
        console.error(info);
        if(sketchup._error){
            sketchup._error(info)
        }else{
            alert(info)
        }
    },

    _last_push: null,

    /* Wrapper to call any defined action_callback, handles escaping and encoding etc.
     * @param json
     * {
     *    interface_name: string,
     *    data: json,
     *    test: function,
     *    success: function,
     *    error: function,
     *    complete: function
     * }
     * @param interface_name, *arguments
     */
    request: function (interface_name, data, complete) {
        if (!SU.isSu) {
            this.error('Error(J): Please add the Test function key!(' + interface_name + ')');
            return false;
        }
        var id = (this._messageId++);
        this._callbacks[id] = complete;
        this._messages.push({
            'RBC-API': true,
            'name': interface_name,
            'id': id,
            'data': data,
            'callback': !!complete
        });
        var d = new Date();
        var time = d.getTime();
        if (this._last_push && time - this._last_push >= 5000) {
            this._ready = true;
        }
        if (this._ready) {
            this._nextMessage()
        }
    },

    _nextMessage: function () {
        var message = this._messages.shift();
        if (!message) {
            this._ready = true;
            return;
        }
        this._ready = false;
        var js_command = 'sketchup.' + message.name + '(' + JSON.stringify(message) + ')';
        //console.log('sketchup connect: ' + message.name+':'+JSON.stringify(message.data));
        try {
            setTimeout(function () {
                eval(js_command);
            }, 0);
        } catch (e) {
            this.error('ERROR(J): An exception occurred with the JS method:(sketchup.action);ActionName:(' + message[0] + ')' + e.toString());
        }
    },
    _ready: true,
    _messages: [],
    _messageId: 0,
    _callbacks: {},

    /* Language */

    strings: {},

    /* refresh language value.
     * @param [Function] callbackFun
     * @return [null]
     * */
    refresh_lang: function (callbackFun) {
        console.log("refresh YUN.Language.");
        if (typeof (callbackFun) === "function") {
            SU._refreshFun = callbackFun;
        }
        if (SU.isSu) {
            sketchup._language()
        } else {
            SU._refreshFun(SU)
        }
        return null;
    },

    /* Get language value.
     * @method tr
     * @param [String] key
     * @return [String]
     * @since 2.0.0
     * */
    tr: function (key) {
        if (!SU.isSu) {
            console.log("YUN.Language: " + key + "<==>" + key);
            return key;
        }
        if (this.strings[key]) {
            console.log("YUN.Language: " + key + "<==>" + this.strings[key]);
            return this.strings[key];
        } else {
            sketchup._language_insert_key(key);
            return key;
        }
    },

    /* Refresh callback function.
     * */
    _refreshFun: function () {}
};