'''
Copyright (C) 2019 James Snowden
james@metaphysic.al
Created by James Snowden
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''

# pylint: disable=invalid-name
bl_info = {
    "name": "RBF Drivers",
    "description": "Radial basis function drivers.",
    "author": "James Snowden",
    "version": (1, 2, 7),
    "blender": (2, 80, 0),
    "location": "View3D",
    "wiki_url": "https://rbfdrivers.readthedocs.io/en/latest/",
    "category": "Rigging",
    "warning": ""
}

# pylint: disable=wrong-import-position
import bpy

if "rbf" not in locals():
    from . import utils, distance, expression, rbf, proxies, network, properties, operators, ui
else:
    import importlib
    utils = importlib.reload(utils)
    distance = importlib.reload(distance)
    expression = importlib.reload(expression)
    rbf = importlib.reload(rbf)
    proxies = importlib.reload(proxies)
    network = importlib.reload(network)
    properties = importlib.reload(properties)
    operators = importlib.reload(operators)
    ui = importlib.reload(ui)

CLASSES = [
    properties.Pose,
    properties.Poses,
    properties.Sample,
    properties.Samples,
    properties.DrivenPropertyState,
    properties.DrivenProperty,
    properties.DrivenProperties,
    properties.RBFDriver,
    properties.RBFDrivers,
    operators.ShapeKeyBlock,
    operators.ShapeKeyedMesh,
    operators.RBFDRIVERS_UL_available_keys,
    operators.RBFDRIVERS_OT_driver_add,
    operators.RBFDRIVERS_OT_driver_new,
    operators.RBFDRIVERS_OT_driver_copy,
    operators.RBFDRIVERS_OT_driver_paste,
    operators.RBFDRIVERS_OT_driver_paste_symmetrical,
    operators.RBFDRIVERS_OT_driver_remove,
    operators.RBFDRIVERS_OT_driver_move_up,
    operators.RBFDRIVERS_OT_driver_move_down,
    operators.RBFDRIVERS_OT_driver_update,
    operators.RBFDRIVERS_OT_driven_properties_add,
    operators.RBFDRIVERS_OT_driven_property_add,
    operators.RBFDRIVERS_OT_driven_property_add_transforms,
    operators.RBFDRIVERS_OT_driven_property_add_shapekeys,
    operators.RBFDRIVERS_OT_driven_property_remove,
    operators.RBFDRIVERS_OT_driven_property_move_up,
    operators.RBFDRIVERS_OT_driven_property_move_down,
    operators.RBFDRIVERS_OT_pose_move_up,
    operators.RBFDRIVERS_OT_pose_move_down,
    operators.RBFDRIVERS_OT_pose_update,
    operators.RBFDRIVERS_OT_pose_add,
    operators.RBFDRIVERS_OT_pose_remove,
    operators.RBFDRIVERS_OT_pose_apply,
    operators.RBFDRIVERS_OT_pose_edit,
    ui.RBFDRIVERS_UL_drivers,
    ui.RBFDRIVERS_UL_poses,
    ui.RBFDRIVERS_PT_main,
    ui.RBFDRIVERS_PT_settings,
    ui.RBFDRIVERS_PT_inputs,
    ui.RBFDRIVERS_PT_driven_properties,
    ui.RBFDRIVERS_PT_poses,
    ]

def register():
    # pylint: disable=missing-function-docstring
    # pylint: disable=import-outside-toplevel
    for cls in CLASSES:
        bpy.utils.register_class(cls)

    bpy.types.PoseBone.rbf_drivers = bpy.props.PointerProperty(
        name="RBF Drivers",
        description="Radial basis function drivers",
        type=properties.RBFDrivers,
        options={'HIDDEN'}
        )

def unregister():
    # pylint: disable=missing-function-docstring
    # pylint: disable=import-outside-toplevel
    del bpy.types.PoseBone.rbf_drivers

    for cls in reversed(CLASSES):
        bpy.utils.unregister_class(cls)
