# pylint: disable=missing-module-docstring
from bpy.types import Context, Panel, UIList

class RBFDRIVERS_UL_drivers(UIList):
    # pylint: disable=invalid-name
    # pylint: disable=missing-class-docstring
    # pylint: disable=too-few-public-methods
    bl_idname = 'RBFDRIVERS_UL_drivers'

    def draw_item(self, context, layout, data, item, icon, active_data, active_prop) -> None:
        # pylint: disable=no-self-use
        # pylint: disable=too-many-arguments
        # pylint: disable=unused-argument
        # pylint: disable=missing-function-docstring
        valid = item.is_valid
        layout.alert = not valid
        layout.prop(item, "name", text="", emboss=False, translate=False)
        if valid:
            layout.prop(item, "mute",
                        text="",
                        icon=f'CHECKBOX_{"DE" if item.mute else ""}HLT',
                        emboss=False,
                        icon_only=True)

class RBFDRIVERS_UL_poses(UIList):
    # pylint: disable=invalid-name
    # pylint: disable=missing-class-docstring
    # pylint: disable=too-few-public-methods
    bl_idname = 'RBFDRIVERS_UL_poses'

    def draw_item(self, context, layout, data, item, icon, active_data, active_prop) -> None:
        # pylint: disable=no-self-use
        # pylint: disable=too-many-arguments
        # pylint: disable=unused-argument
        # pylint: disable=missing-function-docstring
        layout.prop(item, "name", text="", emboss=False, translate=False)

class RBFDRIVERS_PT_main(Panel):
    # pylint: disable=invalid-name
    # pylint: disable=missing-class-docstring

    bl_space_type = 'PROPERTIES'
    bl_region_type = 'WINDOW'
    bl_context = 'bone'
    bl_idname = 'RBFDRIVERS_PT_main'
    bl_description = "Radial based function drivers"
    bl_label = "RBF Drivers"

    @classmethod
    def poll(cls, context: Context) -> bool:
        # pylint: disable=missing-function-docstring
        return context.active_pose_bone is not None

    def draw(self, context: Context) -> None:
        # pylint: disable=missing-function-docstring
        bone = context.active_pose_bone
        layout = self.layout
        if not bone.is_property_set("rbf_drivers") or len(bone.rbf_drivers) == 0:
            layout.operator("rbf_drivers.driver_add", text="Add", icon='ADD')
        else:
            drivers = bone.rbf_drivers
            row = layout.row()
            left = row.column()
            left.template_list("RBFDRIVERS_UL_drivers", "",
                               drivers, "data__internal", drivers, "active_index", rows=6)

            right = row.column(align=True)
            right.operator("rbf_drivers.driver_add", text="", icon='ADD')
            right.operator("rbf_drivers.driver_remove", text="", icon='REMOVE')
            right.separator()
            right.operator("rbf_drivers.driver_copy", text="", icon='COPYDOWN')
            right.operator("rbf_drivers.driver_update", text="", icon='ANIM')
            right.separator()
            right.operator("rbf_drivers.driver_move_up", text="", icon='TRIA_UP')
            right.operator("rbf_drivers.driver_move_down", text="", icon='TRIA_DOWN')

class RBFDRIVERS_PT_settings(Panel):
    # pylint: disable=invalid-name
    # pylint: disable=missing-class-docstring
    bl_space_type = 'PROPERTIES'
    bl_region_type = 'WINDOW'
    bl_context = 'bone'
    bl_idname = 'RBFDRIVERS_PT_settings'
    bl_parent_id = 'RBFDRIVERS_PT_main'
    bl_description = "RBF driver settings"
    bl_label = "RBF Settings"

    @classmethod
    def poll(cls, context: Context) -> bool:
        # pylint: disable=missing-function-docstring
        bone = context.active_pose_bone
        return (bone is not None
                and bone.is_property_set("rbf_drivers")
                and bone.rbf_drivers.active is not None)

    def draw(self, context: Context) -> None:
        # pylint: disable=missing-function-docstring
        driver = context.active_pose_bone.rbf_drivers.active
        layout = self.layout

        split = layout.split(factor=1/3)
        labels = split.column()
        values = split.column()
        labels.alignment = 'RIGHT'

        labels.label(text="Interpolation")
        values.prop(driver, "interpolation", text="")
        labels.separator(factor=0.1)
        values.separator(factor=0.1)

        if driver.interpolation != 'NONE':
            labels.label(text="Radius")
            values.prop(driver, "dispersion", text="")
            labels.separator(factor=0.1)
            values.separator(factor=0.1)

            if driver.dispersion == 'NONE':
                labels.label(text=" ")
                values.prop(driver, "radius", text="")
                labels.separator(factor=0.1)
                values.separator(factor=0.1)

        labels.label(text="Smoothing")
        values.prop(driver, "smoothing", text="")
        labels.separator(factor=0.1)
        values.separator(factor=0.1)

class RBFDRIVERS_PT_inputs(Panel):
    # pylint: disable=invalid-name
    # pylint: disable=missing-class-docstring

    bl_space_type = 'PROPERTIES'
    bl_region_type = 'WINDOW'
    bl_context = 'bone'
    bl_idname = 'RBFDRIVERS_PT_inputs'
    bl_parent_id = 'RBFDRIVERS_PT_main'
    bl_description = "RBF input properties"
    bl_label = "Inputs"

    @classmethod
    def poll(cls, context: Context) -> bool:
        # pylint: disable=missing-function-docstring
        bone = context.active_pose_bone
        return (bone is not None
                and bone.is_property_set("rbf_drivers")
                and bone.rbf_drivers.active is not None)

    def draw(self, context: Context) -> None:
        # pylint: disable=missing-function-docstring
        driver = context.active_pose_bone.rbf_drivers.active
        layout = self.layout

        row = layout.row(align=True)

        col = row.column()
        col.alignment = 'RIGHT'
        spl = col.row(align=True).split(factor=0.75)

        lft = spl.column()
        rgt = spl.column()
        lft.alignment = 'RIGHT'

        lft.label(text="Location X")
        rgt.prop(driver, "use_location", text="", index=0)
        for index, axis in zip(range(1, 3), 'YZ'):
            lft.label(text=axis)
            rgt.prop(driver, "use_location", text="", index=index)

        col = row.column()
        col.alignment = 'RIGHT'
        spl = col.row(align=True).split(factor=0.75)

        lft = spl.column()
        rgt = spl.column()
        lft.alignment = 'RIGHT'

        mode = driver.rotation_mode
        if len(mode) == 3 or mode == 'AUTO':
            lft.label(text="Rotation X")
            rgt.prop(driver, "use_rotation", text="", index=1)
            for index, axis in zip(range(2, 4), 'YZ'):
                lft.label(text=axis)
                rgt.prop(driver, "use_rotation", text="", index=index)
        else:
            lft.label(text="Rotation W")
            rgt.prop(driver, "use_rotation", text="", index=0)
            for index, axis in zip(range(1, 4), 'XYZ'):
                lft.label(text=axis)
                rgt.prop(driver, "use_rotation", text="", index=index)

        col.prop(driver, "rotation_mode", text="")

        col = row.column()
        col.alignment = 'RIGHT'
        spl = col.row(align=True).split(factor=0.75)

        lft = spl.column()
        rgt = spl.column()
        lft.alignment = 'RIGHT'

        lft.label(text="Scale X")
        rgt.prop(driver, "use_scale", text="", index=0)
        for index, axis in zip(range(1, 3), 'YZ'):
            lft.label(text=axis)
            rgt.prop(driver, "use_scale", text="", index=index)

class RBFDRIVERS_PT_driven_properties(Panel):
    # pylint: disable=invalid-name
    # pylint: disable=missing-class-docstring

    bl_space_type = 'PROPERTIES'
    bl_region_type = 'WINDOW'
    bl_context = 'bone'
    bl_idname = 'RBFDRIVERS_PT_driven_properties'
    bl_parent_id = 'RBFDRIVERS_PT_main'
    bl_description = "RBF driven properties"
    bl_label = "Driven Properties"

    @classmethod
    def poll(cls, context: Context) -> bool:
        # pylint: disable=missing-function-docstring
        bone = context.active_pose_bone
        return (bone is not None
                and bone.is_property_set("rbf_drivers")
                and bone.rbf_drivers.active is not None)

    def draw(self, context: Context) -> None:
        # pylint: disable=missing-function-docstring
        bone = context.active_pose_bone
        layout = self.layout

        props = bone.rbf_drivers.active.driven_properties

        for index, prop in enumerate(props):

            col = layout.column(align=True)
            box = col.box()
            row = box.row()

            row.prop(prop, "show_expanded",
                     text="",
                     icon=f'DISCLOSURE_TRI_{"DOWN" if prop.show_expanded else "RIGHT"}',
                     emboss=False)

            sub = row.row(align=True)
            sub.prop(prop, "type", text="", icon_only=True)

            sub = sub.row(align=True)
            sub.alert = not prop.is_valid
            sub.prop(prop, "name", text="")

            sub = row.row(align=True)

            opr = sub.row(align=True)
            opr.enabled = index > 0
            opr.operator("rbf_drivers.driven_property_move_up",
                         text="",
                         icon='TRIA_UP').property_index = index

            opr = sub.row(align=True)
            opr.enabled = len(props) - 1 > index
            opr.operator("rbf_drivers.driven_property_move_down",
                         text="",
                         icon='TRIA_DOWN').property_index = index

            row.operator("rbf_drivers.driven_property_remove",
                         text="",
                         icon='X',
                         emboss=False).property_index = index

            if prop.show_expanded:

                id_ = prop.id
                box = col.box()

                split = box.row().split(factor=0.25)
                labels = split.column()
                values = split.column()
                labels.separator(factor=0.2)
                values.separator(factor=0.2)

                labels.label(text="Object:")
                row = values.row()
                row.alert = id_ is None or prop.type == 'SHAPE_KEY' and id_.type != 'MESH'
                row.prop(prop, "id", text="")
                labels.separator(factor=0.2)
                values.separator(factor=0.2)

                if prop.type == 'TRANSFORMS':
                    if id_ is not None and id_.type == 'ARMATURE':
                        labels.label(text="Bone:")
                        row = values.row()
                        row.alert = (prop.bone_target != ""
                                     and prop.bone_target not in id_.data.bones)
                        row.prop_search(prop, "bone_target", id_.data, "bones", text="")
                        labels.separator(factor=0.2)
                        values.separator(factor=0.2)

                    labels.label(text="Type:")
                    row = values.row()
                    row.alert = prop.transform_type == 'ROT_W' and prop.rotation_mode == 'EULER'
                    row.prop(prop, "transform_type", text="")
                    labels.separator(factor=0.2)
                    values.separator(factor=0.2)

                    if prop.transform_type.startswith('ROT'):
                        labels.label(text="Mode:")
                        values.prop(prop, "rotation_mode", text="")
                        labels.separator(factor=0.2)
                        values.separator(factor=0.2)

                elif prop.type == 'SHAPE_KEY':
                    labels.label(text="Key:")
                    row = values.row()
                    row.alert = not prop.is_valid

                    if id_ is not None and id_.type == 'MESH' and id_.data.shape_keys is not None:
                        row.prop_search(prop, "shape_key",
                                        id_.data.shape_keys, "key_blocks", text="")
                        if prop.shape_key in id_.data.shape_keys.key_blocks:
                            labels.separator(factor=0.2)
                            values.separator(factor=0.2)
                            labels.label(text="Value:")
                            values.prop(id_.data.shape_keys.key_blocks[prop.shape_key], "value",
                                        text="")
                    else:
                        row.prop(prop, "shape_key", text="")

                    labels.separator(factor=0.2)
                    values.separator(factor=0.2)

                else:
                    labels.label(text="Path:")
                    row = values.row()
                    row.alert = not prop.is_valid
                    row.prop(prop, "data_path", text="")
                    labels.separator(factor=0.2)
                    values.separator(factor=0.2)

        layout.operator("rbf_drivers.driven_properties_add", text="Add")

class RBFDRIVERS_PT_poses(Panel):
    # pylint: disable=invalid-name
    # pylint: disable=missing-class-docstring

    bl_space_type = 'PROPERTIES'
    bl_region_type = 'WINDOW'
    bl_context = 'bone'
    bl_idname = 'RBFDRIVERS_PT_poses'
    bl_parent_id = 'RBFDRIVERS_PT_main'
    bl_description = "RBF poses"
    bl_label = "Poses"

    @classmethod
    def poll(cls, context: Context) -> bool:
        # pylint: disable=missing-function-docstring
        bone = context.active_pose_bone
        return (bone is not None
                and bone.is_property_set("rbf_drivers")
                and bone.rbf_drivers.active is not None)

    def draw(self, context: Context) -> None:
        # pylint: disable=missing-function-docstring
        layout = self.layout
        pose_bone = context.active_pose_bone
        driver = pose_bone.rbf_drivers.active
        poses = driver.poses

        row = layout.row()
        lft = row.column(align=True)
        lft.template_list("RBFDRIVERS_UL_poses", "",
                          poses, "data__internal", poses, "active_index", rows=7)

        rgt = row.column(align=True)
        rgt.operator("rbf_drivers.pose_add", text="", icon='ADD')
        rgt.operator("rbf_drivers.pose_remove", text="", icon='REMOVE')
        rgt.separator()
        rgt.operator("rbf_drivers.pose_update", text="", icon='ACTION_TWEAK')
        rgt.operator("rbf_drivers.pose_apply", text="", icon='ZOOM_SELECTED')
        rgt.operator("rbf_drivers.pose_edit", text="", icon='OPTIONS')
        rgt.separator()
        rgt.operator("rbf_drivers.pose_move_up", text="", icon='TRIA_UP')
        rgt.operator("rbf_drivers.pose_move_down", text="", icon='TRIA_DOWN')

        pose_index = poses.active_index
        if pose_index >= 0:
            for suffix, datablock in [
                    ('Weight', pose_bone),
                    ('Effect', pose_bone.id_data.data)
                ]:
                propname = f'RBF Driver Pose {suffix} - rbfn.{str(driver.id__internal).zfill(3)}'
                idprop = datablock.get(propname)
                if idprop and pose_index < len(idprop):
                    col = lft.column()
                    col.separator()
                    col.use_property_split = True
                    col.use_property_decorate = False

                    row = col.row()
                    row.prop(datablock, f'["{propname}"]',
                             index=pose_index, text=suffix, slider=True)
