# pylint: disable=missing-module-docstring
from typing import Callable
import numpy as np

Function = Callable[[np.ndarray, np.ndarray], np.ndarray]

def euclidean(vector: np.ndarray, vectors: np.ndarray) -> np.ndarray:
    # pylint: disable=missing-function-docstring
    a_min_b = vector - vectors
    return np.sqrt(np.einsum("ij,ij->i", a_min_b, a_min_b))

def quaternion(vector: np.ndarray, vectors: np.ndarray) -> np.ndarray:
    # pylint: disable=missing-function-docstring
    out = np.dot(vectors, vector)
    np.clip(out, -1.0, 1.0, out=out)
    return np.arccos(2.0 * out * out - 1.0) / np.pi

def matrix(values: np.ndarray, function: Function) -> np.ndarray:
    # pylint: disable=missing-function-docstring
    return np.array([function(value, values) for value in values], dtype=np.float)
