# pylint: disable=missing-module-docstring
# pylint: disable=invalid-name
# pylint: disable=multiple-statements
# pylint: disable=missing-function-docstring
from typing import Iterable, Sequence, Tuple, Union
import bpy

Integer = Union[str, int]
Float = Union[str, float]
Scalar = Union[str, int, float]
Vector = Sequence[Scalar]
Quaternion = Tuple[Float, Float, Float, Float]

pi = 'pi'

def acos(value: Scalar) -> str:
    return f'acos({value})'

def clamp(value: Scalar, lower: Scalar, upper: Scalar) -> str:
    if bpy.app.version[0] >= 2 and bpy.app.version[1] >= 90:
        value = f'clamp({value},{lower},{upper})'
    else:
        value = f'min(max({value},{lower}),{upper})'
    return value

def divide(a: Scalar, b: Scalar) -> str:
    return f'{a}/{b}'

def dot(a: Iterable[Scalar], b: Iterable[Scalar]) -> str:
    return "+".join(f'{x}*{y}' for x, y in zip(a, b))

def eq(a: Scalar, b: Scalar) -> str:
    return f'{a}=={b}'

def exp(value: Scalar) -> str:
    return f'exp({value})'

def gt(a: Scalar, b: Scalar) -> str:
    return f'{a}>{b}'

def gte(a: Scalar, b: Scalar) -> str:
    return f'{a}>={b}'

def log(value: Scalar) -> str:
    return f'log({value})'

def lt(a: Scalar, b: Scalar) -> str:
    return f'{a}<{b}'

def lte(a: Scalar, b: Scalar) -> str:
    return f'{a}<={b}'

def mean(values: Vector) -> str:
    return divide(wrap(sum(values)), float(len(values)))

def multiply(a: Scalar, b: Scalar) -> str:
    return f'{a}*{b}'

def negative(value: Scalar) -> str:
    return f'-{value}'

def neq(a: Scalar, b: Scalar) -> str:
    return f'{a}!={b}'

def pow(value: Scalar, power: Integer) -> str:
    # pylint: disable=redefined-builtin
    return f'pow({value},{power})'

def sqrt(value: Scalar) -> str:
    return f'sqrt({value})'

def subtract(a: Scalar, b: Scalar) -> str:
    return f'{a}-{b}'

def sum(values: Iterable[Scalar]) -> str:
    # pylint: disable=redefined-builtin
    return "+".join([str(value) for value in values])

def where(condition: str, a: Scalar, b: Scalar) -> str:
    return f'{a} if {condition} else {b}'

def wrap(value: Scalar) -> str:
    return f'({value})'


def euclidean_distance(a: Vector, b: Vector) -> str:
    return sqrt(sum(pow(subtract(x, y), 2) for x, y in zip(a, b)))

def quaternion_distance(a: Quaternion, b: Quaternion) -> str:
    return divide(acos(subtract(multiply(2.0, pow(clamp(dot(a, b), -1.0, 1.0), 2)), 1.0)), pi)


def rbf_gaussian(value: str, radius: Float) -> str:
    return exp(negative(divide(pow(value, 2), radius)))

def rbf_multi_quadratic_biharmonic(value: str, radius: Float) -> str:
    return sqrt(sum([pow(value, 2), pow(radius, 2)]))

def rbf_inverse_multi_quadratic_biharmonic(value: str, radius: Float) -> str:
    return divide(1.0, rbf_multi_quadratic_biharmonic(value, radius))
