# pylint: disable=missing-module-docstring
from typing import Callable
import numpy as np

Function = Callable[[np.ndarray, float], np.ndarray]

def gaussian(array: np.ndarray, radius: float) -> np.ndarray:
    # pylint: disable=missing-function-docstring
    res = np.zeros_like(array, dtype=array.dtype)
    np.divide(np.power(array, 2, out=res), radius, where=radius != 0.0, out=res)
    return np.exp(np.negative(array, out=res), out=res)

def multi_quadratic_biharmonic(array: np.ndarray, radius: float) -> np.ndarray:
    # pylint: disable=missing-function-docstring
    return np.sqrt((array * array) + (radius * radius))

def inverse_multi_quadratic_biharmonic(array: np.ndarray, radius: float) -> np.ndarray:
    # pylint: disable=missing-function-docstring
    return np.divide(1.0, multi_quadratic_biharmonic(array, radius))
