/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.activation.URLDataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailAttachment;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.EmailUtils;

public class MultiPartEmail
extends Email {
    private MimeMultipart container;
    private BodyPart primaryBodyPart;
    private String subType;
    private boolean initialized;
    private boolean boolHasAttachments;

    public void setSubType(String aSubType) {
        this.subType = aSubType;
    }

    public String getSubType() {
        return this.subType;
    }

    public Email addPart(String partContent, String partContentType) throws EmailException {
        BodyPart bodyPart = this.createBodyPart();
        try {
            bodyPart.setContent(partContent, partContentType);
            this.getContainer().addBodyPart(bodyPart);
        }
        catch (MessagingException me) {
            throw new EmailException(me);
        }
        return this;
    }

    public Email addPart(MimeMultipart multipart) throws EmailException {
        try {
            return this.addPart(multipart, this.getContainer().getCount());
        }
        catch (MessagingException me) {
            throw new EmailException(me);
        }
    }

    public Email addPart(MimeMultipart multipart, int index) throws EmailException {
        BodyPart bodyPart = this.createBodyPart();
        try {
            bodyPart.setContent(multipart);
            this.getContainer().addBodyPart(bodyPart, index);
        }
        catch (MessagingException me) {
            throw new EmailException(me);
        }
        return this;
    }

    protected void init() {
        if (this.initialized) {
            throw new IllegalStateException("Already initialized");
        }
        this.container = this.createMimeMultipart();
        super.setContent(this.container);
        this.initialized = true;
    }

    public Email setMsg(String msg) throws EmailException {
        if (EmailUtils.isEmpty(msg)) {
            throw new EmailException("Invalid message supplied");
        }
        try {
            BodyPart primary = this.getPrimaryBodyPart();
            if (primary instanceof MimePart && EmailUtils.isNotEmpty(this.charset)) {
                ((MimePart)((Object)primary)).setText(msg, this.charset);
            } else {
                primary.setText(msg);
            }
        }
        catch (MessagingException me) {
            throw new EmailException(me);
        }
        return this;
    }

    public void buildMimeMessage() throws EmailException {
        try {
            if (this.primaryBodyPart != null) {
                BodyPart body = this.getPrimaryBodyPart();
                try {
                    body.getContent();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.subType != null) {
                this.getContainer().setSubType(this.subType);
            }
            super.buildMimeMessage();
        }
        catch (MessagingException me) {
            throw new EmailException(me);
        }
    }

    public MultiPartEmail attach(File file) throws EmailException {
        String fileName = file.getAbsolutePath();
        try {
            if (!file.exists()) {
                throw new IOException("\"" + fileName + "\" does not exist");
            }
            FileDataSource fds = new FileDataSource(file);
            return this.attach((DataSource)fds, file.getName(), null, "attachment");
        }
        catch (IOException e) {
            throw new EmailException("Cannot attach file \"" + fileName + "\"", e);
        }
    }

    public MultiPartEmail attach(EmailAttachment attachment) throws EmailException {
        MultiPartEmail result = null;
        if (attachment == null) {
            throw new EmailException("Invalid attachment supplied");
        }
        URL url = attachment.getURL();
        if (url == null) {
            String fileName = null;
            try {
                fileName = attachment.getPath();
                File file = new File(fileName);
                if (!file.exists()) {
                    throw new IOException("\"" + fileName + "\" does not exist");
                }
                result = this.attach((DataSource)new FileDataSource(file), attachment.getName(), attachment.getDescription(), attachment.getDisposition());
            }
            catch (IOException e) {
                throw new EmailException("Cannot attach file \"" + fileName + "\"", e);
            }
        } else {
            result = this.attach(url, attachment.getName(), attachment.getDescription(), attachment.getDisposition());
        }
        return result;
    }

    public MultiPartEmail attach(URL url, String name, String description) throws EmailException {
        return this.attach(url, name, description, "attachment");
    }

    public MultiPartEmail attach(URL url, String name, String description, String disposition) throws EmailException {
        try {
            InputStream is = url.openStream();
            is.close();
        }
        catch (IOException e) {
            throw new EmailException("Invalid URL set:" + url, e);
        }
        return this.attach((DataSource)new URLDataSource(url), name, description, disposition);
    }

    public MultiPartEmail attach(DataSource ds, String name, String description) throws EmailException {
        try {
            InputStream is;
            InputStream inputStream = is = ds != null ? ds.getInputStream() : null;
            if (is != null) {
                is.close();
            }
            if (is == null) {
                throw new EmailException("Invalid Datasource");
            }
        }
        catch (IOException e) {
            throw new EmailException("Invalid Datasource", e);
        }
        return this.attach(ds, name, description, "attachment");
    }

    public MultiPartEmail attach(DataSource ds, String name, String description, String disposition) throws EmailException {
        if (EmailUtils.isEmpty(name)) {
            name = ds.getName();
        }
        BodyPart bodyPart = this.createBodyPart();
        try {
            this.getContainer().addBodyPart(bodyPart);
            bodyPart.setDisposition(disposition);
            bodyPart.setFileName(name);
            bodyPart.setDescription(description);
            bodyPart.setDataHandler(new DataHandler(ds));
        }
        catch (MessagingException me) {
            throw new EmailException(me);
        }
        this.setBoolHasAttachments(true);
        return this;
    }

    protected BodyPart getPrimaryBodyPart() throws MessagingException {
        if (!this.initialized) {
            this.init();
        }
        if (this.primaryBodyPart == null) {
            this.primaryBodyPart = this.createBodyPart();
            this.getContainer().addBodyPart(this.primaryBodyPart, 0);
        }
        return this.primaryBodyPart;
    }

    protected MimeMultipart getContainer() {
        if (!this.initialized) {
            this.init();
        }
        return this.container;
    }

    protected BodyPart createBodyPart() {
        return new MimeBodyPart();
    }

    protected MimeMultipart createMimeMultipart() {
        return new MimeMultipart();
    }

    public boolean isBoolHasAttachments() {
        return this.boolHasAttachments;
    }

    public void setBoolHasAttachments(boolean b) {
        this.boolHasAttachments = b;
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    protected void setInitialized(boolean b) {
        this.initialized = b;
    }
}

