/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;

public final class MimeMessageUtils {
    private MimeMessageUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MimeMessage createMimeMessage(Session session, byte[] source) throws MessagingException, IOException {
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(source);
            MimeMessage mimeMessage = new MimeMessage(session, is);
            return mimeMessage;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MimeMessage createMimeMessage(Session session, File source) throws MessagingException, IOException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(source);
            MimeMessage mimeMessage = MimeMessageUtils.createMimeMessage(session, is);
            return mimeMessage;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public static MimeMessage createMimeMessage(Session session, InputStream source) throws MessagingException {
        return new MimeMessage(session, source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MimeMessage createMimeMessage(Session session, String source) throws MessagingException, IOException {
        ByteArrayInputStream is = null;
        try {
            byte[] byteSource = source.getBytes();
            is = new ByteArrayInputStream(byteSource);
            MimeMessage mimeMessage = MimeMessageUtils.createMimeMessage(session, is);
            return mimeMessage;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeMimeMessage(MimeMessage mimeMessage, File resultFile) throws MessagingException, IOException {
        FileOutputStream fos = null;
        try {
            if (!resultFile.getParentFile().exists() && !resultFile.getParentFile().mkdirs()) {
                throw new IOException("Failed to create the following parent directories: " + resultFile.getParentFile());
            }
            fos = new FileOutputStream(resultFile);
            mimeMessage.writeTo(fos);
            fos.flush();
            fos.close();
            fos = null;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

