require("key_enums")

local hwKB = nil
local kbToggleKey = 35 -- (by default END key) lookup the key_enums.lua file to see what number corresponds to what key.

local hwPad = nil
local padToggleBtn = 8192 -- (by default RS/R3 button) lookup the key_enums.lua file to see what number corresponds to what button.

local enableController = false
local enableKeyboard = false
local enabled = false

re.on_pre_application_entry("UpdateBehavior", function() 
    if not hwKB then
        hwKB = sdk.get_managed_singleton("snow.GameKeyboard"):get_field("hardKeyboard")
    end
    if not hwPad then
        hwPad = sdk.get_managed_singleton("snow.Pad"):get_field("hard")
    end
end)

re.on_frame(function()
        if (hwKB:call("getTrg", kbToggleKey) and enableKeyboard) or (hwPad:call("orTrg", padToggleBtn) and enableController) then
			if enabled then
				enabled = false
			else
				enabled = true
			end
		end
end)

re.on_draw_ui(function()
	local changed = false

    if imgui.tree_node("First Person") then
        changed, enabled = imgui.checkbox("Enabled", enabled)
			if imgui.tree_node("Keybind shortcuts") then
				changed, enableController = imgui.checkbox("Controller (default: [RS/R3])", enableController)
				changed, enableKeyboard = imgui.checkbox("Keyboard (default: [END])", enableKeyboard)
				imgui.tree_pop()
		    end
        imgui.tree_pop()
    end
end)

function getType(name)
	return sdk.find_type_definition(name)
end

function getSingletonData(name)
	return { sdk.get_managed_singleton(name), getType(name) }
end

function getSingletonField(singleton, name)
	local singletonRef, typedef = table.unpack(singleton)
	return sdk.get_native_field(singletonRef, typedef, name)
end

local function get_localplayer()
    local player_manager = sdk.get_managed_singleton("snow.player.PlayerManager")
    if not player_manager then 
        return nil
    end

    local player = player_manager:call("findMasterPlayer")
    if not player then 
        return nil
    end

    return player
end


local function get_player_head_joint()
    local player = get_localplayer()
    if not player then return nil end

    local player_gameobject = player:call("get_GameObject")
    if not player_gameobject then return nil end

    local player_transform = player_gameobject:call("get_Transform")
    if not player_transform then return nil end
    return player_transform:call("getJointByName", "Head_00")
end

local function get_camera_joint()
    local camera = sdk.get_primary_camera()
    if not camera then return nil end

    local camera_gameobject = camera:call("get_GameObject")
    if not camera_gameobject then return nil end

    local camera_transform = camera_gameobject:call("get_Transform")
    if not camera_transform then return nil end

    return camera_transform:call("get_Joints"):get_elements()[1]
end

re.on_pre_application_entry("PrepareRendering", function()
    if enabled then
        local player_head = get_player_head_joint()
        if player_head then
            player_head:call("set_LocalScale", Vector3f.new(0, 0, 0))
        end
    end
end)

re.on_pre_application_entry("BeginRendering", function()
    if enabled then
        local player_head = get_player_head_joint()
        local camera_joint = get_camera_joint()
        if not player_head or not camera_joint then return end

        camera_joint:call("set_Position", player_head:call("get_Position"))
    end
end)