// RAINBOND, Application Management Platform
// Copyright (C) 2014-2017 Goodrain Co., Ltd.

// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version. For any non-GPL usage of Rainbond,
// one or multiple Commercial Licenses authorized by Goodrain Co., Ltd.
// must be obtained first.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

package probe

import (
	"context"
	"fmt"
	"testing"

	"github.com/goodrain/rainbond/node/nodem/service"
)

func TestHttpProbe_Check(t *testing.T) {
	ctx, cancel := context.WithCancel(context.Background())
	resultChannel := make(chan *service.HealthStatus, 10)
	httpProbe := HttpProbe{
		Name:         "builder",
		Address:      "127.0.0.1:9090/health",
		Ctx:          ctx,
		Cancel:       cancel,
		ResultsChan:  resultChannel,
		TimeInterval: 3,
	}
	go httpProbe.Check()
	for {
		result := <-resultChannel
		fmt.Println(result.Name, result.Status, result.Info)
	}
}
