using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Configuration;
using System.IO;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Input;
using ff14bot;
using ff14bot.Enums;
using ff14bot.Helpers;
using ff14bot.Managers;
using ff14bot.Navigation;
using ff14bot.AClasses;
using ff14bot.Behavior;
using TreeSharp;
using System.Windows.Forms;
using Action = TreeSharp.Action;

namespace RaidBro
{

    public class RaidBroSettings : JsonSettings
    {

        private static RaidBroSettings _settings;

        public static RaidBroSettings Instance
        {
            get { return _settings ?? (_settings = new RaidBroSettings()); }
        }

        public RaidBroSettings()
            : base(Path.Combine(CharacterSettingsDirectory, "RaidBroSettings.json"))
        {
            //Logging.Write(shit);
        }




        private Keys _pausekey;
        //private string shit = ((int) Keys.X).ToString();
        [Setting]
        [Description("Changes take effect after stopping and starting the bot")]
        [DefaultSettingValue("65624")] //shift +x
        public Keys PauseKey
        {
            get { return _pausekey; }
            set
            {
                if (_pausekey != value)
                {
                    _pausekey = value;
                    Save();
                }

            }
        }


    }

    public class RaidBro : BotBase
    {
        public override string Name
        {
            get { return "Combat Assist"; }
        }


        public override bool WantButton
        {
            get
            {
                return true;
            }
        }

        private SettingsForm settings;
        public override void OnButtonPress()
        {
            if (settings == null || settings.IsDisposed)
                settings = new SettingsForm();
            try
            {
                settings.Show();
                settings.Activate();
            }
            catch (ArgumentOutOfRangeException ee)
            {

            }
        }

        public static Keys Key(Keys number)
        {
            return (Keys)((int)number & 0x0000FFFF);
        }
        public static ModifierKeys ModifierKey(Keys number)
        {
            var key = (Keys)((int)number & 0xFFFF0000);
            return (ModifierKeys)Enum.Parse(typeof(ModifierKeys), key.ToString());
        }

        public bool IsPaused;


        public void setupHotkey()
        {


            HotkeyManager.Register("Raidbro Pause", Key(RaidBroSettings.Instance.PauseKey), ModifierKey(RaidBroSettings.Instance.PauseKey),
    hk =>
    {
        IsPaused = !IsPaused;
        Logging.Write(IsPaused ? "RaidBro Paused!" : "RaidBro Resumed!");
    });
        }


        public override void Start()
        {
            Navigator.PlayerMover = new NullMover();
			Navigator.NavigationProvider = new NullProvider();
            setupHotkey();


            Logging.Write("Starting Combat Assist");
            GameSettingsManager.FaceTargetOnAction = false;
        }

        public override void Stop()
        {
            HotkeyManager.Unregister("Raidbro Pause");
        }

        public override PulseFlags PulseFlags
        {
            get { return PulseFlags.All; }
        }

        private Composite _root;
        public override Composite Root
        {
            get
            {
                return _root ?? (_root =



                    new Decorator(r=>!IsPaused,new Decorator(r => Core.Player.InCombat && Core.Player.HasTarget, 
                        new PrioritySelector(
                         RoutineManager.Current.HealBehavior,
                        RoutineManager.Current.CombatBuffBehavior,
                        RoutineManager.Current.CombatBehavior

                        ))));
            }
        }

        public override bool RequiresProfile
        {
            get { return false; }
        }

    }
}
