﻿using System;
using System.CodeDom;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using ff14bot;
using ff14bot.Enums;
using ff14bot.Managers;

namespace QuestDev
{


    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            propertyGrid1.PropertySort = PropertySort.NoSort;

            Refresh();

        }

        private void button1_Click(object sender, EventArgs e)
        {
            Refresh();
        }

        private Random rnd = new Random();
        private void comboBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            //button1.Text = rnd.Next().ToString();
            propertyGrid1.SelectedObject = comboBox1.SelectedItem;
        }

        private void Form1_Load(object sender, EventArgs e)
        {

        }



        private string pickupQuest = @"
<!-- {0} -->
<If Condition=""IsQuestAcceptQualified({1})"">
	<PickupQuest NpcId=""{2}"" QuestId=""{1}"" />
</If>";




        private void Refresh()
        {
            using (Core.Memory.TemporaryCacheState(false))
            {

                var questData = comboBox1.SelectedItem as QuestWork;
                var quests = QuestLogManager.Quests();

                comboBox1.DataSource = quests;
                comboBox1.DisplayMember = "Name";
                comboBox1.ValueMember = "Name";

                if (questData != null)
                {
                    if (quests.Length > 0)
                        comboBox1.SelectedItem = quests.FirstOrDefault(r => r.Name == questData.Name) ?? quests[0];
                }


                lbKeyItems.DataSource = InventoryManager.GetBagByInventoryBagId(InventoryBagId.KeyItems).FilledSlots;

                lbKeyItems.DisplayMember = "Name";
                lbKeyItems.ValueMember = "Name";

            }


        }

        private void button2_Click(object sender, EventArgs e)
        {
            using (Core.Memory.TemporaryCacheState(false))
            {
                var questData = comboBox1.SelectedItem as QuestWork;
                if (questData != null)
                {
                    var output = string.Format(pickupQuest, questData.Name, questData.GlobalId, Core.Target.NpcId);
                    Clipboard.SetText(output);
                }


            }
        }



        private string turninQuest = @"
<!-- {0} -->
<If Condition=""GetQuestStep({1}) == 255"">
	<TurnIn QuestId=""{1}"" NpcId=""{2}"" XYZ=""{3}"" />
</If> ";


        private string turninQuestitems = @"
<!-- {0} -->
<If Condition=""GetQuestStep({1}) == 255"">
	<TurnIn QuestId=""{1}"" NpcId=""{2}"" ItemId=""{4}"" XYZ=""{3}"" />
</If> ";

        private string ifQuestStep = @"
<!-- {0} -->
<If Condition=""GetQuestStep({1}) == {2}"">
        
</If>";

        private string ifQuestData = @"
<!-- {0} -->
<If Condition=""HasQuest({1}) and GetQuestById({1}).{2} == {3}"">
        
</If>";


        private string talkNothing = @"
<TalkTo InteractDistance=""3.0""  NpcId=""{0}"" XYZ=""{1}"" />
";


        private string talkStandard = @"
<TalkTo InteractDistance=""3.0"" QuestId=""66873"" StepId=""1"" NpcId=""1005932"" XYZ=""-1.236023, 33.38838, -244.1902"" />
";


        private string UseTransport = @"
<UseTransport NpcId=""{0}"" InteractDistance=""3.5"" XYZ=""{1}"" />
";


        private string Handover = @"
<HandOver ItemId=""{0}"" QuestId=""{1}"" StepId=""{2}"" NpcId=""{3}"" XYZ=""{4}"" />
";

        private void button3_Click(object sender, EventArgs e)
        {
            using (Core.Memory.TemporaryCacheState(false))
            {
                var questData = comboBox1.SelectedItem as QuestWork;
                if (questData != null)
                {

                    var location = Core.Target.Location.ToString().Remove(0, 1);
                    location = location.Remove(location.Length - 1, 1);


                    if (lbKeyItems.SelectedItems.Count > 0)
                    {
                        var itemids = string.Join(",", lbKeyItems.SelectedItems.Cast<BagSlot>().Select(r => r.TrueItemId));

                        var output = string.Format(turninQuestitems, questData.Name, questData.GlobalId, Core.Target.NpcId, location, itemids);
                        Clipboard.SetText(output);
                    }
                    else
                    {

                        var output = string.Format(turninQuest, questData.Name, questData.GlobalId, Core.Target.NpcId, location);
                        Clipboard.SetText(output);
                    }

                }


            }
        }

        private void lbKeyItems_MouseDown(object sender, MouseEventArgs e)
        {
            var index = lbKeyItems.IndexFromPoint(e.Location);
            if (index == ListBox.NoMatches)
            {
                lbKeyItems.ClearSelected();
            }

        }

        private void button4_Click(object sender, EventArgs e)
        {
            using (Core.Memory.TemporaryCacheState(false))
            {

                if (propertyGrid1.SelectedGridItem != null)
                {
                    var property = propertyGrid1.SelectedGridItem.Label;
                    if (property == "Step")
                    {


                        var questData = comboBox1.SelectedItem as QuestWork;
                        if (questData != null)
                        {
                            var output = string.Format(ifQuestStep, questData.Name, questData.GlobalId, questData.Step);
                            Clipboard.SetText(output);
                        }
                    }
                    else
                    {
                        var questData = comboBox1.SelectedItem as QuestWork;
                        if (questData != null)
                        {
                            var output = string.Format(ifQuestData, questData.Name, questData.GlobalId, property,propertyGrid1.SelectedGridItem.Value);
                            Clipboard.SetText(output);
                        }
                    }

                }
            }
        }

        private void button5_Click(object sender, EventArgs e)
        {
            using (Core.Memory.TemporaryCacheState(false))
            {
                var questData = comboBox1.SelectedItem as QuestWork;
                if (questData != null)
                {

                    var location = Core.Target.Location.ToString().Remove(0, 1);
                    location = location.Remove(location.Length - 1, 1);
                    var output = string.Format(talkNothing, Core.Target.NpcId, location);
                    Clipboard.SetText(output);
                }
            }
        }

        private void button6_Click(object sender, EventArgs e)
        {
            using (Core.Memory.TemporaryCacheState(false))
            {
                var location = Core.Target.Location.ToString().Remove(0, 1);
                location = location.Remove(location.Length - 1, 1);
                var output = string.Format(UseTransport, Core.Target.NpcId, location);
                Clipboard.SetText(output);
            }
        }

        private void button7_Click(object sender, EventArgs e)
        {
            using (Core.Memory.TemporaryCacheState(false))
            {

                var questData = comboBox1.SelectedItem as QuestWork;
                if (questData != null)
                {


                    if (lbKeyItems.SelectedItems.Count > 0)
                    {
                        var itemids = string.Join(",", lbKeyItems.SelectedItems.Cast<BagSlot>().Select(r => r.TrueItemId));
                        var location = Core.Target.Location.ToString().Remove(0, 1);
                        location = location.Remove(location.Length - 1, 1);
                        var output = string.Format(Handover, itemids, questData.GlobalId, questData.Step, Core.Target.NpcId, location);
                        Clipboard.SetText(output);
                    }




                }
            }
        }

    }


    public class QuestWrapper
    {


        public QuestWrapper(QuestWork value)
        {
            Value = value;
        }
        public QuestWork Value { get; set; }

        public override string ToString()
        {
            return Value.Name;
        }
    }

}
