﻿using RimWorld;
using System;
using System.Reflection;
using System.Text;
using UnityEngine;
using Verse;

namespace RimFridge
{
    public class Building_Refrigerator : Building_Storage
    {
        public CompPowerTrader powerComp;

        public CompGlower glow;

        public float Temp = -3000f;

        public override void SpawnSetup(Map map)
        {
            base.SpawnSetup(map);
            this.powerComp = base.GetComp<CompPowerTrader>();
            this.glow = base.GetComp<CompGlower>();
        }

        public override void ExposeData()
        {
            base.ExposeData();
            Scribe_Values.LookValue<float>(ref this.Temp, "temp", -3000f, false);
        }

        public override void TickRare()
        {
            bool flag = this.Temp < -2000f;
            if (flag)
            {
                this.Temp = GridsUtility.GetTemperature(this.Position,this.Map);
            }
            foreach (IntVec3 current in this.AllSlotCells())
            {
                foreach (Thing current2 in GridsUtility.GetThingList(current,this.Map))
                {
                    CompRottable compRottable = ThingCompUtility.TryGetComp<CompRottable>(current2);
                    bool flag2 = compRottable != null && !(compRottable is CompBetterRottable);
                    if (flag2)
                    {
                        ThingWithComps thingWithComps = current2 as ThingWithComps;
                        CompBetterRottable compBetterRottable = new CompBetterRottable();
                        thingWithComps.AllComps.Remove(compRottable);
                        thingWithComps.AllComps.Add(compBetterRottable);
                        compBetterRottable.props = compRottable.props;
                        compBetterRottable.parent = thingWithComps;
                        compBetterRottable.RotProgress = compRottable.RotProgress;
                    }
                    bool flag3 = ThingCompUtility.TryGetComp<CompFrosty>(current2) == null && current2.def.defName == "Beer";
                    if (flag3)
                    {
                        ThingWithComps thingWithComps2 = current2 as ThingWithComps;
                        CompFrosty compFrosty = new CompFrosty();
                        thingWithComps2.AllComps.Add(compFrosty);
                        compFrosty.props = CompProperties_Frosty.Beer;
                        compFrosty.parent = thingWithComps2;
                        ((TickList)typeof(TickManager).GetField("tickListRare", BindingFlags.Instance | BindingFlags.NonPublic).GetValue(Find.TickManager)).RegisterThing(thingWithComps2);
                    }
                }
            }
            float temperature = GridsUtility.GetTemperature(base.Position,this.Map);
            float num = (temperature - this.Temp) * 0.01f;
            float num2 = -num;
            float num3 = 0f;
            bool flag4 = this.Temp + num > -10f;
            if (flag4)
            {
                float num4 = Mathf.Max(-10f - (this.Temp + num), -1f);
                bool flag5 = this.powerComp != null && this.powerComp.PowerOn;
                if (flag5)
                {
                    num += num4;
                    num2 -= num4 * 1.25f;
                }
                num3 = num4 * -1f;
            }
            this.Temp += num;
            GridsUtility.GetRoom(base.Position,this.Map).PushHeat(num2 * 1.25f);
            this.powerComp.PowerOutput = -((CompProperties_Power)this.powerComp.props).basePowerConsumption * (num3 * 0.9f + 0.1f);
        }

        public override string GetInspectString()
        {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.Append(base.GetInspectString());
            stringBuilder.AppendLine(Translator.Translate("TargetTemperature") + ": " + GenText.ToStringTemperature(-10f, "F0"));
            stringBuilder.AppendLine(Translator.Translate("Temperature") + ": " + GenText.ToStringTemperature(this.Temp, "F0"));
            stringBuilder.AppendLine("Power: " + ((this.powerComp != null && this.powerComp.PowerOn) ? "On" : "Off"));
            return stringBuilder.ToString();
        }
    }
}
