﻿using RimWorld;
using System;
using System.Collections.Generic;
using System.Text;
using UnityEngine;
using Verse;

namespace RimFridge
{
    public class CompBetterRottable : CompRottable
    {
        private CompProperties_Rottable PropsRot
        {
            get
            {
                return (CompProperties_Rottable)this.props;
            }
        }

        public override string CompInspectStringExtra()
        {
            StringBuilder stringBuilder = new StringBuilder();
            switch (base.Stage)
            {
                case RotStage.Fresh:
                    stringBuilder.AppendLine(Translator.Translate("RotStateFresh"));
                    break;
                case RotStage.Rotting:
                    stringBuilder.AppendLine(Translator.Translate("RotStateRotting"));
                    break;
                case RotStage.Dessicated:
                    stringBuilder.AppendLine(Translator.Translate("RotStateDessicated"));
                    break;
            }
            float num = (float)this.PropsRot.TicksToRotStart - base.RotProgress;
            bool flag = num > 0f;
            if (flag)
            {
                float num2 = GenTemperature.GetTemperatureForCell(this.parent.PositionHeld,this.parent.Map);
                List<Thing> list = this.parent.Map.thingGrid.ThingsListAtFast(this.parent.PositionHeld);
                for (int i = 0; i < list.Count; i++)
                {
                    bool flag2 = list[i] is Building_Refrigerator;
                    if (flag2)
                    {
                        Building_Refrigerator building_Refrigerator = list[i] as Building_Refrigerator;
                        num2 = building_Refrigerator.Temp;
                        break;
                    }
                }
                num2 = (float)Mathf.RoundToInt(num2);
                float num3 = GenTemperature.RotRateAtTemperature(num2);
                int ticksUntilRotAtCurrentTemp = base.TicksUntilRotAtCurrentTemp;
                bool flag3 = num3 < 0.001f;
                if (flag3)
                {
                    stringBuilder.AppendLine(Translator.Translate("CurrentlyFrozen"));
                }
                else
                {
                    bool flag4 = num3 < 0.999f;
                    if (flag4)
                    {
                        stringBuilder.AppendLine(Translator.Translate("CurrentlyRefrigerated", new object[]
                        {
                            GenDate.ToStringTicksToPeriodVagueMax(ticksUntilRotAtCurrentTemp)
                        }));
                    }
                    else
                    {
                        stringBuilder.AppendLine(Translator.Translate("NotRefrigerated", new object[]
                        {
                            GenDate.ToStringTicksToPeriodVagueMax(ticksUntilRotAtCurrentTemp)
                        }));
                    }
                }
            }
            return stringBuilder.ToString().Trim();
        }

        public override void CompTickRare()
        {
            float rotProgress = base.RotProgress;
            float num = 1f;
            float num2 = GenTemperature.GetTemperatureForCell(this.parent.PositionHeld,this.parent.Map);
            List<Thing> list = this.parent.Map.thingGrid.ThingsListAtFast(this.parent.PositionHeld);
            for (int i = 0; i < list.Count; i++)
            {
                bool flag = list[i] is Building_Refrigerator;
                if (flag)
                {
                    Building_Refrigerator building_Refrigerator = list[i] as Building_Refrigerator;
                    num2 = building_Refrigerator.Temp;
                    break;
                }
            }
            num *= GenTemperature.RotRateAtTemperature(num2);
            base.RotProgress = base.RotProgress + Mathf.Round(num * 250f);
            bool flag2 = base.Stage == RotStage.Rotting && this.PropsRot.rotDestroys;
            if (flag2)
            {
                bool flag3 = this.parent.Map.slotGroupManager.SlotGroupAt(this.parent.Position) != null;
                if (flag3)
                {
                    Messages.Message(GenText.CapitalizeFirst(Translator.Translate("MessageRottedAwayInStorage", new object[]
                    {
                        this.parent.Label
                    })), 0);
                    LessonAutoActivator.TeachOpportunity(ConceptDefOf.SpoilageAndFreezers, 0);
                }
                this.parent.Destroy(0);
            }
            else
            {
                bool flag4 = Mathf.FloorToInt(rotProgress / 60000f) != Mathf.FloorToInt(base.RotProgress / 60000f);
                bool flag5 = flag4;
                if (flag5)
                {
                    bool flag6 = base.Stage == RotStage.Rotting && this.PropsRot.rotDamagePerDay > 0f;
                    if (flag6)
                    {
                        this.parent.TakeDamage(new DamageInfo(DamageDefOf.Rotting, GenMath.RoundRandom(this.PropsRot.rotDamagePerDay),-1, null, null, null));
                    }
                    else
                    {
                        bool flag7 = base.Stage == RotStage.Dessicated && this.PropsRot.dessicatedDamagePerDay > 0f && this.ShouldTakeDessicateDamage();
                        if (flag7)
                        {
                            this.parent.TakeDamage(new DamageInfo(DamageDefOf.Rotting, GenMath.RoundRandom(this.PropsRot.dessicatedDamagePerDay),-1, null, null, null));
                        }
                    }
                }
            }
        }

        private bool ShouldTakeDessicateDamage()
        {
            bool flag = this.parent.holdingContainer != null;
            bool result;
            if (flag)
            {
                Thing thing = this.parent.holdingContainer.owner as Thing;
                bool flag2 = thing != null && thing.def.category == ThingCategory.Building && thing.def.building.preventDeterioration;
                if (flag2)
                {
                    result = false;
                    return result;
                }
            }
            result = true;
            return result;
        }

        private void StageChanged()
        {
            Corpse corpse = this.parent as Corpse;
            bool flag = corpse != null;
            if (flag)
            {
                corpse.RotStageChanged();
            }
        }
    }
}
