# copyright: Huynh Duong Phuong Vi
# www.sketchupforyou.com
module S4U
    def self.get_file(dir_s4u_name,s4u_name,ext=".txt")
        file_name = s4u_name + ext
        file_name_full = File.join dir_s4u_name,file_name
        if File.exist?(file_name_full)
            file= File.new(file_name_full,"r")
            str=file.readlines
            file.close
            return str.collect{|s| s.chomp}
        end
        return false
        rescue=>error
            p error,error.backtrace.join('\n')
            return false
    end
    def self.set_file(dir_s4u_name,s4u_name,list,ext=".txt")
        file_name = s4u_name + ext
        file_name_full = File.join dir_s4u_name,file_name
        file= File.new(file_name_full, mode: 'w:UTF-8')
        str=list.join("\n")
        file.syswrite str
        file.close
        return true
        rescue=>error
            p error,error.backtrace.join('\n')
            return false
    end
	module S4u_reset_axis
		def self.reset_axis(group,mode=[0,1])
			trans_instances=group.definition.instances.collect{|i| [i,i.transformation]}
			entities=group.definition.entities
            if mode[0]==0
                axes= Sketchup.active_model.axes.transformation
                origin=group.bounds.center.transform axes.inverse
                t=group.transformation
                trans_new=Geom::Transformation.new(axes.xaxis,axes.yaxis,axes.zaxis,origin)
            else
                axes= Geom::Transformation.new
                origin=group.bounds.center.transform axes.inverse
                t=group.transformation
                trans_new=Geom::Transformation.new(origin)
            end
            if mode[1]==1
                axes= Sketchup.active_model.axes.transformation
                edges= self.select_edges(group)
				edges.uniq!{|e| e[0]}
                edges=edges.collect{|e| [e[0].start.position.transform(e[1]),e[0].end.position.transform(e[1])]}
				select_edges=edges.group_by{|e| e[0].z + e[1].z }.to_a.sort_by{|e| e[0]}[0][1]
                select_edges=select_edges.group_by{|e| e[0].y + e[1].y }.to_a.sort_by{|e| e[0]}[0][1]
                ed= select_edges[0]
                xaxis= (ed[1].x > ed[0].x) ? (ed[1]-ed[0]) : (ed[0]-ed[1])
                yaxis=Z_AXIS.cross xaxis
                axes= Geom::Transformation.new xaxis,yaxis,axes.zaxis,axes.origin
                origin=group.bounds.center.transform axes.inverse
                t=group.transformation
                trans_new=Geom::Transformation.new(axes.xaxis,axes.yaxis,axes.zaxis,origin)
            elsif mode[1]==2
				axes= Sketchup.active_model.axes.transformation
                edges= self.select_edges(group)
				edges.uniq!{|e| e[0]}
                edges=edges.collect{|e| [e[0].start.position.transform(e[1]),e[0].end.position.transform(e[1])]}
				select_edges=edges.group_by{|e| (e[0].z + e[1].z).round(9) }.to_a.sort_by{|e| e[0]}[0][1]

                select_edges=select_edges.group_by{|e| e[0].distance(e[1]).round(9)}.to_a.sort_by{|e| e[0]}[-1][1]
                select_edges=select_edges.group_by{|e| (e[0].y + e[1].y).round(9) }.to_a.sort_by{|e| e[0]}[0][1]
                ed= select_edges[0]
                xaxis= (ed[1].x > ed[0].x) ? (ed[1]-ed[0]) : (ed[0]-ed[1])
                yaxis=Z_AXIS.cross xaxis
                axes= Geom::Transformation.new xaxis,yaxis,axes.zaxis,axes.origin
                origin=group.bounds.center.transform axes.inverse
                t=group.transformation
                trans_new=Geom::Transformation.new(axes.xaxis,axes.yaxis,axes.zaxis,origin)
            elsif mode[1]==3
				axes= Sketchup.active_model.axes.transformation
                edges= self.select_edges(group)
				edges.uniq!{|e| e[0]}
                edges=edges.collect{|e| [e[0].start.position.transform(e[1]),e[0].end.position.transform(e[1])]}
				select_edges=edges.group_by{|e| (e[0].z + e[1].z).round(9) }.to_a.sort_by{|e| e[0]}[0][1]

                select_edges=select_edges.group_by{|e| e[0].distance(e[1]).round(9)}.to_a.sort_by{|e| e[0]}[0][1]
                select_edges=select_edges.group_by{|e| (e[0].y + e[1].y).round(9) }.to_a.sort_by{|e| e[0]}[0][1]
                ed= select_edges[0]
                xaxis= (ed[1].x > ed[0].x) ? (ed[1]-ed[0]) : (ed[0]-ed[1])
                yaxis=Z_AXIS.cross xaxis
                axes= Geom::Transformation.new xaxis,yaxis,axes.zaxis,axes.origin
                origin=group.bounds.center.transform axes.inverse
                t=group.transformation
                trans_new=Geom::Transformation.new(axes.xaxis,axes.yaxis,axes.zaxis,origin)
            elsif mode[1]==4
				axes= Sketchup.active_model.axes.transformation
                edges= self.select_edges(group)
				edges.uniq!{|e| e[0]}
                edges=edges.collect{|e| [e[0].start.position.transform(e[1]),e[0].end.position.transform(e[1])]}
				select_edges=edges.group_by{|e| (e[0].z + e[1].z).round(9) }.to_a.sort_by{|e| e[0]}[0][1]

                select_edges=select_edges.group_by{|e| e[0].distance(e[1]).round(9)}.to_a.sort_by{|e| e[0]}[0][1]
                select_edges=select_edges.group_by{|e| (e[0].x + e[1].x).round(9) }.to_a.sort_by{|e| e[0]}[0][1]
                ed= select_edges[0]
                yaxis= (ed[1].x > ed[0].x) ? (ed[1]-ed[0]) : (ed[0]-ed[1])
                xaxis=yaxis.cross Z_AXIS
                axes= Geom::Transformation.new xaxis,yaxis,axes.zaxis,axes.origin
                origin=group.bounds.center.transform axes.inverse
                t=group.transformation
                trans_new=Geom::Transformation.new(axes.xaxis,axes.yaxis,axes.zaxis,origin)
            elsif mode[1]==5
                axes= Sketchup.active_model.axes.transformation
                edges= self.select_edges(group)
				edges.uniq!{|e| e[0]}
                edges=edges.collect{|e| [e[0].start.position.transform(e[1]),e[0].end.position.transform(e[1])]}
				select_edges=edges.group_by{|e| e[0].z + e[1].z }.to_a.sort_by{|e| e[0]}[0][1]
                select_edges=select_edges.group_by{|e| e[0].x + e[1].x }.to_a.sort_by{|e| e[0]}[0][1]
                ed= select_edges[0]
                yaxis= (ed[1].x > ed[0].x) ? (ed[1]-ed[0]) : (ed[0]-ed[1])
                xaxis=yaxis.cross Z_AXIS
                axes= Geom::Transformation.new xaxis,yaxis,axes.zaxis,axes.origin
                origin=group.bounds.center.transform axes.inverse
                t=group.transformation
                trans_new=Geom::Transformation.new(axes.xaxis,axes.yaxis,axes.zaxis,origin)
            elsif mode[1]==6
				axes= Sketchup.active_model.axes.transformation
                edges= self.select_edges(group)
				edges.uniq!{|e| e[0]}
                edges=edges.collect{|e| [e[0].start.position.transform(e[1]),e[0].end.position.transform(e[1])]}
				select_edges=edges.group_by{|e| (e[0].z + e[1].z).round(9) }.to_a.sort_by{|e| e[0]}[0][1]

                select_edges=select_edges.group_by{|e| e[0].distance(e[1]).round(9)}.to_a.sort_by{|e| e[0]}[-1][1]
                select_edges=select_edges.group_by{|e| (e[0].x + e[1].x).round(9) }.to_a.sort_by{|e| e[0]}[0][1]
                ed= select_edges[0]
                yaxis= (ed[1].x > ed[0].x) ? (ed[1]-ed[0]) : (ed[0]-ed[1])
                xaxis=yaxis.cross Z_AXIS
                axes= Geom::Transformation.new xaxis,yaxis,axes.zaxis,axes.origin
                origin=group.bounds.center.transform axes.inverse
                t=group.transformation
                trans_new=Geom::Transformation.new(axes.xaxis,axes.yaxis,axes.zaxis,origin)
            elsif mode[1]==7
				axes= Sketchup.active_model.axes.transformation
                edges= self.select_edges(group)
				edges.uniq!{|e| e[0]}
                edges=edges.collect{|e| [e[0].start.position.transform(e[1]),e[0].end.position.transform(e[1])]}
				select_edges=edges.group_by{|e| (e[0].z + e[1].z).round(9) }.to_a.sort_by{|e| e[0]}[0][1]

                select_edges=select_edges.group_by{|e| e[0].distance(e[1]).round(9)}.to_a.sort_by{|e| e[0]}[0][1]
                select_edges=select_edges.group_by{|e| (e[0].x + e[1].x).round(9) }.to_a.sort_by{|e| e[0]}[0][1]
                ed= select_edges[0]
                yaxis= (ed[1].x > ed[0].x) ? (ed[1]-ed[0]) : (ed[0]-ed[1])
                xaxis=yaxis.cross Z_AXIS
                axes= Geom::Transformation.new xaxis,yaxis,axes.zaxis,axes.origin
                origin=group.bounds.center.transform axes.inverse
                t=group.transformation
                trans_new=Geom::Transformation.new(axes.xaxis,axes.yaxis,axes.zaxis,origin)
            end
			entities.transform_entities axes.inverse*t,entities.to_a
			group.transformation = trans_new
			group.definition.invalidate_bounds
			center=origin.transform axes.inverse
			entities.transform_entities Geom::Transformation.translation(ORIGIN-center),entities.to_a
			group.definition.invalidate_bounds
			trans_instances.each{|e1|
				e1[0].transformation= e1[0].transformation*t.inverse*group.transformation if e1[0]!=group
			}
			self.move_origin(group.definition)
		end
		def self.move_origin(defn,center=false)
			bounds_new= Geom::BoundingBox.new
			defn.entities.each{|de| bounds_new.add(de.bounds)}
			center_new = center ? bounds_new.center : bounds_new.min
			defn.entities.transform_entities(Geom::Transformation.translation(ORIGIN-center_new), defn.entities.to_a)
			defn.instances.each{|e|
				   origin_new=center_new.transform(e.transformation)
				   e.transform!(origin_new-e.transformation.origin)
			}
		end
        def self.select_edges(element,edit_transform=Geom::Transformation.new.inverse)
			model = Sketchup.active_model
			entities=element.definition.entities
			edges=[]
			entities.each{|e|
				if e.is_a?Sketchup::Edge
					edges<< [e,edit_transform*element.transformation,element]
				elsif e.is_a?(Sketchup::Group) || e.is_a?(Sketchup::ComponentInstance)
					#e=e.make_unique if e.is_a?Sketchup::Group
					edges+= self.select_edges e,(edit_transform*element.transformation)
				end
			}
			return edges
		end
		def self.select_definitions(defn)
			ds=defn.entities.select{|e| e.is_a?(Sketchup::Group) || e.is_a?(Sketchup::ComponentInstance)}
			defns=ds.collect{|e| e.definition}.uniq
			if defns.length>0
				defns.each{|d| defns+=self.select_definitions(d) }
			end
			return defns
		end
        class Reset_Axis
			def initialize(mode)
                @mode_reset=@mode_move=nil
                if mode<1
                    @mode_reset=[0,1]
                    @mode=0
                    @mode_list_axis=[Strings["Local Axis"],Strings["Global Axis"]]
                    @mode_list=[
                            Strings["Reset Axis"],
							Strings["Reset X Axis Follow Nearest Edge"],
                            Strings["Reset X Axis Follow Longest Edge"],
							Strings["Reset X Axis Follow Shortest Edge"]
                            ]
                else
                    @mode_move=mode-1
                    @mode=mode-1
                    @mode_list=[
                            Strings["Move Origin"],
                            Strings["Move Origin - All Inside"],
                            Strings["Move Origin To Center"],
							Strings["Move Origin To Center - All Inside"]]
                end
				@cursor_id = nil
				if IS_OSX
					name="icon_mouse.pdf"
				else
					name="icon_mouse.svg"
				end
				cursor_path = File.join(File.dirname(__FILE__),name)
				@cursor_id = UI.create_cursor(cursor_path, 0, 0) if cursor_path
			end
			def activate()
				model=Sketchup.active_model
                ents=model.active_entities
				sel=model.selection.select{|e| e.class==Sketchup::Group || e.class==Sketchup::ComponentInstance}
                @elements=nil
                get_setting()
                #p @mode,@mode_reset,@mode_list[@mode]
				if !sel.empty?
                    S4U::S4u_reset_axis.reset_main(sel,@mode_reset,@mode_move)
					Sketchup.active_model.select_tool nil
				end
				setstatus()
			end
			def deactivate(view)
                if @mode_reset
                    S4U::S4u_reset_axis.instance_variable_set :@last_setting,@mode_reset
                    save_setting
                end
			end
            def get_setting()
                if @mode_reset
                    @last_setting=S4U::S4u_reset_axis.instance_variable_get :@last_setting
                    if !(@last_setting && @last_setting[0].class==Hash)
                        @last_setting=[] if !@last_setting
                        if s=S4U::get_file(Dir_s4u_name,NAME)
                            @last_setting = JSON.parse(s[0])
                            @mode_reset=@last_setting["mode_reset"]
                        end
                    else
                        @mode_reset=@last_setting
                    end
                end
                rescue=> error
                p error,error.backtrace.join("\n")
            end
            def save_setting
                if @mode_reset
                    @last_setting={}
                    @last_setting["mode_reset"]=@mode_reset
                    S4U::set_file(Dir_s4u_name,NAME, [@last_setting.to_json])
                end
                rescue=> error
                p error,error.backtrace.join("\n")
            end
			def onSetCursor
				UI.set_cursor(@cursor_id) if @cursor_id
			end
            def getMenu(menu)
                menus=[]
                if @mode_reset
                    @mode_list_axis.each_index{|i|
                        menus<< menu.add_item(@mode_list_axis[i]) {@mode_reset[0]=i }
                    }
                    menus.each{|m| menu.set_validation_proc(m) { MF_UNCHECKED }}
                    menu.set_validation_proc(menus[@mode_reset[0]]) { MF_CHECKED }
                    menu.add_separator
                    menus=[]
                    @mode_list.each_index{|i|
                        menus<< menu.add_item(@mode_list[i]) {@mode_reset[1]=i }
                    }
                    menus.each{|m| menu.set_validation_proc(m) { MF_UNCHECKED }}
                    menu.set_validation_proc(menus[@mode_reset[1]]) { MF_CHECKED }
                else
                    @mode_list.each_index{|i|
                        menus<< menu.add_item(@mode_list[i]) {@mode_move=i }
                    }
                    menus.each{|m| menu.set_validation_proc(m) { MF_UNCHECKED }}
                    menu.set_validation_proc(menus[@mode_move]) { MF_CHECKED }
                end
			end
			def onLButtonUp(flags, x, y, view)
                if @elements
                    S4U::S4u_reset_axis.reset_main([@elements],@mode_reset,@mode_move)
                end
			end
			def onMouseMove(flags, x, y, view)
                @elements=nil
				ph = view.pick_helper
				ph.do_pick x,y
				entity = ph.best_picked
				if entity.class==Sketchup::Group || entity.class==Sketchup::ComponentInstance
                   @elements=entity
                   view.tooltip='      ' + @elements.definition.name + ((@elements.name!='') ? ("\n      " + @elements.name) : '' )
				end
                setstatus(view)
			end
			def setstatus(view=nil,text="")
                s=''
                if @mode_reset
                    s+=@mode_list_axis[@mode_reset[0]] + " | "
                    s+=@mode_list[@mode_reset[1]] + " | "
                else
                    s+=@mode_list[@mode_move] + " | "
                end
				s+= Strings["Select Component or Group"]  + " | "
                if @elements
                    s+= @elements.definition.name
                end
				Sketchup.status_text= s+text
				view.invalidate if view
			end
			def resume(view)
				setstatus()
			end
		end
        def self.reset_main(elements=Sketchup.active_model.selection.to_a,reset_axis=nil,reset_move=nil)
            model = Sketchup.active_model
			entities = model.active_entities
            select_elements=[]
            if elements
                select_elements=elements
                model.selection.add elements.select{|e|  e && e.valid? }
            else
			    select_elements=model.selection.select{|e| e if e.is_a?(Sketchup::Group) || e.is_a?(Sketchup::ComponentInstance)}
            end
            select_elements.each{|e| e.make_unique if e.class==Sketchup::Group}
			select_elements.uniq!{|e| e.definition }
			model.start_operation TOOL,true,false,false
				if reset_axis
					select_elements.each{|e| reset_axis(e,reset_axis) }
                elsif reset_move
					defns=[]
					select_elements.each{|e|
						defns<<e.definition
						if reset_move==1 || reset_move==3
							defns+=select_definitions(e.definition)
						end
					}
					defns.uniq!
					if reset_move==0 || reset_move==1
						defns.each{|e| move_origin(e,false) }
                    elsif reset_move==2 || reset_move==3
						defns.each{|e| move_origin(e,true) }
					end
				end
			model.commit_operation

			rescue=> error
			p error,error.backtrace.join("\n")
			model.abort_operation
        end
		def self.main(mode)
            Sketchup.active_model.select_tool Reset_Axis.new(mode)
        end
	end
end