# copyright: Huynh Duong Phuong Vi
# www.sketchupforyou.com
module S4U
	module S4u_reset_axis
		IS_WIN = (Sketchup.platform == :platform_win)
		IS_OSX = (Sketchup.platform == :platform_osx)
		Sketchup::require File.join(NAME,(NAME + "_code"))
		if !self.const_defined?("Dir_s4u_name")
			S4U.instance_variable_set(:@s4u_menu,UI.menu("Plugins").add_submenu("Suforyou")) if !S4U.instance_variable_defined?(:@s4u_menu)
			menu=S4U.instance_variable_get :@s4u_menu
			@submenu=menu.add_submenu TOOL
			@toolbar = UI::Toolbar.new("s4u-" + TOOL)
			names=[ [TOOL,NAME,Strings["Reset Axis Groups or Components."]],
					[Strings["Move Origin"],"s4u_move_origin",Strings["Move Origin Groups or Components."]],
					[Strings["Move Origin-ALL Inside"],"s4u_move_origin_all",Strings["Move Origin All Nested Groups or Components."]],
					[Strings["Move Origin To Center"],"s4u_move_origin_center",Strings["Move Origin To Center Groups or Components."]],
					[Strings["Move Origin To Center-ALL Inside"],"s4u_move_origin_center",Strings["Move Origin To Center ALL Nested Groups or Components."]]
				]
			if IS_OSX
				names.each{|n| n[1]+=".pdf"}
			else
				names.each{|n| n[1]+=".svg"}
			end
			(0..names.length-1).each{|i|
				cmd=UI::Command.new(names[i][0]){ self.main(i) }
				cmd.large_icon = names[i][1]
				cmd.small_icon = names[i][1]
				cmd.status_bar_text = names[i][2]
				cmd.tooltip= names[i][0]
				cmd.menu_text = names[i][0]
				@submenu.add_item cmd
				if i<3
					@toolbar=@toolbar.add_item cmd
				end
			}
			@toolbar.show if @toolbar.get_last_state.abs == 1
            Dir_s4u_name = File.join(File.dirname(@ext.extension_path),NAME)
		end
	end
end