input = {}

function input.startInputObserver(evc)
    local keys = {"Keyboard_1", "Keyboard_2", "Keyboard_3", "Keyboard_4", "Keyboard_5", "Keyboard_6", "Keyboard_7", "Keyboard_8", "Keyboard_9", "Keyboard_0"}

    Observe('PlayerPuppet', 'OnGameAttached', function(this)
        input.startListeners(this)
    end)

    Observe('PlayerPuppet', 'OnAction', function(_, action)
        if evc.runtimeData.inCar and not evc.settings.cetKeys then
            local actionName = Game.NameToString(action:GetName(action))
            local actionType = action:GetType(action).value
            if actionName == keys[evc.settings.headlightsInput] then
                if actionType == 'BUTTON_PRESSED' then
                    evc.utils.toggleHeadlights(evc)
                end
            elseif actionName == keys[evc.settings.windowsInput] or (evc.settings.controllerMode and actionName == "dpad_left") then
                if actionType == 'BUTTON_PRESSED' then
                    evc.utils.toggleWindows(evc)
                end
            end
        end
    end)
end

function input.startListeners(player)
    local keys = {"Keyboard_1", "Keyboard_2", "Keyboard_3", "Keyboard_4", "Keyboard_5", "Keyboard_6", "Keyboard_7", "Keyboard_8", "Keyboard_9", "Keyboard_0"}

    for _, key in pairs(keys) do
        player:UnregisterInputListener(player, key)
        player:RegisterInputListener(player, key)
    end
end

return input