-- If you want to add localized text for Native Settings UI, copy the "nui_XXX" parts from the "en-us" localization to your language and change the text

local lang = {
    ["en-us"] = {
        ["toggleHeadlightsHint"] = "Toggle Headlights",
        ["toggleWindowsHint"] = "Open / Close Windows",

        -- Native Settings UI stuff:
        ["nui_genSettings"] = "General Settings",
        ["nui_windowsSettings"] = "Window Controls",
        ["nui_lightsSettings"] = "Headlight State Controls",
        ["nui_controllerMode"] = "Controller mode",
        ["nui_controllerModeDesc"] = "Enables / Disables controller input scheme",
        ["nui_cetHotkeys"] = "Use CET Hotkeys",
        ["nui_cetHotkeysDesc"] = "If this is activated the hotkeys set in CET's \"Bindings\" menu will be used",
        ["nui_forceHide"] = "Force Hide Hints",
        ["nui_forceHideDesc"] = "Use this button in case the input hints wont go away",
        ["nui_forceHideButton"] = "Hide",
        ["nui_windowsKey"] = "Windows toggle key",
        ["nui_windowsKeyDesc"] = "The keyboard key that toggles the windows (Used if the \"Use CET Hotkeys\" option if off)",
        ["nui_showHints"] = "Show input hints",
        ["nui_windowsHintsDesc"] = "Toggles the input hints for the Windows open / close key (Unavailable if the \"Use CET Hotkeys\" option is on)",
        ["nui_lightsHintsDesc"] = "Toggles the input hints for the Headlights open / close key (Unavailable if the \"Use CET Hotkeys\" option is on)",
        ["nui_headlightsKey"] = "Headlights toggle key",
        ["nui_headlightsKeyDesc"] = "The keyboard key that toggles the headlights (Used if the \"Use CET Hotkeys\" option if off)",
        ["nui_kb1"] = "Keyboard 1",
        ["nui_kb2"] = "Keyboard 2",
        ["nui_kb3"] = "Keyboard 3",
        ["nui_kb4"] = "Keyboard 4",
        ["nui_kb5"] = "Keyboard 5",
        ["nui_kb6"] = "Keyboard 6",
        ["nui_kb7"] = "Keyboard 7",
        ["nui_kb8"] = "Keyboard 8",
        ["nui_kb9"] = "Keyboard 9",
        ["nui_kb0"] = "Keyboard 0"
    },
    ["de-de"] = {
        ["toggleHeadlightsHint"] = "Scheinwerfer Umschalten",
        ["toggleWindowsHint"] = "Fenster Öffnen / Schließen",
    },
    ["fr-fr"] = {
        ["toggleHeadlightsHint"] = "Phares à bascule",
        ["toggleWindowsHint"] = "Ouvrir / Fermer les fenêtres",
    },
    ["pl-pl"] = {
        ["toggleHeadlightsHint"] = "Przełączanie reflektorów",
        ["toggleWindowsHint"] = "Otwórz / Zamknij okna",
    },
    ["es-es"] = {
        ["toggleHeadlightsHint"] = "Conmutar los faros",
        ["toggleWindowsHint"] = "Abrir/cerrar ventanas",
    },
    ["es-mx"] = {
        ["toggleHeadlightsHint"] = "Conmutar los faros",
        ["toggleWindowsHint"] = "Abrir/cerrar ventanas",
    },
    ["it-it"] = {
        ["toggleHeadlightsHint"] = "Fari a levetta",
        ["toggleWindowsHint"] = "Aprire/chiudere le finestre",
    },
    ["kr-kr"] = {
        ["toggleHeadlightsHint"] = "헤드라이트 토글",
        ["toggleWindowsHint"] = "창 열기 / 닫기",
    },
    ["zh-cn"] = {
        ["toggleHeadlightsHint"] = "大灯 开/关",
        ["toggleWindowsHint"] = "车窗 开/关",
        ["nui_genSettings"] = "常规设置",
        ["nui_windowsSettings"] = "车窗控制",
        ["nui_lightsSettings"] = "大灯状态控制",
        ["nui_controllerMode"] = "控制器模式",
        ["nui_controllerModeDesc"] = "启用/禁用 控制器输入方案",
        ["nui_cetHotkeys"] = "使用 CET 热键",
        ["nui_cetHotkeysDesc"] = "如果激活此功能，将使用 CET 绑定菜单中 设置的热键",
        ["nui_forceHide"] = "强制隐藏提示",
        ["nui_forceHideDesc"] = "使用此按钮 以防输入提示不会消失",
        ["nui_forceHideButton"] = "隐藏",
        ["nui_windowsKey"] = "车窗 [开/关] 默认键（非NUM数字键）",
        ["nui_windowsKeyDesc"] = "车窗开关 按键《如果 开启使用CET热键》此按键则失效",
        ["nui_showHints"] = "显示输入提示",
        ["nui_windowsHintsDesc"] = "车窗 开/关键的输入提示《如果 开启使用CET热键》则不可用",
        ["nui_lightsHintsDesc"] = "大灯 开/关键的输入提示《如果 开启使用CET热键》则不可用",
        ["nui_headlightsKey"] = "大灯 [开/关] 默认键（非NUM数字键）",
        ["nui_headlightsKeyDesc"] = "大灯开关 按键《如果 开启使用CET热键》此按键则失效",
        ["nui_kb1"] = "数字键 1",
        ["nui_kb2"] = "数字键 2",
        ["nui_kb3"] = "数字键 3",
        ["nui_kb4"] = "数字键 4",
        ["nui_kb5"] = "数字键 5",
        ["nui_kb6"] = "数字键 6",
        ["nui_kb7"] = "数字键 7",
        ["nui_kb8"] = "数字键 8",
        ["nui_kb9"] = "数字键 9",
        ["nui_kb0"] = "数字键 0"
    },
	["zh-tw"] = {
        ["toggleHeadlightsHint"] = "切換大燈",
        ["toggleWindowsHint"] = "打開/關閉窗口",
    },
    ["ru-ru"] = {
        ["toggleHeadlightsHint"] = "Переключатель фар",
        ["toggleWindowsHint"] = "Открыть / закрыть окна",
    },
    ["jp-jp"] = {
        ["toggleHeadlightsHint"] = "トグルヘッドライト",
        ["toggleWindowsHint"] = "ウィンドウを開く/閉じる",
    },
    ["ar-ar"] = {
        ["toggleHeadlightsHint"] = "تبديل المصابيح الأمامية",
        ["toggleWindowsHint"] = "افتح / أغلق النوافذ",
    },
    ["cz-cz"] = {
        ["toggleHeadlightsHint"] = "Přepínání světlometů",
        ["toggleWindowsHint"] = "Otevření/zavření oken",
    },
    ["hu-hu"] = {
        ["toggleHeadlightsHint"] = "Fényszórók kapcsolása",
        ["toggleWindowsHint"] = "Ablakok nyitása/zárása",
    },
    ["tr-tr"] = {
        ["toggleHeadlightsHint"] = "Farları Değiştir",
        ["toggleWindowsHint"] = "Pencereleri Aç / Kapat",
    },
    ["pt-br"] = {
        ["toggleHeadlightsHint"] = "Alternar faróis",
        ["toggleWindowsHint"] = "Abrir/Fechar janelas",
    },
    ["th-th"] = {
        ["toggleHeadlightsHint"] = "สลับไฟหน้า",
        ["toggleWindowsHint"] = "เปิด / ปิด Windows",
    }
}

function lang.getLang()
    local l = Game.GetSettingsSystem():GetVar("/language", "OnScreen"):GetValue().value
    if lang[l] == nil then
        return "en-us"
    else
        return l
    end
end

function lang.getText(key)
    local text = lang[lang.getLang()][key]
    if not text then
        return lang["en-us"][key]
    end
    return text
end

function lang.getKey(text)
    for k, v in pairs(lang[lang.getLang()]) do
        if v == text then return k end
    end
end

return lang