local utils = require("modules/utils")
local lang = require("modules/lang")

ui = {}

function ui.init(mod)
    local nativeSettings = GetMod("nativeSettings")

    if not nativeSettings then
        print("[ExtraVehicleControls] Error: NativeSettings lib not found!")
        return
    end

    local cetVer = tonumber((GetVersion():gsub('^v(%d+)%.(%d+)%.(%d+)(.*)', function(major, minor, patch, wip) -- <-- This has been made by psiberx, all credits to him
        return ('%d.%02d%02d%d'):format(major, minor, patch, (wip == '' and 0 or 1))
    end)))

    if cetVer < 1.18 then
        return
    end

    nativeSettings.addTab("/evc", "额外车辆控制")

    nativeSettings.addSubcategory("/evc/gen", lang.getText("nui_genSettings"))
    nativeSettings.addSubcategory("/evc/windows", lang.getText("nui_windowsSettings"))
    nativeSettings.addSubcategory("/evc/lights", lang.getText("nui_lightsSettings"))

    nativeSettings.addSwitch("/evc/gen", lang.getText("nui_controllerMode"), lang.getText("nui_controllerModeDesc"), mod.settings.controllerMode, mod.defaultSettings.controllerMode, function(state)
        mod.settings.controllerMode = state
        config.saveFile("config.json", mod.settings)
        utils.updateHints(mod)
    end)

    nativeSettings.addSwitch("/evc/gen", lang.getText("nui_cetHotkeys"), lang.getText("nui_cetHotkeysDesc"), mod.settings.cetKeys, mod.defaultSettings.cetKeys, function(state)
        mod.settings.cetKeys = state
        config.saveFile("config.json", mod.settings)
        utils.updateHints(mod)
    end)

    nativeSettings.addButton("/evc/gen", lang.getText("nui_forceHide"), lang.getText("nui_forceHideDesc"), lang.getText("nui_forceHideButton"), 45, function()
        utils.hideHints()
    end)

    local kbInputs = {[1] = lang.getText("nui_kb1"), [2] = lang.getText("nui_kb2"), [3] = lang.getText("nui_kb3"), [4] = lang.getText("nui_kb4"), [5] = lang.getText("nui_kb5"), [6] = lang.getText("nui_kb6"), [7] = lang.getText("nui_kb7"), [8] = lang.getText("nui_kb8"), [9] = lang.getText("nui_kb9"), [10] = lang.getText("nui_kb0")}

    nativeSettings.addSelectorString("/evc/windows", lang.getText("nui_windowsKey"), lang.getText("nui_windowsKeyDesc"), kbInputs, mod.settings.windowsInput, mod.defaultSettings.windowsInput, function(value)
        mod.settings.windowsInput = value
        config.saveFile("config.json", mod.settings)
        utils.updateHints(mod)
    end)

    nativeSettings.addSwitch("/evc/windows", lang.getText("nui_showHints"), lang.getText("nui_windowsHintsDesc"), mod.settings.windowsHints, mod.defaultSettings.windowsHints, function(state)
        mod.settings.windowsHints = state
        config.saveFile("config.json", mod.settings)
        utils.updateHints(mod)
    end)

    nativeSettings.addSelectorString("/evc/lights", lang.getText("nui_headlightsKey"), lang.getText("nui_headlightsKeyDesc"), kbInputs, mod.settings.headlightsInput, mod.defaultSettings.headlightsInput, function(value)
        mod.settings.headlightsInput = value
        config.saveFile("config.json", mod.settings)
        utils.updateHints(mod)
    end)

    nativeSettings.addSwitch("/evc/lights", lang.getText("nui_showHints"), lang.getText("nui_lightsHintsDesc"), mod.settings.headlightsHint, mod.defaultSettings.headlightsHint, function(state)
        mod.settings.headlightsHint = state
        config.saveFile("config.json", mod.settings)
        utils.updateHints(mod)
    end)
end

return ui