/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.exceptions;

import com.sun.org.apache.xml.internal.security.utils.I18n;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.MessageFormat;

public class XMLSecurityException
extends Exception {
    private static final long serialVersionUID = 1L;
    protected Exception originalException = null;
    protected String msgID;

    public XMLSecurityException() {
        super("Missing message string");
        this.msgID = null;
        this.originalException = null;
    }

    public XMLSecurityException(String string) {
        super(I18n.getExceptionMessage(string));
        this.msgID = string;
        this.originalException = null;
    }

    public XMLSecurityException(String string, Object[] objectArray) {
        super(MessageFormat.format(I18n.getExceptionMessage(string), objectArray));
        this.msgID = string;
        this.originalException = null;
    }

    public XMLSecurityException(Exception exception) {
        super("Missing message ID to locate message string in resource bundle \"com/sun/org/apache/xml/internal/security/resource/xmlsecurity\". Original Exception was a " + exception.getClass().getName() + " and message " + exception.getMessage());
        this.originalException = exception;
    }

    public XMLSecurityException(String string, Exception exception) {
        super(I18n.getExceptionMessage(string, exception));
        this.msgID = string;
        this.originalException = exception;
    }

    public XMLSecurityException(String string, Object[] objectArray, Exception exception) {
        super(MessageFormat.format(I18n.getExceptionMessage(string), objectArray));
        this.msgID = string;
        this.originalException = exception;
    }

    public String getMsgID() {
        if (this.msgID == null) {
            return "Missing message ID";
        }
        return this.msgID;
    }

    public String toString() {
        String string = this.getClass().getName();
        String string2 = super.getLocalizedMessage();
        string2 = string2 != null ? string + ": " + string2 : string;
        if (this.originalException != null) {
            string2 = string2 + "\nOriginal Exception was " + this.originalException.toString();
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace() {
        PrintStream printStream = System.err;
        synchronized (printStream) {
            super.printStackTrace(System.err);
            if (this.originalException != null) {
                this.originalException.printStackTrace(System.err);
            }
        }
    }

    public void printStackTrace(PrintWriter printWriter) {
        super.printStackTrace(printWriter);
        if (this.originalException != null) {
            this.originalException.printStackTrace(printWriter);
        }
    }

    public void printStackTrace(PrintStream printStream) {
        super.printStackTrace(printStream);
        if (this.originalException != null) {
            this.originalException.printStackTrace(printStream);
        }
    }

    public Exception getOriginalException() {
        return this.originalException;
    }
}

