/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.client.sei;

import com.sun.xml.internal.bind.api.AccessorException;
import com.sun.xml.internal.bind.api.Bridge;
import com.sun.xml.internal.bind.api.CompositeStructure;
import com.sun.xml.internal.bind.api.RawAccessor;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.message.Attachment;
import com.sun.xml.internal.ws.api.message.AttachmentSet;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.model.ParameterBinding;
import com.sun.xml.internal.ws.api.streaming.XMLStreamReaderFactory;
import com.sun.xml.internal.ws.client.sei.ValueSetter;
import com.sun.xml.internal.ws.client.sei.ValueSetterFactory;
import com.sun.xml.internal.ws.message.AttachmentUnmarshallerImpl;
import com.sun.xml.internal.ws.model.ParameterImpl;
import com.sun.xml.internal.ws.model.WrapperParameter;
import com.sun.xml.internal.ws.resources.ServerMessages;
import com.sun.xml.internal.ws.streaming.XMLStreamReaderUtil;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.imageio.ImageIO;
import javax.xml.bind.JAXBException;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPFaultException;

abstract class ResponseBuilder {
    public static ResponseBuilder NONE = new None();
    private static final Map<Class, Object> primitiveUninitializedValues;

    ResponseBuilder() {
    }

    abstract Object readResponse(Message var1, Object[] var2) throws JAXBException, XMLStreamException;

    public static Object getVMUninitializedValue(Type type) {
        return primitiveUninitializedValues.get(type);
    }

    public static final String getWSDLPartName(Attachment attachment) {
        String string = attachment.getContentId();
        int n = string.lastIndexOf(64, string.length());
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(0, n);
        if ((n = string2.lastIndexOf(61, string2.length())) == -1) {
            return null;
        }
        try {
            return URLDecoder.decode(string2.substring(0, n), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new WebServiceException(unsupportedEncodingException);
        }
    }

    private static boolean isXMLMimeType(String string) {
        return string.equals("text/xml") || string.equals("application/xml");
    }

    static {
        Map<Class, Object> map = primitiveUninitializedValues = new HashMap<Class, Object>();
        map.put(Integer.TYPE, 0);
        map.put(Character.TYPE, Character.valueOf('\u0000'));
        map.put(Byte.TYPE, (byte)0);
        map.put(Short.TYPE, (short)0);
        map.put(Long.TYPE, 0L);
        map.put(Float.TYPE, Float.valueOf(0.0f));
        map.put(Double.TYPE, 0.0);
    }

    static final class RpcLit
    extends ResponseBuilder {
        private final Map<QName, PartBuilder> parts = new HashMap<QName, PartBuilder>();
        private QName wrapperName;

        public RpcLit(WrapperParameter wrapperParameter, ValueSetterFactory valueSetterFactory) {
            assert (wrapperParameter.getTypeReference().type == CompositeStructure.class);
            this.wrapperName = wrapperParameter.getName();
            List<ParameterImpl> list = wrapperParameter.getWrapperChildren();
            for (ParameterImpl parameterImpl : list) {
                this.parts.put(parameterImpl.getName(), new PartBuilder(parameterImpl.getBridge(), valueSetterFactory.get(parameterImpl)));
                assert (parameterImpl.getBinding() == ParameterBinding.BODY);
            }
        }

        public Object readResponse(Message message, Object[] objectArray) throws JAXBException, XMLStreamException {
            Object object = null;
            XMLStreamReader xMLStreamReader = message.readPayload();
            if (!xMLStreamReader.getName().equals(this.wrapperName)) {
                throw new WebServiceException("Unexpected response element " + xMLStreamReader.getName() + " expected: " + this.wrapperName);
            }
            xMLStreamReader.nextTag();
            while (xMLStreamReader.getEventType() == 1) {
                PartBuilder partBuilder = this.parts.get(xMLStreamReader.getName());
                if (partBuilder == null) {
                    XMLStreamReaderUtil.skipElement(xMLStreamReader);
                    xMLStreamReader.nextTag();
                } else {
                    Object object2 = partBuilder.readResponse(objectArray, xMLStreamReader, message.getAttachments());
                    if (object2 != null) {
                        assert (object == null);
                        object = object2;
                    }
                }
                if (xMLStreamReader.getEventType() == 1 || xMLStreamReader.getEventType() == 2) continue;
                XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
            }
            xMLStreamReader.close();
            XMLStreamReaderFactory.recycle(xMLStreamReader);
            return object;
        }

        static final class PartBuilder {
            private final Bridge bridge;
            private final ValueSetter setter;

            public PartBuilder(Bridge bridge, ValueSetter valueSetter) {
                this.bridge = bridge;
                this.setter = valueSetter;
            }

            final Object readResponse(Object[] objectArray, XMLStreamReader xMLStreamReader, AttachmentSet attachmentSet) throws JAXBException {
                Object t = this.bridge.unmarshal(xMLStreamReader, (AttachmentUnmarshaller)(attachmentSet != null ? new AttachmentUnmarshallerImpl(attachmentSet) : null));
                return this.setter.put(t, objectArray);
            }
        }
    }

    static final class DocLit
    extends ResponseBuilder {
        private final PartBuilder[] parts;
        private final Bridge wrapper;
        private final QName wrapperName;

        public DocLit(WrapperParameter wrapperParameter, ValueSetterFactory valueSetterFactory) {
            this.wrapperName = wrapperParameter.getName();
            this.wrapper = wrapperParameter.getBridge();
            Class clazz = (Class)this.wrapper.getTypeReference().type;
            ArrayList<PartBuilder> arrayList = new ArrayList<PartBuilder>();
            List<ParameterImpl> list = wrapperParameter.getWrapperChildren();
            for (ParameterImpl parameterImpl : list) {
                if (parameterImpl.isIN()) continue;
                QName qName = parameterImpl.getName();
                try {
                    arrayList.add(new PartBuilder(wrapperParameter.getOwner().getJAXBContext().getElementPropertyAccessor(clazz, qName.getNamespaceURI(), parameterImpl.getName().getLocalPart()), valueSetterFactory.get(parameterImpl)));
                    assert (parameterImpl.getBinding() == ParameterBinding.BODY);
                }
                catch (JAXBException jAXBException) {
                    throw new WebServiceException(clazz + " do not have a property of the name " + qName, jAXBException);
                }
            }
            this.parts = arrayList.toArray(new PartBuilder[arrayList.size()]);
        }

        public Object readResponse(Message message, Object[] objectArray) throws JAXBException, XMLStreamException {
            Object object = null;
            if (this.parts.length > 0) {
                XMLStreamReader xMLStreamReader = message.readPayload();
                XMLStreamReaderUtil.verifyTag(xMLStreamReader, this.wrapperName);
                Object t = this.wrapper.unmarshal(xMLStreamReader, (AttachmentUnmarshaller)(message.getAttachments() != null ? new AttachmentUnmarshallerImpl(message.getAttachments()) : null));
                try {
                    for (PartBuilder partBuilder : this.parts) {
                        Object object2 = partBuilder.readResponse(objectArray, t);
                        if (object2 == null) continue;
                        assert (object == null);
                        object = object2;
                    }
                }
                catch (AccessorException accessorException) {
                    throw new WebServiceException(accessorException);
                }
                xMLStreamReader.close();
                XMLStreamReaderFactory.recycle(xMLStreamReader);
            } else {
                message.consume();
            }
            return object;
        }

        static final class PartBuilder {
            private final RawAccessor accessor;
            private final ValueSetter setter;

            public PartBuilder(RawAccessor rawAccessor, ValueSetter valueSetter) {
                this.accessor = rawAccessor;
                this.setter = valueSetter;
                assert (rawAccessor != null && valueSetter != null);
            }

            final Object readResponse(Object[] objectArray, Object object) throws AccessorException {
                Object v = this.accessor.get(object);
                return this.setter.put(v, objectArray);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Body
    extends ResponseBuilder {
        private final Bridge<?> bridge;
        private final ValueSetter setter;

        public Body(Bridge<?> bridge, ValueSetter valueSetter) {
            this.bridge = bridge;
            this.setter = valueSetter;
        }

        @Override
        public Object readResponse(Message message, Object[] objectArray) throws JAXBException {
            return this.setter.put(message.readPayloadAsJAXB(this.bridge), objectArray);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Header
    extends ResponseBuilder {
        private final Bridge<?> bridge;
        private final ValueSetter setter;
        private final QName headerName;
        private final SOAPVersion soapVersion;

        public Header(SOAPVersion sOAPVersion, QName qName, Bridge<?> bridge, ValueSetter valueSetter) {
            this.soapVersion = sOAPVersion;
            this.headerName = qName;
            this.bridge = bridge;
            this.setter = valueSetter;
        }

        public Header(SOAPVersion sOAPVersion, ParameterImpl parameterImpl, ValueSetter valueSetter) {
            this(sOAPVersion, parameterImpl.getTypeReference().tagName, parameterImpl.getBridge(), valueSetter);
            assert (parameterImpl.getOutBinding() == ParameterBinding.HEADER);
        }

        private SOAPFaultException createDuplicateHeaderException() {
            try {
                SOAPFault sOAPFault = this.soapVersion.saajSoapFactory.createFault(ServerMessages.DUPLICATE_PORT_KNOWN_HEADER(this.headerName), this.soapVersion.faultCodeServer);
                return new SOAPFaultException(sOAPFault);
            }
            catch (SOAPException sOAPException) {
                throw new WebServiceException(sOAPException);
            }
        }

        @Override
        public Object readResponse(Message message, Object[] objectArray) throws JAXBException {
            com.sun.xml.internal.ws.api.message.Header header = null;
            Iterator<com.sun.xml.internal.ws.api.message.Header> iterator = message.getHeaders().getHeaders(this.headerName, true);
            if (iterator.hasNext()) {
                header = iterator.next();
                if (iterator.hasNext()) {
                    throw this.createDuplicateHeaderException();
                }
            }
            if (header != null) {
                return this.setter.put(header.readAsJAXB(this.bridge), objectArray);
            }
            return null;
        }
    }

    private static final class JAXBBuilder
    extends AttachmentBuilder {
        JAXBBuilder(ParameterImpl parameterImpl, ValueSetter valueSetter) {
            super(parameterImpl, valueSetter);
        }

        Object mapAttachment(Attachment attachment, Object[] objectArray) throws JAXBException {
            Object t = this.param.getBridge().unmarshal(attachment.asInputStream());
            return this.setter.put(t, objectArray);
        }
    }

    private static final class InputStreamBuilder
    extends AttachmentBuilder {
        InputStreamBuilder(ParameterImpl parameterImpl, ValueSetter valueSetter) {
            super(parameterImpl, valueSetter);
        }

        Object mapAttachment(Attachment attachment, Object[] objectArray) {
            return this.setter.put(attachment.asInputStream(), objectArray);
        }
    }

    private static final class ImageBuilder
    extends AttachmentBuilder {
        ImageBuilder(ParameterImpl parameterImpl, ValueSetter valueSetter) {
            super(parameterImpl, valueSetter);
        }

        Object mapAttachment(Attachment attachment, Object[] objectArray) {
            BufferedImage bufferedImage;
            InputStream inputStream = null;
            try {
                inputStream = attachment.asInputStream();
                bufferedImage = ImageIO.read(inputStream);
            }
            catch (IOException iOException) {
                throw new WebServiceException(iOException);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        throw new WebServiceException(iOException);
                    }
                }
            }
            return this.setter.put(bufferedImage, objectArray);
        }
    }

    private static final class SourceBuilder
    extends AttachmentBuilder {
        SourceBuilder(ParameterImpl parameterImpl, ValueSetter valueSetter) {
            super(parameterImpl, valueSetter);
        }

        Object mapAttachment(Attachment attachment, Object[] objectArray) {
            return this.setter.put(attachment.asSource(), objectArray);
        }
    }

    private static final class ByteArrayBuilder
    extends AttachmentBuilder {
        ByteArrayBuilder(ParameterImpl parameterImpl, ValueSetter valueSetter) {
            super(parameterImpl, valueSetter);
        }

        Object mapAttachment(Attachment attachment, Object[] objectArray) {
            return this.setter.put(attachment.asByteArray(), objectArray);
        }
    }

    private static final class DataHandlerBuilder
    extends AttachmentBuilder {
        DataHandlerBuilder(ParameterImpl parameterImpl, ValueSetter valueSetter) {
            super(parameterImpl, valueSetter);
        }

        Object mapAttachment(Attachment attachment, Object[] objectArray) {
            return this.setter.put(attachment.asDataHandler(), objectArray);
        }
    }

    static abstract class AttachmentBuilder
    extends ResponseBuilder {
        protected final ValueSetter setter;
        protected final ParameterImpl param;
        private final String pname;
        private final String pname1;

        AttachmentBuilder(ParameterImpl parameterImpl, ValueSetter valueSetter) {
            this.setter = valueSetter;
            this.param = parameterImpl;
            this.pname = parameterImpl.getPartName();
            this.pname1 = "<" + this.pname;
        }

        public static ResponseBuilder createAttachmentBuilder(ParameterImpl parameterImpl, ValueSetter valueSetter) {
            Class clazz = (Class)parameterImpl.getTypeReference().type;
            if (DataHandler.class.isAssignableFrom(clazz)) {
                return new DataHandlerBuilder(parameterImpl, valueSetter);
            }
            if (byte[].class == clazz) {
                return new ByteArrayBuilder(parameterImpl, valueSetter);
            }
            if (Source.class.isAssignableFrom(clazz)) {
                return new SourceBuilder(parameterImpl, valueSetter);
            }
            if (Image.class.isAssignableFrom(clazz)) {
                return new ImageBuilder(parameterImpl, valueSetter);
            }
            if (InputStream.class == clazz) {
                return new InputStreamBuilder(parameterImpl, valueSetter);
            }
            if (ResponseBuilder.isXMLMimeType(parameterImpl.getBinding().getMimeType())) {
                return new JAXBBuilder(parameterImpl, valueSetter);
            }
            throw new UnsupportedOperationException("Unexpected Attachment type =" + clazz);
        }

        public Object readResponse(Message message, Object[] objectArray) throws JAXBException, XMLStreamException {
            for (Attachment attachment : message.getAttachments()) {
                String string = AttachmentBuilder.getWSDLPartName(attachment);
                if (string == null || !string.equals(this.pname) && !string.equals(this.pname1)) continue;
                return this.mapAttachment(attachment, objectArray);
            }
            return null;
        }

        abstract Object mapAttachment(Attachment var1, Object[] var2) throws JAXBException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Composite
    extends ResponseBuilder {
        private final ResponseBuilder[] builders;

        public Composite(ResponseBuilder ... responseBuilderArray) {
            this.builders = responseBuilderArray;
        }

        public Composite(Collection<? extends ResponseBuilder> collection) {
            this(collection.toArray(new ResponseBuilder[collection.size()]));
        }

        @Override
        public Object readResponse(Message message, Object[] objectArray) throws JAXBException, XMLStreamException {
            Object object = null;
            for (ResponseBuilder responseBuilder : this.builders) {
                Object object2 = responseBuilder.readResponse(message, objectArray);
                if (object2 == null) continue;
                assert (object == null);
                object = object2;
            }
            return object;
        }
    }

    static final class NullSetter
    extends ResponseBuilder {
        private final ValueSetter setter;
        private final Object nullValue;

        public NullSetter(ValueSetter valueSetter, Object object) {
            assert (valueSetter != null);
            this.nullValue = object;
            this.setter = valueSetter;
        }

        public Object readResponse(Message message, Object[] objectArray) {
            return this.setter.put(this.nullValue, objectArray);
        }
    }

    static final class None
    extends ResponseBuilder {
        private None() {
        }

        public Object readResponse(Message message, Object[] objectArray) {
            message.consume();
            return null;
        }
    }
}

