/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.client.sei;

import com.sun.xml.internal.bind.api.RawAccessor;
import com.sun.xml.internal.ws.model.ParameterImpl;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.ws.Holder;
import javax.xml.ws.WebServiceException;

abstract class ValueSetter {
    private static final ValueSetter RETURN_VALUE = new ReturnValue();
    private static final ValueSetter[] POOL = new ValueSetter[16];
    static final ValueSetter SINGLE_VALUE;

    private ValueSetter() {
    }

    abstract Object put(Object var1, Object[] var2);

    static ValueSetter getSync(ParameterImpl parameterImpl) {
        int n = parameterImpl.getIndex();
        if (n == -1) {
            return RETURN_VALUE;
        }
        if (n < POOL.length) {
            return POOL[n];
        }
        return new Param(n);
    }

    static {
        for (int i = 0; i < POOL.length; ++i) {
            ValueSetter.POOL[i] = new Param(i);
        }
        SINGLE_VALUE = new SingleValue();
    }

    static final class AsyncBeanValueSetter
    extends ValueSetter {
        private final RawAccessor accessor;

        AsyncBeanValueSetter(ParameterImpl parameterImpl, Class clazz) {
            QName qName = parameterImpl.getName();
            try {
                this.accessor = parameterImpl.getOwner().getJAXBContext().getElementPropertyAccessor(clazz, qName.getNamespaceURI(), qName.getLocalPart());
            }
            catch (JAXBException jAXBException) {
                throw new WebServiceException(clazz + " do not have a property of the name " + qName, jAXBException);
            }
        }

        Object put(Object object, Object[] objectArray) {
            assert (objectArray != null);
            assert (objectArray.length == 1);
            assert (objectArray[0] != null);
            Object object2 = objectArray[0];
            try {
                this.accessor.set(object2, object);
            }
            catch (Exception exception) {
                throw new WebServiceException(exception);
            }
            return null;
        }
    }

    private static final class SingleValue
    extends ValueSetter {
        private SingleValue() {
        }

        Object put(Object object, Object[] objectArray) {
            objectArray[0] = object;
            return null;
        }
    }

    static final class Param
    extends ValueSetter {
        private final int idx;

        public Param(int n) {
            this.idx = n;
        }

        Object put(Object object, Object[] objectArray) {
            Object object2 = objectArray[this.idx];
            if (object2 != null) {
                assert (object2 instanceof Holder);
                ((Holder)object2).value = object;
            }
            return null;
        }
    }

    private static final class ReturnValue
    extends ValueSetter {
        private ReturnValue() {
        }

        Object put(Object object, Object[] objectArray) {
            return object;
        }
    }
}

