/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.d3d;

import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.ImageCapabilities;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.VolatileImage;
import sun.awt.Win32GraphicsConfig;
import sun.awt.image.SunVolatileImage;
import sun.awt.image.SurfaceManager;
import sun.awt.windows.WComponentPeer;
import sun.java2d.Surface;
import sun.java2d.SurfaceData;
import sun.java2d.d3d.D3DContext;
import sun.java2d.d3d.D3DGraphicsDevice;
import sun.java2d.d3d.D3DRenderQueue;
import sun.java2d.d3d.D3DSurfaceData;
import sun.java2d.pipe.hw.AccelDeviceEventListener;
import sun.java2d.pipe.hw.AccelDeviceEventNotifier;
import sun.java2d.pipe.hw.AccelGraphicsConfig;
import sun.java2d.pipe.hw.AccelSurface;
import sun.java2d.pipe.hw.AccelTypedVolatileImage;
import sun.java2d.pipe.hw.ContextCapabilities;

public class D3DGraphicsConfig
extends Win32GraphicsConfig
implements AccelGraphicsConfig {
    private static ImageCapabilities imageCaps = new D3DImageCaps();
    private BufferCapabilities bufferCaps;
    private D3DGraphicsDevice device;

    protected D3DGraphicsConfig(D3DGraphicsDevice d3DGraphicsDevice) {
        super(d3DGraphicsDevice, 0);
        this.device = d3DGraphicsDevice;
    }

    public SurfaceData createManagedSurface(int n, int n2, int n3) {
        return D3DSurfaceData.createData(this, n, n2, this.getColorModel(n3), null, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void displayChanged() {
        super.displayChanged();
        D3DRenderQueue d3DRenderQueue = D3DRenderQueue.getInstance();
        d3DRenderQueue.lock();
        try {
            D3DContext.invalidateCurrentContext();
        }
        finally {
            d3DRenderQueue.unlock();
        }
    }

    public ColorModel getColorModel(int n) {
        switch (n) {
            case 1: {
                return new DirectColorModel(24, 0xFF0000, 65280, 255);
            }
            case 2: {
                return new DirectColorModel(25, 0xFF0000, 65280, 255, 0x1000000);
            }
            case 3: {
                ColorSpace colorSpace = ColorSpace.getInstance(1000);
                return new DirectColorModel(colorSpace, 32, 0xFF0000, 65280, 255, -16777216, true, 3);
            }
        }
        return null;
    }

    public String toString() {
        return "D3DGraphicsConfig[dev=" + this.screen + ",pixfmt=" + this.visual + "]";
    }

    public SurfaceData createSurfaceData(WComponentPeer wComponentPeer, int n) {
        return super.createSurfaceData(wComponentPeer, n);
    }

    public void assertOperationSupported(Component component, int n, BufferCapabilities bufferCapabilities) throws AWTException {
        if (n < 2 || n > 4) {
            throw new AWTException("Only 2-4 buffers supported");
        }
        if (bufferCapabilities.getFlipContents() == BufferCapabilities.FlipContents.COPIED && n != 2) {
            throw new AWTException("FlipContents.COPIED is onlysupported for 2 buffers");
        }
    }

    public VolatileImage createBackBuffer(WComponentPeer wComponentPeer) {
        Component component = (Component)wComponentPeer.getTarget();
        int n = Math.max(1, component.getWidth());
        int n2 = Math.max(1, component.getHeight());
        return new SunVolatileImage(component, n, n2, Boolean.TRUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flip(WComponentPeer wComponentPeer, Component component, VolatileImage volatileImage, int n, int n2, int n3, int n4, BufferCapabilities.FlipContents flipContents) {
        Object object;
        SurfaceManager surfaceManager = SurfaceManager.getManager(volatileImage);
        SurfaceData surfaceData = surfaceManager.getDestSurfaceData();
        if (surfaceData instanceof D3DSurfaceData) {
            object = (D3DSurfaceData)surfaceData;
            D3DSurfaceData.swapBuffers((D3DSurfaceData)object, n, n2, n3, n4);
        } else {
            object = wComponentPeer.getGraphics();
            try {
                ((Graphics)object).drawImage(volatileImage, n, n2, n3, n4, n, n2, n3, n4, null);
            }
            finally {
                ((Graphics)object).dispose();
            }
        }
        if (flipContents == BufferCapabilities.FlipContents.BACKGROUND) {
            object = volatileImage.getGraphics();
            try {
                ((Graphics)object).setColor(component.getBackground());
                ((Graphics)object).fillRect(0, 0, volatileImage.getWidth(), volatileImage.getHeight());
            }
            finally {
                ((Graphics)object).dispose();
            }
        }
    }

    public BufferCapabilities getBufferCapabilities() {
        if (this.bufferCaps == null) {
            this.bufferCaps = new D3DBufferCaps();
        }
        return this.bufferCaps;
    }

    public ImageCapabilities getImageCapabilities() {
        return imageCaps;
    }

    D3DGraphicsDevice getD3DDevice() {
        return this.device;
    }

    public D3DContext getContext() {
        return this.device.getContext();
    }

    public VolatileImage createCompatibleVolatileImage(int n, int n2, int n3, int n4) {
        AccelTypedVolatileImage accelTypedVolatileImage;
        Surface surface;
        boolean bl;
        if (n4 == 4 || n4 == 1 || n4 == 0 || n3 == 2) {
            return null;
        }
        boolean bl2 = bl = n3 == 1;
        if (n4 == 5) {
            int n5;
            int n6 = n5 = bl ? 8 : 4;
            if (!this.device.isCapPresent(n5)) {
                return null;
            }
        } else if (n4 == 2 && !bl && !this.device.isCapPresent(2)) {
            return null;
        }
        if (!((surface = (accelTypedVolatileImage = new AccelTypedVolatileImage((GraphicsConfiguration)this, n, n2, n3, n4)).getDestSurface()) instanceof AccelSurface) || ((AccelSurface)surface).getType() != n4) {
            accelTypedVolatileImage.flush();
            accelTypedVolatileImage = null;
        }
        return accelTypedVolatileImage;
    }

    public ContextCapabilities getContextCapabilities() {
        return this.device.getContextCapabilities();
    }

    public void addDeviceEventListener(AccelDeviceEventListener accelDeviceEventListener) {
        AccelDeviceEventNotifier.addListener(accelDeviceEventListener, this.device.getScreen());
    }

    public void removeDeviceEventListener(AccelDeviceEventListener accelDeviceEventListener) {
        AccelDeviceEventNotifier.removeListener(accelDeviceEventListener);
    }

    private static class D3DImageCaps
    extends ImageCapabilities {
        private D3DImageCaps() {
            super(true);
        }

        public boolean isTrueVolatile() {
            return true;
        }
    }

    private static class D3DBufferCaps
    extends BufferCapabilities {
        public D3DBufferCaps() {
            super(imageCaps, imageCaps, BufferCapabilities.FlipContents.UNDEFINED);
        }

        public boolean isMultiBufferAvailable() {
            return true;
        }
    }
}

