/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import org.apache.tomcat.util.MutableInteger;
import org.apache.tomcat.util.net.NioChannel;
import org.apache.tomcat.util.net.NioSelectorPool;

public class SecureNioChannel
extends NioChannel {
    protected ByteBuffer netInBuffer;
    protected ByteBuffer netOutBuffer;
    protected SSLEngine sslEngine;
    protected boolean initHandshakeComplete = false;
    protected SSLEngineResult.HandshakeStatus initHandshakeStatus;
    protected boolean closed = false;
    protected boolean closing = false;
    protected NioSelectorPool pool;

    public SecureNioChannel(SocketChannel channel, SSLEngine engine, ApplicationBufferHandler bufHandler, NioSelectorPool pool) throws IOException {
        super(channel, bufHandler);
        this.sslEngine = engine;
        int appBufSize = this.sslEngine.getSession().getApplicationBufferSize();
        int netBufSize = this.sslEngine.getSession().getPacketBufferSize();
        if (this.netInBuffer == null) {
            this.netInBuffer = ByteBuffer.allocateDirect(netBufSize);
        }
        if (this.netOutBuffer == null) {
            this.netOutBuffer = ByteBuffer.allocateDirect(netBufSize);
        }
        this.pool = pool;
        bufHandler.expand(bufHandler.getReadBuffer(), appBufSize);
        bufHandler.expand(bufHandler.getWriteBuffer(), appBufSize);
        this.reset();
    }

    public void reset(SSLEngine engine) throws IOException {
        this.sslEngine = engine;
        this.reset();
    }

    public void reset() throws IOException {
        super.reset();
        this.netOutBuffer.position(0);
        this.netOutBuffer.limit(0);
        this.netInBuffer.position(0);
        this.netInBuffer.limit(0);
        this.initHandshakeComplete = false;
        this.closed = false;
        this.closing = false;
        this.sslEngine.beginHandshake();
        this.initHandshakeStatus = this.sslEngine.getHandshakeStatus();
    }

    public int getBufferSize() {
        int size = super.getBufferSize();
        size += this.netInBuffer != null ? this.netInBuffer.capacity() : 0;
        return size += this.netOutBuffer != null ? this.netOutBuffer.capacity() : 0;
    }

    public boolean flush(boolean block, Selector s, long timeout, MutableInteger lastWrite) throws IOException {
        if (!block) {
            this.flush(this.netOutBuffer);
        } else {
            this.pool.write(this.netOutBuffer, this, s, timeout, block, lastWrite);
        }
        return !this.netOutBuffer.hasRemaining();
    }

    protected boolean flush(ByteBuffer buf) throws IOException {
        int remaining = buf.remaining();
        if (remaining > 0) {
            int written = this.sc.write(buf);
            return written >= remaining;
        }
        return true;
    }

    public int handshake(boolean read, boolean write) throws IOException {
        if (this.initHandshakeComplete) {
            return 0;
        }
        if (!this.flush(this.netOutBuffer)) {
            return 4;
        }
        SSLEngineResult handshake = null;
        block7: while (!this.initHandshakeComplete) {
            switch (this.initHandshakeStatus) {
                case NOT_HANDSHAKING: {
                    throw new IOException("NOT_HANDSHAKING during handshake");
                }
                case FINISHED: {
                    this.initHandshakeComplete = !this.netOutBuffer.hasRemaining();
                    return this.initHandshakeComplete ? 0 : 4;
                }
                case NEED_WRAP: {
                    handshake = this.handshakeWrap(write);
                    if (handshake.getStatus() == SSLEngineResult.Status.OK) {
                        if (this.initHandshakeStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                            this.initHandshakeStatus = this.tasks();
                        }
                    } else {
                        throw new IOException("Unexpected status:" + (Object)((Object)handshake.getStatus()) + " during handshake WRAP.");
                    }
                    if (this.initHandshakeStatus != SSLEngineResult.HandshakeStatus.NEED_UNWRAP || !this.flush(this.netOutBuffer)) {
                        return 4;
                    }
                }
                case NEED_UNWRAP: {
                    handshake = this.handshakeUnwrap(read);
                    if (handshake.getStatus() == SSLEngineResult.Status.OK) {
                        if (this.initHandshakeStatus != SSLEngineResult.HandshakeStatus.NEED_TASK) continue block7;
                        this.initHandshakeStatus = this.tasks();
                        continue block7;
                    }
                    if (handshake.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                        return 1;
                    }
                    throw new IOException("Invalid handshake status:" + (Object)((Object)this.initHandshakeStatus) + " during handshake UNWRAP.");
                }
                case NEED_TASK: {
                    this.initHandshakeStatus = this.tasks();
                    continue block7;
                }
            }
            throw new IllegalStateException("Invalid handshake status:" + (Object)((Object)this.initHandshakeStatus));
        }
        return this.initHandshakeComplete ? 0 : 5;
    }

    protected SSLEngineResult.HandshakeStatus tasks() {
        Runnable r = null;
        while ((r = this.sslEngine.getDelegatedTask()) != null) {
            r.run();
        }
        return this.sslEngine.getHandshakeStatus();
    }

    protected SSLEngineResult handshakeWrap(boolean doWrite) throws IOException {
        this.netOutBuffer.clear();
        SSLEngineResult result = this.sslEngine.wrap(this.bufHandler.getWriteBuffer(), this.netOutBuffer);
        this.netOutBuffer.flip();
        this.initHandshakeStatus = result.getHandshakeStatus();
        if (doWrite) {
            this.flush(this.netOutBuffer);
        }
        return result;
    }

    protected SSLEngineResult handshakeUnwrap(boolean doread) throws IOException {
        SSLEngineResult result;
        int read;
        if (this.netInBuffer.position() == this.netInBuffer.limit()) {
            this.netInBuffer.clear();
        }
        if (doread && (read = this.sc.read(this.netInBuffer)) == -1) {
            throw new IOException("EOF encountered during handshake.");
        }
        boolean cont = false;
        do {
            this.netInBuffer.flip();
            result = this.sslEngine.unwrap(this.netInBuffer, this.bufHandler.getReadBuffer());
            this.netInBuffer.compact();
            this.initHandshakeStatus = result.getHandshakeStatus();
            if (result.getStatus() != SSLEngineResult.Status.OK || result.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_TASK) continue;
            this.initHandshakeStatus = this.tasks();
        } while (cont = result.getStatus() == SSLEngineResult.Status.OK && this.initHandshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP);
        return result;
    }

    public void close() throws IOException {
        if (this.closing) {
            return;
        }
        this.closing = true;
        this.sslEngine.closeOutbound();
        if (!this.flush(this.netOutBuffer)) {
            throw new IOException("Remaining data in the network buffer, can't send SSL close message, force a close with close(true) instead");
        }
        this.netOutBuffer.clear();
        SSLEngineResult handshake = this.sslEngine.wrap(this.getEmptyBuf(), this.netOutBuffer);
        if (handshake.getStatus() != SSLEngineResult.Status.CLOSED) {
            throw new IOException("Invalid close state, will not send network data.");
        }
        this.netOutBuffer.flip();
        this.flush(this.netOutBuffer);
        this.closed = !this.netOutBuffer.hasRemaining() && handshake.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_WRAP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean force) throws IOException {
        try {
            this.close();
        }
        finally {
            if (force || this.closed) {
                this.closed = true;
                this.sc.socket().close();
                this.sc.close();
            }
        }
    }

    public int read(ByteBuffer dst) throws IOException {
        if (dst != this.bufHandler.getReadBuffer()) {
            throw new IllegalArgumentException("You can only read using the application read buffer provided by the handler.");
        }
        if (this.closing || this.closed) {
            return -1;
        }
        if (!this.initHandshakeComplete) {
            throw new IllegalStateException("Handshake incomplete, you must complete handshake before reading data.");
        }
        int netread = this.sc.read(this.netInBuffer);
        if (netread == -1) {
            return -1;
        }
        int read = 0;
        do {
            this.netInBuffer.flip();
            SSLEngineResult unwrap = this.sslEngine.unwrap(this.netInBuffer, dst);
            this.netInBuffer.compact();
            if (unwrap.getStatus() == SSLEngineResult.Status.OK || unwrap.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                read += unwrap.bytesProduced();
                if (unwrap.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                    this.tasks();
                }
                if (unwrap.getStatus() != SSLEngineResult.Status.BUFFER_UNDERFLOW) continue;
                break;
            }
            if (unwrap.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW && read > 0) break;
            throw new IOException("Unable to unwrap data, invalid status: " + (Object)((Object)unwrap.getStatus()));
        } while (this.netInBuffer.position() != 0);
        return read;
    }

    public int write(ByteBuffer src) throws IOException {
        if (src == this.netOutBuffer) {
            int written = this.sc.write(src);
            return written;
        }
        if (src != this.bufHandler.getWriteBuffer()) {
            throw new IllegalArgumentException("You can only write using the application write buffer provided by the handler.");
        }
        if (this.closing || this.closed) {
            throw new IOException("Channel is in closing state.");
        }
        int written = 0;
        if (!this.flush(this.netOutBuffer)) {
            return written;
        }
        this.netOutBuffer.clear();
        SSLEngineResult result = this.sslEngine.wrap(src, this.netOutBuffer);
        written = result.bytesConsumed();
        this.netOutBuffer.flip();
        if (result.getStatus() == SSLEngineResult.Status.OK) {
            if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                this.tasks();
            }
        } else {
            throw new IOException("Unable to wrap data, invalid engine state: " + (Object)((Object)result.getStatus()));
        }
        this.flush(this.netOutBuffer);
        return written;
    }

    public ApplicationBufferHandler getBufHandler() {
        return this.bufHandler;
    }

    public boolean isInitHandshakeComplete() {
        return this.initHandshakeComplete;
    }

    public boolean isClosing() {
        return this.closing;
    }

    public SSLEngine getSslEngine() {
        return this.sslEngine;
    }

    public ByteBuffer getEmptyBuf() {
        return emptyBuf;
    }

    public void setBufHandler(ApplicationBufferHandler bufHandler) {
        this.bufHandler = bufHandler;
    }

    public SocketChannel getIOChannel() {
        return this.sc;
    }

    public static interface ApplicationBufferHandler {
        public ByteBuffer expand(ByteBuffer var1, int var2);

        public ByteBuffer getReadBuffer();

        public ByteBuffer getWriteBuffer();
    }
}

