/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.jsse;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPathParameters;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.util.Collection;
import java.util.Vector;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.net.ServerSocketFactory;
import org.apache.tomcat.util.net.jsse.JSSEKeyManager;
import org.apache.tomcat.util.res.StringManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSSESocketFactory
extends ServerSocketFactory {
    private static StringManager sm = StringManager.getManager("org.apache.tomcat.util.net.jsse.res");
    static String defaultProtocol = "TLS";
    static boolean defaultClientAuth = false;
    static String defaultKeystoreType = "JKS";
    private static final String defaultKeystoreFile = System.getProperty("user.home") + "/.keystore";
    private static final String defaultKeyPass = "changeit";
    static Log log = LogFactory.getLog(JSSESocketFactory.class);
    protected boolean initialized;
    protected String clientAuth = "false";
    protected SSLServerSocketFactory sslProxy = null;
    protected String[] enabledCiphers;
    protected boolean requireClientAuth = false;
    protected boolean wantClientAuth = false;

    @Override
    public ServerSocket createSocket(int port) throws IOException {
        if (!this.initialized) {
            this.init();
        }
        ServerSocket socket = this.sslProxy.createServerSocket(port);
        this.initServerSocket(socket);
        return socket;
    }

    @Override
    public ServerSocket createSocket(int port, int backlog) throws IOException {
        if (!this.initialized) {
            this.init();
        }
        ServerSocket socket = this.sslProxy.createServerSocket(port, backlog);
        this.initServerSocket(socket);
        return socket;
    }

    @Override
    public ServerSocket createSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
        if (!this.initialized) {
            this.init();
        }
        ServerSocket socket = this.sslProxy.createServerSocket(port, backlog, ifAddress);
        this.initServerSocket(socket);
        return socket;
    }

    @Override
    public Socket acceptSocket(ServerSocket socket) throws IOException {
        SSLSocket asock = null;
        try {
            asock = (SSLSocket)socket.accept();
            this.configureClientAuth(asock);
        }
        catch (SSLException e) {
            throw new SocketException("SSL handshake error" + e.toString());
        }
        return asock;
    }

    @Override
    public void handshake(Socket sock) throws IOException {
        ((SSLSocket)sock).startHandshake();
    }

    protected String[] getEnabledCiphers(String requestedCiphers, String[] supportedCiphers) {
        Object[] enabledCiphers = null;
        if (requestedCiphers != null) {
            Vector<String> vec = null;
            String cipher = requestedCiphers;
            int index = requestedCiphers.indexOf(44);
            if (index != -1) {
                int fromIndex = 0;
                while (index != -1) {
                    cipher = requestedCiphers.substring(fromIndex, index).trim();
                    if (cipher.length() > 0) {
                        for (int i = 0; supportedCiphers != null && i < supportedCiphers.length; ++i) {
                            if (!supportedCiphers[i].equals(cipher)) continue;
                            if (vec == null) {
                                vec = new Vector();
                            }
                            vec.addElement(cipher);
                            break;
                        }
                    }
                    fromIndex = index + 1;
                    index = requestedCiphers.indexOf(44, fromIndex);
                }
                cipher = requestedCiphers.substring(fromIndex);
            }
            if (cipher != null && (cipher = cipher.trim()).length() > 0) {
                for (int i = 0; supportedCiphers != null && i < supportedCiphers.length; ++i) {
                    if (!supportedCiphers[i].equals(cipher)) continue;
                    if (vec == null) {
                        vec = new Vector<String>();
                    }
                    vec.addElement(cipher);
                    break;
                }
            }
            if (vec != null) {
                enabledCiphers = new String[vec.size()];
                vec.copyInto(enabledCiphers);
            }
        } else {
            enabledCiphers = this.sslProxy.getDefaultCipherSuites();
        }
        return enabledCiphers;
    }

    protected String getKeystorePassword() {
        String keystorePass;
        String keyPass = (String)this.attributes.get("keypass");
        if (keyPass == null) {
            keyPass = defaultKeyPass;
        }
        if ((keystorePass = (String)this.attributes.get("keystorePass")) == null) {
            keystorePass = keyPass;
        }
        return keystorePass;
    }

    protected KeyStore getKeystore(String type, String pass) throws IOException {
        String keystoreFile = (String)this.attributes.get("keystore");
        if (keystoreFile == null) {
            keystoreFile = defaultKeystoreFile;
        }
        return this.getStore(type, keystoreFile, pass);
    }

    protected KeyStore getTrustStore(String keystoreType) throws IOException {
        String truststoreType;
        String trustStorePassword;
        KeyStore trustStore = null;
        String trustStoreFile = (String)this.attributes.get("truststoreFile");
        if (trustStoreFile == null) {
            trustStoreFile = System.getProperty("javax.net.ssl.trustStore");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Truststore = " + trustStoreFile));
        }
        if ((trustStorePassword = (String)this.attributes.get("truststorePass")) == null) {
            trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword");
        }
        if (trustStorePassword == null) {
            trustStorePassword = this.getKeystorePassword();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("TrustPass = " + trustStorePassword));
        }
        if ((truststoreType = (String)this.attributes.get("truststoreType")) == null) {
            truststoreType = System.getProperty("javax.net.ssl.trustStoreType");
        }
        if (truststoreType == null) {
            truststoreType = keystoreType;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("trustType = " + truststoreType));
        }
        if (trustStoreFile != null && trustStorePassword != null) {
            trustStore = this.getStore(truststoreType, trustStoreFile, trustStorePassword);
        }
        return trustStore;
    }

    private KeyStore getStore(String type, String path, String pass) throws IOException {
        KeyStore ks = null;
        InputStream istream = null;
        try {
            ks = KeyStore.getInstance(type);
            if (!"PKCS11".equalsIgnoreCase(type)) {
                File keyStoreFile = new File(path);
                if (!keyStoreFile.isAbsolute()) {
                    keyStoreFile = new File(System.getProperty("catalina.base"), path);
                }
                istream = new FileInputStream(keyStoreFile);
            }
            ks.load(istream, pass.toCharArray());
        }
        catch (FileNotFoundException fnfe) {
            throw fnfe;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception ex) {
            log.error((Object)("Exception trying to load keystore " + path), (Throwable)ex);
            throw new IOException("Exception trying to load keystore " + path + ": " + ex.getMessage());
        }
        finally {
            if (istream != null) {
                try {
                    istream.close();
                }
                catch (IOException ioe) {}
            }
        }
        return ks;
    }

    void init() throws IOException {
        try {
            String trustAlgorithm;
            String keystoreType;
            String algorithm;
            String clientAuthStr = (String)this.attributes.get("clientauth");
            if ("true".equalsIgnoreCase(clientAuthStr) || "yes".equalsIgnoreCase(clientAuthStr)) {
                this.requireClientAuth = true;
            } else if ("want".equalsIgnoreCase(clientAuthStr)) {
                this.wantClientAuth = true;
            }
            String protocol = (String)this.attributes.get("protocol");
            if (protocol == null) {
                protocol = defaultProtocol;
            }
            if ((algorithm = (String)this.attributes.get("algorithm")) == null) {
                algorithm = KeyManagerFactory.getDefaultAlgorithm();
            }
            if ((keystoreType = (String)this.attributes.get("keystoreType")) == null) {
                keystoreType = defaultKeystoreType;
            }
            if ((trustAlgorithm = (String)this.attributes.get("truststoreAlgorithm")) == null) {
                trustAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
            }
            SSLContext context = SSLContext.getInstance(protocol);
            context.init(this.getKeyManagers(keystoreType, algorithm, (String)this.attributes.get("keyAlias")), this.getTrustManagers(keystoreType, trustAlgorithm), new SecureRandom());
            this.sslProxy = context.getServerSocketFactory();
            String requestedCiphers = (String)this.attributes.get("ciphers");
            this.enabledCiphers = this.getEnabledCiphers(requestedCiphers, this.sslProxy.getSupportedCipherSuites());
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e.getMessage());
        }
    }

    protected KeyManager[] getKeyManagers(String keystoreType, String algorithm, String keyAlias) throws Exception {
        KeyManager[] kms = null;
        String keystorePass = this.getKeystorePassword();
        KeyStore ks = this.getKeystore(keystoreType, keystorePass);
        if (keyAlias != null && !ks.isKeyEntry(keyAlias)) {
            throw new IOException(sm.getString("jsse.alias_no_key_entry", keyAlias));
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
        kmf.init(ks, keystorePass.toCharArray());
        kms = kmf.getKeyManagers();
        if (keyAlias != null) {
            if (defaultKeystoreType.equals(keystoreType)) {
                keyAlias = keyAlias.toLowerCase();
            }
            for (int i = 0; i < kms.length; ++i) {
                kms[i] = new JSSEKeyManager((X509KeyManager)kms[i], keyAlias);
            }
        }
        return kms;
    }

    protected TrustManager[] getTrustManagers(String keystoreType, String algorithm) throws Exception {
        KeyStore trustStore;
        String crlf = (String)this.attributes.get("crlFile");
        TrustManager[] tms = null;
        String truststoreType = (String)this.attributes.get("truststoreType");
        if (truststoreType == null) {
            truststoreType = keystoreType;
        }
        if ((trustStore = this.getTrustStore(truststoreType)) != null) {
            if (crlf == null) {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
                tmf.init(trustStore);
                tms = tmf.getTrustManagers();
            } else {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
                CertPathParameters params = this.getParameters(algorithm, crlf, trustStore);
                CertPathTrustManagerParameters mfp = new CertPathTrustManagerParameters(params);
                tmf.init(mfp);
                tms = tmf.getTrustManagers();
            }
        }
        return tms;
    }

    protected CertPathParameters getParameters(String algorithm, String crlf, KeyStore trustStore) throws Exception {
        PKIXBuilderParameters xparams;
        PKIXBuilderParameters params = null;
        if ("PKIX".equalsIgnoreCase(algorithm)) {
            xparams = new PKIXBuilderParameters(trustStore, (CertSelector)new X509CertSelector());
            Collection<? extends CRL> crls = this.getCRLs(crlf);
            CollectionCertStoreParameters csp = new CollectionCertStoreParameters(crls);
            CertStore store = CertStore.getInstance("Collection", csp);
            xparams.addCertStore(store);
            xparams.setRevocationEnabled(true);
            String trustLength = (String)this.attributes.get("trustMaxCertLength");
            if (trustLength != null) {
                try {
                    xparams.setMaxPathLength(Integer.parseInt(trustLength));
                }
                catch (Exception ex) {
                    log.warn((Object)("Bad maxCertLength: " + trustLength));
                }
            }
        } else {
            throw new CRLException("CRLs not supported for type: " + algorithm);
        }
        params = xparams;
        return params;
    }

    protected Collection<? extends CRL> getCRLs(String crlf) throws IOException, CRLException, CertificateException {
        File crlFile = new File(crlf);
        if (!crlFile.isAbsolute()) {
            crlFile = new File(System.getProperty("catalina.base"), crlf);
        }
        Collection<? extends CRL> crls = null;
        InputStream is = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            is = new FileInputStream(crlFile);
            crls = cf.generateCRLs(is);
        }
        catch (IOException iex) {
            throw iex;
        }
        catch (CRLException crle) {
            throw crle;
        }
        catch (CertificateException ce) {
            throw ce;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception ex) {}
            }
        }
        return crls;
    }

    protected void setEnabledProtocols(SSLServerSocket socket, String[] protocols) {
        if (protocols != null) {
            socket.setEnabledProtocols(protocols);
        }
    }

    protected String[] getEnabledProtocols(SSLServerSocket socket, String requestedProtocols) {
        String[] supportedProtocols = socket.getSupportedProtocols();
        Object[] enabledProtocols = null;
        if (requestedProtocols != null) {
            Vector<String> vec = null;
            String protocol = requestedProtocols;
            int index = requestedProtocols.indexOf(44);
            if (index != -1) {
                int fromIndex = 0;
                while (index != -1) {
                    protocol = requestedProtocols.substring(fromIndex, index).trim();
                    if (protocol.length() > 0) {
                        for (int i = 0; supportedProtocols != null && i < supportedProtocols.length; ++i) {
                            if (!supportedProtocols[i].equals(protocol)) continue;
                            if (vec == null) {
                                vec = new Vector();
                            }
                            vec.addElement(protocol);
                            break;
                        }
                    }
                    fromIndex = index + 1;
                    index = requestedProtocols.indexOf(44, fromIndex);
                }
                protocol = requestedProtocols.substring(fromIndex);
            }
            if (protocol != null && (protocol = protocol.trim()).length() > 0) {
                for (int i = 0; supportedProtocols != null && i < supportedProtocols.length; ++i) {
                    if (!supportedProtocols[i].equals(protocol)) continue;
                    if (vec == null) {
                        vec = new Vector<String>();
                    }
                    vec.addElement(protocol);
                    break;
                }
            }
            if (vec != null) {
                enabledProtocols = new String[vec.size()];
                vec.copyInto(enabledProtocols);
            }
        }
        return enabledProtocols;
    }

    protected void configureClientAuth(SSLServerSocket socket) {
        if (this.wantClientAuth) {
            socket.setWantClientAuth(this.wantClientAuth);
        } else {
            socket.setNeedClientAuth(this.requireClientAuth);
        }
    }

    protected void configureClientAuth(SSLSocket socket) {
    }

    private void initServerSocket(ServerSocket ssocket) {
        SSLServerSocket socket = (SSLServerSocket)ssocket;
        if (this.enabledCiphers != null) {
            socket.setEnabledCipherSuites(this.enabledCiphers);
        }
        String requestedProtocols = (String)this.attributes.get("protocols");
        this.setEnabledProtocols(socket, this.getEnabledProtocols(socket, requestedProtocols));
        this.configureClientAuth(socket);
    }
}

